/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.ide.analytics;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.android.tools.idea.appinspection.ide.analytics.AnalyticsProtoExtensionsKt;
import com.android.tools.idea.appinspection.inspector.api.process.DeviceDescriptor;
import com.android.tools.idea.appinspection.internal.AppInspectionAnalyticsTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J&\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0014\b\u0002\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00070\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/appinspection/ide/analytics/AppInspectionAnalyticsTrackerService;", "Lcom/android/tools/idea/appinspection/internal/AppInspectionAnalyticsTracker;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "trackErrorOccurred", "", "errorKind", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$ErrorKind;", "trackToolWindowOpened", "trackToolWindowHidden", "trackProcessSelected", "device", "Lcom/android/tools/idea/appinspection/inspector/api/process/DeviceDescriptor;", "numDevices", "", "numProcesses", "trackInspectionStopped", "trackInspectionRestarted", "toEnvironmentMetadata", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$EnvironmentMetadata;", "track", "type", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$Type;", "addMetadataTo", "Lkotlin/Function1;", "Lcom/android/tools/idea/appinspection/ide/analytics/AppInspectionAnalyticsTrackerService$Events;", "Companion", "Events", "app-inspection.ide"})
public final class AppInspectionAnalyticsTrackerService
implements AppInspectionAnalyticsTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public AppInspectionAnalyticsTrackerService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public void trackErrorOccurred(@NotNull AppInspectionEvent.ErrorKind errorKind) {
        Intrinsics.checkNotNullParameter((Object)errorKind, (String)"errorKind");
        this.track(AppInspectionEvent.Type.ERROR_OCCURRED, (Function1<? super Events, Unit>)((Function1)arg_0 -> AppInspectionAnalyticsTrackerService.trackErrorOccurred$lambda$0(errorKind, arg_0)));
    }

    @Override
    public void trackToolWindowOpened() {
        AppInspectionAnalyticsTrackerService.track$default(this, AppInspectionEvent.Type.TOOL_WINDOW_OPENED, null, 2, null);
    }

    @Override
    public void trackToolWindowHidden() {
        AppInspectionAnalyticsTrackerService.track$default(this, AppInspectionEvent.Type.TOOL_WINDOW_HIDDEN, null, 2, null);
    }

    @Override
    public void trackProcessSelected(@NotNull DeviceDescriptor device2, int numDevices, int numProcesses) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.track(AppInspectionEvent.Type.PROCESS_SELECTED, (Function1<? super Events, Unit>)((Function1)arg_0 -> AppInspectionAnalyticsTrackerService.trackProcessSelected$lambda$1(device2, this, numDevices, numProcesses, arg_0)));
    }

    @Override
    public void trackInspectionStopped() {
        AppInspectionAnalyticsTrackerService.track$default(this, AppInspectionEvent.Type.INSPECTION_STOPPED, null, 2, null);
    }

    @Override
    public void trackInspectionRestarted() {
        AppInspectionAnalyticsTrackerService.track$default(this, AppInspectionEvent.Type.INSPECTION_RESTARTED, null, 2, null);
    }

    private final AppInspectionEvent.EnvironmentMetadata toEnvironmentMetadata(int numDevices, int numProcesses) {
        AppInspectionEvent.EnvironmentMetadata environmentMetadata = AppInspectionEvent.EnvironmentMetadata.newBuilder().setNumDevices(numDevices).setNumProcesses(numProcesses).build();
        Intrinsics.checkNotNullExpressionValue((Object)environmentMetadata, (String)"build(...)");
        return environmentMetadata;
    }

    private final void track(AppInspectionEvent.Type type, Function1<? super Events, Unit> addMetadataTo) {
        AppInspectionEvent.Builder appInspectionEvent = AppInspectionEvent.newBuilder().setType(type);
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.APP_INSPECTION);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setKind(...)");
        AndroidStudioEvent.Builder studioEvent = UsageTrackerUtils.withProjectId(builder, this.project);
        Intrinsics.checkNotNull((Object)appInspectionEvent);
        addMetadataTo.invoke((Object)new Events(studioEvent, appInspectionEvent));
        studioEvent.setAppInspectionEvent(appInspectionEvent);
        UsageTracker.log((AndroidStudioEvent.Builder)studioEvent);
    }

    static /* synthetic */ void track$default(AppInspectionAnalyticsTrackerService appInspectionAnalyticsTrackerService, AppInspectionEvent.Type type, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = AppInspectionAnalyticsTrackerService::track$lambda$2;
        }
        appInspectionAnalyticsTrackerService.track(type, (Function1<? super Events, Unit>)function1);
    }

    private static final Unit trackErrorOccurred$lambda$0(AppInspectionEvent.ErrorKind $errorKind, Events events) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        events.getInspectionEvent().setErrorKind($errorKind);
        return Unit.INSTANCE;
    }

    private static final Unit trackProcessSelected$lambda$1(DeviceDescriptor $device, AppInspectionAnalyticsTrackerService this$0, int $numDevices, int $numProcesses, Events events) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        events.getStudioEvent().setDeviceInfo(AnalyticsProtoExtensionsKt.toDeviceInfo($device));
        events.getInspectionEvent().setEnvironmentMetadata(this$0.toEnvironmentMetadata($numDevices, $numProcesses));
        return Unit.INSTANCE;
    }

    private static final Unit track$lambda$2(Events it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/appinspection/ide/analytics/AppInspectionAnalyticsTrackerService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/appinspection/ide/analytics/AppInspectionAnalyticsTrackerService;", "project", "Lcom/intellij/openapi/project/Project;", "app-inspection.ide"})
    @SourceDebugExtension(value={"SMAP\nAppInspectionAnalyticsTrackerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppInspectionAnalyticsTrackerService.kt\ncom/android/tools/idea/appinspection/ide/analytics/AppInspectionAnalyticsTrackerService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,92:1\n31#2,2:93\n*S KotlinDebug\n*F\n+ 1 AppInspectionAnalyticsTrackerService.kt\ncom/android/tools/idea/appinspection/ide/analytics/AppInspectionAnalyticsTrackerService$Companion\n*L\n32#1:93,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AppInspectionAnalyticsTrackerService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<AppInspectionAnalyticsTrackerService> serviceClass$iv = AppInspectionAnalyticsTrackerService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (AppInspectionAnalyticsTrackerService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/appinspection/ide/analytics/AppInspectionAnalyticsTrackerService$Events;", "", "studioEvent", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "inspectionEvent", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$Builder;", "<init>", "(Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$Builder;)V", "getStudioEvent", "()Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "getInspectionEvent", "()Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$Builder;", "app-inspection.ide"})
    private static final class Events {
        @NotNull
        private final AndroidStudioEvent.Builder studioEvent;
        @NotNull
        private final AppInspectionEvent.Builder inspectionEvent;

        public Events(@NotNull AndroidStudioEvent.Builder studioEvent, @NotNull AppInspectionEvent.Builder inspectionEvent) {
            Intrinsics.checkNotNullParameter((Object)studioEvent, (String)"studioEvent");
            Intrinsics.checkNotNullParameter((Object)inspectionEvent, (String)"inspectionEvent");
            this.studioEvent = studioEvent;
            this.inspectionEvent = inspectionEvent;
        }

        @NotNull
        public final AndroidStudioEvent.Builder getStudioEvent() {
            return this.studioEvent;
        }

        @NotNull
        public final AppInspectionEvent.Builder getInspectionEvent() {
            return this.inspectionEvent;
        }
    }
}

