/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.network.view;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.RangeSelectionComponent;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.instructions.HyperlinkInstruction;
import com.android.tools.adtui.instructions.InstructionsPanel;
import com.android.tools.adtui.instructions.NewRowInstruction;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionListener;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.ViewBinder;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.stdui.CommonTabbedPane;
import com.android.tools.adtui.stdui.TimelineScrollbar;
import com.android.tools.adtui.stdui.TooltipLayeredPane;
import com.android.tools.idea.appinspection.inspectors.network.model.LegendsModel;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorAspect;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorModel;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorServices;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkSpeedLineChartModel;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkTrafficTooltipModel;
import com.android.tools.idea.appinspection.inspectors.network.model.connections.ConnectionData;
import com.android.tools.idea.appinspection.inspectors.network.model.connections.SelectionRangeDataListener;
import com.android.tools.idea.appinspection.inspectors.network.view.NetworkTrafficTooltipView;
import com.android.tools.idea.appinspection.inspectors.network.view.ThreadsView;
import com.android.tools.idea.appinspection.inspectors.network.view.TooltipMouseAdapter;
import com.android.tools.idea.appinspection.inspectors.network.view.UiComponentsProvider;
import com.android.tools.idea.appinspection.inspectors.network.view.connectionsview.ConnectionsView;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.ColorsKt;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.FontsKt;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.LayoutKt;
import com.android.tools.idea.appinspection.inspectors.network.view.details.NetworkInspectorDetailsPanel;
import com.android.tools.idea.appinspection.inspectors.network.view.rules.RulesTableView;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\b\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020:H\u0002J\b\u0010<\u001a\u00020 H\u0002J\b\u0010=\u001a\u00020\u0019H\u0002J\u0018\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0002J\b\u0010D\u001a\u00020:H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\u00020\"8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020&8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010.\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u001e0/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/NetworkInspectorView;", "Lcom/android/tools/adtui/model/AspectObserver;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;", "componentsProvider", "Lcom/android/tools/idea/appinspection/inspectors/network/view/UiComponentsProvider;", "parentPane", "Lcom/android/tools/adtui/stdui/TooltipLayeredPane;", "inspectorServices", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorServices;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "parentDisposable", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;Lcom/android/tools/idea/appinspection/inspectors/network/view/UiComponentsProvider;Lcom/android/tools/adtui/stdui/TooltipLayeredPane;Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorServices;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/Disposable;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getModel", "()Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;", "getComponentsProvider", "()Lcom/android/tools/idea/appinspection/inspectors/network/view/UiComponentsProvider;", "component", "Ljavax/swing/JPanel;", "getComponent", "()Ljavax/swing/JPanel;", "tooltipPanel", "activeTooltipView", "Lcom/android/tools/adtui/TooltipView;", "selectionTimeLabel", "Ljavax/swing/JLabel;", "connectionsView", "Lcom/android/tools/idea/appinspection/inspectors/network/view/connectionsview/ConnectionsView;", "getConnectionsView", "()Lcom/android/tools/idea/appinspection/inspectors/network/view/connectionsview/ConnectionsView;", "detailsPanel", "Lcom/android/tools/idea/appinspection/inspectors/network/view/details/NetworkInspectorDetailsPanel;", "getDetailsPanel", "()Lcom/android/tools/idea/appinspection/inspectors/network/view/details/NetworkInspectorDetailsPanel;", "rulesView", "Lcom/android/tools/idea/appinspection/inspectors/network/view/rules/RulesTableView;", "getRulesView", "()Lcom/android/tools/idea/appinspection/inspectors/network/view/rules/RulesTableView;", "mainPanel", "tooltipBinder", "Lcom/android/tools/adtui/model/ViewBinder;", "Lcom/android/tools/adtui/model/TooltipModel;", "messageBusConnection", "Lcom/intellij/util/messages/MessageBusConnection;", "buildTimeAxis", "Ljavax/swing/JComponent;", "axis", "Lcom/android/tools/adtui/model/axis/ResizingAxisComponentModel;", "font", "Lcom/intellij/util/ui/JBFont;", "tooltipChanged", "", "selectionChanged", "createSelectionTimeLabel", "buildMonitorUi", "hasTrafficUsage", "", "series", "Lcom/android/tools/adtui/model/RangedContinuousSeries;", "range", "Lcom/android/tools/adtui/model/Range;", "dispose", "app-inspection.inspectors.network.view"})
@SourceDebugExtension(value={"SMAP\nNetworkInspectorView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkInspectorView.kt\ncom/android/tools/idea/appinspection/inspectors/network/view/NetworkInspectorView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,464:1\n1#2:465\n1755#3,3:466\n*S KotlinDebug\n*F\n+ 1 NetworkInspectorView.kt\ncom/android/tools/idea/appinspection/inspectors/network/view/NetworkInspectorView\n*L\n441#1:466,3\n*E\n"})
public final class NetworkInspectorView
extends AspectObserver
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final NetworkInspectorModel model;
    @NotNull
    private final UiComponentsProvider componentsProvider;
    @NotNull
    private final TooltipLayeredPane parentPane;
    @NotNull
    private final JPanel component;
    @NotNull
    private final JPanel tooltipPanel;
    @Nullable
    private TooltipView activeTooltipView;
    @NotNull
    private final JLabel selectionTimeLabel;
    @VisibleForTesting
    @NotNull
    private final ConnectionsView connectionsView;
    @VisibleForTesting
    @NotNull
    private final NetworkInspectorDetailsPanel detailsPanel;
    @NotNull
    private final RulesTableView rulesView;
    @NotNull
    private final JPanel mainPanel;
    @NotNull
    private final ViewBinder<NetworkInspectorView, TooltipModel, TooltipView> tooltipBinder;
    @NotNull
    private final MessageBusConnection messageBusConnection;

    /*
     * WARNING - void declaration
     */
    public NetworkInspectorView(@NotNull Project project, @NotNull NetworkInspectorModel model, @NotNull UiComponentsProvider componentsProvider, @NotNull TooltipLayeredPane parentPane, @NotNull NetworkInspectorServices inspectorServices, @NotNull CoroutineScope scope, @NotNull Disposable parentDisposable) {
        void $this$detailsPanel_u24lambda_u240;
        NetworkInspectorDetailsPanel networkInspectorDetailsPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)componentsProvider, (String)"componentsProvider");
        Intrinsics.checkNotNullParameter((Object)parentPane, (String)"parentPane");
        Intrinsics.checkNotNullParameter((Object)inspectorServices, (String)"inspectorServices");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.model = model;
        this.componentsProvider = componentsProvider;
        this.parentPane = parentPane;
        this.component = new JPanel(new BorderLayout());
        this.tooltipPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.selectionTimeLabel = this.createSelectionTimeLabel();
        this.connectionsView = new ConnectionsView(this.project, this.model);
        NetworkInspectorDetailsPanel networkInspectorDetailsPanel2 = networkInspectorDetailsPanel = new NetworkInspectorDetailsPanel(this, inspectorServices.getUsageTracker());
        NetworkInspectorView networkInspectorView = this;
        boolean bl = false;
        $this$detailsPanel_u24lambda_u240.setVisible(false);
        networkInspectorView.detailsPanel = networkInspectorDetailsPanel;
        this.rulesView = new RulesTableView(this.project, inspectorServices.getClient(), scope, this.model, this.detailsPanel.getRuleDetailsView(), inspectorServices.getUsageTracker());
        this.mainPanel = new JPanel((LayoutManager)new TabularLayout("*,Fit-", "Fit-,*"));
        this.tooltipBinder = new ViewBinder();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.tooltipPanel.setBackground(ColorsKt.getTOOLTIP_BACKGROUND());
        this.model.addDependency(this).onChange((Enum)NetworkInspectorAspect.TOOLTIP, () -> NetworkInspectorView._init_$lambda$1(this));
        this.model.getTimeline().getSelectionRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> NetworkInspectorView._init_$lambda$2(this));
        this.selectionChanged();
        this.tooltipBinder.bind(NetworkTrafficTooltipModel.class, NetworkInspectorView::_init_$lambda$3);
        this.detailsPanel.setMinimumSize(new Dimension(JBUI.scale((int)550), (int)this.detailsPanel.getMinimumSize().getHeight()));
        ThreadsView threadsView = new ThreadsView(this.model, this.parentPane);
        JBSplitter leftSplitter = new JBSplitter(true, 0.25f);
        leftSplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_HORIZONTAL_BORDERS);
        leftSplitter.setFirstComponent((JComponent)this.buildMonitorUi());
        this.messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(parentDisposable);
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        this.messageBusConnection.subscribe(topic, arg_0 -> NetworkInspectorView._init_$lambda$4(leftSplitter, this, arg_0));
        final JPanel connectionsPanel = new JPanel(new CardLayout());
        CommonTabbedPane connectionsTab = new CommonTabbedPane();
        JBScrollPane connectionScrollPane = new JBScrollPane((Component)this.connectionsView.getComponent());
        connectionScrollPane.setBorder((Border)JBUI.Borders.empty());
        JBScrollPane threadsViewScrollPane = new JBScrollPane((Component)threadsView.getComponent());
        threadsViewScrollPane.setBorder((Border)JBUI.Borders.empty());
        connectionsTab.addTab("Connection View", (Component)connectionScrollPane);
        connectionsTab.addTab("Thread View", (Component)threadsViewScrollPane);
        if (((Boolean)StudioFlags.ENABLE_NETWORK_INTERCEPTION.get()).booleanValue()) {
            connectionsTab.addTab("Rules", (Component)this.rulesView.getComponent());
            Ref.ObjectRef selectedComponent = new Ref.ObjectRef();
            connectionsTab.addChangeListener(arg_0 -> NetworkInspectorView._init_$lambda$5(connectionsTab, connectionScrollPane, threadsViewScrollPane, selectedComponent, this, arg_0));
        }
        connectionsTab.addChangeListener(arg_0 -> NetworkInspectorView._init_$lambda$6(this, arg_0));
        connectionsPanel.add((Component)connectionsTab, "Connections");
        JPanel infoPanel = new JPanel(new BorderLayout());
        RenderInstruction[] renderInstructionArray = new RenderInstruction[]{new TextInstruction(UIUtilities.getFontMetrics((JComponent)infoPanel, (Font)FontsKt.getH3_FONT()), "Network inspector data unavailable"), new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), new TextInstruction(UIUtilities.getFontMetrics((JComponent)infoPanel, (Font)FontsKt.getSTANDARD_FONT()), "There is no information for the network traffic you've selected."), new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), new HyperlinkInstruction(FontsKt.getSTANDARD_FONT(), "Learn More", "https://developer.android.com/r/studio-ui/network-profiler-troubleshoot-connections.html")};
        InstructionsPanel instructionsPanel = new InstructionsPanel.Builder(renderInstructionArray).setColors(JBColor.foreground(), null).build();
        Intrinsics.checkNotNullExpressionValue((Object)instructionsPanel, (String)"build(...)");
        InstructionsPanel infoMessage = instructionsPanel;
        infoPanel.add((Component)infoMessage, "Center");
        infoPanel.setName("Info");
        connectionsPanel.add((Component)infoPanel, "Info");
        JPanel toolbar = new JPanel(new GridBagLayout());
        this.selectionTimeLabel.setBorder((Border)JBUI.Borders.empty((int)8, (int)0, (int)0, (int)8));
        toolbar.add(this.selectionTimeLabel);
        this.mainPanel.add((Component)toolbar, new TabularLayout.Constraint(0, 1, 0, 4, null));
        this.mainPanel.add((Component)connectionsPanel, new TabularLayout.Constraint(0, 0, 2, 2));
        leftSplitter.setSecondComponent((JComponent)this.mainPanel);
        this.model.getSelectionRangeDataFetcher().addListener(new SelectionRangeDataListener(){

            @Override
            public void onUpdate(List<? extends ConnectionData> data2) {
                CardLayout cardLayout;
                block2: {
                    block3: {
                        Intrinsics.checkNotNullParameter(data2, (String)"data");
                        LayoutManager layoutManager = connectionsPanel.getLayout();
                        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.CardLayout");
                        cardLayout = (CardLayout)layoutManager;
                        if (!data2.isEmpty()) break block2;
                        NetworkSpeedLineChartModel detailedNetworkUsage = this.getModel().getNetworkUsage();
                        RangedContinuousSeries rangedContinuousSeries = detailedNetworkUsage.getRxSeries();
                        Range range = this.getModel().getTimeline().getSelectionRange();
                        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getSelectionRange(...)");
                        if (this.hasTrafficUsage(rangedContinuousSeries, range)) break block3;
                        RangedContinuousSeries rangedContinuousSeries2 = detailedNetworkUsage.getTxSeries();
                        Range range2 = this.getModel().getTimeline().getSelectionRange();
                        Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"getSelectionRange(...)");
                        if (!this.hasTrafficUsage(rangedContinuousSeries2, range2)) break block2;
                    }
                    cardLayout.show(connectionsPanel, "Info");
                    return;
                }
                cardLayout.show(connectionsPanel, "Connections");
            }
        });
        JBSplitter splitter = new JBSplitter(false, 0.6f);
        splitter.setFirstComponent((JComponent)leftSplitter);
        splitter.setSecondComponent((JComponent)this.detailsPanel);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.getDivider().setBorder(AdtUiUtils.DEFAULT_VERTICAL_BORDERS);
        this.component.add((Component)splitter, "Center");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final NetworkInspectorModel getModel() {
        return this.model;
    }

    @NotNull
    public final UiComponentsProvider getComponentsProvider() {
        return this.componentsProvider;
    }

    @NotNull
    public final JPanel getComponent() {
        return this.component;
    }

    @NotNull
    public final ConnectionsView getConnectionsView() {
        return this.connectionsView;
    }

    @NotNull
    public final NetworkInspectorDetailsPanel getDetailsPanel() {
        return this.detailsPanel;
    }

    @NotNull
    public final RulesTableView getRulesView() {
        return this.rulesView;
    }

    private final JComponent buildTimeAxis(ResizingAxisComponentModel axis, JBFont font) {
        JPanel axisPanel = new JPanel(new BorderLayout());
        axisPanel.setBackground(ColorsKt.getDEFAULT_BACKGROUND());
        AxisComponent timeAxis = new AxisComponent((AxisComponentModel)axis, AxisComponent.AxisOrientation.BOTTOM, true);
        timeAxis.setShowAxisLine(false);
        timeAxis.setFont((Font)font);
        timeAxis.setMinimumSize(new Dimension(0, LayoutKt.getTIME_AXIS_HEIGHT()));
        timeAxis.setPreferredSize(new Dimension(Integer.MAX_VALUE, LayoutKt.getTIME_AXIS_HEIGHT()));
        axisPanel.add((Component)timeAxis, "Center");
        return axisPanel;
    }

    private final void tooltipChanged() {
        TooltipView tooltipView = this.activeTooltipView;
        if (tooltipView != null) {
            tooltipView.dispose();
        }
        this.activeTooltipView = null;
        this.tooltipPanel.removeAll();
        this.tooltipPanel.setVisible(false);
        if (this.model.getTooltip() != null && !this.model.getTimeline().getDataRange().isTrivial()) {
            TooltipView tooltipView2;
            Object object = this.tooltipBinder.build((Object)this, (Object)this.model.getTooltip());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
            this.activeTooltipView = tooltipView2 = (TooltipView)object;
            this.tooltipPanel.add(tooltipView2.createComponent());
            this.tooltipPanel.setVisible(true);
        }
        this.tooltipPanel.invalidate();
        this.tooltipPanel.repaint();
    }

    private final void selectionChanged() {
        Timeline timeline = this.model.getTimeline();
        Range range = timeline.getSelectionRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getSelectionRange(...)");
        Range selectionRange = range;
        if (selectionRange.isEmpty() || this.model.getTimeline().getDataRange().isTrivial()) {
            this.selectionTimeLabel.setIcon(null);
            this.selectionTimeLabel.setText("");
            return;
        }
        long selectionMinUs = 0L;
        long selectionMaxUs = 0L;
        if (((Boolean)StudioFlags.NETWORK_INSPECTOR_STATIC_TIMELINE.get()).booleanValue()) {
            selectionMinUs = (long)(selectionRange.getMin() - timeline.getDataRange().getMin());
            selectionMaxUs = (long)(selectionRange.getMax() - timeline.getDataRange().getMin());
        } else {
            Intrinsics.checkNotNull((Object)timeline, (String)"null cannot be cast to non-null type com.android.tools.adtui.model.StreamingTimeline");
            StreamingTimeline streamingTimeline = (StreamingTimeline)timeline;
            selectionMinUs = streamingTimeline.convertToRelativeTimeUs(TimeUnit.MICROSECONDS.toNanos((long)selectionRange.getMin()));
            selectionMaxUs = streamingTimeline.convertToRelativeTimeUs(TimeUnit.MICROSECONDS.toNanos((long)selectionRange.getMax()));
        }
        this.selectionTimeLabel.setIcon(StudioIcons.Profiler.Toolbar.CLOCK);
        if (selectionRange.isPoint()) {
            this.selectionTimeLabel.setText(TimeFormatter.getSimplifiedClockString((long)selectionMinUs));
        } else {
            this.selectionTimeLabel.setText(TimeFormatter.getSimplifiedClockString((long)selectionMinUs) + " - " + TimeFormatter.getSimplifiedClockString((long)selectionMaxUs));
        }
    }

    private final JLabel createSelectionTimeLabel() {
        JLabel label2 = new JLabel("");
        label2.setFont(FontsKt.getSTANDARD_FONT());
        label2.setBorder(JBUI.Borders.empty((int)3));
        label2.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ NetworkInspectorView this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Timeline timeline = this.this$0.getModel().getTimeline();
                timeline.frameViewToRange(timeline.getSelectionRange());
            }
        });
        label2.setToolTipText("Selected range");
        label2.setCursor(Cursor.getPredefinedCursor(12));
        return label2;
    }

    private final JPanel buildMonitorUi() {
        JBFont jBFont = JBUI.Fonts.label();
        Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"label(...)");
        JBFont font = jBFont;
        Timeline timeline = this.model.getTimeline();
        RangeSelectionComponent selection2 = new RangeSelectionComponent(this.model.getRangeSelectionModel());
        selection2.setCursorSetter(AdtUiUtils::setTooltipCursor);
        selection2.setRangeOcclusionTest(() -> NetworkInspectorView.buildMonitorUi$lambda$7(this));
        RangeTooltipComponent tooltip = new RangeTooltipComponent(timeline, (JComponent)this.tooltipPanel, (JComponent)this.parentPane, () -> NetworkInspectorView.buildMonitorUi$lambda$8(selection2));
        TabularLayout layout = new TabularLayout("*");
        JBPanel panel2 = new JBPanel((LayoutManager)layout);
        panel2.setBackground(ColorsKt.getDEFAULT_STAGE_BACKGROUND());
        panel2.add((Component)tooltip, (Object)new TabularLayout.Constraint(0, 0, 2, 1));
        TimelineScrollbar sb = new TimelineScrollbar(timeline, (JComponent)panel2);
        panel2.add((Component)sb, (Object)new TabularLayout.Constraint(3, 0, 0, 4, null));
        ResizingAxisComponentModel resizingAxisComponentModel = new ResizingAxisComponentModel.Builder(timeline.getViewRange(), (BaseAxisFormatter)TimeAxisFormatter.DEFAULT).setGlobalRange(timeline.getDataRange()).build();
        Intrinsics.checkNotNullExpressionValue((Object)resizingAxisComponentModel, (String)"build(...)");
        ResizingAxisComponentModel viewAxis = resizingAxisComponentModel;
        JComponent timeAxis = this.buildTimeAxis(viewAxis, font);
        panel2.add((Component)timeAxis, (Object)new TabularLayout.Constraint(2, 0, 0, 4, null));
        JBPanel monitorPanel = new JBPanel((LayoutManager)new TabularLayout("*", "*"));
        monitorPanel.setOpaque(false);
        monitorPanel.setBorder(LayoutKt.getMONITOR_BORDER());
        JLabel label2 = new JLabel(this.model.getName());
        label2.setBorder(LayoutKt.getMONITOR_LABEL_PADDING());
        label2.setVerticalAlignment(1);
        JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
        lineChartPanel.setOpaque(false);
        lineChartPanel.setBorder((Border)JBUI.Borders.emptyTop((int)LayoutKt.getY_AXIS_TOP_MARGIN()));
        NetworkSpeedLineChartModel usage = this.model.getNetworkUsage();
        LineChart lineChart = new LineChart((LineChartModel)usage);
        LineConfig receivedConfig = new LineConfig(ColorsKt.getNETWORK_RECEIVING_COLOR()).setLegendIconType(LegendConfig.IconType.LINE);
        lineChart.configure(usage.getRxSeries(), receivedConfig);
        LineConfig sentConfig = new LineConfig(ColorsKt.getNETWORK_SENDING_COLOR()).setLegendIconType(LegendConfig.IconType.LINE);
        lineChart.configure(usage.getTxSeries(), sentConfig);
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChartPanel.add((Component)lineChart, (Object)"Center");
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent leftAxis = new AxisComponent((AxisComponentModel)this.model.getTrafficAxis(), AxisComponent.AxisOrientation.RIGHT, true);
        leftAxis.setShowAxisLine(false);
        leftAxis.setShowMax(true);
        leftAxis.setOnlyShowUnitAtMax(true);
        leftAxis.setHideTickAtMin(true);
        leftAxis.setMarkerLengths(LayoutKt.getMARKER_LENGTH(), LayoutKt.getMARKER_LENGTH());
        leftAxis.setMargins(0, LayoutKt.getY_AXIS_TOP_MARGIN());
        leftAxis.setFont((Font)font);
        axisPanel.add((Component)leftAxis, (Object)"West");
        LegendsModel legends = this.model.getLegends();
        LegendComponent legendComponent = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(LayoutKt.getLEGEND_RIGHT_PADDING()).setTextSize(font.getSize()).build();
        Intrinsics.checkNotNullExpressionValue((Object)legendComponent, (String)"build(...)");
        LegendComponent legend = legendComponent;
        legend.configure((Legend)legends.getRxLegend(), new LegendConfig(lineChart.getLineConfig(usage.getRxSeries())));
        legend.configure((Legend)legends.getTxLegend(), new LegendConfig(lineChart.getLineConfig(usage.getTxSeries())));
        JBPanel legendPanel = new JBPanel((LayoutManager)new BorderLayout());
        legendPanel.setOpaque(false);
        legendPanel.add((Component)label2, (Object)"West");
        legendPanel.add((Component)legend, (Object)"East");
        this.model.getRangeSelectionModel().addListener(new RangeSelectionListener(this){
            final /* synthetic */ NetworkInspectorView this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionCleared() {
                this.this$0.getModel().setSelectedConnection(null);
            }
        });
        selection2.addMouseListener((MouseListener)new TooltipMouseAdapter(this.model, () -> NetworkInspectorView.buildMonitorUi$lambda$9(this)));
        tooltip.registerListenersOn((JComponent)selection2);
        monitorPanel.add((Component)legendPanel, (Object)new TabularLayout.Constraint(0, 0, 0, 4, null));
        monitorPanel.add((Component)selection2, (Object)new TabularLayout.Constraint(0, 0, 0, 4, null));
        monitorPanel.add((Component)axisPanel, (Object)new TabularLayout.Constraint(0, 0, 0, 4, null));
        monitorPanel.add((Component)lineChartPanel, (Object)new TabularLayout.Constraint(0, 0, 0, 4, null));
        layout.setRowSizing(1, "*");
        panel2.add((Component)monitorPanel, (Object)new TabularLayout.Constraint(1, 0, 0, 4, null));
        return (JPanel)panel2;
    }

    private final boolean hasTrafficUsage(RangedContinuousSeries series, Range range) {
        int maxIndex;
        boolean bl;
        List list;
        block4: {
            list = series.getSeriesForRange(range);
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SeriesData data2 = (SeriesData)element$iv;
                    boolean bl2 = false;
                    if (!((double)data2.x >= range.getMin() && (double)data2.x <= range.getMax() && ((Number)data2.value).longValue() > 0L)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        Function1 getInsertPoint = arg_0 -> NetworkInspectorView.hasTrafficUsage$lambda$13(list, arg_0);
        int minIndex = ((Number)getInsertPoint.invoke((Object)((long)range.getMin()))).intValue();
        return minIndex == (maxIndex = ((Number)getInsertPoint.invoke((Object)((long)range.getMax()))).intValue()) ? minIndex > 0 && ((Number)((SeriesData)list.get((int)(minIndex - 1))).value).longValue() > 0L && minIndex < list.size() && ((Number)((SeriesData)list.get((int)minIndex)).value).longValue() > 0L : false;
    }

    public void dispose() {
        this.messageBusConnection.disconnect();
    }

    private static final void _init_$lambda$1(NetworkInspectorView this$0) {
        this$0.tooltipChanged();
    }

    private static final void _init_$lambda$2(NetworkInspectorView this$0) {
        this$0.selectionChanged();
    }

    private static final NetworkTrafficTooltipView _init_$lambda$3(NetworkInspectorView view, NetworkTrafficTooltipModel tooltip) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Intrinsics.checkNotNull((Object)tooltip);
        return new NetworkTrafficTooltipView(view, tooltip);
    }

    private static final void _init_$lambda$4(JBSplitter $leftSplitter, NetworkInspectorView this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $leftSplitter.setFirstComponent((JComponent)this$0.buildMonitorUi());
    }

    private static final void _init_$lambda$5(CommonTabbedPane $connectionsTab, JBScrollPane $connectionScrollPane, JBScrollPane $threadsViewScrollPane, Ref.ObjectRef $selectedComponent, NetworkInspectorView this$0, ChangeEvent it) {
        Component component = $connectionsTab.getSelectedComponent();
        if (Intrinsics.areEqual((Object)component, (Object)$connectionScrollPane) || Intrinsics.areEqual((Object)component, (Object)$threadsViewScrollPane)) {
            if (Intrinsics.areEqual((Object)$selectedComponent.element, (Object)this$0.rulesView.getComponent())) {
                this$0.model.setDetailContent(this$0.model.getSelectedConnection() == null ? NetworkInspectorModel.DetailContent.EMPTY : NetworkInspectorModel.DetailContent.CONNECTION);
            }
        } else if (Intrinsics.areEqual((Object)component, (Object)this$0.rulesView.getComponent()) && (Intrinsics.areEqual((Object)$selectedComponent.element, (Object)$connectionScrollPane) || Intrinsics.areEqual((Object)$selectedComponent.element, (Object)$threadsViewScrollPane))) {
            this$0.model.setDetailContent(this$0.model.getSelectedRule() == null ? NetworkInspectorModel.DetailContent.EMPTY : NetworkInspectorModel.DetailContent.RULE);
        }
        $selectedComponent.element = $connectionsTab.getSelectedComponent();
    }

    private static final void _init_$lambda$6(NetworkInspectorView this$0, ChangeEvent it) {
        this$0.mainPanel.repaint();
    }

    private static final boolean buildMonitorUi$lambda$7(NetworkInspectorView this$0) {
        return this$0.model.getTimeline().getDataRange().isTrivial();
    }

    private static final Boolean buildMonitorUi$lambda$8(RangeSelectionComponent $selection) {
        return $selection.shouldShowSeekComponent();
    }

    private static final TooltipModel buildMonitorUi$lambda$9(NetworkInspectorView this$0) {
        return new NetworkTrafficTooltipModel(this$0.model);
    }

    private static final int hasTrafficUsage$lambda$13$lambda$11(SeriesData o1, SeriesData o2) {
        return Intrinsics.compare((long)o1.x, (long)o2.x);
    }

    private static final int hasTrafficUsage$lambda$13$lambda$12(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final int hasTrafficUsage$lambda$13(List $list, long time2) {
        int index = CollectionsKt.binarySearch$default((List)$list, (Object)new SeriesData(time2, (Object)0L), (arg_0, arg_1) -> NetworkInspectorView.hasTrafficUsage$lambda$13$lambda$12(NetworkInspectorView::hasTrafficUsage$lambda$13$lambda$11, arg_0, arg_1), (int)0, (int)0, (int)12, null);
        return index < 0 ? -(index + 1) : index;
    }
}

