/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.network.view.details;

import com.android.tools.adtui.stdui.ContentType;
import com.android.tools.idea.appinspection.inspectors.network.model.connections.ConnectionData;
import com.android.tools.idea.appinspection.inspectors.network.model.connections.HttpData;
import com.android.tools.idea.appinspection.inspectors.network.view.UiComponentsProvider;
import com.android.tools.idea.appinspection.inspectors.network.view.details.DataComponentFactory;
import com.android.tools.idea.appinspection.inspectors.network.view.details.HttpDataComponentFactoryKt;
import com.android.tools.idea.appinspection.inspectors.network.view.details.SwitchingPanel;
import com.android.tools.idea.appinspection.inspectors.network.view.details.TabUiUtilsKt;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.inspectors.common.ui.dataviewer.DataViewer;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/details/HttpDataComponentFactory;", "Lcom/android/tools/idea/appinspection/inspectors/network/view/details/DataComponentFactory;", "httpData", "Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/HttpData;", "componentsProvider", "Lcom/android/tools/idea/appinspection/inspectors/network/view/UiComponentsProvider;", "<init>", "(Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/HttpData;Lcom/android/tools/idea/appinspection/inspectors/network/view/UiComponentsProvider;)V", "getHttpData", "()Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/HttpData;", "getContentType", "Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/HttpData$ContentType;", "type", "Lcom/android/tools/idea/appinspection/inspectors/network/view/details/DataComponentFactory$ConnectionType;", "getPayload", "Lcom/android/tools/idea/protobuf/ByteString;", "getMimeTypeString", "", "getBodyTitle", "createBodyComponent", "Ljavax/swing/JComponent;", "createDataViewer", "Lcom/android/tools/inspectors/common/ui/dataviewer/DataViewer;", "formatted", "", "Companion", "app-inspection.inspectors.network.view"})
public final class HttpDataComponentFactory
extends DataComponentFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UiComponentsProvider componentsProvider;
    @NotNull
    public static final String ID_PAYLOAD_VIEWER = "PAYLOAD_VIEWER";
    @NotNull
    private static final Border PAYLOAD_BORDER;

    public HttpDataComponentFactory(@NotNull HttpData httpData, @NotNull UiComponentsProvider componentsProvider) {
        Intrinsics.checkNotNullParameter((Object)httpData, (String)"httpData");
        Intrinsics.checkNotNullParameter((Object)componentsProvider, (String)"componentsProvider");
        super(httpData);
        this.componentsProvider = componentsProvider;
    }

    private final HttpData getHttpData() {
        ConnectionData connectionData = this.getData();
        Intrinsics.checkNotNull((Object)connectionData, (String)"null cannot be cast to non-null type com.android.tools.idea.appinspection.inspectors.network.model.connections.HttpData");
        return (HttpData)connectionData;
    }

    private final HttpData.ContentType getContentType(DataComponentFactory.ConnectionType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> this.getHttpData().getRequestContentType();
            case 2 -> this.getHttpData().getResponseContentType();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final ByteString getPayload(DataComponentFactory.ConnectionType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> this.getHttpData().getRequestPayload();
            case 2 -> this.getHttpData().getReadableResponsePayload();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String getMimeTypeString(DataComponentFactory.ConnectionType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> this.getHttpData().getRequestContentType().getMimeType();
            case 2 -> this.getHttpData().getResponseContentType().getMimeType();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String getBodyTitle(DataComponentFactory.ConnectionType type) {
        HttpData.ContentType contentType = this.getContentType(type);
        return contentType.isEmpty() ? "Body" : "Body ( " + Companion.getDisplayName(contentType) + " )";
    }

    @Override
    @NotNull
    public JComponent createBodyComponent(@NotNull DataComponentFactory.ConnectionType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        ByteString payload = this.getPayload(type);
        if (payload.isEmpty()) {
            return (JComponent)TabUiUtilsKt.createTitledPanel(this.getBodyTitle(type), new JLabel("Not available"), null);
        }
        HttpData.ContentType contentType = this.getContentType(type);
        JComponent rawView = HttpDataComponentFactory.Companion.createRawDataComponent(payload, contentType, this.componentsProvider);
        JComponent prettyView = HttpDataComponentFactory.Companion.createParsedDataComponent(payload, contentType, this.componentsProvider);
        Pair pair = prettyView == null ? TuplesKt.to((Object)rawView, null) : HttpDataComponentFactoryKt.access$withSwitcher(new SwitchingPanel(prettyView, "View Parsed", rawView, "View Source"));
        JComponent bodyView = (JComponent)pair.component1();
        JLabel northEastView = (JLabel)pair.component2();
        bodyView.setName(type.getBodyComponentId());
        return (JComponent)TabUiUtilsKt.createTitledPanel(this.getBodyTitle(type), bodyView, northEastView);
    }

    @Override
    @NotNull
    public DataViewer createDataViewer(@NotNull DataComponentFactory.ConnectionType type, boolean formatted) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        byte[] byArray = this.getPayload(type).toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        ContentType contentType = ContentType.fromMimeType((String)this.getMimeTypeString(type));
        Intrinsics.checkNotNullExpressionValue((Object)contentType, (String)"fromMimeType(...)");
        return this.componentsProvider.createDataViewer(byArray, contentType, DataViewer.Style.PRETTY, formatted);
    }

    static {
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.emptyTop((int)6);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"emptyTop(...)");
        PAYLOAD_BORDER = (Border)jBEmptyBorder;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/details/HttpDataComponentFactory$Companion;", "", "<init>", "()V", "ID_PAYLOAD_VIEWER", "", "getID_PAYLOAD_VIEWER$annotations", "PAYLOAD_BORDER", "Ljavax/swing/border/Border;", "createRawDataComponent", "Ljavax/swing/JComponent;", "payload", "Lcom/android/tools/idea/protobuf/ByteString;", "contentType", "Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/HttpData$ContentType;", "componentsProvider", "Lcom/android/tools/idea/appinspection/inspectors/network/view/UiComponentsProvider;", "createParsedDataComponent", "getDisplayName", "app-inspection.inspectors.network.view"})
    @SourceDebugExtension(value={"SMAP\nHttpDataComponentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpDataComponentFactory.kt\ncom/android/tools/idea/appinspection/inspectors/network/view/details/HttpDataComponentFactory$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,209:1\n108#2:210\n80#2,22:211\n108#2:239\n80#2,22:240\n1187#3,2:233\n1261#3,4:235\n*S KotlinDebug\n*F\n+ 1 HttpDataComponentFactory.kt\ncom/android/tools/idea/appinspection/inspectors/network/view/details/HttpDataComponentFactory$Companion\n*L\n150#1:210\n150#1:211,22\n189#1:239\n189#1:240,22\n152#1:233,2\n152#1:235,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getID_PAYLOAD_VIEWER$annotations() {
        }

        private final JComponent createRawDataComponent(ByteString payload, HttpData.ContentType contentType, UiComponentsProvider componentsProvider) {
            ContentType contentType2 = ContentType.fromMimeType((String)contentType.getMimeType());
            Intrinsics.checkNotNullExpressionValue((Object)contentType2, (String)"fromMimeType(...)");
            ContentType contentTypeFromMime = contentType2;
            byte[] byArray = payload.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            DataViewer viewer = componentsProvider.createDataViewer(byArray, contentTypeFromMime, DataViewer.Style.RAW, false);
            JComponent jComponent = viewer.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            JComponent viewerComponent = jComponent;
            viewerComponent.setName(HttpDataComponentFactory.ID_PAYLOAD_VIEWER);
            viewerComponent.setBorder(PAYLOAD_BORDER);
            BorderLayoutPanel panel2 = new BorderLayoutPanel();
            panel2.add((Component)viewerComponent);
            return (JComponent)panel2;
        }

        /*
         * WARNING - void declaration
         */
        private final JComponent createParsedDataComponent(ByteString payload, HttpData.ContentType contentType, UiComponentsProvider componentsProvider) {
            if (contentType.isFormData()) {
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                Object $this$trim$iv;
                String contentToParse = payload.toStringUtf8();
                Intrinsics.checkNotNull((Object)contentToParse);
                String string = contentToParse;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim22 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                $this$trim$iv = new char[]{'&'};
                $this$trim$iv = StringsKt.split$default((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (char[])$this$trim$iv, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                void $i$f$trim22 = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map2 = destination$iv$iv;
                    String s = (String)element$iv$iv;
                    boolean bl = false;
                    char[] cArray = new char[]{'='};
                    List splits = StringsKt.split$default((CharSequence)s, (char[])cArray, (boolean)false, (int)2, (int)2, null);
                    Pair pair = splits.size() > 1 ? TuplesKt.to(splits.get(0), (Object)CollectionsKt.listOf(splits.get(1))) : TuplesKt.to(splits.get(0), (Object)CollectionsKt.listOf((Object)""));
                    map2.put(pair.getFirst(), pair.getSecond());
                }
                Map parsedContent = destination$iv$iv;
                return TabUiUtilsKt.createStyledMapComponent(parsedContent);
            }
            ContentType contentType2 = ContentType.fromMimeType((String)contentType.getMimeType());
            Intrinsics.checkNotNullExpressionValue((Object)contentType2, (String)"fromMimeType(...)");
            ContentType contentTypeFromMime = contentType2;
            byte[] byArray = payload.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            DataViewer viewer = componentsProvider.createDataViewer(byArray, contentTypeFromMime, DataViewer.Style.PRETTY, true);
            if (viewer.getStyle() == DataViewer.Style.PRETTY) {
                JComponent jComponent = viewer.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                JComponent viewerComponent = jComponent;
                viewerComponent.setBorder(PAYLOAD_BORDER);
                return viewerComponent;
            }
            return null;
        }

        @VisibleForTesting
        @NotNull
        public final String getDisplayName(@NotNull HttpData.ContentType contentType) {
            Object object;
            String mimeType;
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            String $this$trim$iv = contentType.getMimeType();
            boolean $i$f$trim22 = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (((CharSequence)(mimeType = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())).length() == 0) {
                return mimeType;
            }
            if (contentType.isFormData()) {
                return "Form Data";
            }
            char[] $i$f$trim22 = new char[]{'/'};
            List typeAndSubType = StringsKt.split$default((CharSequence)mimeType, (char[])$i$f$trim22, (boolean)false, (int)2, (int)2, null);
            boolean showSubType = typeAndSubType.size() > 1 && (Intrinsics.areEqual(typeAndSubType.get(0), (Object)"text") || Intrinsics.areEqual(typeAndSubType.get(0), (Object)"application"));
            String name2 = showSubType ? (String)typeAndSubType.get(1) : (String)typeAndSubType.get(0);
            if (((CharSequence)name2).length() == 0 || showSubType) {
                String string = name2;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string2 = string.toUpperCase(locale);
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            } else {
                String string = name2.substring(0, 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string3 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string4 = string3.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                String string5 = name2.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                object = string4 + string5;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataComponentFactory.ConnectionType.values().length];
            try {
                nArray[DataComponentFactory.ConnectionType.REQUEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataComponentFactory.ConnectionType.RESPONSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

