/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant;

import com.android.tools.idea.assistant.AssistantBundleCreator;
import com.android.tools.idea.assistant.AssistantGetBundleFromConfigTask;
import com.android.tools.idea.assistant.AssistantGetBundleTask;
import com.android.tools.idea.assistant.datamodel.AnalyticsProvider;
import com.android.tools.idea.assistant.datamodel.FeatureData;
import com.android.tools.idea.assistant.datamodel.TutorialBundleData;
import com.android.tools.idea.assistant.view.FeaturesPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.http.concurrent.FutureCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J2\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0016\b\u0002\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/assistant/AssistSidePanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "getLoadingPanel", "()Lcom/intellij/ui/components/JBLoadingPanel;", "errorPanel", "errorText", "Lcom/intellij/ui/components/JBLabel;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "featuresPanel", "Lcom/android/tools/idea/assistant/view/FeaturesPanel;", "showBundle", "", "bundleId", "", "defaultTutorialId", "onBundleCreated", "Lkotlin/Function1;", "Lcom/android/tools/idea/assistant/datamodel/TutorialBundleData;", "AssistantLoadingCallback", "assistant"})
@SourceDebugExtension(value={"SMAP\nAssistSidePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssistSidePanel.kt\ncom/android/tools/idea/assistant/AssistSidePanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,156:1\n1#2:157\n1137#3,2:158\n*S KotlinDebug\n*F\n+ 1 AssistSidePanel.kt\ncom/android/tools/idea/assistant/AssistSidePanel\n*L\n74#1:158,2\n*E\n"})
public final class AssistSidePanel
extends JPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final JBLoadingPanel loadingPanel;
    @NotNull
    private final JPanel errorPanel;
    @NotNull
    private final JBLabel errorText;
    @Nullable
    private FeaturesPanel featuresPanel;

    public AssistSidePanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(new BorderLayout());
        this.project = project;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this.project, 200);
        this.loadingPanel.add((Component)this, (Object)"Center");
        this.loadingPanel.setLoadingText("Loading assistant content");
        this.loadingPanel.setName("assistantPanel");
        this.errorPanel = new JPanel(new BorderLayout());
        String message = "Error loading assistant panel. Please check idea.log for detailed error message.";
        String htmlText = "<html><div style='text-align: center;'>" + StringUtil.escapeXmlEntities((String)message) + "</div></html>";
        this.errorText = new JBLabel(htmlText);
        this.errorText.setHorizontalAlignment(0);
        this.errorPanel.add((Component)this.errorText, "Center");
        this.add((Component)this.errorPanel, "Center");
        this.errorPanel.setVisible(false);
    }

    @NotNull
    public final JBLoadingPanel getLoadingPanel() {
        return this.loadingPanel;
    }

    private final Logger getLog() {
        Logger logger = Logger.getInstance(AssistSidePanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    public final void showBundle(@NotNull String bundleId, @Nullable String defaultTutorialId, @Nullable Function1<? super TutorialBundleData, Unit> onBundleCreated) {
        URL uRL;
        Object $this$first$iv;
        Intrinsics.checkNotNullParameter((Object)bundleId, (String)"bundleId");
        FeaturesPanel featuresPanel = this.featuresPanel;
        if (featuresPanel != null) {
            FeaturesPanel it = featuresPanel;
            int n = 0;
            this.remove(it);
        }
        this.loadingPanel.startLoading();
        this.errorPanel.setVisible(false);
        try {
            Object element$iv2;
            block9: {
                $this$first$iv = AssistantBundleCreator.EP_NAME.getExtensions();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    AssistantBundleCreator it = (AssistantBundleCreator)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getBundleId(), (Object)bundleId)) {
                        continue;
                    }
                    break block9;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            $this$first$iv = (AssistantBundleCreator)element$iv2;
        }
        catch (NoSuchElementException e) {
            this.getLog().warn("Unable to find configuration for the selected action: " + bundleId);
            return;
        }
        Object bundleCreator = $this$first$iv;
        try {
            uRL = bundleCreator.getConfig();
        }
        catch (FileNotFoundException e) {
            this.getLog().warn((Throwable)e);
            uRL = null;
        }
        URL config = uRL;
        if (config != null) {
            Intrinsics.checkNotNull((Object)bundleCreator);
            FutureCallback futureCallback = new AssistantLoadingCallback(bundleId, (AssistantBundleCreator)bundleCreator, defaultTutorialId, onBundleCreated);
            String string = bundleCreator.getBundleId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBundleId(...)");
            new AssistantGetBundleFromConfigTask(this.project, config, (FutureCallback<TutorialBundleData>)futureCallback, string).queue();
        } else {
            Intrinsics.checkNotNull((Object)bundleCreator);
            new AssistantGetBundleTask(this.project, (AssistantBundleCreator)bundleCreator, (FutureCallback<TutorialBundleData>)((FutureCallback)new AssistantLoadingCallback(bundleId, (AssistantBundleCreator)bundleCreator, defaultTutorialId, onBundleCreated))).queue();
        }
    }

    public static /* synthetic */ void showBundle$default(AssistSidePanel assistSidePanel, String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        assistSidePanel.showBundle(string, string2, (Function1<? super TutorialBundleData, Unit>)function1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ*\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0014\u0010\u0014\u001a\u00020\n2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/assistant/AssistSidePanel$AssistantLoadingCallback;", "Lorg/apache/http/concurrent/FutureCallback;", "Lcom/android/tools/idea/assistant/datamodel/TutorialBundleData;", "bundleId", "", "bundleCreator", "Lcom/android/tools/idea/assistant/AssistantBundleCreator;", "defaultTutorialId", "onBundleCreated", "Lkotlin/Function1;", "", "<init>", "(Lcom/android/tools/idea/assistant/AssistSidePanel;Ljava/lang/String;Lcom/android/tools/idea/assistant/AssistantBundleCreator;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "createFeaturesPanel", "bundle", "actionId", "project", "Lcom/intellij/openapi/project/Project;", "cancelled", "completed", "failed", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "assistant"})
    private final class AssistantLoadingCallback
    implements FutureCallback<TutorialBundleData> {
        @NotNull
        private final String bundleId;
        @NotNull
        private final AssistantBundleCreator bundleCreator;
        @Nullable
        private final String defaultTutorialId;
        @Nullable
        private final Function1<TutorialBundleData, Unit> onBundleCreated;

        public AssistantLoadingCallback(@NotNull String bundleId, @Nullable AssistantBundleCreator bundleCreator, @Nullable String defaultTutorialId, Function1<? super TutorialBundleData, Unit> onBundleCreated) {
            Intrinsics.checkNotNullParameter((Object)bundleId, (String)"bundleId");
            Intrinsics.checkNotNullParameter((Object)bundleCreator, (String)"bundleCreator");
            this.bundleId = bundleId;
            this.bundleCreator = bundleCreator;
            this.defaultTutorialId = defaultTutorialId;
            this.onBundleCreated = onBundleCreated;
        }

        private final void createFeaturesPanel(TutorialBundleData bundle, String actionId, AssistantBundleCreator bundleCreator, Project project) {
            if (bundle == null) {
                AssistSidePanel.this.getLog().error("Unable to get Assistant configuration for action: " + actionId);
                AssistSidePanel.this.errorPanel.setVisible(true);
            } else {
                bundle.setResourceClass(bundleCreator.getClass());
                for (FeatureData featureData : bundle.getFeatures()) {
                    featureData.setResourceClass(bundleCreator.getClass());
                }
                Function1<TutorialBundleData, Unit> function1 = this.onBundleCreated;
                if (function1 != null) {
                    function1.invoke((Object)bundle);
                }
                AnalyticsProvider analyticsProvider = bundleCreator.getAnalyticsProvider();
                Intrinsics.checkNotNullExpressionValue((Object)analyticsProvider, (String)"getAnalyticsProvider(...)");
                AnalyticsProvider analyticsProvider2 = analyticsProvider;
                analyticsProvider2.trackPanelOpened(project);
                AssistSidePanel.this.featuresPanel = new FeaturesPanel(bundle, project, analyticsProvider2, this.defaultTutorialId);
                AssistSidePanel.this.add(AssistSidePanel.this.featuresPanel);
            }
        }

        public void cancelled() {
            AssistSidePanel.this.getLoadingPanel().stopLoading();
        }

        public void completed(@NotNull TutorialBundleData bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            this.createFeaturesPanel(bundle, this.bundleId, this.bundleCreator, AssistSidePanel.this.project);
            AssistSidePanel.this.getLoadingPanel().stopLoading();
        }

        public void failed(@NotNull Exception e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            AssistSidePanel.this.getLog().error((Throwable)e);
            AssistSidePanel.this.getLoadingPanel().stopLoading();
            AssistSidePanel.this.errorPanel.setVisible(true);
        }
    }
}

