/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.DefaultTutorialBundle;
import com.android.tools.idea.assistant.PanelFactory;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.StepData;
import com.android.tools.idea.assistant.datamodel.StepElementData;
import com.android.tools.idea.assistant.view.StatefulButton;
import com.android.tools.idea.assistant.view.UIUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.CopyAction;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.text.DefaultCaret;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TutorialStep
extends JPanel {
    public final JBColor NUMBER_COLOR = new JBColor(5399451, 5807606);
    private static final int IMAGE_PADDING = 10;
    private final int myIndex;
    @NotNull
    private final StepData myStep;
    @NotNull
    private final JPanel myContents;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Class<?> myResourceClass;
    private final boolean myUseLocalHTMLPaths;

    private static Logger getLog() {
        return Logger.getInstance(TutorialStep.class);
    }

    TutorialStep(@NotNull StepData step2, int index, @NotNull ActionListener listener2, @NotNull Project project, boolean hideStepIndex, boolean useLocalHTMLPaths, @NotNull Class<?> resourceClass) {
        super(new GridBagLayout());
        this.myIndex = index;
        this.myStep = step2;
        this.myProject = project;
        this.myContents = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, true));
        this.myUseLocalHTMLPaths = useLocalHTMLPaths;
        this.myResourceClass = resourceClass;
        this.setOpaque(false);
        if (!hideStepIndex) {
            this.initStepNumber();
        }
        if (!this.myStep.getLabel().isEmpty()) {
            this.initLabel();
        }
        this.initStepContentsContainer();
        this.populateStepContents(listener2);
        this.setBorder(this.myStep.getBorder());
    }

    private void populateStepContents(@NotNull ActionListener listener2) {
        HashMap<String, JPanel> panelMap = new HashMap<String, JPanel>();
        block15: for (StepElementData stepElementData : this.myStep.getStepElements()) {
            boolean addedNewComponent = false;
            switch (stepElementData.getType()) {
                case SECTION: {
                    JEditorPane section = new JEditorPane(){

                        @Override
                        public Dimension getPreferredSize() {
                            return new Dimension(1, (int)super.getPreferredSize().getHeight());
                        }
                    };
                    DefaultCaret caret = new DefaultCaret();
                    caret.setUpdatePolicy(1);
                    section.setCaret(caret);
                    section.setOpaque(false);
                    section.setBorder(BorderFactory.createEmptyBorder());
                    section.setDragEnabled(false);
                    String content2 = stepElementData.getSection();
                    if (this.myUseLocalHTMLPaths) {
                        content2 = UIUtils.addLocalHTMLPaths(this.myResourceClass, content2);
                    }
                    UIUtils.setHtml(section, content2, ".as-shim { margin-top: 1px; }");
                    this.myContents.add(section);
                    addedNewComponent = true;
                    break;
                }
                case ACTION: {
                    addedNewComponent = this.handleActionElement(listener2, panelMap, stepElementData);
                    break;
                }
                case CODE: {
                    this.myContents.add((Component)((Object)new CodePane(stepElementData)));
                    addedNewComponent = true;
                    break;
                }
                case IMAGE: {
                    DefaultTutorialBundle.Image imageElement = stepElementData.getImage();
                    if (imageElement == null) {
                        TutorialStep.getLog().error("Image element has no image.");
                        continue block15;
                    }
                    String imageSource = imageElement.getSource();
                    if (imageSource == null) {
                        TutorialStep.getLog().error("Image has no source.");
                        continue block15;
                    }
                    try {
                        InputStream imageStream = this.myResourceClass.getResourceAsStream(imageSource);
                        try {
                            if (imageStream == null) {
                                TutorialStep.getLog().error("Cannot load image: " + imageSource);
                                continue block15;
                            }
                            ImageIcon imageIcon = new ImageIcon(ImageIO.read(imageStream));
                            Image image = imageIcon.getImage();
                            Image scaledImage = image.getScaledInstance(imageElement.getWidth(), imageElement.getHeight(), 4);
                            imageIcon = new ImageIcon(scaledImage, imageElement.getDescription());
                            JPanel containerPanel = new JPanel((LayoutManager)new HorizontalLayout(0));
                            containerPanel.setBackground(UIUtils.getBackgroundColor());
                            containerPanel.setBorder((Border)new JBEmptyBorder(10, 0, 10, 0));
                            containerPanel.add(new JLabel(imageIcon));
                            this.myContents.add(containerPanel);
                            addedNewComponent = true;
                            break;
                        }
                        finally {
                            if (imageStream == null) continue block15;
                            imageStream.close();
                            continue block15;
                        }
                    }
                    catch (IOException e) {
                        TutorialStep.getLog().error("Cannot load image: " + imageSource, (Throwable)e);
                        break;
                    }
                }
                case PANEL: {
                    String factoryId = Objects.requireNonNull(stepElementData.getPanel()).getFactoryId();
                    PanelFactory panelFactory = PanelFactory.EP_NAME.getExtensionList().stream().filter(factory2 -> factory2.getId().equals(factoryId)).findFirst().orElseThrow(() -> new AssertionError((Object)("No PanelFactory exists for " + factoryId)));
                    this.myContents.add(panelFactory.create(this.myProject));
                    break;
                }
                default: {
                    TutorialStep.getLog().error("Found a StepElement of unknown type. " + stepElementData);
                }
            }
            if (!addedNewComponent) continue;
            this.myContents.add(Box.createRigidArea(new Dimension(0, 5)));
        }
    }

    private boolean handleActionElement(@NotNull ActionListener listener2, @NotNull Map<String, JPanel> panelMap, @NotNull StepElementData element) {
        boolean addedNewComponent = false;
        if (element.getAction() != null) {
            ActionData action2 = element.getAction();
            Optional<AssistActionStateManager> stateManager = Arrays.stream((AssistActionStateManager[])AssistActionStateManager.EP_NAME.getExtensions()).filter(s -> s.getId().equals(action2.getKey())).findFirst();
            StatefulButton actionButton = new StatefulButton(action2, listener2, stateManager.orElse(null), this.myProject);
            String groupName = element.getAction().getActionArgument();
            if (groupName == null) {
                this.myContents.add(actionButton);
                addedNewComponent = true;
            } else {
                JPanel panel2 = panelMap.get(groupName);
                if (panel2 == null) {
                    FlowLayout layout = new FlowLayout(0);
                    layout.setVgap(0);
                    layout.setHgap(0);
                    panel2 = new JPanel(layout);
                    panel2.setOpaque(false);
                    panelMap.put(groupName, panel2);
                    this.myContents.add(panel2);
                    addedNewComponent = true;
                }
                panel2.add(actionButton);
            }
        } else {
            TutorialStep.getLog().warn("Found action element with no action definition: " + element);
        }
        return addedNewComponent;
    }

    private void initLabel() {
        JBLabel label2 = new JBLabel(this.myStep.getLabel());
        Font font = label2.getFont();
        Font plainFont = new Font(font.getFontName(), 0, JBUIScale.scaleFontSize((float)18.0f));
        label2.setFont(plainFont);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = JBUI.insets((int)8, (int)10, (int)10, (int)5);
        this.add((Component)label2, c);
    }

    private void initStepContentsContainer() {
        this.myContents.setOpaque(false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = JBUI.insets((int)0, (int)10, (int)0, (int)10);
        this.add((Component)this.myContents, c);
    }

    private void initStepNumber() {
        Font font = new JLabel().getFont();
        JTextPane stepNumber = new JTextPane();
        DefaultCaret ct = (DefaultCaret)stepNumber.getCaret();
        ct.setUpdatePolicy(1);
        stepNumber.setEditable(false);
        stepNumber.setText(String.valueOf(this.myIndex + 1));
        Font boldFont = new Font(font.getFontName(), 1, JBUIScale.scaleFontSize((float)11.0f));
        stepNumber.setFont(boldFont);
        stepNumber.setOpaque(false);
        stepNumber.setForeground((Color)this.NUMBER_COLOR);
        stepNumber.setBorder(new NumberBorder());
        JBDimension size = JBUI.size((int)21, (int)21);
        stepNumber.setSize((Dimension)size);
        stepNumber.setPreferredSize((Dimension)size);
        stepNumber.setMinimumSize((Dimension)size);
        stepNumber.setMaximumSize((Dimension)size);
        StyledDocument doc = stepNumber.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 10;
        c.insets = JBUI.insets((int)5, (int)5, (int)5, (int)0);
        this.add((Component)stepNumber, c);
    }

    private class CodePane
    extends EditorTextField {
        private static final int PAD = 5;
        private static final int MAX_HEIGHT = 500;
        private int myScrollBarHeight;

        private CodePane(StepElementData element) {
            super(element.getCode() != null ? element.getCode() : "", TutorialStep.this.myProject, (FileType)(element.getCodeType() != null ? element.getCodeType() : JavaFileType.INSTANCE));
            this.myScrollBarHeight = 0;
            this.setOneLineMode(false);
            this.setFont(new Font("Monospaced", 0, JBUIScale.scaleFontSize((float)11.0f)));
            this.ensureWillComputePreferredSize();
            this.getDocument().setReadOnly(true);
            this.getPreferredSize();
            int height = Math.min(500, this.getActualPreferredHeight());
            this.setMinimumSize(new Dimension(1, height));
            this.setPreferredSize(new Dimension(this.getActualPreferredWidth(), height));
        }

        private int getActualPreferredWidth() {
            return (int)this.getPreferredSize().getWidth() + 10;
        }

        private int getActualPreferredHeight() {
            return this.getFontMetrics(this.getFont()).getHeight() * this.getDocument().getLineCount() + 10 + this.myScrollBarHeight;
        }

        @NotNull
        protected EditorEx createEditor() {
            final EditorEx editor = super.createEditor();
            editor.setBackgroundColor(UIUtils.getBackgroundColor());
            editor.addEditorMouseListener((EditorMouseListener)new AutoTextSelectionListener(editor));
            editor.installPopupHandler((EditorPopupHandler)new ContextMenuPopupHandler(){

                @NotNull
                public ActionGroup getActionGroup(@NotNull EditorMouseEvent event) {
                    DefaultActionGroup group2 = new DefaultActionGroup();
                    CopyAction copyAction = new CopyAction();
                    copyAction.getTemplatePresentation().setText(ActionsBundle.message((String)"action.EditorCopy.text", (Object[])new Object[0]));
                    copyAction.getTemplatePresentation().setIcon(AllIcons.Actions.Copy);
                    group2.add((AnAction)copyAction);
                    return group2;
                }
            });
            editor.getContentComponent().setFocusTraversalKeysEnabled(false);
            editor.getContentComponent().addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyChar() != '\t') {
                        return;
                    }
                    if (e.getModifiers() == 1) {
                        editor.getContentComponent().transferFocusBackward();
                        return;
                    }
                    editor.getContentComponent().transferFocus();
                }
            });
            JScrollPane scroll = editor.getScrollPane();
            scroll.getViewport().setBackground(UIUtils.getBackgroundColor());
            if (scroll.getViewport().getView() != null) {
                scroll.getViewport().getView().setBackground(UIUtils.getBackgroundColor());
            }
            scroll.addMouseWheelListener(new CodeMouseWheelListener(scroll));
            scroll.setViewportBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, UIUtils.getBackgroundColor()));
            this.myScrollBarHeight = scroll.getHorizontalScrollBar().getPreferredSize().height + 2;
            scroll.setHorizontalScrollBarPolicy(30);
            scroll.setVerticalScrollBarPolicy(20);
            JScrollBar verticalScrollBar = scroll.getVerticalScrollBar();
            JScrollBar horizontalScrollBar = scroll.getHorizontalScrollBar();
            verticalScrollBar.setValue(verticalScrollBar.getMinimum());
            horizontalScrollBar.setValue(horizontalScrollBar.getMinimum());
            return editor;
        }

        class CodeMouseWheelListener
        implements MouseWheelListener {
            @NotNull
            private JScrollBar myScrollBar;
            private int myLastScrollOffset = 0;
            @Nullable
            private JScrollPane myParentScrollPane;
            @NotNull
            private JScrollPane currentScrollPane;

            CodeMouseWheelListener(JScrollPane scroll) {
                this.currentScrollPane = scroll;
                this.myScrollBar = this.currentScrollPane.getVerticalScrollBar();
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int terminalValue;
                JScrollPane parent = this.getParentScrollPane();
                if (parent == null) {
                    this.currentScrollPane.removeMouseWheelListener(this);
                    return;
                }
                int n = terminalValue = e.getWheelRotation() < 0 ? 0 : this.getMax();
                if (this.myScrollBar.getValue() == terminalValue && this.myLastScrollOffset == terminalValue) {
                    parent.dispatchEvent(this.cloneEvent(e));
                }
                this.myLastScrollOffset = this.myScrollBar.getValue();
            }

            private JScrollPane getParentScrollPane() {
                if (this.myParentScrollPane == null) {
                    Container parent;
                    for (parent = CodePane.this.getParent(); !(parent instanceof JScrollPane) && parent != null; parent = parent.getParent()) {
                    }
                    this.myParentScrollPane = (JScrollPane)parent;
                }
                return this.myParentScrollPane;
            }

            private int getMax() {
                return this.myScrollBar.getMaximum() - this.myScrollBar.getVisibleAmount();
            }

            private MouseWheelEvent cloneEvent(MouseWheelEvent e) {
                return new MouseWheelEvent((Component)this.getParentScrollPane(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
            }
        }
    }

    class NumberBorder
    extends AbstractBorder {
        private static final int INSET = 3;

        NumberBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int d = height - 1;
            g2.setColor((Color)TutorialStep.this.NUMBER_COLOR);
            g2.drawOval(x, y, d, d);
            g2.dispose();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return JBUI.insets((int)3);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.bottom = 3;
            insets.top = 3;
            insets.right = 3;
            insets.left = 3;
            return insets;
        }
    }

    private static class AutoTextSelectionListener
    extends EditorMouseAdapter {
        private final EditorEx myEditor;
        private boolean myIsTextSelectedOnMousePressed = false;

        AutoTextSelectionListener(@NotNull EditorEx editor) {
            this.myEditor = editor;
        }

        private boolean isNothingSelected() {
            return Strings.isNullOrEmpty((String)this.myEditor.getSelectionModel().getSelectedText(true));
        }

        private boolean isAnythingSelected() {
            return !Strings.isNullOrEmpty((String)this.myEditor.getSelectionModel().getSelectedText(true));
        }

        public void mouseClicked(@NotNull EditorMouseEvent e) {
            if (e.getMouseEvent().getButton() != 1) {
                return;
            }
            if (!this.myIsTextSelectedOnMousePressed && this.isNothingSelected()) {
                this.selectAllText();
                e.consume();
            }
        }

        public void mousePressed(@NotNull EditorMouseEvent e) {
            if (e.getMouseEvent().getButton() != 1) {
                return;
            }
            this.myIsTextSelectedOnMousePressed = this.isAnythingSelected();
            if (this.myIsTextSelectedOnMousePressed) {
                this.selectNothing();
            }
        }

        private void selectNothing() {
            LogicalPosition docStart = this.myEditor.visualToLogicalPosition(new VisualPosition(0, 0));
            this.myEditor.getCaretModel().setCaretsAndSelections((List)Lists.newArrayList((Object[])new CaretState[]{new CaretState(docStart, docStart, docStart)}));
        }

        private void selectAllText() {
            int lineCount = this.myEditor.getDocument().getLineCount() - 1;
            if (lineCount < 0) {
                return;
            }
            int lastLineEndOffset = this.myEditor.getDocument().getLineEndOffset(lineCount);
            LogicalPosition docStart = this.myEditor.visualToLogicalPosition(new VisualPosition(0, 0));
            LogicalPosition docEnd = this.myEditor.visualToLogicalPosition(new VisualPosition(lineCount, lastLineEndOffset));
            this.myEditor.getCaretModel().setCaretsAndSelections((List)Lists.newArrayList((Object[])new CaretState[]{new CaretState(docStart, docStart, docEnd)}));
        }
    }
}

