/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.skincombobox;

import com.android.tools.idea.avdmanager.skincombobox.Skin;
import com.android.tools.idea.avdmanager.skincombobox.SkinComboBoxModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Editor
extends BasicComboBoxEditor {
    @NotNull
    private final SkinComboBoxModel myModel;
    @Nullable
    private final Project myProject;
    @NotNull
    private final Function<Project, Optional<Path>> myChoosePath;

    Editor(@NotNull SkinComboBoxModel model, @Nullable Project project) {
        this(model, project, Editor::choosePath);
    }

    @VisibleForTesting
    Editor(@NotNull SkinComboBoxModel model, @Nullable Project project, @NotNull Function<Project, Optional<Path>> choosePath) {
        this.myModel = model;
        this.myProject = project;
        this.myChoosePath = choosePath;
    }

    @NotNull
    private static Optional<Path> choosePath(@Nullable Project project) {
        return Optional.ofNullable(FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), (Project)project, null)).map(VirtualFile::toNioPath);
    }

    @Override
    @NotNull
    protected JTextField createEditorComponent() {
        ExtendableTextField textField2 = new ExtendableTextField();
        textField2.setEditable(false);
        textField2.addExtension(ExtendableTextComponent.Extension.create((Icon)AllIcons.General.OpenDisk, (Icon)AllIcons.General.OpenDiskHover, null, this::choosePath));
        return textField2;
    }

    @VisibleForTesting
    void choosePath() {
        this.myChoosePath.apply(this.myProject).map(this.myModel::getSkin).ifPresent(skin -> {
            this.myModel.addElement((Skin)skin);
            this.myModel.setSelectedItem(skin);
        });
    }
}

