/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.skincombobox;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.avdmanager.DeviceSkinUpdater;
import com.android.tools.idea.avdmanager.DeviceSkinUpdaterService;
import com.android.tools.idea.avdmanager.skincombobox.DefaultSkin;
import com.android.tools.idea.avdmanager.skincombobox.PlatformSkin;
import com.android.tools.idea.avdmanager.skincombobox.Skin;
import com.android.tools.idea.avdmanager.skincombobox.SystemImageSkin;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.collect.Streams;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class SkinCollector {
    @NotNull
    private final AndroidSdkHandler myHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
    @NotNull
    private final ProgressIndicator myIndicator = new StudioLoggerProgressIndicator(SkinCollector.class);
    @NotNull
    private final UnaryOperator<Path> myMap;

    private SkinCollector(@NotNull @NotNull UnaryOperator<@NotNull Path> map2) {
        this.myMap = map2;
    }

    @NotNull
    public static @NotNull Collection<@NotNull Skin> updateAndCollect() {
        return new SkinCollector(DeviceSkinUpdater::updateSkin).collect();
    }

    @NotNull
    public static @NotNull Collection<@NotNull Skin> getFilenamesAndCollect() {
        return new SkinCollector(Path::getFileName).collect();
    }

    @NotNull
    private @NotNull Collection<@NotNull Skin> collect() {
        return Streams.concat((Stream[])new Stream[]{this.platformSkins(), SkinCollector.skins(), this.systemImageSkins()}).toList();
    }

    @NotNull
    private Stream<Skin> platformSkins() {
        return this.myHandler.getAndroidTargetManager(this.myIndicator).getTargets(this.myIndicator).stream().flatMap(this::platformSkins);
    }

    @NotNull
    private Stream<Skin> platformSkins(@NotNull IAndroidTarget platform) {
        AndroidVersion version2 = platform.getVersion();
        return platform.getSkins().stream().map(this.myMap).map(path -> new PlatformSkin((Path)path, version2));
    }

    @NotNull
    private static Stream<Skin> skins() {
        return DeviceSkinUpdaterService.deviceSkinStream().map(DefaultSkin::new);
    }

    @NotNull
    private Stream<Skin> systemImageSkins() {
        return this.myHandler.getSystemImageManager(this.myIndicator).getImages().stream().flatMap(this::systemImageSkins);
    }

    @NotNull
    private Stream<Skin> systemImageSkins(@NotNull ISystemImage image) {
        AndroidVersion version2 = image.getAndroidVersion();
        String abi = image.getPrimaryAbiType();
        return image.getSkins().stream().map(this.myMap).map(path -> new SystemImageSkin((Path)path, version2, abi));
    }
}

