/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.ui;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.ui.DeviceUiAction;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ImportDevicesAction
extends DeviceUiAction {
    public ImportDevicesAction(@NotNull DeviceUiAction.DeviceProvider provider) {
        super(provider, "Import Hardware Profiles");
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        VirtualFile[] virtualFileArray;
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, false, false, false, true).withExtensionFilter((FileType)XmlFileType.INSTANCE);
        String homePath = System.getProperty("user.home");
        File parentPath = homePath == null ? new File("/") : new File(homePath);
        VirtualFile parent = LocalFileSystem.getInstance().findFileByIoFile(parentPath);
        if (parent != null) {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = parent;
        } else {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] toSelect = virtualFileArray;
        VirtualFile[] files2 = FileChooserFactory.getInstance().createFileChooser(descriptor2, this.myProvider.getProject(), null).choose(null, toSelect);
        ArrayList<Device> importedDevices = new ArrayList<Device>();
        for (VirtualFile vf : files2) {
            importedDevices.addAll(DeviceManagerConnection.getDevicesFromFile(VfsUtilCore.virtualToIoFile((VirtualFile)vf)));
        }
        if (!importedDevices.isEmpty()) {
            DeviceManagerConnection.getDefaultDeviceManagerConnection().createDevices(importedDevices);
            this.myProvider.refreshDevices();
        }
    }
}

