/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.backup;

import com.android.tools.idea.backup.BackupFileHistory;
import com.android.tools.idea.backup.BackupFileType;
import com.android.tools.idea.util.PathExtensionsKt;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.TextFieldWithHistory;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u0013\u0014B\u0011\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\rJ\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/backup/BackupFileTextField;", "Lcom/intellij/openapi/ui/ComponentWithBrowseButton;", "Lcom/intellij/ui/TextFieldWithHistory;", "Lcom/intellij/ui/TextAccessor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "textComponent", "Ljavax/swing/text/JTextComponent;", "getTextComponent", "()Ljavax/swing/text/JTextComponent;", "setTextAndAddToHistory", "", "text", "", "addCurrentTextToHistory", "setText", "getText", "TextFieldWithProjectStoredHistory", "Companion", "intellij.android.backup"})
public final class BackupFileTextField
extends ComponentWithBrowseButton<TextFieldWithHistory>
implements TextAccessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JTextComponent textComponent;

    private BackupFileTextField(Project project) {
        super((JComponent)((Object)new TextFieldWithProjectStoredHistory(project)), null);
        JTextField jTextField = ((TextFieldWithHistory)this.getChildComponent()).getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextEditor(...)");
        this.textComponent = jTextField;
    }

    @NotNull
    public final JTextComponent getTextComponent() {
        return this.textComponent;
    }

    public final void setTextAndAddToHistory(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        ((TextFieldWithHistory)this.getChildComponent()).setTextAndAddToHistory(text2);
    }

    public final void addCurrentTextToHistory() {
        ((TextFieldWithHistory)this.getChildComponent()).addCurrentTextToHistory();
    }

    public void setText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        ((TextFieldWithHistory)this.getChildComponent()).setText(text2);
    }

    @NotNull
    public String getText() {
        String string = ((TextFieldWithHistory)this.getChildComponent()).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public /* synthetic */ BackupFileTextField(Project project, DefaultConstructorMarker $constructor_marker) {
        this(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/backup/BackupFileTextField$Companion;", "", "<init>", "()V", "createFileSaver", "Lcom/android/tools/idea/backup/BackupFileTextField;", "project", "Lcom/intellij/openapi/project/Project;", "onFileChosen", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "", "createFileChooser", "intellij.android.backup"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackupFileTextField createFileSaver(@NotNull Project project, @NotNull Function1<? super Path, Unit> onFileChosen) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(onFileChosen, (String)"onFileChosen");
            BackupFileTextField textField2 = new BackupFileTextField(project, null);
            textField2.addActionListener(arg_0 -> Companion.createFileSaver$lambda$0(textField2, project, onFileChosen, arg_0));
            return textField2;
        }

        @NotNull
        public final BackupFileTextField createFileChooser(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BackupFileTextField textField2 = new BackupFileTextField(project, null);
            textField2.addActionListener(arg_0 -> Companion.createFileChooser$lambda$1(project, textField2, arg_0));
            return textField2;
        }

        private static final void createFileSaver$lambda$0(BackupFileTextField $textField, Project $project, Function1 $onFileChosen, ActionEvent it) {
            File file;
            Path path;
            Path path2 = Path.of($textField.getText(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
            Path absolutePath = PathExtensionsKt.absoluteInProject((Path)path2, (Project)$project);
            Path parent = absolutePath.getParent();
            String nameWithoutExtension = PathsKt.getNameWithoutExtension((Path)absolutePath);
            VirtualFileWrapper virtualFileWrapper = FileChooserFactory.getInstance().createSaveFileDialog(BackupFileType.INSTANCE.getFILE_SAVER_DESCRIPTOR(), $project).save(parent, nameWithoutExtension);
            Path path3 = path = virtualFileWrapper != null && (file = virtualFileWrapper.getFile()) != null ? file.toPath() : null;
            if (path != null) {
                $textField.setTextAndAddToHistory(((Object)PathExtensionsKt.relativeToProject((Path)path, (Project)$project)).toString());
                $onFileChosen.invoke((Object)path);
            }
        }

        private static final void createFileChooser$lambda$1(Project $project, BackupFileTextField $textField, ActionEvent it) {
            Path path;
            VirtualFile[] virtualFileArray = FileChooserFactory.getInstance().createFileChooser(BackupFileType.INSTANCE.getFILE_CHOOSER_DESCRIPTOR(), $project, null).choose($project, new VirtualFile[0]);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"choose(...)");
            VirtualFile virtualFile = (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray);
            Path path2 = path = virtualFile != null ? virtualFile.toNioPath() : null;
            if (path != null) {
                $textField.setTextAndAddToHistory(((Object)PathExtensionsKt.relativeToProject((Path)path, (Project)$project)).toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/backup/BackupFileTextField$TextFieldWithProjectStoredHistory;", "Lcom/intellij/ui/TextFieldWithHistory;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "backupFileHistory", "Lcom/android/tools/idea/backup/BackupFileHistory;", "addCurrentTextToHistory", "", "reset", "intellij.android.backup"})
    private static final class TextFieldWithProjectStoredHistory
    extends TextFieldWithHistory {
        @NotNull
        private final BackupFileHistory backupFileHistory;

        public TextFieldWithProjectStoredHistory(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.backupFileHistory = new BackupFileHistory(project);
            this.reset();
        }

        public void addCurrentTextToHistory() {
            super.addCurrentTextToHistory();
            List list = this.getHistory();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getHistory(...)");
            this.backupFileHistory.setFileHistory(list);
        }

        public final void reset() {
            List<String> history = this.backupFileHistory.getFileHistory();
            this.setHistory(history);
            this.setSelectedItem("");
        }
    }
}

