/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.targets.PlatformTarget;
import com.android.tools.configurations.Configuration;
import com.android.tools.configurations.ConfigurationSettings;
import com.android.tools.configurations.ResourceResolverCache;
import com.android.tools.idea.configurations.ConfigurationFileState;
import com.android.tools.idea.configurations.ConfigurationForFile;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.ConfigurationProjectState;
import com.android.tools.idea.configurations.ConfigurationStateManager;
import com.android.tools.idea.configurations.ReferenceDevice;
import com.android.tools.idea.configurations.StudioConfigurationModelModule;
import com.android.tools.idea.configurations.StudioConfigurationStateManager;
import com.android.tools.layoutlib.AndroidTargets;
import com.android.tools.res.ResourceRepositoryManager;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.AndroidSdkData;
import com.android.tools.sdk.AndroidTargetData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AvdManagerUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ConfigurationManager
implements Disposable,
ConfigurationSettings {
    private static final String AVD_ID_PREFIX = "_android_virtual_device_id_";
    private static final Key<ConfigurationManager> KEY = Key.create((String)ConfigurationManager.class.getName());
    private static final Key<VirtualFile> CONFIGURATION_MANAGER_PROJECT_CANONICAL_KEY = Key.create((String)(ConfigurationManager.class.getName() + "ProjectCanonicalKey"));
    @NotNull
    private final StudioConfigurationModelModule myConfigurationModule;
    @NotNull
    private final Module myModule;
    private final Map<VirtualFile, ConfigurationForFile> myCache = ContainerUtil.createSoftValueMap();
    private Device myDefaultDevice;
    private Locale myLocale;
    private IAndroidTarget myTarget;
    private int myStateVersion;
    private ResourceResolverCache myResolverCache;

    @NotNull
    public static ConfigurationManager getOrCreateInstance(@NotNull Module module) {
        return ConfigurationManager.findConfigurationManager(module, true);
    }

    @Nullable
    public static ConfigurationManager findExistingInstance(@NotNull Module module) {
        return ConfigurationManager.findConfigurationManager(module, false);
    }

    @Contract(value="_, true -> !null")
    @Nullable
    private static ConfigurationManager findConfigurationManager(@NotNull Module module, boolean createIfNecessary) {
        ConfigurationManager configurationManager = (ConfigurationManager)module.getUserData(KEY);
        if (configurationManager == null && createIfNecessary) {
            configurationManager = new ConfigurationManager(module);
            module.putUserData(KEY, (Object)configurationManager);
        }
        return configurationManager;
    }

    protected ConfigurationManager(@NotNull Module module, StudioConfigurationModelModule config) {
        this.myConfigurationModule = config;
        this.myModule = module;
        Disposer.register((Disposable)this.myModule, (Disposable)this);
    }

    protected ConfigurationManager(@NotNull Module module) {
        this(module, new StudioConfigurationModelModule(module));
    }

    @Slow
    @NotNull
    public ConfigurationForFile getConfiguration(@NotNull VirtualFile file) {
        ConfigurationForFile configuration2 = this.myCache.get(file);
        if (configuration2 == null) {
            configuration2 = this.create(file);
            this.myCache.put(file, configuration2);
        }
        return configuration2;
    }

    @TestOnly
    boolean hasCachedConfiguration(@NotNull VirtualFile file) {
        return this.myCache.get(file) != null;
    }

    @Slow
    @NotNull
    private ConfigurationForFile create(@NotNull VirtualFile file) {
        FolderConfiguration config;
        ConfigurationStateManager stateManager = this.getStateManager();
        ConfigurationFileState fileState = stateManager.getConfigurationState(file);
        FolderConfiguration folderConfiguration = config = file.getParent() != null ? FolderConfiguration.getConfigForFolder((String)file.getParent().getName()) : null;
        if (config == null) {
            config = new FolderConfiguration();
        }
        ConfigurationForFile configuration2 = ConfigurationForFile.create(this, file, fileState, config);
        ConfigurationMatcher matcher = new ConfigurationMatcher(configuration2, file);
        if (stateManager.getProjectState().getDeviceIds().isEmpty() && fileState == null) {
            matcher.findAndSetCompatibleConfig(false);
        } else {
            matcher.adaptConfigSelection(true);
        }
        return configuration2;
    }

    @NotNull
    public ConfigurationForFile createSimilar(@NotNull VirtualFile file, @NotNull VirtualFile baseFile) {
        ConfigurationStateManager stateManager = this.getStateManager();
        ConfigurationFileState fileState = stateManager.getConfigurationState(baseFile);
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)file.getParent().getName());
        if (config == null) {
            config = new FolderConfiguration();
        }
        ConfigurationForFile configuration2 = ConfigurationForFile.create(this, file, fileState, config);
        Configuration baseConfig = this.myCache.get(file);
        if (baseConfig != null) {
            configuration2.setEffectiveDevice(baseConfig.getDevice(), baseConfig.getDeviceState());
        }
        ConfigurationMatcher matcher = new ConfigurationMatcher(configuration2, file);
        matcher.adaptConfigSelection(true);
        this.myCache.put(file, configuration2);
        return configuration2;
    }

    @NotNull
    public ConfigurationStateManager getStateManager() {
        return StudioConfigurationStateManager.get(this.myModule.getProject());
    }

    @Override
    @Slow
    @NotNull
    public ImmutableList<Device> getDevices() {
        AndroidPlatform platform = this.myConfigurationModule.getAndroidPlatform();
        if (platform == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll((Iterable)platform.getSdkData().getDeviceManager().getDevices((Collection)DeviceManager.ALL_DEVICES));
        builder.addAll(ReferenceDevice.INSTANCE.getWindowSizeDevices());
        return builder.build();
    }

    @Override
    @Nullable
    public Device getDeviceById(@NotNull String id2) {
        return this.getDeviceById(id2, (List<Device>)this.getDevices());
    }

    @Nullable
    public Device getDeviceById(@NotNull String id2, List<Device> inputList) {
        return inputList.stream().filter(device2 -> device2.getId().equals(id2)).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public Device createDeviceForAvd(@NotNull AvdInfo avd) {
        AndroidPlatform platform = this.myConfigurationModule.getAndroidPlatform();
        if (platform == null) {
            return null;
        }
        Device modelDevice = platform.getSdkData().getDeviceManager().getDevice(avd.getDeviceName(), avd.getDeviceManufacturer());
        if (modelDevice == null) {
            return null;
        }
        String avdName = avd.getName();
        Device.Builder builder = new Device.Builder(modelDevice);
        builder.setName(avd.getDisplayName());
        builder.setId(AVD_ID_PREFIX + avdName);
        return builder.build();
    }

    public static boolean isAvdDevice(@NotNull Device device2) {
        return device2.getId().startsWith(AVD_ID_PREFIX);
    }

    @Override
    @NotNull
    public IAndroidTarget[] getTargets() {
        AndroidPlatform platform = this.myConfigurationModule.getAndroidPlatform();
        if (platform != null) {
            AndroidSdkData sdkData = platform.getSdkData();
            return sdkData.getTargets();
        }
        return new IAndroidTarget[0];
    }

    @Override
    @Nullable
    public IAndroidTarget getHighestApiTarget() {
        IAndroidTarget[] targetList = this.getTargets();
        for (int i = targetList.length - 1; i >= 0; --i) {
            IAndroidTarget target2 = targetList[i];
            if (!AndroidTargets.isLayoutLibTarget(target2) || !ConfigurationManager.isLayoutLibSupported(target2)) continue;
            return target2;
        }
        return null;
    }

    private static boolean isLayoutLibSupported(IAndroidTarget target2) {
        if (target2 instanceof PlatformTarget) {
            int layoutlibVersion = ((PlatformTarget)target2).getLayoutlibApi();
            return layoutlibVersion <= 17;
        }
        return false;
    }

    @NotNull
    public final Module getModule() {
        return this.myModule;
    }

    @NotNull
    public Project getProject() {
        return this.myConfigurationModule.getProject();
    }

    @Override
    @NotNull
    public final StudioConfigurationModelModule getConfigModule() {
        return this.myConfigurationModule;
    }

    public void dispose() {
        this.myModule.putUserData(KEY, null);
    }

    @Override
    @Nullable
    public Device getDefaultDevice() {
        ImmutableList<Device> devices2;
        if (this.myDefaultDevice == null && !(devices2 = this.getDevices()).isEmpty()) {
            Device device2 = (Device)devices2.get(0);
            for (Device d : devices2) {
                String id2 = d.getId();
                if (id2.equals("pixel")) {
                    device2 = d;
                    break;
                }
                if (!id2.equals("Galaxy Nexus")) continue;
                device2 = d;
            }
            this.myDefaultDevice = device2;
        }
        return this.myDefaultDevice;
    }

    @Nullable
    public IAndroidTarget getDefaultTarget() {
        return this.getHighestApiTarget();
    }

    @Override
    @NotNull
    public ImmutableList<Locale> getLocalesInProject() {
        ResourceRepositoryManager repositoryManager = this.myConfigurationModule.getResourceRepositoryManager();
        assert (repositoryManager != null);
        return repositoryManager.getLocalesInProject();
    }

    @Override
    @Nullable
    public IAndroidTarget getProjectTarget() {
        AndroidPlatform platform = this.myConfigurationModule.getAndroidPlatform();
        return platform != null ? platform.getTarget() : null;
    }

    @NotNull
    private static Locale fromLocaleString(@Nullable String locale) {
        if (locale == null) {
            return Locale.ANY;
        }
        return Locale.create((String)locale);
    }

    @Override
    @NotNull
    public Locale getLocale() {
        if (this.myLocale == null) {
            String localeString = this.getStateManager().getProjectState().getLocale();
            this.myLocale = localeString != null ? ConfigurationManager.fromLocaleString(localeString) : Locale.ANY;
        }
        return this.myLocale;
    }

    @Nullable
    private static String toLocaleString(@Nullable Locale locale) {
        if (locale == null || locale == Locale.ANY) {
            return null;
        }
        return locale.qualifier.getFolderSegment();
    }

    @Override
    public void setLocale(@NotNull Locale locale) {
        if (!locale.equals((Object)this.myLocale)) {
            this.myLocale = locale;
            ++this.myStateVersion;
            this.getStateManager().getProjectState().setLocale(ConfigurationManager.toLocaleString(locale));
            for (Configuration configuration2 : this.myCache.values()) {
                configuration2.updated(16);
            }
        }
    }

    @Override
    @NotNull
    public List<Device> getRecentDevices() {
        List<Device> avdDevices = this.getAvdDevices();
        List<String> deviceIds = this.getStateManager().getProjectState().getDeviceIds();
        if (deviceIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList devices2 = Lists.newArrayListWithExpectedSize((int)deviceIds.size());
        ListIterator<String> iterator2 = deviceIds.listIterator();
        while (iterator2.hasNext()) {
            String id2 = iterator2.next();
            Device device2 = this.getDeviceById(id2);
            if (device2 == null) {
                device2 = this.getDeviceById(id2, avdDevices);
            }
            if (device2 != null) {
                devices2.add(device2);
                continue;
            }
            iterator2.remove();
        }
        return devices2;
    }

    @Override
    public void selectDevice(@NotNull Device device2) {
        String id2 = device2.getId();
        List<String> deviceIds = this.getStateManager().getProjectState().getDeviceIds();
        deviceIds.remove(id2);
        deviceIds.add(0, id2);
        while (deviceIds.size() > 10) {
            deviceIds.remove(deviceIds.size() - 1);
        }
        ++this.myStateVersion;
        for (Configuration configuration2 : this.myCache.values()) {
            boolean updateTheme = false;
            String theme = configuration2.getTheme();
            if (theme.startsWith("@android:style/")) {
                updateTheme = true;
                configuration2.startBulkEditing();
                configuration2.setTheme(null);
            }
            configuration2.setDevice(device2, true);
            if (!updateTheme) continue;
            configuration2.finishBulkEditing();
        }
    }

    @Nullable
    private static IAndroidTarget fromTargetString(@NotNull ConfigurationSettings settings, @Nullable String targetString) {
        if (targetString != null) {
            for (IAndroidTarget target2 : settings.getTargets()) {
                if (!targetString.equals(target2.hashString()) || !AndroidTargets.isLayoutLibTarget(target2)) continue;
                return target2;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IAndroidTarget getTarget() {
        if (this.myTarget == null) {
            ConfigurationProjectState projectState = this.getStateManager().getProjectState();
            if (projectState.isPickTarget()) {
                this.myTarget = this.getDefaultTarget();
            } else {
                String targetString = projectState.getTarget();
                this.myTarget = ConfigurationManager.fromTargetString(this, targetString);
                if (this.myTarget == null) {
                    this.myTarget = this.getDefaultTarget();
                }
            }
            return this.myTarget;
        }
        return this.myTarget;
    }

    @Override
    @Nullable
    public IAndroidTarget getTarget(int min) {
        IAndroidTarget target2 = this.getTarget();
        if (target2 != null && target2.getVersion().getApiLevel() >= min) {
            return target2;
        }
        IAndroidTarget[] targetList = this.getTargets();
        for (int i = targetList.length - 1; i >= 0; --i) {
            target2 = targetList[i];
            if (!AndroidTargets.isLayoutLibTarget(target2) || target2.getVersion().getFeatureLevel() < min || !ConfigurationManager.isLayoutLibSupported(target2)) continue;
            return target2;
        }
        return null;
    }

    @Nullable
    private static String toTargetString(@Nullable IAndroidTarget target2) {
        return target2 != null ? target2.hashString() : null;
    }

    @Override
    public void setTarget(@Nullable IAndroidTarget target2) {
        if (target2 != this.myTarget) {
            AndroidTargetData targetData;
            if (this.myTarget != null && (targetData = AndroidTargetData.getTargetData(this.myTarget, this.myConfigurationModule.getAndroidPlatform())) != null) {
                targetData.clearLayoutBitmapCache(this.myConfigurationModule.getModuleKey());
            }
            this.myTarget = target2;
            if (target2 != null) {
                this.getStateManager().getProjectState().setTarget(ConfigurationManager.toTargetString(target2));
                ++this.myStateVersion;
                for (Configuration configuration2 : this.myCache.values()) {
                    configuration2.updated(32);
                }
            }
        }
    }

    @Override
    public int getStateVersion() {
        return this.myStateVersion;
    }

    @Override
    @NotNull
    public ResourceResolverCache getResolverCache() {
        if (this.myResolverCache == null) {
            this.myResolverCache = new ResourceResolverCache(this);
        }
        return this.myResolverCache;
    }

    @Override
    @NotNull
    public List<Device> getAvdDevices() {
        AndroidFacet facet = AndroidFacet.getInstance((Module)this.myModule);
        if (facet == null) {
            return Collections.emptyList();
        }
        AvdManager avdManager = AvdManagerUtils.getAvdManager(facet);
        if (avdManager == null) {
            return Collections.emptyList();
        }
        return avdManager.getValidAvds().stream().filter(Objects::nonNull).map(this::createDeviceForAvd).collect(Collectors.toList());
    }

    @NotNull
    public static ConfigurationManager getFromConfiguration(@NotNull Configuration configuration2) {
        return (ConfigurationManager)configuration2.getSettings();
    }
}

