/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.connection.assistant.actions;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.assistant.view.UIUtils;
import com.android.tools.idea.connection.assistant.actions.ButtonMessage;
import com.android.tools.idea.connection.assistant.actions.CustomSuccessState;
import com.android.tools.idea.connection.assistant.actions.ListUsbDevicesActionStateManagerKt;
import com.android.tools.idea.connection.assistant.actions.RestartAdbAction;
import com.android.utils.HtmlBuilder;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ConnectionAssistantEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.EdtExecutorService;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0016J\u001b\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u00a2\u0006\u0002\u0010\u0019R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u0007R\u00020\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/connection/assistant/actions/RestartAdbActionStateManager;", "Lcom/android/tools/idea/assistant/AssistActionStateManager;", "<init>", "()V", "projectStates", "", "Lcom/intellij/openapi/project/Project;", "Lcom/android/tools/idea/connection/assistant/actions/RestartAdbActionStateManager$State;", "init", "", "project", "actionData", "Lcom/android/tools/idea/assistant/datamodel/ActionData;", "getId", "", "getState", "Lcom/android/tools/idea/assistant/AssistActionState;", "getStateDisplay", "Lcom/android/tools/idea/assistant/view/StatefulButtonMessage;", "message", "generateMessage", "Lcom/android/tools/idea/connection/assistant/actions/ButtonMessage;", "devices", "", "Lcom/android/ddmlib/IDevice;", "([Lcom/android/ddmlib/IDevice;)Lcom/android/tools/idea/connection/assistant/actions/ButtonMessage;", "State", "connection-assistant"})
@SourceDebugExtension(value={"SMAP\nRestartAdbActionStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestartAdbActionStateManager.kt\ncom/android/tools/idea/connection/assistant/actions/RestartAdbActionStateManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n13402#2:209\n13403#2:211\n1#3:210\n*S KotlinDebug\n*F\n+ 1 RestartAdbActionStateManager.kt\ncom/android/tools/idea/connection/assistant/actions/RestartAdbActionStateManager\n*L\n194#1:209\n194#1:211\n*E\n"})
public final class RestartAdbActionStateManager
extends AssistActionStateManager {
    @NotNull
    private final Map<Project, State> projectStates = new LinkedHashMap();

    @Override
    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
        this.projectStates.computeIfAbsent(project, arg_0 -> RestartAdbActionStateManager.init$lambda$0((Function1)new Function1<Project, State>((Object)this){

            public final State invoke(Project p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return (RestartAdbActionStateManager)this.receiver.new State(p0);
            }
        }, arg_0));
        this.refreshDependencyState(project);
    }

    @Override
    @NotNull
    public String getId() {
        return RestartAdbAction.Companion.getACTION_ID();
    }

    @Override
    @NotNull
    public AssistActionState getState(@NotNull Project project, @NotNull ActionData actionData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
        State state2 = this.projectStates.get(project);
        if ((state2 != null ? state2.getAssistActionState() : null) == null) {
            ListUsbDevicesActionStateManagerKt.getLogger().warn("getState called before init for this project");
            return DefaultActionState.IN_PROGRESS;
        }
        State state3 = this.projectStates.get(project);
        Intrinsics.checkNotNull((Object)state3);
        return state3.getAssistActionState();
    }

    @Override
    @Nullable
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
        State state2 = this.projectStates.get(project);
        if ((state2 != null ? state2.getStateDisplay() : null) == null) {
            ListUsbDevicesActionStateManagerKt.getLogger().warn("getStateDisplay called before init for this project");
            return null;
        }
        State state3 = this.projectStates.get(project);
        Intrinsics.checkNotNull((Object)state3);
        return state3.getStateDisplay();
    }

    private final ButtonMessage generateMessage(IDevice[] devices2) {
        ButtonMessage buttonMessage;
        if (devices2.length == 0) {
            String string = new HtmlBuilder().addHtml(AndroidBundle.message("connection.assistant.adb.no_devices.title", new Object[0])).newlineIfNecessary().getHtml();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHtml(...)");
            buttonMessage = new ButtonMessage(string, new HtmlBuilder().addHtml("<p>" + AndroidBundle.message("connection.assistant.adb.no_devices.body", new Object[0]) + "</p>").getHtml());
        } else {
            String title2 = new HtmlBuilder().addHtml("<span style=\"color: " + UIUtils.getCssColor(UIUtils.getSuccessColor()) + ";\">" + AndroidBundle.message("connection.assistant.adb.devices", new Object[0]) + "</span>").getHtml();
            HtmlBuilder htmlBodyBuilder = new HtmlBuilder();
            IDevice[] $this$forEach$iv = devices2;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                AndroidVersion androidVersion;
                IDevice element$iv;
                IDevice device2 = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                AndroidVersion it = androidVersion = device2.getVersion();
                boolean bl2 = false;
                AndroidVersion deviceVersion = !Intrinsics.areEqual((Object)it, (Object)AndroidVersion.DEFAULT) ? androidVersion : null;
                AndroidVersion $this$generateMessage_u24lambda_u243_u24lambda_u242 = androidVersion = htmlBodyBuilder.addHtml("<p><span>" + device2.getName() + "</span>").newline();
                boolean bl3 = false;
                if (deviceVersion == null) continue;
                $this$generateMessage_u24lambda_u243_u24lambda_u242.addHtml("<span style=\"font-size: 80%; font-weight: lighter;\">" + device2.getVersion() + "</span></p>").newline();
            }
            Intrinsics.checkNotNull((Object)title2);
            buttonMessage = new ButtonMessage(title2, htmlBodyBuilder.getHtml());
        }
        return buttonMessage;
    }

    private static final State init$lambda$0(Function1 $tmp0, Object p0) {
        return (State)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0012\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0010H\u0016J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/connection/assistant/actions/RestartAdbActionStateManager$State;", "Lcom/android/ddmlib/AndroidDebugBridge$IDebugBridgeChangeListener;", "Lcom/android/ddmlib/AndroidDebugBridge$IDeviceChangeListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/android/tools/idea/connection/assistant/actions/RestartAdbActionStateManager;Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "adbFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "Lcom/android/ddmlib/AndroidDebugBridge;", "loading", "", "initDebugBridge", "", "setLoading", "bridgeChanged", "bridge", "restartInitiated", "restartCompleted", "isSuccessful", "deviceConnected", "device", "Lcom/android/ddmlib/IDevice;", "deviceDisconnected", "deviceChanged", "changeMask", "", "dispose", "getAssistActionState", "Lcom/android/tools/idea/assistant/AssistActionState;", "getStateDisplay", "Lcom/android/tools/idea/assistant/view/StatefulButtonMessage;", "connection-assistant"})
    private final class State
    implements AndroidDebugBridge.IDebugBridgeChangeListener,
    AndroidDebugBridge.IDeviceChangeListener,
    Disposable {
        @NotNull
        private final Project project;
        @Nullable
        private ListenableFuture<AndroidDebugBridge> adbFuture;
        private boolean loading;

        public State(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
            AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
            Disposer.register((Disposable)((Disposable)this.project), (Disposable)this);
            this.initDebugBridge();
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public final void initDebugBridge() {
            File file = AndroidSdkUtils.getAdb(this.project);
            if (file == null) {
                return;
            }
            File adb = file;
            ListenableFuture<AndroidDebugBridge> listenableFuture = AdbService.getInstance().getDebugBridge(adb);
            if (listenableFuture == null) {
                return;
            }
            this.adbFuture = listenableFuture;
            Futures.addCallback(this.adbFuture, (FutureCallback)((FutureCallback)new FutureCallback<AndroidDebugBridge>(RestartAdbActionStateManager.this, this){
                final /* synthetic */ RestartAdbActionStateManager this$0;
                final /* synthetic */ State this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void onSuccess(AndroidDebugBridge bridge) {
                    this.this$0.refreshDependencyState(this.this$1.getProject());
                }

                public void onFailure(Throwable t) {
                    this.this$0.refreshDependencyState(this.this$1.getProject());
                }
            }), (Executor)((Executor)EdtExecutorService.getInstance()));
        }

        private final void setLoading(boolean loading) {
            this.loading = loading;
            RestartAdbActionStateManager.this.refreshDependencyState(this.project);
        }

        public void bridgeChanged(@Nullable AndroidDebugBridge bridge) {
        }

        public void restartInitiated() {
            this.setLoading(true);
        }

        public void restartCompleted(boolean isSuccessful) {
            this.setLoading(false);
        }

        public void deviceConnected(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            RestartAdbActionStateManager.this.refreshDependencyState(this.project);
        }

        public void deviceDisconnected(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            RestartAdbActionStateManager.this.refreshDependencyState(this.project);
        }

        public void deviceChanged(@NotNull IDevice device2, int changeMask) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            if (changeMask == 1) {
                RestartAdbActionStateManager.this.refreshDependencyState(this.project);
            }
        }

        public void dispose() {
            AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
            RestartAdbActionStateManager.this.projectStates.remove(this.project);
        }

        @NotNull
        public final AssistActionState getAssistActionState() {
            block7: {
                block6: {
                    if (this.loading) {
                        return DefaultActionState.IN_PROGRESS;
                    }
                    if (this.adbFuture == null) {
                        return DefaultActionState.INCOMPLETE;
                    }
                    ListenableFuture<AndroidDebugBridge> listenableFuture = this.adbFuture;
                    Intrinsics.checkNotNull(listenableFuture);
                    if (!listenableFuture.isDone()) {
                        return DefaultActionState.IN_PROGRESS;
                    }
                    AndroidDebugBridge adb = AndroidDebugBridge.getBridge();
                    if (adb == null) break block6;
                    IDevice[] iDeviceArray = adb.getDevices();
                    Intrinsics.checkNotNullExpressionValue((Object)iDeviceArray, (String)"getDevices(...)");
                    if (!(((Object[])iDeviceArray).length == 0)) break block7;
                }
                return DefaultActionState.ERROR_RETRY;
            }
            return CustomSuccessState.INSTANCE;
        }

        @NotNull
        public final StatefulButtonMessage getStateDisplay() {
            ButtonMessage buttonMessage;
            AssistActionState state2 = this.getAssistActionState();
            AssistActionState assistActionState = state2;
            if (assistActionState == DefaultActionState.IN_PROGRESS) {
                String string = AndroidBundle.message("connection.assistant.loading", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                buttonMessage = new ButtonMessage(string, null, 2, null);
            } else if (Intrinsics.areEqual((Object)assistActionState, (Object)CustomSuccessState.INSTANCE) || assistActionState == DefaultActionState.ERROR_RETRY) {
                IDevice[] adb;
                IDevice[] iDeviceArray = adb = AndroidDebugBridge.getBridge();
                int deviceCount = adb != null && (iDeviceArray = iDeviceArray.getDevices()) != null ? iDeviceArray.length : -1;
                AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.CONNECTION_ASSISTANT_EVENT).setConnectionAssistantEvent(ConnectionAssistantEvent.newBuilder().setType(ConnectionAssistantEvent.ConnectionAssistantEventType.ADB_DEVICES_DETECTED).setAdbDevicesDetected(deviceCount));
                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setConnectionAssistantEvent(...)");
                UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(builder, this.project));
                if (adb != null) {
                    IDevice[] iDeviceArray2 = adb.getDevices();
                    Intrinsics.checkNotNullExpressionValue((Object)iDeviceArray2, (String)"getDevices(...)");
                    buttonMessage = RestartAdbActionStateManager.this.generateMessage(iDeviceArray2);
                } else {
                    String string = AndroidBundle.message("connection.assistant.adb.failure", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    buttonMessage = new ButtonMessage(string, null, 2, null);
                }
            } else {
                String string = AndroidBundle.message("connection.assistant.adb.unexpected", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                buttonMessage = new ButtonMessage(string, null, 2, null);
            }
            ButtonMessage buttonMessage2 = buttonMessage;
            String title2 = buttonMessage2.component1();
            String body = buttonMessage2.component2();
            return new StatefulButtonMessage(title2, state2, body);
        }
    }
}

