/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.sdklib.AndroidApiLevel;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.debug.AndroidPositionManagerKt;
import com.android.tools.idea.debug.PsiUtilsKt;
import com.android.tools.idea.execution.common.AndroidSessionInfo;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.SdkInstallListener;
import com.android.tools.idea.sdk.sources.SdkSourcePositionFinder;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XDebugSessionListener;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 +2\u00020\u0001:\u0002*+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0012\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u0003H\u0002J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J$\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010$\u001a\u00020%*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010&\u001a\u00020%*\u00020\n2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010)\u001a\u00020%*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/debug/AndroidPositionManager;", "Lcom/intellij/debugger/engine/PositionManagerImpl;", "myDebugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "<init>", "(Lcom/intellij/debugger/engine/DebugProcessImpl;)V", "myAndroidVersion", "Lcom/android/sdklib/AndroidVersion;", "getAllClasses", "", "Lcom/sun/jdi/ReferenceType;", "position", "Lcom/intellij/debugger/SourcePosition;", "createPrepareRequests", "Lcom/sun/jdi/request/ClassPrepareRequest;", "requestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "getAcceptedFileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "getSourcePosition", "location", "Lcom/sun/jdi/Location;", "getPsiFileByLocation", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "refreshDebugSession", "", "getDisposable", "Lcom/intellij/openapi/Disposable;", "getExtraPrepareRequests", "getCompanionClasses", "types", "getCompanionsOfTypes", "getCompanionsForPositionByName", "hasLocationsForPosition", "", "isCompanion", "className", "", "containsPosition", "MyXDebugSessionListener", "Companion", "intellij.android.debuggers"})
@SourceDebugExtension(value={"SMAP\nAndroidPositionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPositionManager.kt\ncom/android/tools/idea/debug/AndroidPositionManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,324:1\n25#2:325\n25#2:326\n774#3:327\n865#3,2:328\n774#3:331\n865#3:332\n1755#3,3:333\n866#3:336\n1368#3:337\n1454#3,5:338\n1#4:330\n*S KotlinDebug\n*F\n+ 1 AndroidPositionManager.kt\ncom/android/tools/idea/debug/AndroidPositionManager\n*L\n82#1:325\n186#1:326\n235#1:327\n235#1:328,2\n247#1:331\n247#1:332\n248#1:333,3\n247#1:336\n256#1:337\n256#1:338,5\n*E\n"})
public final class AndroidPositionManager
extends PositionManagerImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DebugProcessImpl myDebugProcess;
    @Nullable
    private final AndroidVersion myAndroidVersion;
    @NotNull
    private static final Logger LOG;

    public AndroidPositionManager(@NotNull DebugProcessImpl myDebugProcess) {
        Intrinsics.checkNotNullParameter((Object)myDebugProcess, (String)"myDebugProcess");
        super(myDebugProcess);
        this.myDebugProcess = myDebugProcess;
        this.myAndroidVersion = (AndroidVersion)this.myDebugProcess.getProcessHandler().getUserData(AndroidSessionInfo.Companion.getANDROID_DEVICE_API_LEVEL());
        Disposable disposable = this.getDisposable(this.myDebugProcess);
        if (disposable == null) {
            AndroidPositionManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AndroidPositionManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot subscribe to OnDownloadedCallback");
        } else {
            this.myDebugProcess.getProject().getMessageBus().connect(disposable).subscribe(SdkInstallListener.TOPIC, (arg_0, arg_1) -> AndroidPositionManager._init_$lambda$2(this, arg_0, arg_1));
        }
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition position) throws NoDataException {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        List list = super.getAllClasses(position);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllClasses(...)");
        List classes = list;
        List<ReferenceType> companionClasses = this.getCompanionClasses(position, classes);
        List allClasses = CollectionsKt.plus((Collection)classes, (Iterable)companionClasses);
        if (allClasses.isEmpty()) {
            throw NoDataException.INSTANCE;
        }
        return CollectionsKt.distinct((Iterable)allClasses);
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) throws NoDataException {
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        List list = super.createPrepareRequests(requestor, position);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createPrepareRequests(...)");
        List requests2 = CollectionsKt.plus((Collection)list, (Iterable)this.getExtraPrepareRequests(requestor, position));
        if (requests2.isEmpty()) {
            throw NoDataException.INSTANCE;
        }
        return requests2;
    }

    @NotNull
    public Set<FileType> getAcceptedFileTypes() {
        return SetsKt.setOf((Object)JavaFileType.INSTANCE);
    }

    @NotNull
    public SourcePosition getSourcePosition(@Nullable Location location) throws NoDataException {
        if (location == null) {
            throw NoDataException.INSTANCE;
        }
        if (this.myAndroidVersion == null) {
            LOG.debug("getSourcePosition cannot determine version from device.");
            throw NoDataException.INSTANCE;
        }
        Project project = this.myDebugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiFile file = this.getPsiFileByLocation(project2, location);
        if (file == null || !AndroidSdks.getInstance().isInAndroidSdk((PsiElement)file)) {
            throw NoDataException.INSTANCE;
        }
        SdkSourcePositionFinder sdkSourcePositionFinder = SdkSourcePositionFinder.Companion.getInstance(project2);
        AndroidApiLevel androidApiLevel = this.myAndroidVersion.getAndroidApiLevel();
        Intrinsics.checkNotNullExpressionValue((Object)androidApiLevel, (String)"getAndroidApiLevel(...)");
        return sdkSourcePositionFinder.getSourcePosition(androidApiLevel, file, DebuggerUtilsEx.getLineNumber((Location)location, (boolean)true));
    }

    @VisibleForTesting
    @Nullable
    public PsiFile getPsiFileByLocation(@NotNull Project project, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return super.getPsiFileByLocation(project, location);
    }

    private final void refreshDebugSession() {
        Project project = this.myDebugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DumbService.Companion.getInstance(project).smartInvokeLater(() -> AndroidPositionManager.refreshDebugSession$lambda$6(this));
    }

    private final Disposable getDisposable(DebugProcessImpl $this$getDisposable) {
        Disposable disposable;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            disposable = (Disposable)$this$getDisposable.getProject();
        } else {
            Disposable disposable2;
            try {
                Field field2 = DebugProcessImpl.class.getDeclaredField("myDisposable");
                field2.setAccessible(true);
                Object object = field2.get($this$getDisposable);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.Disposable");
                disposable2 = (Disposable)object;
            }
            catch (Exception e) {
                DebugProcessImpl $this$thisLogger$iv = $this$getDisposable;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(DebugProcessImpl.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Could not get DebugProcessImpl.disposable");
                disposable2 = null;
            }
            disposable = disposable2;
        }
        return disposable;
    }

    private final List<ClassPrepareRequest> getExtraPrepareRequests(ClassPrepareRequestor requestor, SourcePosition position) {
        Object object = ReadAction.compute(() -> AndroidPositionManager.getExtraPrepareRequests$lambda$8(position, this, requestor));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ReferenceType> getCompanionClasses(SourcePosition position, List<? extends ReferenceType> types) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = types;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ReferenceType type = (ReferenceType)element$iv$iv;
            boolean bl = false;
            Project project = this.getDebugProcess().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Object object = DumbService.Companion.getInstance(project).runReadActionInSmartMode(() -> AndroidPositionManager.getCompanionClasses$lambda$10$lambda$9(this, type));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadActionInSmartMode(...)");
            if (!((Boolean)object).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List candidatesForDesugaringCompanion = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)this.getCompanionsOfTypes(position, candidatesForDesugaringCompanion), (Iterable)this.getCompanionsForPositionByName(position));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ReferenceType> getCompanionsOfTypes(SourcePosition position, List<? extends ReferenceType> types) {
        void $this$filterTo$iv$iv;
        Object $this$getCompanionsOfTypes_u24lambda_u2411;
        AndroidPositionManager androidPositionManager = this;
        try {
            $this$getCompanionsOfTypes_u24lambda_u2411 = androidPositionManager;
            boolean bl = false;
            $this$getCompanionsOfTypes_u24lambda_u2411 = Result.constructor-impl((Object)$this$getCompanionsOfTypes_u24lambda_u2411.getDebugProcess().getVirtualMachineProxy().allClasses());
        }
        catch (Throwable bl) {
            $this$getCompanionsOfTypes_u24lambda_u2411 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        androidPositionManager = $this$getCompanionsOfTypes_u24lambda_u2411;
        $this$getCompanionsOfTypes_u24lambda_u2411 = CollectionsKt.emptyList();
        List allLoadedTypes = (List)(Result.isFailure-impl((Object)((Object)androidPositionManager)) ? $this$getCompanionsOfTypes_u24lambda_u2411 : androidPositionManager);
        Intrinsics.checkNotNull((Object)allLoadedTypes);
        Iterable $this$filter$iv = allLoadedTypes;
        boolean $i$f$filter = false;
        Iterable bl = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl2;
            block6: {
                ReferenceType loadedType = (ReferenceType)element$iv$iv;
                boolean bl3 = false;
                Iterable $this$any$iv = types;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ReferenceType candidate = (ReferenceType)element$iv;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)loadedType);
                        String string = candidate.name();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                        if (!this.isCompanion(loadedType, string, position)) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<ReferenceType> getCompanionsForPositionByName(SourcePosition position) {
        Object object = ReadAction.compute(() -> AndroidPositionManager.getCompanionsForPositionByName$lambda$15(position, this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (List)object;
    }

    private final boolean hasLocationsForPosition(ReferenceType $this$hasLocationsForPosition, SourcePosition position) {
        Object object;
        Object object2 = $this$hasLocationsForPosition;
        try {
            ReferenceType $this$hasLocationsForPosition_u24lambda_u2416 = object2;
            boolean bl = false;
            List list = this.locationsOfLine($this$hasLocationsForPosition_u24lambda_u2416, position);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"locationsOfLine(...)");
            object = Result.constructor-impl((Object)(!((Collection)list).isEmpty() ? 1 : 0));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = false;
        return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    private final boolean isCompanion(ReferenceType $this$isCompanion, String className, SourcePosition position) {
        return AndroidPositionManagerKt.access$startsWith($this$isCompanion, className + "$") && this.containsPosition($this$isCompanion, position);
    }

    private final boolean containsPosition(ReferenceType $this$containsPosition, SourcePosition position) {
        List list = this.locationsOfLine($this$containsPosition, position);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"locationsOfLine(...)");
        return !((Collection)list).isEmpty();
    }

    private static final void _init_$lambda$2(AndroidPositionManager this$0, Collection installed, Collection uninstalled) {
        block9: {
            block8: {
                Object v2;
                block7: {
                    Object v1;
                    UpdatablePackage it;
                    Iterable iterable;
                    String path;
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)installed, (String)"installed");
                        Intrinsics.checkNotNullParameter((Object)uninstalled, (String)"uninstalled");
                        AndroidVersion androidVersion = this$0.myAndroidVersion;
                        if (androidVersion == null) {
                            return;
                        }
                        path = DetailsTypes.getSourcesPath((AndroidVersion)androidVersion);
                        iterable = installed;
                        for (Object t : iterable) {
                            it = (UpdatablePackage)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getPath(), (Object)path)) continue;
                            v1 = t;
                            break block6;
                        }
                        v1 = null;
                    }
                    if (v1 != null) break block8;
                    iterable = uninstalled;
                    for (Object t : iterable) {
                        it = (LocalPackage)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getPath(), (Object)path)) continue;
                        v2 = t;
                        break block7;
                    }
                    v2 = null;
                }
                if (v2 == null) break block9;
            }
            this$0.refreshDebugSession();
        }
    }

    private static final void refreshDebugSession$lambda$6$lambda$5$lambda$3(AndroidPositionManager this$0) {
        this$0.myDebugProcess.getSession().refresh(true);
    }

    private static final boolean refreshDebugSession$lambda$6$lambda$5$lambda$4(AndroidPositionManager this$0, Object it) {
        return this$0.myDebugProcess.getSession().isStopped();
    }

    private static final void refreshDebugSession$lambda$6$lambda$5(AndroidPositionManager this$0) {
        this$0.myDebugProcess.getPositionManager().clearCache();
        ApplicationManager.getApplication().invokeLater(() -> AndroidPositionManager.refreshDebugSession$lambda$6$lambda$5$lambda$3(this$0), arg_0 -> AndroidPositionManager.refreshDebugSession$lambda$6$lambda$5$lambda$4(this$0, arg_0));
    }

    private static final void refreshDebugSession$lambda$6(AndroidPositionManager this$0) {
        this$0.myDebugProcess.getManagerThread().invoke(PrioritizedTask.Priority.HIGH, () -> AndroidPositionManager.refreshDebugSession$lambda$6$lambda$5(this$0));
    }

    private static final void getExtraPrepareRequests$lambda$8$lambda$7(AndroidPositionManager this$0, SourcePosition $position, ClassPrepareRequestor $requestor, DebugProcess debuggerProcess, ReferenceType referenceType) {
        Intrinsics.checkNotNull((Object)referenceType);
        if (this$0.hasLocationsForPosition(referenceType, $position)) {
            $requestor.processClassPrepare(debuggerProcess, referenceType);
        }
    }

    private static final List getExtraPrepareRequests$lambda$8(SourcePosition $position, AndroidPositionManager this$0, ClassPrepareRequestor $requestor) {
        PsiElement psiElement = $position.getElementAt();
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement element = psiElement;
        PsiClass psiClass = AndroidPositionManagerKt.access$getInterfaceParent(element);
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass classHolder = psiClass;
        if (AndroidPositionManagerKt.access$isAbstractMethod(element)) {
            return CollectionsKt.emptyList();
        }
        String classPattern = PsiUtilsKt.getJvmName(classHolder) + "$*";
        ClassPrepareRequestor trampolinePrepareRequestor = (arg_0, arg_1) -> AndroidPositionManager.getExtraPrepareRequests$lambda$8$lambda$7(this$0, $position, $requestor, arg_0, arg_1);
        return CollectionsKt.listOfNotNull((Object)this$0.getDebugProcess().getRequestsManager().createClassPrepareRequest(trampolinePrepareRequestor, classPattern));
    }

    private static final Boolean getCompanionClasses$lambda$10$lambda$9(AndroidPositionManager this$0, ReferenceType $type) {
        Project project = this$0.getDebugProcess().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiClass psiClass = AndroidPositionManagerKt.access$findClassInAllScope(project, $type);
        return psiClass != null ? AndroidPositionManagerKt.access$canBeTransformedForDesugaring(psiClass) : false;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getCompanionsForPositionByName$lambda$15(SourcePosition $position, AndroidPositionManager this$0) {
        void $this$flatMapTo$iv$iv;
        Set set2 = PositionManagerImpl.getLineClasses((PsiFile)$position.getFile(), (int)$position.getLine());
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getLineClasses(...)");
        Iterable $this$flatMap$iv = set2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PsiClass it = (PsiClass)element$iv$iv;
            boolean bl = false;
            VirtualMachineProxy virtualMachineProxy = this$0.getDebugProcess().getVirtualMachineProxy();
            Intrinsics.checkNotNull((Object)it);
            List list = virtualMachineProxy.classesByName(PsiUtilsKt.getJvmName(it) + "$-CC");
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classesByName(...)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        Logger logger = Logger.getInstance(AndroidPositionManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\f\u0010\r\u001a\u00020\b*\u00020\bH\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/debug/AndroidPositionManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getRelPathForJavaSource", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "changeClassExtensionToJava", "intellij.android.debuggers"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @Nullable
        public final String getRelPathForJavaSource(@NotNull Project project, @NotNull PsiFile file) {
            String string;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            FileType fileType = file.getFileType();
            if (Intrinsics.areEqual((Object)fileType, (Object)JavaFileType.INSTANCE)) {
                VirtualFile sourceRoot = ProjectFileIndex.getInstance((Project)project).getSourceRootForFile(file.getVirtualFile());
                if (sourceRoot == null) {
                    LOG.debug("Could not determine source root for file: " + file.getVirtualFile().getPath());
                    string = null;
                } else {
                    string = VfsUtilCore.getRelativePath((VirtualFile)file.getVirtualFile(), (VirtualFile)sourceRoot);
                }
            } else if (Intrinsics.areEqual((Object)fileType, (Object)JavaClassFileType.INSTANCE)) {
                String relativeClassPath;
                VirtualFile virtualFile = file.getVirtualFile();
                String string2 = relativeClassPath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)VfsUtilCore.getRootFile((VirtualFile)virtualFile));
                string = string2 != null ? this.changeClassExtensionToJava(string2) : null;
            } else {
                string = null;
            }
            return string;
        }

        @VisibleForTesting
        @NotNull
        public final String changeClassExtensionToJava(@NotNull String $this$changeClassExtensionToJava) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)$this$changeClassExtensionToJava, (String)"<this>");
            if (StringsKt.endsWith$default((String)$this$changeClassExtensionToJava, (String)".class", (boolean)false, (int)2, null)) {
                String string = $this$changeClassExtensionToJava.substring(0, $this$changeClassExtensionToJava.length() - 6);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = string + ".java";
            } else {
                object = $this$changeClassExtensionToJava;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/debug/AndroidPositionManager$MyXDebugSessionListener;", "Lcom/intellij/xdebugger/XDebugSessionListener;", "fileToClose", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)V", "myFileToClose", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "myProject", "sessionStopped", "", "intellij.android.debuggers"})
    @SourceDebugExtension(value={"SMAP\nAndroidPositionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPositionManager.kt\ncom/android/tools/idea/debug/AndroidPositionManager$MyXDebugSessionListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,324:1\n1#2:325\n*E\n"})
    public static final class MyXDebugSessionListener
    implements XDebugSessionListener {
        @NotNull
        private final WeakReference<VirtualFile> myFileToClose;
        @NotNull
        private final Project myProject;

        @VisibleForTesting
        public MyXDebugSessionListener(@NotNull VirtualFile fileToClose, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)fileToClose, (String)"fileToClose");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.myFileToClose = new WeakReference<VirtualFile>(fileToClose);
            this.myProject = project;
        }

        public void sessionStopped() {
            block0: {
                VirtualFile virtualFile = (VirtualFile)this.myFileToClose.get();
                if (virtualFile == null) break block0;
                VirtualFile it = virtualFile;
                boolean bl = false;
                ActionsKt.runInEdt$default(null, () -> MyXDebugSessionListener.sessionStopped$lambda$1$lambda$0(this, it), (int)1, null);
            }
        }

        private static final Unit sessionStopped$lambda$1$lambda$0(MyXDebugSessionListener this$0, VirtualFile $it) {
            FileEditorManager.getInstance((Project)this$0.myProject).closeFile($it);
            return Unit.INSTANCE;
        }
    }
}

