/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.ddmlib.BitmapDecoder;
import com.google.common.collect.ImmutableList;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BitmapEvaluatorProvider
implements BitmapDecoder.BitmapDataProvider,
AutoCloseable {
    private static final int MAX_DIMENSION = 1024;
    @NotNull
    private EvaluationContextImpl myEvaluationContext;
    @NotNull
    private ObjectReference myBitmap;
    private boolean isGcDisabledOnBitmap = false;

    public BitmapEvaluatorProvider(@NotNull Value bitmap, @NotNull EvaluationContextImpl evaluationContext) {
        this.myEvaluationContext = evaluationContext;
        String fqcn = bitmap.type().name();
        if ("android.graphics.drawable.BitmapDrawable".equals(fqcn)) {
            Value actualBitmap = this.getBitmapFromDrawable((ObjectReference)bitmap);
            if (actualBitmap == null) {
                throw new RuntimeException("Unable to obtain bitmap from drawable");
            }
            this.myBitmap = (ObjectReference)actualBitmap;
        } else {
            if (!"android.graphics.Bitmap".equals(fqcn)) {
                throw new RuntimeException("Invalid parameter passed into method");
            }
            this.myBitmap = (ObjectReference)bitmap;
        }
    }

    @Nullable
    public String getBitmapConfigName() throws EvaluateException {
        Value config = this.getBitmapConfig();
        if (!(config instanceof ObjectReference)) {
            return null;
        }
        Field f = ((ObjectReference)config).referenceType().fieldByName("name");
        if (f == null) {
            return null;
        }
        return ((ObjectReference)config).getValue(f).toString();
    }

    @Nullable
    public Dimension getDimension() throws EvaluateException {
        DebugProcessImpl debugProcess2 = this.myEvaluationContext.getDebugProcess();
        Integer w = this.getImageDimension(debugProcess2, "getWidth");
        Integer h = this.getImageDimension(debugProcess2, "getHeight");
        return w != null && h != null ? new Dimension(w, h) : null;
    }

    public boolean downsizeBitmap(@NotNull Dimension currentDimensions) throws EvaluateException {
        Value filter2;
        Value dstHeight;
        DebugProcessImpl debugProcess2 = this.myEvaluationContext.getDebugProcess();
        Method createScaledBitmapMethod = DebuggerUtils.findMethod((ReferenceType)this.myBitmap.referenceType(), (String)"createScaledBitmap", (String)"(Landroid/graphics/Bitmap;IIZ)Landroid/graphics/Bitmap;");
        if (createScaledBitmapMethod == null) {
            return false;
        }
        double s = Math.max(currentDimensions.getHeight(), currentDimensions.getWidth()) / 1024.0;
        VirtualMachineProxyImpl vm = this.myEvaluationContext.getDebugProcess().getVirtualMachineProxy();
        Value dstWidth = DebuggerUtilsEx.createValue((VirtualMachineProxyImpl)vm, (String)"int", (long)((int)(currentDimensions.getWidth() / s)));
        Value result2 = debugProcess2.invokeMethod((EvaluationContext)this.myEvaluationContext, this.myBitmap, createScaledBitmapMethod, Arrays.asList(this.myBitmap, dstWidth, dstHeight = DebuggerUtilsEx.createValue((VirtualMachineProxyImpl)vm, (String)"int", (long)((int)(currentDimensions.getHeight() / s))), filter2 = DebuggerUtilsEx.createValue((VirtualMachineProxyImpl)vm, (String)"boolean", (boolean)Boolean.FALSE)));
        if (result2 != null) {
            this.enableGarbageCollection();
            this.myBitmap = (ObjectReference)result2;
            this.disableGarbageCollection();
        }
        return result2 != null;
    }

    @Nullable
    public byte[] getPixelBytes(@NotNull Dimension size) throws Exception {
        List<Value> pixelValues;
        Field bufferField = this.myBitmap.referenceType().fieldByName("mBuffer");
        if (bufferField != null) {
            Value bufferValue = this.myBitmap.getValue(bufferField);
            if (!(bufferValue instanceof ArrayReference)) {
                throw new RuntimeException("Image Buffer is not an array");
            }
            pixelValues = ((ArrayReference)bufferValue).getValues();
        } else {
            pixelValues = this.copyToBuffer(size);
            if (pixelValues == null) {
                throw new RuntimeException("Unable to extract image data: Bitmap has no buffer field.");
            }
        }
        byte[] argb = new byte[pixelValues.size()];
        for (int i = 0; i < pixelValues.size(); ++i) {
            Value pixelValue = pixelValues.get(i);
            if (!(pixelValue instanceof ByteValue)) continue;
            argb[i] = ((ByteValue)pixelValue).byteValue();
        }
        return argb;
    }

    @Nullable
    private Value getBitmapConfig() throws EvaluateException {
        DebugProcessImpl debugProcess2 = this.myEvaluationContext.getDebugProcess();
        Method getConfig = DebuggerUtils.findMethod((ReferenceType)this.myBitmap.referenceType(), (String)"getConfig", (String)"()Landroid/graphics/Bitmap$Config;");
        if (getConfig == null) {
            return null;
        }
        return debugProcess2.invokeMethod((EvaluationContext)this.myEvaluationContext, this.myBitmap, getConfig, Collections.emptyList());
    }

    @Nullable
    private Integer getImageDimension(@NotNull DebugProcessImpl debugProcess2, @NotNull String methodName) throws EvaluateException {
        Value widthValue;
        Method method2 = DebuggerUtils.findMethod((ReferenceType)this.myBitmap.referenceType(), (String)methodName, (String)"()I");
        if (method2 != null && (widthValue = debugProcess2.invokeMethod((EvaluationContext)this.myEvaluationContext, this.myBitmap, method2, Collections.emptyList())) instanceof IntegerValue) {
            return ((IntegerValue)widthValue).value();
        }
        return null;
    }

    @Nullable
    private List<Value> copyToBuffer(@NotNull Dimension size) throws EvaluateException {
        DebugProcessImpl debugProcess2 = this.myEvaluationContext.getDebugProcess();
        VirtualMachineProxyImpl virtualMachineProxy = debugProcess2.getVirtualMachineProxy();
        List classes = virtualMachineProxy.classesByName("byte[]");
        if (classes.size() != 1 || !(classes.get(0) instanceof ArrayType)) {
            return null;
        }
        ArrayType byteArrayType = (ArrayType)classes.get(0);
        classes = virtualMachineProxy.classesByName("java.nio.ByteBuffer");
        if (classes.size() != 1 || !(classes.get(0) instanceof ClassType)) {
            return null;
        }
        ClassType byteBufferType = (ClassType)classes.get(0);
        Method wrapMethod = DebuggerUtils.findMethod((ReferenceType)byteBufferType, (String)"wrap", (String)"([B)Ljava/nio/ByteBuffer;");
        if (wrapMethod == null) {
            return null;
        }
        ArrayReference byteArray = byteArrayType.newInstance(size.width * size.height * 4);
        Value byteBufferRef = debugProcess2.invokeMethod((EvaluationContext)this.myEvaluationContext, byteBufferType, wrapMethod, (List)ImmutableList.of((Object)byteArray));
        Method copyToBufferMethod = DebuggerUtils.findMethod((ReferenceType)this.myBitmap.referenceType(), (String)"copyPixelsToBuffer", (String)"(Ljava/nio/Buffer;)V");
        if (copyToBufferMethod == null) {
            return null;
        }
        debugProcess2.invokeMethod((EvaluationContext)this.myEvaluationContext, this.myBitmap, copyToBufferMethod, (List)ImmutableList.of((Object)byteBufferRef));
        return byteArray.getValues();
    }

    @Nullable
    private Value getBitmapFromDrawable(@NotNull ObjectReference bitmapDrawable) {
        try {
            DebugProcessImpl debugProcess2 = this.myEvaluationContext.getDebugProcess();
            Method getBitmapMethod = DebuggerUtils.findMethod((ReferenceType)bitmapDrawable.referenceType(), (String)"getBitmap", (String)"()Landroid/graphics/Bitmap;");
            if (getBitmapMethod == null) {
                return null;
            }
            return debugProcess2.invokeMethod((EvaluationContext)this.myEvaluationContext, bitmapDrawable, getBitmapMethod, Collections.emptyList());
        }
        catch (EvaluateException ignored) {
            return null;
        }
    }

    @Override
    public void close() {
        this.enableGarbageCollection();
    }

    private void disableGarbageCollection() {
        DebuggerUtilsEx.disableCollection((ObjectReference)this.myBitmap);
        this.isGcDisabledOnBitmap = true;
    }

    private void enableGarbageCollection() {
        if (this.isGcDisabledOnBitmap) {
            DebuggerUtilsEx.enableCollection((ObjectReference)this.myBitmap);
            this.isGcDisabledOnBitmap = false;
        }
    }
}

