/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.device.explorer.DeviceExplorerController;
import com.android.tools.idea.device.explorer.DeviceExplorerModel;
import com.android.tools.idea.device.explorer.common.DeviceExplorerTabController;
import com.android.tools.idea.device.explorer.files.DeviceExplorerFileManager;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerControllerImpl;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerModel;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerView;
import com.android.tools.idea.device.explorer.files.ui.DeviceFileExplorerViewImpl;
import com.android.tools.idea.device.explorer.monitor.DeviceMonitorControllerImpl;
import com.android.tools.idea.device.explorer.monitor.DeviceMonitorModel;
import com.android.tools.idea.device.explorer.monitor.adbimpl.AdbDeviceService;
import com.android.tools.idea.device.explorer.monitor.processes.DeviceProcessService;
import com.android.tools.idea.device.explorer.monitor.ui.DeviceMonitorView;
import com.android.tools.idea.device.explorer.monitor.ui.DeviceMonitorViewImpl;
import com.android.tools.idea.device.explorer.ui.DeviceExplorerViewImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import icons.StudioIcons;
import java.nio.file.Path;
import java.util.List;
import javax.swing.Icon;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/device/explorer/DeviceExplorerToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "<init>", "()V", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "createToolWindowContent", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "createDeviceMonitorController", "Lcom/android/tools/idea/device/explorer/common/DeviceExplorerTabController;", "createDeviceFilesController", "Companion", "intellij.android.device-explorer"})
public final class DeviceExplorerToolWindowFactory
implements DumbAware,
ToolWindowFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TOOL_WINDOW_ID = "Device Explorer";
    @NotNull
    private static final String DEVICE_EXPLORER_ENABLED = "android.device.explorer.enabled";

    public boolean isApplicable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.setIcon(StudioIcons.Shell.ToolWindows.DEVICE_EXPLORER);
        toolWindow.setAvailable(true);
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setTitle(TOOL_WINDOW_ID);
        DeviceExplorerModel model = new DeviceExplorerModel(project);
        DeviceExplorerViewImpl view = new DeviceExplorerViewImpl(project, model, TOOL_WINDOW_ID);
        Object[] objectArray = new DeviceExplorerTabController[]{this.createDeviceFilesController(project), this.createDeviceMonitorController(project)};
        List tabController = CollectionsKt.listOf((Object[])objectArray);
        DeviceExplorerController deviceExplorerController = new DeviceExplorerController(project, model, view, tabController);
        deviceExplorerController.setup();
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        Content content2 = contentManager2.getFactory().createContent(view.getComponent(), "", true);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
        Content toolWindowContent = content2;
        contentManager2.addContent(toolWindowContent);
    }

    private final DeviceExplorerTabController createDeviceMonitorController(Project project) {
        AdbDeviceService adbService = (AdbDeviceService)project.getService(AdbDeviceService.class);
        DeviceProcessService processService = (DeviceProcessService)project.getService(DeviceProcessService.class);
        Intrinsics.checkNotNull((Object)processService);
        DeviceMonitorModel model = new DeviceMonitorModel(project, processService);
        DeviceMonitorViewImpl view = new DeviceMonitorViewImpl(project, model, null, 4, null);
        DeviceMonitorView deviceMonitorView = view;
        Intrinsics.checkNotNull((Object)adbService);
        return new DeviceMonitorControllerImpl(project, model, deviceMonitorView, adbService);
    }

    private final DeviceExplorerTabController createDeviceFilesController(Project project) {
        DeviceExplorerFileManager fileManager = (DeviceExplorerFileManager)project.getService(DeviceExplorerFileManager.class);
        DeviceFileExplorerModel model = new DeviceFileExplorerModel();
        DeviceFileExplorerViewImpl view = new DeviceFileExplorerViewImpl(project, model, TOOL_WINDOW_ID);
        DeviceFileExplorerView deviceFileExplorerView = view;
        Intrinsics.checkNotNull((Object)fileManager);
        return new DeviceFileExplorerControllerImpl(project, model, deviceFileExplorerView, fileManager, new DeviceFileExplorerControllerImpl.FileOpener(fileManager){
            final /* synthetic */ DeviceExplorerFileManager $fileManager;
            {
                this.$fileManager = $fileManager;
            }

            @UiThread
            public Object openFile(Path localPath, Continuation<? super Unit> $completion) {
                Object object = this.$fileManager.openFile(localPath, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        });
    }

    @Nullable
    public Object isApplicableAsync(@NotNull Project project, @NotNull Continuation<? super Boolean> $completion) {
        return super.isApplicableAsync(project, $completion);
    }

    public void init(@NotNull ToolWindow toolWindow) {
        super.init(toolWindow);
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    @Nullable
    public Object manage(@NotNull ToolWindow toolWindow, @NotNull ToolWindowManager toolWindowManager, @NotNull Continuation<? super Unit> $completion) {
        return super.manage(toolWindow, toolWindowManager, $completion);
    }

    public boolean shouldBeAvailable(@NotNull Project project) {
        return super.shouldBeAvailable(project);
    }

    @Deprecated(message="Use {@link ToolWindowEP#isDoNotActivateOnStart}")
    public boolean isDoNotActivateOnStart() {
        return super.isDoNotActivateOnStart();
    }

    @ApiStatus.Internal
    @Nullable
    public ToolWindowAnchor getAnchor() {
        return super.getAnchor();
    }

    @ApiStatus.Internal
    @Nullable
    public Icon getIcon() {
        return super.getIcon();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/device/explorer/DeviceExplorerToolWindowFactory$Companion;", "", "<init>", "()V", "TOOL_WINDOW_ID", "", "DEVICE_EXPLORER_ENABLED", "intellij.android.device-explorer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

