/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.files.options;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.device.explorer.common.DeviceExplorerSettings;
import com.android.tools.idea.device.explorer.files.DeviceExplorerBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DeviceFileExplorerConfigurable
implements SearchableConfigurable {
    private JPanel myContentPanel;
    private TextFieldWithBrowseButton myDownloadLocation;
    private static Method cachedGetBundleMethod = null;

    DeviceFileExplorerConfigurable() {
        this.setupUI();
        this.myDownloadLocation.addBrowseFolderListener(null, new FileChooserDescriptor(false, true, false, false, false, false).withTitle(DeviceExplorerBundle.message("dialog.title.device.file.explorer.download.location", new Object[0])));
    }

    @NotNull
    public String getId() {
        return "device.explorer";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myContentPanel;
    }

    public boolean isModified() {
        return !DeviceExplorerSettings.getInstance().getDownloadLocation().equals(this.myDownloadLocation.getText());
    }

    public void apply() throws ConfigurationException {
        Path path = Paths.get(this.getDownloadLocation(), new String[0]);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new ConfigurationException(DeviceExplorerBundle.message("dialog.message.path.must.be.existing.directory", new Object[0]), DeviceExplorerBundle.message("dialog.title.invalid.path", new Object[0]));
        }
        DeviceExplorerSettings.getInstance().setDownloadLocation(path.toString());
    }

    public void reset() {
        this.myDownloadLocation.setText(DeviceExplorerSettings.getInstance().getDownloadLocation());
    }

    public void disposeUIResources() {
    }

    @NlsContexts.ConfigurableName
    public String getDisplayName() {
        if (IdeInfo.getInstance().isAndroidStudio()) {
            return DeviceExplorerBundle.message("configurable.name.device.file.explorer", new Object[0]);
        }
        return DeviceExplorerBundle.message("configurable.name.android.device.file.explorer", new Object[0]);
    }

    @NotNull
    private String getDownloadLocation() {
        return this.myDownloadLocation.getText();
    }

    private void setupUI() {
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myDownloadLocation = new TextFieldWithBrowseButton();
        this.myDownloadLocation.setText("");
        this.myContentPanel.add((Component)this.myDownloadLocation, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myContentPanel.add((Component)spacer1, new GridConstraints(1, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        this.loadLabelText(label1, this.getMessageFromBundle("messages/AndroidBundle", "label.download.location"));
        this.myContentPanel.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
    }

    private String getMessageFromBundle(String path, String key) {
        ResourceBundle bundle;
        try {
            Class<?> thisClass = this.getClass();
            if (cachedGetBundleMethod == null) {
                Class<?> dynamicBundleClass = thisClass.getClassLoader().loadClass("com.intellij.DynamicBundle");
                cachedGetBundleMethod = dynamicBundleClass.getMethod("getBundle", String.class, Class.class);
            }
            bundle = (ResourceBundle)cachedGetBundleMethod.invoke(null, path, thisClass);
        }
        catch (Exception e) {
            bundle = ResourceBundle.getBundle(path);
        }
        return bundle.getString(key);
    }

    private void loadLabelText(JLabel component, String text2) {
        StringBuffer result2 = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text2.length(); ++i) {
            if (text2.charAt(i) == '&') {
                if (++i == text2.length()) break;
                if (!haveMnemonic && text2.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text2.charAt(i);
                    mnemonicIndex = result2.length();
                }
            }
            result2.append(text2.charAt(i));
        }
        component.setText(result2.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }
}

