/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.commit;

import com.android.tools.idea.diagnostics.commit.GitCommitTracker;
import com.android.tools.idea.serverflags.ServerFlagService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001d\u0010\f\u001a\u00020\n2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0002J\u0006\u0010\u0013\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/diagnostics/commit/GitCommitTimestampTrackerService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "gitCommitTrackers", "", "Lcom/android/tools/idea/diagnostics/commit/GitCommitTracker;", "subscribeToVcsRootChanges", "", "checkAndTrackGitRepository", "startTrackers", "allVcsRoots", "", "Lcom/intellij/openapi/vcs/VcsRoot;", "([Lcom/intellij/openapi/vcs/VcsRoot;)V", "dispose", "stopAllTrackers", "startTracking", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nGitCommitTimestampTrackerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCommitTimestampTrackerService.kt\ncom/android/tools/idea/diagnostics/commit/GitCommitTimestampTrackerService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n3829#2:81\n4344#2,2:82\n1863#3,2:84\n1863#3,2:86\n*S KotlinDebug\n*F\n+ 1 GitCommitTimestampTrackerService.kt\ncom/android/tools/idea/diagnostics/commit/GitCommitTimestampTrackerService\n*L\n59#1:81\n59#1:82,2\n59#1:84,2\n71#1:86,2\n*E\n"})
public final class GitCommitTimestampTrackerService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<GitCommitTracker> gitCommitTrackers;
    @NotNull
    private static final Logger LOG;

    public GitCommitTimestampTrackerService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.gitCommitTrackers = new ArrayList();
    }

    private final void subscribeToVcsRootChanges(Project project) {
        MessageBusConnection vcsConnection = project.getMessageBus().connect((Disposable)this);
        Topic topic = ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VCS_CONFIGURATION_CHANGED");
        vcsConnection.subscribe(topic, (Object)new VcsListener(this, project){
            final /* synthetic */ GitCommitTimestampTrackerService this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public void directoryMappingChanged() {
                GitCommitTimestampTrackerService.Companion.getLOG().info("VCS roots updated");
                GitCommitTimestampTrackerService.access$stopAllTrackers(this.this$0);
                VcsRoot[] vcsRootArray = ProjectLevelVcsManager.getInstance((Project)this.$project).getAllVcsRoots();
                Intrinsics.checkNotNullExpressionValue((Object)vcsRootArray, (String)"getAllVcsRoots(...)");
                VcsRoot[] vcsRoots = vcsRootArray;
                GitCommitTimestampTrackerService.access$startTrackers(this.this$0, vcsRoots);
            }
        });
    }

    private final void checkAndTrackGitRepository(Project project) {
        LOG.info("Project base path: " + project.getBasePath());
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        VcsRoot[] vcsRootArray = vcsManager.getAllVcsRoots();
        Intrinsics.checkNotNullExpressionValue((Object)vcsRootArray, (String)"getAllVcsRoots(...)");
        VcsRoot[] allVcsRoots = vcsRootArray;
        this.subscribeToVcsRootChanges(project);
        this.startTrackers(allVcsRoots);
    }

    /*
     * WARNING - void declaration
     */
    private final void startTrackers(VcsRoot[] allVcsRoots) {
        void $this$filterTo$iv$iv;
        VcsRoot[] $this$filter$iv = allVcsRoots;
        boolean $i$f$filter = false;
        VcsRoot[] vcsRootArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            AbstractVcs abstractVcs = it.getVcs();
            if (!Intrinsics.areEqual((Object)"Git", (Object)(abstractVcs != null ? abstractVcs.getName() : null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VcsRoot root = (VcsRoot)element$iv;
            boolean bl = false;
            String string = root.getPath().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            GitCommitTracker gitCommitTracker = new GitCommitTracker(string, 0L, 2, null);
            gitCommitTracker.startTracking();
            this.gitCommitTrackers.add(gitCommitTracker);
        }
    }

    public void dispose() {
        this.stopAllTrackers();
    }

    private final void stopAllTrackers() {
        Iterable $this$forEach$iv = this.gitCommitTrackers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GitCommitTracker p0 = (GitCommitTracker)element$iv;
            boolean bl = false;
            p0.stopTracking();
        }
        this.gitCommitTrackers.clear();
    }

    public final void startTracking() {
        if (!ServerFlagService.Companion.getInstance().getBoolean("diagnostics/commit_timestamp", false)) {
            return;
        }
        this.checkAndTrackGitRepository(this.project);
    }

    public static final /* synthetic */ void access$stopAllTrackers(GitCommitTimestampTrackerService $this) {
        $this.stopAllTrackers();
    }

    public static final /* synthetic */ void access$startTrackers(GitCommitTimestampTrackerService $this, VcsRoot[] allVcsRoots) {
        $this.startTrackers(allVcsRoots);
    }

    static {
        Logger logger = Logger.getInstance(GitCommitTimestampTrackerService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/diagnostics/commit/GitCommitTimestampTrackerService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

