/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.jfr.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001c2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u001d\u001a\u00020\u001aJ\b\u0010\u001e\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!H\u0002J\u0006\u0010\"\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00000\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/analysis/CallTree;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "sampleCount", "", "getSampleCount", "()I", "setSampleCount", "(I)V", "truncatedSampleCount", "getTruncatedSampleCount", "setTruncatedSampleCount", "time", "", "getTime", "()J", "setTime", "(J)V", "children", "", "addStacktrace", "", "stacktrace", "", "sort", "toString", "depth", "branch", "", "numNodesAboveCutoff", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nCallTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallTree.kt\ncom/android/tools/idea/diagnostics/jfr/analysis/CallTree\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1#2:72\n1019#3,2:73\n1863#3,2:75\n1863#3,2:77\n1863#3,2:79\n*S KotlinDebug\n*F\n+ 1 CallTree.kt\ncom/android/tools/idea/diagnostics/jfr/analysis/CallTree\n*L\n41#1:73,2\n42#1:75,2\n48#1:77,2\n60#1:79,2\n*E\n"})
public final class CallTree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private int sampleCount;
    private int truncatedSampleCount;
    private long time;
    @NotNull
    private final List<CallTree> children;
    private static final int MIN_TIME_CUTOFF_MS = 200;

    public CallTree(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.name = name2;
        this.children = new ArrayList();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getSampleCount() {
        return this.sampleCount;
    }

    public final void setSampleCount(int n) {
        this.sampleCount = n;
    }

    public final int getTruncatedSampleCount() {
        return this.truncatedSampleCount;
    }

    public final void setTruncatedSampleCount(int n) {
        this.truncatedSampleCount = n;
    }

    public final long getTime() {
        return this.time;
    }

    public final void setTime(long l) {
        this.time = l;
    }

    public final void addStacktrace(@NotNull List<String> stacktrace, long time2) {
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter(stacktrace, (String)"stacktrace");
            int n = this.sampleCount;
            this.sampleCount = n + 1;
            this.time += time2;
            Iterable iterable = this.children;
            for (Object t : iterable) {
                CallTree it = (CallTree)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name, (Object)CollectionsKt.last(stacktrace))) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        CallTree matchingChild = v0;
        if (matchingChild == null) {
            matchingChild = new CallTree((String)CollectionsKt.last(stacktrace));
            this.children.add(matchingChild);
        }
        if (stacktrace.size() > 1) {
            matchingChild.addStacktrace(stacktrace.subList(0, stacktrace.size() - 1), time2);
        } else {
            CallTree callTree = matchingChild;
            int n = callTree.sampleCount;
            callTree.sampleCount = n + 1;
            callTree = matchingChild;
            callTree.time += time2;
        }
    }

    public final void sort() {
        List<CallTree> $this$sortByDescending$iv = this.children;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CallTree ch = (CallTree)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(ch.getTime());
                    ch = (CallTree)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(ch.getTime()));
                }
            });
        }
        Iterable $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CallTree it = (CallTree)element$iv;
            boolean bl = false;
            it.sort();
        }
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.children.size() > 1 && this.children.get((int)1).time > 200L) {
            Iterable $this$forEach$iv = this.children;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CallTree c = (CallTree)element$iv;
                boolean bl2 = false;
                if (c.time <= 200L) continue;
                $this$toString_u24lambda_u244.append(c.toString(1, true));
            }
        } else if (!((Collection)this.children).isEmpty() && this.children.get((int)0).time > 200L) {
            $this$toString_u24lambda_u244.append(this.children.get(0).toString(0, false));
        }
        return stringBuilder.toString();
    }

    private final String toString(int depth, boolean branch) {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int indent = depth - (branch ? 1 : 0);
        for (int i = 0; i < indent; ++i) {
            $this$toString_u24lambda_u246.append("  ");
        }
        if (branch) {
            $this$toString_u24lambda_u246.append("+ ");
        }
        $this$toString_u24lambda_u246.append(this.name + " [" + this.time + "ms] (" + this.sampleCount + ")").append('\n');
        if (this.children.size() > 1 && this.children.get((int)1).time > 200L) {
            Iterable $this$forEach$iv = this.children;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CallTree c = (CallTree)element$iv;
                boolean bl2 = false;
                if (c.time <= 200L) continue;
                $this$toString_u24lambda_u246.append(c.toString(depth + 1, true));
            }
        } else if (!((Collection)this.children).isEmpty() && this.children.get((int)0).time > 200L) {
            $this$toString_u24lambda_u246.append(this.children.get(0).toString(depth, false));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final int numNodesAboveCutoff() {
        int n;
        if (this.time < 200L) {
            n = 0;
        } else {
            int n2;
            Iterable iterable = this.children;
            int n3 = 1;
            int n4 = 0;
            for (Object t : iterable) {
                void it;
                CallTree callTree = (CallTree)t;
                n2 = n4;
                boolean bl = false;
                int n5 = it.numNodesAboveCutoff();
                n4 = n2 + n5;
            }
            n2 = n4;
            n = n3 + n2;
        }
        return n;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/analysis/CallTree$Companion;", "", "<init>", "()V", "MIN_TIME_CUTOFF_MS", "", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

