/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.jfr.reports;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.diagnostics.jfr.CallTreeAggregator;
import com.android.tools.idea.diagnostics.jfr.EventFilter;
import com.android.tools.idea.diagnostics.jfr.JfrReportGenerator;
import com.android.tools.idea.diagnostics.jfr.JfrReportManager;
import com.android.tools.idea.serverflags.ServerFlagService;
import com.android.tools.idea.serverflags.protos.JfrTypingLatencyConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.LatencyListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jdk.jfr.consumer.RecordedEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports;", "", "<init>", "()V", "SERVER_FLAG_NAME", "", "DEFAULT_MAX_REPORTING_LENGTH_BYTES", "", "CALL_TREES_FIELD", "KEYSTROKE_COUNT_FIELD", "DEFAULT_TYPING_TIMEOUT", "Lkotlin/time/Duration;", "J", "DEFAULT_SESSION_TIMEOUT", "DEFAULT_COOLDOWN_TIMEOUT", "DEFAULT_LATENCY_THRESHOLD", "REPORT_TYPE", "FIELDS", "", "getFIELDS", "()Ljava/util/List;", "createReportManager", "Lcom/android/tools/idea/diagnostics/jfr/JfrReportManager;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "serverFlagService", "Lcom/android/tools/idea/serverflags/ServerFlagService;", "MyReportGenerator", "MyLatencyListener", "intellij.android.core"})
public final class JfrTypingLatencyReports {
    @NotNull
    public static final JfrTypingLatencyReports INSTANCE = new JfrTypingLatencyReports();
    @NotNull
    private static final String SERVER_FLAG_NAME = "diagnostics/jfr_typing_latency";
    private static final int DEFAULT_MAX_REPORTING_LENGTH_BYTES = 200000;
    @NotNull
    private static final String CALL_TREES_FIELD = "callTrees";
    @NotNull
    private static final String KEYSTROKE_COUNT_FIELD = "keystrokes";
    private static final long DEFAULT_TYPING_TIMEOUT = DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS);
    private static final long DEFAULT_SESSION_TIMEOUT = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS);
    private static final long DEFAULT_COOLDOWN_TIMEOUT = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES);
    private static final long DEFAULT_LATENCY_THRESHOLD = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
    @NotNull
    public static final String REPORT_TYPE = "JFR-TypingLatency";
    @NotNull
    private static final List<String> FIELDS;

    private JfrTypingLatencyReports() {
    }

    @NotNull
    public final List<String> getFIELDS() {
        return FIELDS;
    }

    @JvmStatic
    @NotNull
    public static final JfrReportManager<?> createReportManager(@NotNull Disposable parentDisposable, @NotNull ServerFlagService serverFlagService) {
        JfrTypingLatencyConfig config;
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)serverFlagService, (String)"serverFlagService");
        JfrTypingLatencyConfig jfrTypingLatencyConfig = JfrTypingLatencyConfig.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)jfrTypingLatencyConfig, (String)"getDefaultInstance(...)");
        JfrTypingLatencyConfig jfrTypingLatencyConfig2 = config = (JfrTypingLatencyConfig)serverFlagService.getProtoOrNull(SERVER_FLAG_NAME, (Message)jfrTypingLatencyConfig);
        int maxReportLengthBytes = (jfrTypingLatencyConfig2 != null ? jfrTypingLatencyConfig2.hasMaxReportLengthBytes() : false) ? config.getMaxReportLengthBytes() : 200000;
        return JfrReportManager.Companion.create$default(JfrReportManager.Companion, () -> JfrTypingLatencyReports.createReportManager$lambda$0(maxReportLengthBytes), null, arg_0 -> JfrTypingLatencyReports.createReportManager$lambda$2(parentDisposable, config, arg_0), 2, null);
    }

    private static final MyReportGenerator createReportManager$lambda$0(int $maxReportLengthBytes) {
        return new MyReportGenerator($maxReportLengthBytes);
    }

    private static final Unit createReportManager$lambda$2$lambda$1(JfrReportManager<MyReportGenerator> $this_create, int keystrokes) {
        MyReportGenerator myReportGenerator = $this_create.getCurrentReportGenerator();
        if (myReportGenerator != null) {
            myReportGenerator.setKeystrokeCount(keystrokes);
        }
        $this_create.stopCapture();
        return Unit.INSTANCE;
    }

    private static final Unit createReportManager$lambda$2(Disposable $parentDisposable, JfrTypingLatencyConfig $config, JfrReportManager $this$create) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
        Function1 stopCapture = arg_0 -> JfrTypingLatencyReports.createReportManager$lambda$2$lambda$1($this$create, arg_0);
        CoroutineScope coroutineScope = CoroutineUtilsKt.AndroidCoroutineScope((Disposable)$parentDisposable, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()));
        MyLatencyListener latencyListener2 = new MyLatencyListener($config, (Function0<Unit>)((Function0)new Function0<Unit>((Object)$this$create){

            public final void invoke() {
                ((JfrReportManager)this.receiver).startCapture();
            }
        }), (Function1<? super Integer, Unit>)stopCapture, coroutineScope);
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect($parentDisposable);
        Topic topic = LatencyListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)latencyListener2);
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new String[]{CALL_TREES_FIELD, KEYSTROKE_COUNT_FIELD};
        FIELDS = CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\b\b\u0001\u0018\u00002\u00020\u0001:\u0002,-BJ\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012!\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00060\b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0013\u0010\u0017\u001a\u00020\u0012*\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\"\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0017J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0018H\u0003J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0018H\u0003J\b\u0010*\u001a\u00020\u0006H\u0007J\b\u0010+\u001a\u00020\u0006H\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u0015\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyLatencyListener;", "Lcom/intellij/openapi/editor/actionSystem/LatencyListener;", "config", "Lcom/android/tools/idea/serverflags/protos/JfrTypingLatencyConfig;", "startCapture", "Lkotlin/Function0;", "", "stopCapture", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "keystrokeCount", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/android/tools/idea/serverflags/protos/JfrTypingLatencyConfig;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlinx/coroutines/CoroutineScope;)V", "typingTimeout", "Lkotlin/time/Duration;", "J", "sessionTimeout", "cooldownTimeout", "latencyReportingThreshold", "timeout", "Lcom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyLatencyListener$TimeoutType;", "timeout-5sfh64U", "(Lcom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyLatencyListener$TimeoutType;)J", "state", "Lcom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyLatencyListener$State;", "timeouts", "", "Lkotlinx/coroutines/Job;", "recordTypingLatency", "editor", "Lcom/intellij/openapi/editor/Editor;", "action", "", "latencyMs", "", "startTimeout", "timeoutType", "handleTimeout", "cancelAllTimeouts", "doStopRecording", "State", "TimeoutType", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nJfrTypingLatencyReports.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JfrTypingLatencyReports.kt\ncom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyLatencyListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,216:1\n1863#2,2:217\n*S KotlinDebug\n*F\n+ 1 JfrTypingLatencyReports.kt\ncom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyLatencyListener\n*L\n201#1:217,2\n*E\n"})
    public static final class MyLatencyListener
    implements LatencyListener {
        @NotNull
        private final Function0<Unit> startCapture;
        @NotNull
        private final Function1<Integer, Unit> stopCapture;
        @NotNull
        private final CoroutineScope coroutineScope;
        private final long typingTimeout;
        private final long sessionTimeout;
        private final long cooldownTimeout;
        private final long latencyReportingThreshold;
        @NotNull
        private State state;
        private int keystrokeCount;
        @NotNull
        private final Map<TimeoutType, Job> timeouts;

        public MyLatencyListener(@Nullable JfrTypingLatencyConfig config, @NotNull Function0<Unit> startCapture2, @NotNull Function1<? super Integer, Unit> stopCapture, @NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter(startCapture2, (String)"startCapture");
            Intrinsics.checkNotNullParameter(stopCapture, (String)"stopCapture");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.startCapture = startCapture2;
            this.stopCapture = stopCapture;
            this.coroutineScope = coroutineScope;
            JfrTypingLatencyConfig jfrTypingLatencyConfig = config;
            this.typingTimeout = (jfrTypingLatencyConfig != null ? jfrTypingLatencyConfig.hasTypingTimeoutMillis() : false) ? DurationKt.toDuration((long)config.getTypingTimeoutMillis(), (DurationUnit)DurationUnit.MILLISECONDS) : DEFAULT_TYPING_TIMEOUT;
            JfrTypingLatencyConfig jfrTypingLatencyConfig2 = config;
            this.sessionTimeout = (jfrTypingLatencyConfig2 != null ? jfrTypingLatencyConfig2.hasSessionTimeoutMillis() : false) ? DurationKt.toDuration((long)config.getSessionTimeoutMillis(), (DurationUnit)DurationUnit.MILLISECONDS) : DEFAULT_SESSION_TIMEOUT;
            JfrTypingLatencyConfig jfrTypingLatencyConfig3 = config;
            this.cooldownTimeout = (jfrTypingLatencyConfig3 != null ? jfrTypingLatencyConfig3.hasCooldownTimeoutMillis() : false) ? DurationKt.toDuration((long)config.getCooldownTimeoutMillis(), (DurationUnit)DurationUnit.MILLISECONDS) : DEFAULT_COOLDOWN_TIMEOUT;
            JfrTypingLatencyConfig jfrTypingLatencyConfig4 = config;
            this.latencyReportingThreshold = (jfrTypingLatencyConfig4 != null ? jfrTypingLatencyConfig4.hasLatencyReportingThresholdMillis() : false) ? DurationKt.toDuration((long)config.getLatencyReportingThresholdMillis(), (DurationUnit)DurationUnit.MILLISECONDS) : DEFAULT_LATENCY_THRESHOLD;
            this.state = State.WAITING_TO_RECORD;
            this.timeouts = new LinkedHashMap();
        }

        private final long timeout-5sfh64U(TimeoutType $this$timeout_u2d5sfh64U) {
            return switch (WhenMappings.$EnumSwitchMapping$0[$this$timeout_u2d5sfh64U.ordinal()]) {
                case 1 -> this.typingTimeout;
                case 2 -> this.sessionTimeout;
                case 3 -> this.cooldownTimeout;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @UiThread
        public void recordTypingLatency(@NotNull Editor editor, @Nullable String action2, long latencyMs) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            switch (WhenMappings.$EnumSwitchMapping$1[this.state.ordinal()]) {
                case 1: {
                    if (Duration.compareTo-LRDsOJo((long)DurationKt.toDuration((long)latencyMs, (DurationUnit)DurationUnit.MILLISECONDS), (long)this.latencyReportingThreshold) <= 0) break;
                    this.keystrokeCount = 1;
                    this.cancelAllTimeouts();
                    this.startTimeout(TimeoutType.TYPING);
                    this.startTimeout(TimeoutType.SESSION);
                    this.startCapture.invoke();
                    this.state = State.RECORDING;
                    break;
                }
                case 2: {
                    if (Duration.compareTo-LRDsOJo((long)DurationKt.toDuration((long)latencyMs, (DurationUnit)DurationUnit.MILLISECONDS), (long)this.latencyReportingThreshold) > 0) {
                        int n = this.keystrokeCount;
                        this.keystrokeCount = n + 1;
                        this.startTimeout(TimeoutType.TYPING);
                        break;
                    }
                    this.doStopRecording();
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        @UiThread
        private final void startTimeout(TimeoutType timeoutType) {
            Job job2 = this.timeouts.remove((Object)timeoutType);
            if (job2 != null) {
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
            }
            this.timeouts.put(timeoutType, BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, timeoutType, null){
                int label;
                final /* synthetic */ MyLatencyListener this$0;
                final /* synthetic */ TimeoutType $timeoutType;
                {
                    this.this$0 = $receiver;
                    this.$timeoutType = $timeoutType;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)MyLatencyListener.access$timeout-5sfh64U(this.this$0, this.$timeoutType), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            MyLatencyListener.access$handleTimeout(this.this$0, this.$timeoutType);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null));
        }

        @UiThread
        private final void handleTimeout(TimeoutType timeoutType) {
            switch (WhenMappings.$EnumSwitchMapping$0[timeoutType.ordinal()]) {
                case 1: 
                case 2: {
                    if (this.state != State.RECORDING) break;
                    this.doStopRecording();
                    break;
                }
                case 3: {
                    if (this.state != State.COOLDOWN) break;
                    this.cancelAllTimeouts();
                    this.state = State.WAITING_TO_RECORD;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        @UiThread
        public final void cancelAllTimeouts() {
            Iterable $this$forEach$iv = this.timeouts.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Job it = (Job)element$iv;
                boolean bl = false;
                Job.DefaultImpls.cancel$default((Job)it, null, (int)1, null);
            }
            this.timeouts.clear();
        }

        @UiThread
        private final void doStopRecording() {
            this.stopCapture.invoke((Object)this.keystrokeCount);
            this.keystrokeCount = 0;
            this.cancelAllTimeouts();
            this.startTimeout(TimeoutType.COOLDOWN);
            this.state = State.COOLDOWN;
        }

        public static final /* synthetic */ long access$timeout-5sfh64U(MyLatencyListener $this, TimeoutType $receiver) {
            return $this.timeout-5sfh64U($receiver);
        }

        public static final /* synthetic */ void access$handleTimeout(MyLatencyListener $this, TimeoutType timeoutType) {
            $this.handleTimeout(timeoutType);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyLatencyListener$State;", "", "<init>", "(Ljava/lang/String;I)V", "WAITING_TO_RECORD", "RECORDING", "COOLDOWN", "intellij.android.core"})
        private static final class State
        extends Enum<State> {
            public static final /* enum */ State WAITING_TO_RECORD = new State();
            public static final /* enum */ State RECORDING = new State();
            public static final /* enum */ State COOLDOWN = new State();
            private static final /* synthetic */ State[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value2) {
                return Enum.valueOf(State.class, value2);
            }

            @NotNull
            public static EnumEntries<State> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = stateArray = new State[]{State.WAITING_TO_RECORD, State.RECORDING, State.COOLDOWN};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyLatencyListener$TimeoutType;", "", "<init>", "(Ljava/lang/String;I)V", "TYPING", "SESSION", "COOLDOWN", "intellij.android.core"})
        private static final class TimeoutType
        extends Enum<TimeoutType> {
            public static final /* enum */ TimeoutType TYPING = new TimeoutType();
            public static final /* enum */ TimeoutType SESSION = new TimeoutType();
            public static final /* enum */ TimeoutType COOLDOWN = new TimeoutType();
            private static final /* synthetic */ TimeoutType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static TimeoutType[] values() {
                return (TimeoutType[])$VALUES.clone();
            }

            public static TimeoutType valueOf(String value2) {
                return Enum.valueOf(TimeoutType.class, value2);
            }

            @NotNull
            public static EnumEntries<TimeoutType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = timeoutTypeArray = new TimeoutType[]{TimeoutType.TYPING, TimeoutType.SESSION, TimeoutType.COOLDOWN};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[TimeoutType.values().length];
                try {
                    nArray[TimeoutType.TYPING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TimeoutType.SESSION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TimeoutType.COOLDOWN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[State.values().length];
                try {
                    nArray[State.WAITING_TO_RECORD.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.RECORDING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.COOLDOWN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011R\u00020\u0001H\u0016J\u0014\u0010\u0012\u001a\u00020\r2\n\u0010\u0010\u001a\u00060\u0011R\u00020\u0001H\u0016J\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyReportGenerator;", "Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator;", "maxReportLengthBytes", "", "<init>", "(I)V", "keystrokeCount", "getKeystrokeCount", "()I", "setKeystrokeCount", "callTreeAggregator", "Lcom/android/tools/idea/diagnostics/jfr/CallTreeAggregator;", "accept", "", "e", "Ljdk/jfr/consumer/RecordedEvent;", "c", "Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator$Capture;", "captureCompleted", "generateReport", "", "", "intellij.android.core"})
    private static final class MyReportGenerator
    extends JfrReportGenerator {
        private final int maxReportLengthBytes;
        private int keystrokeCount;
        @NotNull
        private final CallTreeAggregator callTreeAggregator;

        public MyReportGenerator(int maxReportLengthBytes) {
            super(JfrTypingLatencyReports.REPORT_TYPE, EventFilter.Companion.getCPU_SAMPLES(), 0L, 0L, null, 28, null);
            this.maxReportLengthBytes = maxReportLengthBytes;
            this.keystrokeCount = -1;
            this.callTreeAggregator = new CallTreeAggregator(CallTreeAggregator.Companion.getTHREAD_FILTER_ALL());
        }

        public final int getKeystrokeCount() {
            return this.keystrokeCount;
        }

        public final void setKeystrokeCount(int n) {
            this.keystrokeCount = n;
        }

        @Override
        public void accept(@NotNull RecordedEvent e, @NotNull JfrReportGenerator.Capture c) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            this.callTreeAggregator.accept(e);
        }

        @Override
        public void captureCompleted(@NotNull JfrReportGenerator.Capture c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Instant instant = c.getEnd();
            Intrinsics.checkNotNull((Object)instant);
            this.callTreeAggregator.processBatch(instant);
        }

        @Override
        @NotNull
        public Map<String, String> generateReport() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)JfrTypingLatencyReports.CALL_TREES_FIELD, (Object)this.callTreeAggregator.generateReport(this.maxReportLengthBytes)), TuplesKt.to((Object)JfrTypingLatencyReports.KEYSTROKE_COUNT_FIELD, (Object)String.valueOf(this.keystrokeCount))};
            return MapsKt.mapOf((Pair[])pairArray);
        }
    }
}

