/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editing.documentation;

import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceItemResolver;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.resources.aar.AarResourceRepository;
import com.android.tools.configurations.Configuration;
import com.android.tools.dom.attrs.AttributeDefinition;
import com.android.tools.idea.configurations.ConfigurationForFile;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.SourceProviders;
import com.android.tools.idea.rendering.AndroidBuildTargetReference;
import com.android.tools.idea.rendering.ShowFixFactory;
import com.android.tools.idea.rendering.StudioRenderService;
import com.android.tools.idea.rendering.StudioRenderServiceKt;
import com.android.tools.idea.res.AndroidDependenciesCache;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.StateList;
import com.android.tools.idea.res.StateListState;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.idea.util.NonBlockingReadActionUtilKt;
import com.android.tools.rendering.HtmlLinkManager;
import com.android.tools.rendering.RenderLogger;
import com.android.tools.rendering.RenderService;
import com.android.tools.rendering.RenderTask;
import com.android.tools.res.FrameworkOverlay;
import com.android.tools.res.ResourceFiles;
import com.android.utils.HtmlBuilder;
import com.android.utils.SdkUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class AndroidJavaDocRenderer {
    private static final int MASK_NORMAL = 0;
    private static final int MASK_FLAVOR_SELECTED = 1;
    private static final int MASK_ITEM_HIDDEN = 2;

    @Nullable
    public static String render(@NotNull Module module, @NotNull ResourceType type, @NotNull String name2, boolean framework) {
        return AndroidJavaDocRenderer.render(module, null, type, name2, framework);
    }

    @Nullable
    public static String render(@NotNull Module module, @Nullable Configuration configuration2, @NotNull ResourceType type, @NotNull String name2, boolean framework) {
        return AndroidJavaDocRenderer.render(module, configuration2, ResourceUrl.create((ResourceType)type, (String)name2, (boolean)framework));
    }

    @Nullable
    public static String render(@NotNull Module module, @Nullable Configuration configuration2, @NotNull ResourceUrl url) {
        ResourceValueRenderer renderer2 = ResourceValueRenderer.create(url.type, module, configuration2);
        boolean framework = url.isFramework();
        if (renderer2 == null || framework && renderer2.getFrameworkResources() == null || !framework && renderer2.getAppResources() == null) {
            return null;
        }
        String valueDoc = renderer2.render(url);
        if (url.type.equals((Object)ResourceType.ATTR)) {
            String attrDoc = AndroidJavaDocRenderer.renderAttributeDoc(module, configuration2, (url.isFramework() ? "android:" : "") + url.name);
            if (valueDoc == null) {
                return attrDoc;
            }
            return AndroidJavaDocRenderer.injectExternalDocumentation(attrDoc, valueDoc);
        }
        return valueDoc;
    }

    @NotNull
    private static String renderAttributeDoc(@NotNull Module module, @Nullable Configuration configuration2, @NotNull String name2) {
        AttributeDefinition def = ResolutionUtils.getAttributeDefinition(module, configuration2, name2);
        String doc = def == null ? null : def.getDescription(null);
        HtmlBuilder builder = new HtmlBuilder();
        builder.openHtmlBody();
        builder.beginBold();
        builder.add(name2);
        builder.endBold();
        int api = ResolutionUtils.getOriginalApiLevel(name2, module.getProject());
        if (api > 1) {
            builder.add(" (Added in API level ");
            builder.add(String.valueOf(api));
            builder.add(")");
        }
        builder.addHtml("<br/>");
        if (!StringUtil.isEmpty((String)doc)) {
            builder.addHtml(doc);
            builder.addHtml("<br/>");
        }
        builder.addHtml("<hr/>");
        builder.closeHtmlBody();
        return builder.getHtml();
    }

    @VisibleForTesting
    static String injectExternalDocumentation(@Nullable String rendered, @Nullable String external) {
        if (rendered == null) {
            return external;
        }
        if (external == null) {
            return rendered;
        }
        int styleStart = ((String)external).indexOf("<style");
        int styleEnd = ((String)external).indexOf("</style>");
        if (styleStart != -1 && styleEnd != -1) {
            String style = ((String)external).substring(styleStart, styleEnd + "</style>".length());
            external = ((String)external).substring(0, styleStart) + ((String)external).substring(styleEnd + "</style>".length());
            int insert = ((String)rendered).indexOf("<body>");
            if (insert != -1) {
                int headEnd = ((String)rendered).lastIndexOf("</head>", insert);
                if (headEnd != -1) {
                    insert = headEnd;
                    rendered = ((String)rendered).substring(0, insert) + style + ((String)rendered).substring(insert);
                } else {
                    rendered = ((String)rendered).substring(0, insert) + "<head>" + style + "</head>" + ((String)rendered).substring(insert);
                }
            }
        }
        external = AndroidJavaDocRenderer.getTagContent(AndroidJavaDocRenderer.getTagContent((String)external, "body"), "html");
        int bodyEnd = StringUtil.indexOfIgnoreCase((String)rendered, (String)"</body>", (int)0);
        if (bodyEnd == -1) {
            bodyEnd = StringUtil.indexOfIgnoreCase((String)rendered, (String)"</html>", (int)0);
        }
        if (bodyEnd != -1) {
            return ((String)rendered).substring(0, bodyEnd) + (String)external + ((String)rendered).substring(bodyEnd);
        }
        return (String)rendered + (String)external;
    }

    @NotNull
    private static String getTagContent(@NotNull String text2, @NotNull String tag) {
        int start2 = StringUtil.indexOfIgnoreCase((String)text2, (String)("<" + tag), (int)0);
        int end = StringUtil.indexOfIgnoreCase((String)text2, (String)("</" + tag + ">"), (int)0);
        if (start2 != -1 && end != -1 && (start2 = StringUtil.indexOfIgnoreCase((String)text2, (String)">", (int)start2)) != -1) {
            return text2.substring(start2 + 1, end);
        }
        return text2;
    }

    private static boolean haveFlavors(List<ItemInfo> items) {
        for (ItemInfo info : items) {
            if (info.flavor == null) continue;
            return true;
        }
        return false;
    }

    private static void markHidden(List<ItemInfo> items) {
        HashSet<String> hiddenQualifiers = new HashSet<String>();
        for (ItemInfo info : items) {
            String folder = info.folder;
            if (hiddenQualifiers.contains(folder)) {
                info.displayMask |= 2;
            }
            hiddenQualifiers.add(folder);
        }
    }

    private static String renderFolderName(String name2) {
        String prefix = "values";
        if (name2.equals(prefix)) {
            return "Default";
        }
        if (name2.startsWith(prefix + "-")) {
            return name2.substring(prefix.length() + 1);
        }
        return name2;
    }

    @NotNull
    private static ResourceReference urlToReference(ResourceUrl url) {
        return new ResourceReference(ResourceNamespace.fromBoolean((boolean)url.isFramework()), url.type, url.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Dimension getSize(@NotNull VirtualFile file) {
        try {
            ImageInputStream input2 = ImageIO.createImageInputStream(file.getInputStream());
            if (input2 != null) {
                try {
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(input2);
                    if (readers.hasNext()) {
                        ImageReader reader2 = readers.next();
                        try {
                            reader2.setInput(input2);
                            Dimension dimension2 = new Dimension(reader2.getWidth(0), reader2.getHeight(0));
                            reader2.dispose();
                            return dimension2;
                        }
                        catch (Throwable throwable) {
                            reader2.dispose();
                            throw throwable;
                        }
                    }
                }
                finally {
                    input2.close();
                }
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static abstract class ResourceValueRenderer
    implements ResourceItemResolver.ResourceProvider {
        protected final Module myModule;
        protected final Configuration myConfiguration;
        protected ResourceRepository myAppResources;
        protected ResourceResolver myResourceResolver;
        protected boolean mySmall;

        protected ResourceValueRenderer(@NotNull Module module, @Nullable Configuration configuration2) {
            this.myModule = module;
            this.myConfiguration = configuration2;
        }

        public void setSmall(boolean small) {
            this.mySmall = small;
        }

        public abstract void renderToHtml(@NotNull HtmlBuilder var1, @NotNull ItemInfo var2, @NotNull ResourceUrl var3, boolean var4, @Nullable ResourceValue var5);

        @Nullable
        public static ResourceValueRenderer create(@NotNull ResourceType type, @NotNull Module module, @Nullable Configuration configuration2) {
            switch (type) {
                case ATTR: 
                case STRING: 
                case DIMEN: 
                case INTEGER: 
                case BOOL: 
                case STYLE: {
                    return new TextValueRenderer(module, configuration2);
                }
                case ARRAY: {
                    return new ArrayRenderer(module, configuration2);
                }
                case MIPMAP: 
                case DRAWABLE: {
                    return new DrawableValueRenderer(module, configuration2);
                }
                case COLOR: {
                    return new ColorValueRenderer(module, configuration2);
                }
            }
            return null;
        }

        @Nullable
        public String render(@NotNull ResourceUrl url) {
            List<ItemInfo> items = this.gatherItems(url);
            if (items != null) {
                Collections.sort(items);
                return this.renderKeyValues(items, url);
            }
            return null;
        }

        @Nullable
        private List<ItemInfo> gatherItems(@NotNull ResourceUrl url) {
            ResourceType type = url.type;
            String resourceName = url.name;
            boolean framework = url.isFramework();
            if (framework) {
                ArrayList<ItemInfo> results2 = new ArrayList<ItemInfo>();
                this.addItemsFromFramework(null, 0, 0, type, resourceName, results2);
                return results2;
            }
            AndroidFacet facet = AndroidFacet.getInstance((Module)this.myModule);
            if (facet == null) {
                return null;
            }
            ArrayList<ItemInfo> results3 = new ArrayList<ItemInfo>();
            ResourceRepository resources = this.getAppResources();
            List<AndroidFacet> dependencies2 = AndroidDependenciesCache.getAllAndroidDependencies(this.myModule, true);
            int rank = 0;
            for (AndroidFacet reachableFacet : Iterables.concat((Iterable)ImmutableList.of((Object)facet), dependencies2)) {
                String facetModuleName = ProjectSystemUtil.getModuleSystem(reachableFacet.getModule()).getDisplayNameForModuleGroup();
                SourceProviders sourceProviders = SourceProviders.getInstance(reachableFacet);
                HashSet<NamedIdeaSourceProvider> selectedProviders = new HashSet<NamedIdeaSourceProvider>();
                for (NamedIdeaSourceProvider sourceProvider : ImmutableList.copyOf(sourceProviders.getCurrentSourceProviders()).reverse()) {
                    ResourceValueRenderer.addItemsFromSourceSet(sourceProvider.getName() + " (" + facetModuleName + ")", 1, rank++, sourceProvider, type, resourceName, results3, reachableFacet);
                    selectedProviders.add(sourceProvider);
                }
                for (NamedIdeaSourceProvider sourceProvider : ImmutableList.copyOf(sourceProviders.getCurrentAndSomeFrequentlyUsedInactiveSourceProviders()).reverse()) {
                    if (selectedProviders.contains(sourceProvider)) continue;
                    ResourceValueRenderer.addItemsFromSourceSet(sourceProvider.getName() + " (" + facetModuleName + ")", 0, rank++, sourceProvider, type, resourceName, results3, reachableFacet);
                    selectedProviders.add(sourceProvider);
                }
            }
            if (resources != null) {
                for (AarResourceRepository dependency : StudioResourceRepositoryManager.getInstance(facet).getLibraryResources()) {
                    ResourceValueRenderer.addItemsFromRepository(dependency.getDisplayName(), 0, rank++, (ResourceRepository)dependency, false, type, resourceName, results3);
                }
            }
            return results3;
        }

        private static void addItemsFromSourceSet(@Nullable String flavor, int mask, int rank, @NotNull NamedIdeaSourceProvider sourceProvider, @NotNull ResourceType type, @NotNull String name2, @NotNull List<ItemInfo> results2, @NotNull AndroidFacet facet) {
            Iterable<VirtualFile> resDirectories = sourceProvider.getResDirectories();
            for (VirtualFile dir : resDirectories) {
                ResourceFolderRepository resources = ResourceFolderRegistry.getInstance(facet.getModule().getProject()).get(facet, dir);
                ResourceValueRenderer.addItemsFromRepository(flavor, mask, rank, resources, false, type, name2, results2);
            }
        }

        private void addItemsFromFramework(@Nullable String flavor, int mask, int rank, @NotNull ResourceType type, @NotNull String name2, @NotNull List<ItemInfo> results2) {
            ResourceRepository frameworkResources = this.getFrameworkResources();
            if (frameworkResources == null) {
                return;
            }
            ResourceValueRenderer.addItemsFromRepository(flavor, mask, rank, frameworkResources, true, type, name2, results2);
        }

        private static void addItemsFromRepository(@Nullable String flavor, int mask, int rank, @NotNull ResourceRepository resources, boolean isFramework, @NotNull ResourceType type, @NotNull String name2, @NotNull List<ItemInfo> results2) {
            ResourceNamespace namespace = isFramework ? ResourceNamespace.ANDROID : ResourceNamespace.TODO();
            List items = resources.getResources(namespace, type, name2);
            for (ResourceItem item : items) {
                String folderName = null;
                PathString source2 = item.getSource();
                if (source2 != null) {
                    folderName = source2.getParentFileName();
                }
                if (folderName == null) {
                    folderName = "?";
                }
                String folder = AndroidJavaDocRenderer.renderFolderName(folderName);
                ResourceValue value2 = item.getResourceValue();
                ItemInfo info = new ItemInfo(value2, item.getConfiguration(), folder, flavor, rank, mask);
                results2.add(info);
            }
        }

        @Nullable
        private String renderKeyValues(@NotNull List<ItemInfo> items, @NotNull ResourceUrl url) {
            if (items.isEmpty()) {
                return null;
            }
            AndroidJavaDocRenderer.markHidden(items);
            HtmlBuilder builder = new HtmlBuilder();
            builder.openHtmlBody();
            if (items.size() == 1) {
                this.renderToHtml(builder, items.get(0), url, true, items.get((int)0).value);
            } else {
                builder.beginTable("valign=\"top\"", "white-space: nowrap;");
                boolean haveFlavors = AndroidJavaDocRenderer.haveFlavors(items);
                if (haveFlavors) {
                    builder.addTableRow(true, new String[]{"Flavor/Library", "Configuration", "Value"});
                } else {
                    builder.addTableRow(true, new String[]{"Configuration", "Value"});
                }
                String prevFlavor = null;
                boolean showResolution = true;
                for (ItemInfo info : items) {
                    String style;
                    String folder = info.folder;
                    String flavor = StringUtil.notNullize((String)info.flavor);
                    if (flavor.equals(prevFlavor)) {
                        flavor = "";
                    } else {
                        prevFlavor = flavor;
                    }
                    builder.addHtml("<tr>");
                    if (haveFlavors) {
                        style = (info.displayMask & 1) != 0 ? "b" : null;
                        this.addTableCell(builder, style, flavor, null, null, false);
                    }
                    this.addTableCell(builder, null, folder, null, null, false);
                    style = (info.displayMask & 2) != 0 ? "s" : null;
                    this.addTableCell(builder, style, null, info, url, showResolution);
                    showResolution = false;
                    builder.addHtml("</tr>");
                }
                builder.endTable();
            }
            builder.closeHtmlBody();
            return builder.getHtml();
        }

        private void addTableCell(@NotNull HtmlBuilder builder, @Nullable String attribute2, @Nullable String text2, @Nullable ItemInfo info, @Nullable ResourceUrl url, boolean showResolution) {
            builder.addHtml("<td valign=\"top\">");
            if (attribute2 != null) {
                builder.addHtml("<").addHtml(attribute2).addHtml(">");
            }
            if (text2 != null) {
                builder.add(text2);
            } else {
                assert (info != null);
                assert (url != null);
                this.renderToHtml(builder, info, url, showResolution, info.value);
            }
            if (attribute2 != null) {
                builder.addHtml("</").addHtml(attribute2).addHtml(">");
            }
            builder.addHtml("</td>");
        }

        @NotNull
        protected ResourceItemResolver createResolver(@NotNull ItemInfo item) {
            return this.createResolver(item.value, item.configuration);
        }

        @NotNull
        protected ResourceItemResolver createResolver(@Nullable ResourceValue value2, @NotNull FolderConfiguration configuration2) {
            ResourceItemResolver resolver = new ResourceItemResolver(configuration2, (ResourceItemResolver.ResourceProvider)this, null);
            ArrayList<ResourceValue> lookupChain = new ArrayList<ResourceValue>();
            lookupChain.add(value2);
            resolver.setLookupChainList(lookupChain);
            return resolver;
        }

        protected void displayChain(@NotNull ResourceUrl url, @NotNull List<ResourceValue> lookupChain, @NotNull HtmlBuilder builder, boolean newlineBefore, boolean newlineAfter) {
            if (!lookupChain.isEmpty()) {
                if (newlineBefore) {
                    builder.newline();
                }
                String text2 = ResourceItemResolver.getDisplayString((String)url.toString(), lookupChain);
                builder.add(text2);
                builder.newline();
                if (newlineAfter) {
                    builder.newline();
                }
            }
        }

        @Nullable
        public ResourceRepository getFrameworkResources() {
            StudioResourceRepositoryManager repositoryManager = StudioResourceRepositoryManager.getInstance(this.myModule);
            ImmutableList overlays = this.myConfiguration != null ? this.myConfiguration.getOverlays() : ImmutableList.of();
            return repositoryManager == null ? null : repositoryManager.getFrameworkResources((Set<String>)ImmutableSet.of(), (List<? extends FrameworkOverlay>)overlays);
        }

        @Nullable
        public ResourceRepository getAppResources() {
            if (this.myAppResources == null) {
                this.myAppResources = StudioResourceRepositoryManager.getAppResources(this.myModule);
            }
            return this.myAppResources;
        }

        @Nullable
        public ResourceResolver getResolver(boolean createIfNecessary) {
            if (this.myResourceResolver == null && createIfNecessary) {
                VirtualFile layout;
                if (this.myConfiguration != null) {
                    this.myResourceResolver = this.myConfiguration.getResourceResolver();
                    return this.myResourceResolver;
                }
                AndroidFacet facet = AndroidFacet.getInstance((Module)this.myModule);
                if (facet != null && (layout = IdeResourcesUtil.pickAnyLayoutFile(facet)) != null) {
                    ConfigurationForFile configuration2 = ConfigurationManager.getOrCreateInstance(this.myModule).getConfiguration(layout);
                    this.myResourceResolver = configuration2.getResourceResolver();
                }
            }
            return this.myResourceResolver;
        }

        public static void renderError(@NotNull HtmlBuilder builder, @Nullable String error) {
            builder.beginColor((Color)JBColor.RED);
            builder.addBold(error == null ? "Error" : error);
            builder.endColor();
        }
    }

    private static class ItemInfo
    implements Comparable<ItemInfo> {
        @Nullable
        public final ResourceValue value;
        @NotNull
        public final FolderConfiguration configuration;
        @Nullable
        public final String flavor;
        @NotNull
        public final String folder;
        public final int rank;
        public int displayMask;

        private ItemInfo(@Nullable ResourceValue value2, @NotNull FolderConfiguration configuration2, @NotNull String folder, @Nullable String flavor, int rank, int initialMask) {
            this.value = value2;
            this.configuration = configuration2;
            this.flavor = flavor;
            this.folder = folder;
            this.displayMask = initialMask;
            this.rank = rank;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemInfo itemInfo = (ItemInfo)o;
            if (this.rank != itemInfo.rank) {
                return false;
            }
            if (!this.configuration.equals((Object)itemInfo.configuration)) {
                return false;
            }
            if (!Objects.equals(this.flavor, itemInfo.flavor)) {
                return false;
            }
            if (!this.folder.equals(itemInfo.folder)) {
                return false;
            }
            return Objects.equals(this.value, itemInfo.value);
        }

        public int hashCode() {
            int result2 = this.value != null ? this.value.hashCode() : 0;
            result2 = 31 * result2 + this.configuration.hashCode();
            result2 = 31 * result2 + (this.flavor != null ? this.flavor.hashCode() : 0);
            result2 = 31 * result2 + this.folder.hashCode();
            result2 = 31 * result2 + this.rank;
            return result2;
        }

        @Override
        public int compareTo(@NotNull ItemInfo other) {
            if (this.rank != other.rank) {
                return this.rank - other.rank;
            }
            DensityQualifier density1 = this.configuration.getDensityQualifier();
            DensityQualifier density2 = other.configuration.getDensityQualifier();
            if (density1 != null && density2 != null) {
                Density density1Value = density1.getValue() == null ? Density.MEDIUM : density1.getValue();
                Density density2Value = density2.getValue() == null ? Density.MEDIUM : density2.getValue();
                int delta = density2Value.compareTo(density1Value);
                if (delta != 0) {
                    return delta;
                }
                if (density1Value == Density.MEDIUM && density1 != density2) {
                    return density2 == density2.getNullQualifier() ? 1 : 0;
                }
            }
            return this.configuration.compareTo(other.configuration);
        }
    }

    private static class ColorValueRenderer
    extends ResourceValueRenderer {
        private ColorValueRenderer(@NotNull Module module, @Nullable Configuration configuration2) {
            super(module, configuration2);
        }

        @Nullable
        private static ResourceValue resolveValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue value2) {
            assert (resolver.getLookupChain() != null);
            resolver.setLookupChainList(new ArrayList());
            if (value2 != null) {
                value2 = resolver.resolveResValue(value2);
            }
            return value2;
        }

        private static float resolveAlpha(@NotNull ResourceItemResolver resolver, @Nullable String alphaValue) {
            float alpha = 1.0f;
            if (alphaValue != null) {
                try {
                    alpha = Float.parseFloat(IdeResourcesUtil.resolveStringValue((RenderResources)resolver, alphaValue));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return alpha;
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue) {
            ResourceItemResolver resolver = this.createResolver(item);
            resourceValue = ColorValueRenderer.resolveValue(resolver, resourceValue);
            assert (resolver.getLookupChain() != null);
            ArrayList<ResourceValue> lookupChain = new ArrayList<ResourceValue>(resolver.getLookupChain());
            if (resourceValue != null) {
                this.renderColorToHtml(resolver, builder, resourceValue, showResolution, 1.0f, 0);
            } else if (item.value != null) {
                ColorValueRenderer.renderError(builder, item.value.getValue());
            }
            if (showResolution) {
                this.displayChain(url, lookupChain, builder, true, false);
            }
        }

        private void renderColorToHtml(@NotNull ResourceItemResolver resolver, @NotNull HtmlBuilder builder, @NotNull ResourceValue resourceValue, boolean showResolution, float alpha, int depth) {
            if (depth >= 50) {
                ColorValueRenderer.renderError(builder, "Resource indirection too deep; might be cyclical");
                return;
            }
            StateList stateList = IdeResourcesUtil.resolveStateList((RenderResources)resolver, resourceValue, this.myModule.getProject());
            if (stateList != null) {
                List<StateListState> states = stateList.getStates();
                if (states.isEmpty()) {
                    ColorValueRenderer.renderError(builder, "Empty StateList");
                } else {
                    builder.addHtml("<table>");
                    for (StateListState state2 : states) {
                        builder.addHtml("<tr>");
                        builder.addHtml("<td>");
                        boolean oldSmall = this.mySmall;
                        this.mySmall = true;
                        float stateAlpha = ColorValueRenderer.resolveAlpha(resolver, state2.getAlpha()) * alpha;
                        ResourceValue resolvedStateResource = resolver.findResValue(state2.getValue(), false);
                        ArrayList<ResourceValue> lookupChain = null;
                        if (resolvedStateResource != null) {
                            resolvedStateResource = ColorValueRenderer.resolveValue(resolver, resolvedStateResource);
                            assert (resolver.getLookupChain() != null);
                            ArrayList<ResourceValue> arrayList = lookupChain = showResolution ? new ArrayList<ResourceValue>(resolver.getLookupChain()) : null;
                        }
                        if (resolvedStateResource != null) {
                            this.renderColorToHtml(resolver, builder, resolvedStateResource, showResolution, stateAlpha, depth + 1);
                        } else {
                            this.renderColorToHtml(builder, state2.getValue(), stateAlpha);
                        }
                        this.mySmall = oldSmall;
                        builder.addHtml("</td>");
                        builder.addHtml("<td>");
                        builder.addHtml(state2.getDescription());
                        builder.addHtml("</td>");
                        if (lookupChain != null) {
                            builder.addHtml("<td>");
                            ResourceUrl resUrl = ResourceUrl.parse((String)state2.getValue());
                            assert (resUrl != null);
                            this.displayChain(resUrl, lookupChain, builder, true, false);
                            builder.addHtml("</td>");
                        }
                        builder.addHtml("</tr>");
                    }
                    builder.addHtml("</table>");
                }
            } else {
                this.renderColorToHtml(builder, resourceValue.getValue(), alpha);
            }
        }

        private void renderColorToHtml(@NotNull HtmlBuilder builder, @Nullable String colorString, float alpha) {
            Color color = ResourcesUtil.parseColor((String)colorString);
            if (color == null) {
                ColorValueRenderer.renderError(builder, colorString);
                return;
            }
            int combinedAlpha = (int)((float)color.getAlpha() * alpha);
            color = ColorUtil.toAlpha((Color)color, (int)IdeResourcesUtil.clamp(combinedAlpha, 0, 255));
            this.renderColorToHtml(builder, color);
        }

        public void renderColorToHtml(@NotNull HtmlBuilder builder, @NotNull Color color) {
            Color displayColor = color;
            int width = 200;
            int height = 100;
            if (this.mySmall) {
                int divisor = 3;
                width /= divisor;
                height /= divisor;
            }
            if (color.getAlpha() != 255) {
                float alpha = (float)color.getAlpha() / 255.0f;
                Color backgroundColor = EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)EditorColors.DOCUMENTATION_COLOR);
                if (backgroundColor != null) {
                    color = new Color((int)((float)backgroundColor.getRed() * (1.0f - alpha) + alpha * (float)color.getRed()), (int)((float)backgroundColor.getGreen() * (1.0f - alpha) + alpha * (float)color.getGreen()), (int)((float)backgroundColor.getBlue() * (1.0f - alpha) + alpha * (float)color.getBlue()));
                }
            }
            String colorString = String.format(Locale.US, "rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
            String foregroundColor = ColorUtil.isDark((Color)color) ? "white" : "black";
            String css = "background-color:" + colorString + ";width:" + width + "px;text-align:center;vertical-align:middle;";
            builder.addHtml("<table style=\"" + css + "\" border=\"0\"><tr height=\"" + height + "\">");
            builder.addHtml("<td align=\"center\" valign=\"middle\" height=\"" + height + "\" style=\"color:" + foregroundColor + "\">");
            builder.addHtml(ResourcesUtil.colorToString((Color)displayColor));
            builder.addHtml("</td></tr></table>");
        }
    }

    private static class DrawableValueRenderer
    extends ResourceValueRenderer {
        private DrawableValueRenderer(@NotNull Module module, @Nullable Configuration configuration2) {
            super(module, configuration2);
        }

        @Nullable
        private static ResourceValue resolveValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue value2) {
            assert (resolver.getLookupChain() != null);
            resolver.setLookupChainList(new ArrayList());
            if (value2 != null) {
                value2 = resolver.resolveResValue(value2);
            }
            return value2;
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue) {
            FolderConfiguration configuration2 = item.configuration;
            DensityQualifier densityQualifier = configuration2.getDensityQualifier();
            if (!ResourceQualifier.isValid((ResourceQualifier)densityQualifier)) {
                densityQualifier = new DensityQualifier(Density.MEDIUM);
                configuration2 = FolderConfiguration.copyOf((FolderConfiguration)item.configuration);
                configuration2.setDensityQualifier(densityQualifier);
            }
            ResourceItemResolver resolver = this.createResolver(item.value, configuration2);
            resourceValue = DrawableValueRenderer.resolveValue(resolver, resourceValue);
            assert (resolver.getLookupChain() != null);
            ArrayList<ResourceValue> lookupChain = new ArrayList<ResourceValue>(resolver.getLookupChain());
            if (resourceValue != null) {
                this.renderDrawableToHtml(resolver, builder, resourceValue, showResolution, configuration2, 0);
            } else if (item.value != null) {
                DrawableValueRenderer.renderError(builder, item.value.getValue());
            }
            if (showResolution) {
                this.displayChain(url, lookupChain, builder, true, false);
            }
        }

        private void renderDrawableToHtml(@NotNull ResourceItemResolver resolver, @NotNull HtmlBuilder builder, @NotNull ResourceValue resolvedValue, boolean showResolution, @NotNull FolderConfiguration configuration2, int depth) {
            if (depth >= 50) {
                DrawableValueRenderer.renderError(builder, "Resource indirection too deep; might be cyclical");
                return;
            }
            StateList stateList = IdeResourcesUtil.resolveStateList((RenderResources)resolver, resolvedValue, this.myModule.getProject());
            if (stateList != null) {
                List<StateListState> states = stateList.getStates();
                if (states.isEmpty()) {
                    DrawableValueRenderer.renderError(builder, "Empty StateList");
                } else {
                    builder.addHtml("<table>");
                    for (StateListState state2 : states) {
                        builder.addHtml("<tr>");
                        builder.addHtml("<td>");
                        boolean oldSmall = this.mySmall;
                        this.mySmall = true;
                        ResourceValue resolvedStateResource = resolver.findResValue(state2.getValue(), false);
                        ArrayList<ResourceValue> lookupChain = null;
                        if (resolvedStateResource != null) {
                            resolvedStateResource = DrawableValueRenderer.resolveValue(resolver, resolvedStateResource);
                            assert (resolver.getLookupChain() != null);
                            ArrayList<ResourceValue> arrayList = lookupChain = showResolution ? new ArrayList<ResourceValue>(resolver.getLookupChain()) : null;
                        }
                        if (resolvedStateResource != null) {
                            this.renderDrawableToHtml(resolver, builder, resolvedStateResource, showResolution, configuration2, depth + 1);
                        } else {
                            DrawableValueRenderer.renderError(builder, state2.getValue());
                        }
                        this.mySmall = oldSmall;
                        builder.addHtml("</td>");
                        builder.addHtml("<td>");
                        builder.addHtml(state2.getDescription());
                        builder.addHtml("</td>");
                        if (lookupChain != null) {
                            builder.addHtml("<td>");
                            ResourceUrl resUrl = ResourceUrl.parse((String)state2.getValue());
                            assert (resUrl != null);
                            this.displayChain(resUrl, lookupChain, builder, true, false);
                            builder.addHtml("</td>");
                        }
                        builder.addHtml("</tr>");
                    }
                    builder.addHtml("</table>");
                }
            } else {
                AndroidFacet facet = AndroidFacet.getInstance((Module)this.myModule);
                assert (facet != null);
                FolderConfiguration folderConfiguration = ResolutionUtils.getFolderConfiguration(facet, resolvedValue, configuration2);
                DensityQualifier densityQualifier = folderConfiguration.getDensityQualifier();
                if (!ResourceQualifier.isValid((ResourceQualifier)densityQualifier)) {
                    densityQualifier = configuration2.getDensityQualifier();
                    assert (ResourceQualifier.isValid((ResourceQualifier)densityQualifier));
                }
                String value2 = resolvedValue.getValue();
                assert (value2 != null);
                this.renderDrawableToHtml(builder, value2, densityQualifier.getValue(), resolvedValue);
            }
        }

        private void renderDrawableToHtml(@NotNull HtmlBuilder builder, @NotNull String result2, @NotNull Density density, @NotNull ResourceValue resolvedValue) {
            if (ResourceFiles.isResourceFile(result2)) {
                VirtualFile file = FileExtensions.toVirtualFile(ResourcesUtil.toFileResourcePathString((String)result2));
                if (file == null) {
                    DrawableValueRenderer.renderError(builder, result2);
                } else {
                    this.renderDrawableToHtml(builder, file, density, resolvedValue);
                }
            } else if (result2.startsWith("#")) {
                ColorValueRenderer colorRenderer = (ColorValueRenderer)ResourceValueRenderer.create(ResourceType.COLOR, this.myModule, this.myConfiguration);
                assert (colorRenderer != null);
                colorRenderer.setSmall(this.mySmall);
                colorRenderer.renderColorToHtml(builder, result2, 1.0f);
            } else {
                DrawableValueRenderer.renderError(builder, result2);
            }
        }

        private void renderDrawableToHtml(@NotNull HtmlBuilder builder, @NotNull VirtualFile virtualFile, @NotNull Density density, @NotNull ResourceValue resolvedValue) {
            String path = virtualFile.getPath();
            boolean isWebP = path.endsWith(".webp");
            if (SdkUtils.hasImageExtension((String)path) && !isWebP) {
                File file;
                if (virtualFile.getFileSystem().getProtocol().equals("file")) {
                    file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                } else {
                    try {
                        Path outputPath = Files.createTempFile("render", ".png", new FileAttribute[0]);
                        file = outputPath.toFile();
                        file.deleteOnExit();
                        try (InputStream input2 = virtualFile.getInputStream();
                             OutputStream output = Files.newOutputStream(file.toPath(), StandardOpenOption.APPEND, StandardOpenOption.WRITE);){
                            FileUtilRt.copy((InputStream)input2, (OutputStream)output);
                        }
                    }
                    catch (IOException e) {
                        DrawableValueRenderer.renderError(builder, e.toString());
                        return;
                    }
                }
                URL fileUrl = DrawableValueRenderer.fileToUrl(file);
                if (fileUrl != null) {
                    builder.beginDiv("background-color:gray;padding:10px");
                    builder.addImage(fileUrl, path);
                    builder.endDiv();
                    Dimension size = AndroidJavaDocRenderer.getSize(virtualFile);
                    if (size != null) {
                        builder.addHtml(String.format(Locale.US, "%1$d&#xd7;%2$d px (%3$d&#xd7;%4$d dp @ %5$s)", size.width, size.height, DrawableValueRenderer.px2dp(size.width, density), DrawableValueRenderer.px2dp(size.height, density), density.getResourceValue()));
                    }
                }
            } else if (this.myConfiguration != null) {
                BufferedImage image;
                AndroidFacet facet = AndroidFacet.getInstance((Module)this.myModule);
                assert (facet != null);
                RenderService service = StudioRenderService.getInstance(this.myModule.getProject());
                RenderLogger logger = new RenderLogger(null, null, (Boolean)StudioFlags.NELE_LOG_ANDROID_FRAMEWORK.get(), ShowFixFactory.INSTANCE, () -> HtmlLinkManager.NOOP_LINK_MANAGER);
                CompletableFuture<RenderTask> renderTaskFuture = StudioRenderServiceKt.taskBuilder(service, AndroidBuildTargetReference.gradleOnly(facet), this.myConfiguration, logger).build();
                CompletionStage future2 = renderTaskFuture.thenCompose(renderTask -> {
                    Dimension size;
                    if (renderTask == null) {
                        return CompletableFuture.completedFuture(null);
                    }
                    int width = 100;
                    int height = 100;
                    if (isWebP && (size = AndroidJavaDocRenderer.getSize(virtualFile)) != null) {
                        width = size.width;
                        height = size.height;
                    }
                    renderTask.setOverrideRenderSize(width, height);
                    return renderTask.renderDrawable(resolvedValue).whenComplete((image, ex) -> renderTask.dispose());
                });
                try {
                    image = (BufferedImage)NonBlockingReadActionUtilKt.waitInterruptibly(future2);
                }
                catch (InterruptedException | ExecutionException e) {
                    DrawableValueRenderer.renderError(builder, e.toString());
                    return;
                }
                if (image != null) {
                    try {
                        URL fileUrl;
                        Path outputFile = Files.createTempFile("render", ".png", new FileAttribute[0]);
                        File tempFile = outputFile.toFile();
                        tempFile.deleteOnExit();
                        boolean ok2 = ImageIO.write((RenderedImage)image, "PNG", tempFile);
                        if (ok2 && (fileUrl = DrawableValueRenderer.fileToUrl(tempFile)) != null) {
                            builder.beginDiv("background-color:gray;padding:10px");
                            builder.addImage(fileUrl, null);
                            builder.endDiv();
                        }
                    }
                    catch (IOException e) {
                        DrawableValueRenderer.renderError(builder, e.toString());
                    }
                } else {
                    DrawableValueRenderer.renderError(builder, "Couldn't render " + virtualFile);
                }
            } else {
                DrawableValueRenderer.renderError(builder, path);
            }
        }

        @Nullable
        private static URL fileToUrl(@NotNull File file) {
            try {
                return SdkUtils.fileToUrl((File)file);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        private static int px2dp(int px, Density density) {
            return (int)((float)px * (float)Density.MEDIUM.getDpiValue() / (float)density.getDpiValue());
        }
    }

    private static class ArrayRenderer
    extends ResourceValueRenderer {
        private ArrayRenderer(@NotNull Module module, @Nullable Configuration configuration2) {
            super(module, configuration2);
        }

        @Nullable
        private static ResourceValue resolveValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue value2) {
            if (value2 != null) {
                assert (resolver.getLookupChain() != null);
                resolver.setLookupChainList(new ArrayList());
                return resolver.resolveResValue(value2);
            }
            return null;
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue) {
            ResourceItemResolver resolver = this.createResolver(item);
            ResourceValue value2 = ArrayRenderer.resolveValue(resolver, resourceValue);
            if (value2 instanceof ArrayResourceValue) {
                ArrayResourceValue arv = (ArrayResourceValue)value2;
                builder.add(Joiner.on((String)", ").skipNulls().join((Iterable)arv));
            } else if (value2 != null) {
                builder.add(value2.toString());
            }
            if (showResolution) {
                List lookupChain = resolver.getLookupChain();
                assert (lookupChain != null);
                if (lookupChain.size() > 1) {
                    this.displayChain(url, lookupChain, builder, true, false);
                }
            }
        }
    }

    private static class TextValueRenderer
    extends ResourceValueRenderer {
        private TextValueRenderer(@NotNull Module module, @Nullable Configuration configuration2) {
            super(module, configuration2);
        }

        @Nullable
        private static String resolveStringValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue itemValue, @NotNull ResourceUrl url) {
            assert (resolver.getLookupChain() != null);
            resolver.setLookupChainList(new ArrayList());
            if (itemValue != null) {
                String value2 = itemValue.getValue();
                if (value2 != null) {
                    ResourceUrl parsed = ResourceUrl.parse((String)value2);
                    if (parsed != null) {
                        ResourceValueImpl v = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), null);
                        v.setValue(url.toString());
                        ResourceValue resourceValue = resolver.resolveResValue((ResourceValue)v);
                        if (resourceValue.getValue() != null) {
                            return resourceValue.getValue();
                        }
                    }
                    return value2;
                }
                ResourceValueImpl v = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), null);
                v.setValue(url.toString());
                ResourceValue resourceValue = resolver.resolveResValue((ResourceValue)v);
                if (resourceValue.getValue() != null) {
                    return resourceValue.getValue();
                }
                if (resourceValue instanceof StyleResourceValue) {
                    return resourceValue.getResourceUrl().toString();
                }
                return url.toString();
            }
            return null;
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue) {
            ResourceItemResolver resolver = this.createResolver(item);
            String value2 = TextValueRenderer.resolveStringValue(resolver, resourceValue, url);
            List lookupChain = resolver.getLookupChain();
            if (value2 != null) {
                boolean found = false;
                if (url.isTheme()) {
                    if (value2.startsWith("#")) {
                        Color color = ResourcesUtil.parseColor((String)value2);
                        if (color != null) {
                            found = true;
                            ResourceValueRenderer renderer2 = ResourceValueRenderer.create(ResourceType.COLOR, this.myModule, this.myConfiguration);
                            assert (renderer2 != null);
                            ResourceValueImpl resolved = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), null);
                            resolved.setValue(value2);
                            renderer2.renderToHtml(builder, item, url, false, (ResourceValue)resolved);
                            builder.newline();
                        }
                    } else if (value2.endsWith(".png") && ResourceFiles.isResourceFile(value2)) {
                        found = true;
                        ResourceValueRenderer renderer3 = ResourceValueRenderer.create(ResourceType.DRAWABLE, this.myModule, this.myConfiguration);
                        assert (renderer3 != null);
                        ResourceValueImpl resolved = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), null);
                        resolved.setValue(value2);
                        renderer3.renderToHtml(builder, item, url, false, (ResourceValue)resolved);
                        builder.newline();
                    }
                    if (!found) {
                        assert (lookupChain != null);
                        int i = lookupChain.size();
                        while (--i >= 0) {
                            ResourceValueRenderer renderer4;
                            ResourceUrl resourceUrl;
                            String value22;
                            ResourceValue rv = (ResourceValue)lookupChain.get(i);
                            if (rv == null || (value22 = rv.getValue()) == null || (resourceUrl = ResourceUrl.parse((String)value22, (boolean)rv.isFramework())) == null || resourceUrl.isTheme() || (renderer4 = TextValueRenderer.create(resourceUrl.type, this.myModule, this.myConfiguration)) == null || renderer4.getClass() == this.getClass()) continue;
                            found = true;
                            ResourceValueImpl resolved = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(resourceUrl), null);
                            resolved.setValue(value2);
                            renderer4.renderToHtml(builder, item, resourceUrl, false, (ResourceValue)resolved);
                            builder.newline();
                            break;
                        }
                    }
                }
                if (!(found || showResolution && lookupChain != null && !lookupChain.isEmpty())) {
                    builder.add(value2);
                }
            } else if (item.value != null && item.value.getValue() != null) {
                builder.add(item.value.getValue());
            }
            if (showResolution) {
                ResourceValue rv;
                assert (lookupChain != null);
                this.displayChain(url, lookupChain, builder, true, true);
                if (!lookupChain.isEmpty() && (rv = (ResourceValue)lookupChain.get(lookupChain.size() - 1)) instanceof StyleResourceValue) {
                    StyleResourceValue srv = (StyleResourceValue)rv;
                    this.displayStyleValues(builder, item, resolver, srv);
                }
            }
        }

        private void displayStyleValues(HtmlBuilder builder, ItemInfo item, ResourceItemResolver resolver, StyleResourceValue styleValue) {
            List lookupChain = resolver.getLookupChain();
            builder.addHtml("<hr>");
            builder.addBold(styleValue.getName()).add(":").newline();
            HashSet<String> visitedStyleValues = new HashSet<String>();
            HashSet<String> masked = new HashSet<String>();
            while (styleValue != null && visitedStyleValues.add(styleValue.asReference().getQualifiedName())) {
                ImmutableList values = Ordering.usingToString().immutableSortedCopy((Iterable)styleValue.getDefinedItems());
                for (StyleItemResourceValue itemResourceValue : values) {
                    StyleItemResourceValue v;
                    String name2 = itemResourceValue.getAttrName();
                    if (!masked.add(name2)) continue;
                    String value2 = null;
                    ResourceReference attr = itemResourceValue.getAttr();
                    if (attr != null && (v = styleValue.getItem(attr)) != null) {
                        value2 = v.getValue();
                    }
                    builder.addNbsps(4);
                    if (attr != null && attr.getNamespace() == ResourceNamespace.ANDROID) {
                        builder.add("android:");
                    }
                    builder.addBold(name2).add(" = ").add(value2 == null ? "null" : value2);
                    if (value2 != null) {
                        ResourceUrl url = ResourceUrl.parse((String)value2, (boolean)styleValue.isFramework());
                        if (url != null) {
                            ResourceValueRenderer renderer2;
                            ResourceUrl resolvedUrl = url;
                            int count = 0;
                            while (resolvedUrl != null) {
                                ResourceValue resourceValue;
                                if (lookupChain != null) {
                                    lookupChain.clear();
                                }
                                if (resolvedUrl.isTheme()) {
                                    ResourceReference ref = new ResourceReference(ResourceNamespace.fromBoolean((boolean)resolvedUrl.isFramework()), ResourceType.ATTR, resolvedUrl.name);
                                    resourceValue = resolver.findItemInTheme(ref);
                                } else {
                                    resourceValue = resolver.findResValue(resolvedUrl.toString(), resolvedUrl.isFramework());
                                }
                                if (resourceValue == null || resourceValue.getValue() == null) break;
                                url = resolvedUrl;
                                value2 = resourceValue.getValue();
                                resolvedUrl = ResourceUrl.parse((String)value2, (boolean)resolvedUrl.isFramework());
                                if (count++ != 50) continue;
                                break;
                            }
                            if ((renderer2 = TextValueRenderer.create(url.type, this.myModule, this.myConfiguration)) != null && renderer2.getClass() != this.getClass()) {
                                builder.newline();
                                renderer2.setSmall(true);
                                ResourceValueImpl resolved = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), value2);
                                renderer2.renderToHtml(builder, item, url, false, (ResourceValue)resolved);
                                continue;
                            }
                            builder.add(" => ");
                            int index = value2.indexOf("exploded-aar");
                            if (index != -1) {
                                value2 = value2.substring(index + "exploded-aar".length() + 1);
                            }
                            builder.add(value2);
                            builder.newline();
                            continue;
                        }
                        builder.newline();
                        continue;
                    }
                    builder.newline();
                }
                if ((styleValue = resolver.getParent(styleValue)) == null) continue;
                builder.newline();
                builder.add("Inherits from: ").add(styleValue.getResourceUrl().toString()).add(":").newline();
            }
        }
    }
}

