/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.ResourceItem;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.model.StringResourceKey;
import com.android.tools.idea.editors.strings.model.StringResourceRepository;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StringResourceWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.RenameProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 22\u00020\u0001:\u00012B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0015\u001a\u00020\u0010J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0015\u001a\u00020\u0010H\u0007J\u000e\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010J\u000e\u0010!\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0010J\u0010\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001f0'8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u00063"}, d2={"Lcom/android/tools/idea/editors/strings/StringResourceData;", "", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lcom/android/tools/idea/editors/strings/model/StringResourceRepository;", "stringResourceWriter", "Lcom/android/tools/idea/res/StringResourceWriter;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/editors/strings/model/StringResourceRepository;Lcom/android/tools/idea/res/StringResourceWriter;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRepository", "()Lcom/android/tools/idea/editors/strings/model/StringResourceRepository;", "keyToResourceMap", "", "Lcom/android/tools/idea/editors/strings/model/StringResourceKey;", "Lcom/android/tools/idea/editors/strings/StringResource;", "setKeyName", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "key", "name", "", "replaceInMap", "", "old", "new", "validateKey", "getMissingTranslations", "", "Lcom/android/ide/common/resources/Locale;", "containsKey", "getStringResource", "resources", "", "getResources", "()Ljava/util/Collection;", "keys", "", "getKeys", "()Ljava/util/List;", "localeList", "getLocaleList", "localeSet", "getLocaleSet", "()Ljava/util/Set;", "getDefaultLocaleXml", "Lcom/intellij/psi/xml/XmlFile;", "locale", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nStringResourceData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringResourceData.kt\ncom/android/tools/idea/editors/strings/StringResourceData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n1279#2,2:185\n1293#2,4:187\n1755#2,3:191\n1863#2,2:194\n774#2:197\n865#2,2:198\n1#3:196\n*S KotlinDebug\n*F\n+ 1 StringResourceData.kt\ncom/android/tools/idea/editors/strings/StringResourceData\n*L\n40#1:185,2\n40#1:187,4\n45#1:191,3\n77#1:194,2\n119#1:197\n119#1:198,2\n*E\n"})
public final class StringResourceData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final StringResourceRepository repository;
    @NotNull
    private final StringResourceWriter stringResourceWriter;
    @NotNull
    private final Map<StringResourceKey, StringResource> keyToResourceMap;
    private static final int MAX_LOCALE_LABEL_COUNT = 3;

    /*
     * WARNING - void declaration
     */
    private StringResourceData(Project project, StringResourceRepository repository2, StringResourceWriter stringResourceWriter) {
        void $this$associateWith$iv;
        this.project = project;
        this.repository = repository2;
        this.stringResourceWriter = stringResourceWriter;
        Iterable iterable = this.repository.getKeys();
        StringResourceData stringResourceData = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            StringResourceKey stringResourceKey = (StringResourceKey)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            StringResource stringResource = (StringResource)ActionsKt.runReadAction(() -> StringResourceData.keyToResourceMap$lambda$1$lambda$0((StringResourceKey)it, this));
            map2.put(t, stringResource);
        }
        stringResourceData.keyToResourceMap = MapsKt.toMutableMap((Map)result$iv);
    }

    /* synthetic */ StringResourceData(Project project, StringResourceRepository stringResourceRepository, StringResourceWriter stringResourceWriter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            stringResourceWriter = StringResourceWriter.INSTANCE;
        }
        this(project, stringResourceRepository, stringResourceWriter);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final StringResourceRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public final ListenableFuture<Boolean> setKeyName(@NotNull StringResourceKey key, @NotNull String name2) {
        Object it;
        block13: {
            block12: {
                boolean bl;
                block11: {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    if (Intrinsics.areEqual((Object)key.getName(), (Object)name2)) break block12;
                    Iterable $this$any$iv = this.keyToResourceMap.keySet();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (StringResourceKey)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)((StringResourceKey)it).getName(), (Object)name2)) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block13;
            }
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
            return listenableFuture;
        }
        ResourceItem resourceItem = this.getStringResource(key).getDefaultValueAsResourceItem();
        if (resourceItem == null) {
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
            return listenableFuture;
        }
        ResourceItem value2 = resourceItem;
        XmlTag xmlTag = IdeResourcesUtil.getItemTag(this.project, value2);
        if (xmlTag == null) {
            Object element$iv;
            element$iv = "Required value was null.";
            throw new IllegalStateException(element$iv.toString());
        }
        XmlTag stringElement = xmlTag;
        XmlAttribute xmlAttribute = stringElement.getAttribute("name");
        if (xmlAttribute == null) {
            it = "Required value was null.";
            throw new IllegalStateException(it.toString());
        }
        XmlAttribute nameAttribute = xmlAttribute;
        XmlAttributeValue xmlAttributeValue = nameAttribute.getValueElement();
        if (xmlAttributeValue == null) {
            String bl2 = "Required value was null.";
            throw new IllegalStateException(bl2.toString());
        }
        XmlAttributeValue nameAttributeValue = xmlAttributeValue;
        new RenameProcessor(this.project, (PsiElement)nameAttributeValue, name2, false, false).run();
        SettableFuture futureItem = SettableFuture.create();
        StringResourceKey newKey = new StringResourceKey(name2, key.getDirectory(), false, 4, null);
        this.repository.invokeAfterPendingUpdatesFinish(newKey, () -> StringResourceData.setKeyName$lambda$3(this, key, newKey, futureItem));
        Intrinsics.checkNotNull((Object)futureItem);
        return (ListenableFuture)futureItem;
    }

    private final void replaceInMap(StringResourceKey old, StringResource stringResource) {
        List values = CollectionsKt.toList((Iterable)this.keyToResourceMap.values());
        boolean newAdded = false;
        this.keyToResourceMap.clear();
        Iterable $this$forEach$iv = values;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StringResource value2 = (StringResource)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)value2.getKey(), (Object)old)) {
                this.keyToResourceMap.put(stringResource.getKey(), stringResource);
                newAdded = true;
                continue;
            }
            this.keyToResourceMap.put(value2.getKey(), value2);
        }
        if (!newAdded) {
            this.keyToResourceMap.put(stringResource.getKey(), stringResource);
        }
    }

    @Nullable
    public final String validateKey(@NotNull StringResourceKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!this.keyToResourceMap.containsKey(key)) {
            boolean $i$a$-require-StringResourceData$validateKey$22 = false;
            String $i$a$-require-StringResourceData$validateKey$22 = "Key " + key + " does not exist.";
            throw new IllegalArgumentException($i$a$-require-StringResourceData$validateKey$22.toString());
        }
        StringResource stringResource = this.getStringResource(key);
        if (!stringResource.isTranslatable()) {
            Collection<Locale> localesWithTranslation = stringResource.getTranslatedLocales();
            if (!localesWithTranslation.isEmpty()) {
                return "Key '" + key.getName() + "' is marked as non translatable, but is translated in " + StringUtil.pluralize((String)"locale", (int)localesWithTranslation.size()) + " " + Companion.summarizeLocales(localesWithTranslation);
            }
        } else {
            if (stringResource.getDefaultValueAsResourceItem() == null) {
                return "Key '" + key.getName() + "' missing default value";
            }
            Set<Locale> missingTranslations = this.getMissingTranslations(key);
            if (!missingTranslations.isEmpty()) {
                return "Key '" + key.getName() + "' has translations missing for " + StringUtil.pluralize((String)"locale", (int)missingTranslations.size()) + " " + Companion.summarizeLocales((Collection<? extends Locale>)missingTranslations);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final Set<Locale> getMissingTranslations(@NotNull StringResourceKey key) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        StringResource stringResource = this.getStringResource(key);
        Iterable $this$filter$iv = this.getLocaleSet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Locale it = (Locale)element$iv$iv;
            boolean bl = false;
            if (!stringResource.isTranslationMissing(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final boolean containsKey(@NotNull StringResourceKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.keyToResourceMap.containsKey(key);
    }

    @NotNull
    public final StringResource getStringResource(@NotNull StringResourceKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        StringResource stringResource = this.keyToResourceMap.get(key);
        if (stringResource == null) {
            boolean bl = false;
            String string = key.toString();
            throw new IllegalArgumentException(string.toString());
        }
        return stringResource;
    }

    @NotNull
    public final Collection<StringResource> getResources() {
        return this.keyToResourceMap.values();
    }

    @NotNull
    public final List<StringResourceKey> getKeys() {
        return CollectionsKt.toList((Iterable)this.keyToResourceMap.keySet());
    }

    @NotNull
    public final List<Locale> getLocaleList() {
        Iterable iterable = this.getLocaleSet();
        Comparator comparator = Locale.LANGUAGE_NAME_COMPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"LANGUAGE_NAME_COMPARATOR");
        return CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator));
    }

    @NotNull
    public final Set<Locale> getLocaleSet() {
        return this.repository.getTranslatedLocales();
    }

    @Nullable
    public final XmlFile getDefaultLocaleXml(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return (XmlFile)SequencesKt.singleOrNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.keyToResourceMap.values()), arg_0 -> StringResourceData.getDefaultLocaleXml$lambda$8(locale, arg_0)), arg_0 -> StringResourceData.getDefaultLocaleXml$lambda$9(this, arg_0))));
    }

    private static final StringResource keyToResourceMap$lambda$1$lambda$0(StringResourceKey $it, StringResourceData this$0) {
        return new StringResource($it, this$0, null, 4, null);
    }

    private static final void setKeyName$lambda$3(StringResourceData this$0, StringResourceKey $key, StringResourceKey $newKey, SettableFuture $futureItem) {
        this$0.replaceInMap($key, new StringResource($newKey, this$0, null, 4, null));
        $futureItem.set((Object)true);
    }

    private static final ResourceItem getDefaultLocaleXml$lambda$8(Locale $locale, StringResource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTranslationAsResourceItem($locale);
    }

    private static final XmlFile getDefaultLocaleXml$lambda$9(StringResourceData this$0, ResourceItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        XmlTag xmlTag = IdeResourcesUtil.getItemTag(this$0.project, it);
        PsiFile psiFile = xmlTag != null ? xmlTag.getContainingFile() : null;
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    @JvmStatic
    @NotNull
    public static final StringResourceData create(@NotNull Project project, @NotNull StringResourceRepository repository2) {
        return Companion.create(project, repository2);
    }

    @VisibleForTesting
    @JvmStatic
    @NotNull
    public static final String summarizeLocales(@NotNull Collection<? extends Locale> locales) {
        return Companion.summarizeLocales(locales);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012*\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0012\u0010\u0013\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\f\u0010\u0014\u001a\u00020\r*\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/editors/strings/StringResourceData$Companion;", "", "<init>", "()V", "MAX_LOCALE_LABEL_COUNT", "", "create", "Lcom/android/tools/idea/editors/strings/StringResourceData;", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lcom/android/tools/idea/editors/strings/model/StringResourceRepository;", "summarizeLocales", "", "locales", "", "Lcom/android/ide/common/resources/Locale;", "getLowest", "", "getLabels", "getLabel", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nStringResourceData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringResourceData.kt\ncom/android/tools/idea/editors/strings/StringResourceData$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n1053#2:185\n*S KotlinDebug\n*F\n+ 1 StringResourceData.kt\ncom/android/tools/idea/editors/strings/StringResourceData$Companion\n*L\n177#1:185\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final StringResourceData create(@NotNull Project project, @NotNull StringResourceRepository repository2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            return new StringResourceData(project, repository2, null, 4, null);
        }

        @VisibleForTesting
        @JvmStatic
        @NotNull
        public final String summarizeLocales(@NotNull Collection<? extends Locale> locales) {
            Intrinsics.checkNotNullParameter(locales, (String)"locales");
            if (locales.isEmpty()) {
                return "";
            }
            int size = locales.size();
            if (size == 1) {
                return this.getLabel((Locale)CollectionsKt.first((Iterable)locales));
            }
            List<Locale> sorted = this.getLowest(locales);
            return size <= 3 ? this.getLabels((Collection<? extends Locale>)sorted.subList(0, size - 1)) + " and " + this.getLabel(sorted.get(size - 1)) : this.getLabels((Collection<? extends Locale>)sorted) + " and " + (size - 3) + " more";
        }

        private final List<Locale> getLowest(Collection<? extends Locale> $this$getLowest) {
            Iterable $this$sortedBy$iv = CollectionsKt.take((Iterable)$this$getLowest, (int)3);
            boolean $i$f$sortedBy = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Locale it = (Locale)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)com.android.tools.idea.editors.strings.StringResourceData$Companion.access$getLabel(StringResourceData.Companion, it));
                    it = (Locale)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)com.android.tools.idea.editors.strings.StringResourceData$Companion.access$getLabel(StringResourceData.Companion, it))));
                }
            });
        }

        private final String getLabels(Collection<? extends Locale> $this$getLabels) {
            return CollectionsKt.joinToString$default((Iterable)$this$getLabels, (CharSequence)", ", null, null, (int)0, null, Companion::getLabels$lambda$1, (int)30, null);
        }

        private final String getLabel(Locale $this$getLabel) {
            String string = Locale.getLocaleLabel((Locale)$this$getLabel, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocaleLabel(...)");
            return string;
        }

        private static final CharSequence getLabels$lambda$1(Locale it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.getLabel(it);
        }

        public static final /* synthetic */ String access$getLabel(Companion $this, Locale $receiver) {
            return $this.getLabel($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

