/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.MinimumWidthTextField;
import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.intellij.ui.DocumentAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.function.IntSupplier;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/editors/strings/TranslationsEditorTextField;", "Lcom/android/tools/idea/editors/strings/MinimumWidthTextField;", "table", "Lcom/android/tools/idea/editors/strings/table/StringResourceTable;", "columnSupplier", "Ljava/util/function/IntSupplier;", "validator", "Lkotlin/Function1;", "", "<init>", "(Lcom/android/tools/idea/editors/strings/table/StringResourceTable;Ljava/util/function/IntSupplier;Lkotlin/jvm/functions/Function1;)V", "lastSavedValue", "setText", "", "text", "saveText", "updateErrorState", "intellij.android.core"})
public final class TranslationsEditorTextField
extends MinimumWidthTextField {
    @NotNull
    private final StringResourceTable table;
    @NotNull
    private final IntSupplier columnSupplier;
    @NotNull
    private final Function1<String, String> validator;
    @Nullable
    private String lastSavedValue;

    public TranslationsEditorTextField(@NotNull StringResourceTable table2, @NotNull IntSupplier columnSupplier, @NotNull Function1<? super String, String> validator) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        Intrinsics.checkNotNullParameter((Object)columnSupplier, (String)"columnSupplier");
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        this.table = table2;
        this.columnSupplier = columnSupplier;
        this.validator = validator;
        this.addActionListener(arg_0 -> TranslationsEditorTextField._init_$lambda$0(this, arg_0));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.saveText();
            }
        });
        this.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.updateErrorState();
            }
        });
    }

    public void setText(@Nullable String text2) {
        super.setText(text2);
        this.lastSavedValue = text2;
    }

    private final void saveText() {
        String error;
        CharSequence charSequence;
        if (this.table.hasSelectedCell() && !Intrinsics.areEqual((Object)this.getText(), (Object)this.lastSavedValue) && ((charSequence = (CharSequence)(error = this.updateErrorState())) == null || charSequence.length() == 0)) {
            this.lastSavedValue = this.getText();
            ((StringResourceTableModel)this.table.getModel()).setValueAt(this.getText(), this.table.getSelectedModelRowIndex(), this.columnSupplier.getAsInt());
        }
    }

    private final String updateErrorState() {
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String error = (String)this.validator.invoke((Object)string);
        CharSequence charSequence = error;
        this.putClientProperty("JComponent.outline", charSequence == null || charSequence.length() == 0 ? null : "error");
        this.setToolTipText(error);
        return error;
    }

    private static final void _init_$lambda$0(TranslationsEditorTextField this$0, ActionEvent it) {
        this$0.saveText();
    }
}

