/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.ide.common.resources.Locale;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.table.FrozenColumnTable;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableRowSorter;
import com.android.tools.idea.editors.strings.table.LocaleRenderer;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringTableCellEditor;
import com.android.tools.idea.editors.strings.table.StringsCellRenderer;
import com.android.tools.idea.editors.strings.table.filter.StringResourceTableColumnFilter;
import com.android.tools.idea.editors.strings.table.filter.StringResourceTableRowFilter;
import com.intellij.util.ui.JBUI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceTable
extends FrozenColumnTable<StringResourceTableModel> {
    private final TableCellRenderer myLocaleRenderer;
    @Nullable
    private StringResourceTableColumnFilter myColumnFilter;
    private boolean myColumnPreferredWidthsSet;

    public StringResourceTable() {
        super(new StringResourceTableModel(), 4);
        this.setDefaultEditor(String.class, new StringTableCellEditor());
        this.setDefaultRenderer(String.class, new StringsCellRenderer());
        this.setRowSorter(new FrozenColumnTableRowSorter(new ThreeStateTableRowSorter<StringResourceTableModel>((StringResourceTableModel)this.getModel()), this));
        this.putInInputMap(KeyStroke.getKeyStroke(8, 0), "delete");
        this.putInInputMap(KeyStroke.getKeyStroke(127, 0), "delete");
        this.myLocaleRenderer = new LocaleRenderer(this.getDefaultTableHeaderRenderer());
    }

    @Nullable
    public StringResourceData getData() {
        return ((StringResourceTableModel)this.getModel()).getData();
    }

    @Nullable
    public StringResourceTableRowFilter getRowFilter() {
        FrozenColumnTableRowSorter sorter = this.getRowSorter();
        assert (sorter != null);
        return (StringResourceTableRowFilter)sorter.getRowFilter();
    }

    public void setRowFilter(@Nullable StringResourceTableRowFilter filter2) {
        FrozenColumnTableRowSorter<StringResourceTableModel> sorter = this.getRowSorter();
        assert (sorter != null);
        sorter.setRowFilter(filter2);
    }

    @Nullable
    public StringResourceTableColumnFilter getColumnFilter() {
        return this.myColumnFilter;
    }

    public void setColumnFilter(@Nullable StringResourceTableColumnFilter filter2) {
        this.myColumnFilter = filter2;
        this.createDefaultColumnsFromModel();
    }

    @Override
    boolean includeColumn(int modelColumnIndex) {
        if (modelColumnIndex < 4) {
            return true;
        }
        if (this.myColumnFilter == null) {
            return true;
        }
        Locale locale = ((StringResourceTableModel)this.getModel()).getLocale(modelColumnIndex);
        assert (locale != null);
        return this.myColumnFilter.include(locale);
    }

    @Override
    @NotNull
    TableColumn createColumn(int modelColumnIndex) {
        TableColumn column2 = new TableColumn(modelColumnIndex);
        if (modelColumnIndex >= 4) {
            column2.setHeaderRenderer(this.myLocaleRenderer);
        }
        return column2;
    }

    @Override
    public void setModel(@NotNull StringResourceTableModel model) {
        super.setModel(model);
        List keys = Optional.ofNullable(this.getRowSorter()).map(FrozenColumnTableRowSorter::getSortKeys).orElse(Collections.emptyList());
        this.setRowSorter(new FrozenColumnTableRowSorter(new ThreeStateTableRowSorter<StringResourceTableModel>(model), this, keys));
        if (this.myColumnPreferredWidthsSet) {
            return;
        }
        IntStream.range(0, this.getColumnCount()).forEach(viewColumnIndex -> this.getColumn(viewColumnIndex).setPreferredWidth(this.getPreferredColumnWidth(viewColumnIndex)));
        this.myColumnPreferredWidthsSet = true;
    }

    private int getPreferredColumnWidth(int viewColumnIndex) {
        int minColumnWidth;
        OptionalInt optionalMaxCellWidth;
        int headerWidth = this.getPreferredHeaderWidth(viewColumnIndex);
        int columnWidth = Math.max(headerWidth, (optionalMaxCellWidth = IntStream.range(0, this.getRowCount()).map(viewRowIndex -> this.getPreferredCellWidth(viewRowIndex, viewColumnIndex)).max()).orElse(minColumnWidth = JBUI.scale((int)20)));
        if (columnWidth < minColumnWidth) {
            return minColumnWidth;
        }
        int maxColumnWidth = JBUI.scale((int)200);
        return Math.min(columnWidth, maxColumnWidth);
    }

    private int getPreferredHeaderWidth(int viewColumnIndex) {
        TableCellRenderer renderer2 = this.getColumn(viewColumnIndex).getHeaderRenderer();
        if (renderer2 == null) {
            renderer2 = this.getDefaultTableHeaderRenderer();
        }
        return this.getPreferredWidth(renderer2, this.getColumnName(viewColumnIndex), -1, viewColumnIndex);
    }

    private int getPreferredCellWidth(int viewRowIndex, int viewColumnIndex) {
        TableCellRenderer renderer2 = this.getCellRenderer(viewRowIndex, viewColumnIndex);
        return this.getPreferredWidth(renderer2, this.getValueAt(viewRowIndex, viewColumnIndex), viewRowIndex, viewColumnIndex);
    }

    @Override
    boolean isPastePossible() {
        return this.hasSelectedCell() && StringResourceTable.isColumnValidPasteTarget(this.getSelectedColumn());
    }

    private static boolean isColumnValidPasteTarget(int column2) {
        return column2 != 0 && column2 != 2;
    }

    static class ThreeStateTableRowSorter<M extends TableModel>
    extends TableRowSorter<M> {
        private ThreeStateTableRowSorter(M model) {
            super(model);
        }

        @Override
        public void toggleSortOrder(int column2) {
            List<RowSorter.SortKey> sortKeys = this.getSortKeys();
            if (!sortKeys.isEmpty() && sortKeys.get(0).getSortOrder() == SortOrder.DESCENDING) {
                this.setSortKeys(null);
                return;
            }
            super.toggleSortOrder(column2);
        }

        @Override
        public void modelStructureChanged() {
            List<RowSorter.SortKey> sortKeys = this.getSortKeys();
            super.modelStructureChanged();
            this.setSortKeys(sortKeys);
        }
    }
}

