/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.utils.text.TextUtilsKt;
import com.google.common.collect.ImmutableSet;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ColorUtils {
    private static final double THRESHOLD = 4.5;
    private static final String DISABLED_PREFIX = "Disabled";

    @NotNull
    public static String getContrastWarningMessage(@NotNull Map<String, Color> contrastColorsWithDescription, @NotNull Color color, boolean isBackground) {
        ImmutableSet.Builder lowContrastColorsBuilder = ImmutableSet.builder();
        for (Map.Entry<String, Color> contrastColor : contrastColorsWithDescription.entrySet()) {
            String colorDescription = contrastColor.getKey();
            if (colorDescription.startsWith(DISABLED_PREFIX)) continue;
            Color otherColor = contrastColor.getValue();
            if (isBackground) {
                backgroundColor = ColorUtils.worstContrastColor(otherColor, color);
                color = ColorUtil.alphaBlending((Color)color, (Color)backgroundColor);
                otherColor = ColorUtil.alphaBlending((Color)otherColor, (Color)color);
            } else {
                backgroundColor = ColorUtils.worstContrastColor(color, otherColor);
                otherColor = ColorUtil.alphaBlending((Color)otherColor, (Color)backgroundColor);
                color = ColorUtil.alphaBlending((Color)color, (Color)otherColor);
            }
            if (!(ColorUtils.calculateContrastRatio(color, otherColor) < 4.5)) continue;
            lowContrastColorsBuilder.add((Object)colorDescription);
        }
        ImmutableSet lowContrastColors = lowContrastColorsBuilder.build();
        if (lowContrastColors.isEmpty()) {
            return "";
        }
        return "<html>Not enough contrast with " + TextUtilsKt.toCommaSeparatedList((Collection)lowContrastColors, (String)"and");
    }

    @NotNull
    public static Color worstContrastColor(@NotNull Color foreground, @NotNull Color background) {
        int backgroundAlpha = background.getAlpha();
        int r = ColorUtils.worstContrastComponent(foreground.getRed(), background.getRed(), backgroundAlpha);
        int g = ColorUtils.worstContrastComponent(foreground.getGreen(), background.getGreen(), backgroundAlpha);
        int b = ColorUtils.worstContrastComponent(foreground.getBlue(), background.getBlue(), backgroundAlpha);
        return new Color(r, g, b);
    }

    private static int worstContrastComponent(int foregroundComponent, int backgroundComponent, int backgroundAlpha) {
        if (backgroundAlpha == 255) {
            return 0;
        }
        int component = (255 * foregroundComponent - backgroundAlpha * backgroundComponent) / (255 - backgroundAlpha);
        return IdeResourcesUtil.clamp(component, 0, 255);
    }

    public static double calculateContrastRatio(@NotNull Color color1, @NotNull Color color2) {
        double color1Luminance = ColorUtils.calculateColorLuminance(color1);
        double color2Luminance = ColorUtils.calculateColorLuminance(color2);
        return (Math.max(color1Luminance, color2Luminance) + 0.05) / (Math.min(color2Luminance, color1Luminance) + 0.05);
    }

    private static double calculateColorLuminance(@NotNull Color color) {
        return ColorUtils.calculateLuminanceContribution((double)color.getRed() / 255.0) * 0.2126 + ColorUtils.calculateLuminanceContribution((double)color.getGreen() / 255.0) * 0.7152 + ColorUtils.calculateLuminanceContribution((double)color.getBlue() / 255.0) * 0.0722;
    }

    private static double calculateLuminanceContribution(double colorValue) {
        if (colorValue <= 0.03928) {
            return colorValue / 12.92;
        }
        return Math.pow((colorValue + 0.055) / 1.055, 2.4);
    }
}

