/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.SdkConstants;
import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.RClassNaming;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.configurations.Configuration;
import com.android.tools.dom.attrs.AttributeDefinition;
import com.android.tools.dom.attrs.AttributeDefinitions;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.res.LocalResourceRepository;
import com.android.tools.sdk.AndroidTargetData;
import com.android.xml.AttrNameSplitter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolutionUtils {
    private static final Logger LOG = Logger.getInstance(ResolutionUtils.class);

    private ResolutionUtils() {
    }

    @Deprecated
    @NotNull
    public static ResourceReference getStyleReference(@NotNull String themeName) {
        if (themeName.startsWith("android:")) {
            return ResourceReference.style((ResourceNamespace)ResourceNamespace.ANDROID, (String)themeName.substring("android:".length()));
        }
        assert (themeName.indexOf(58) < 0);
        return ResourceReference.style((ResourceNamespace)ResourceNamespace.TODO(), (String)themeName);
    }

    @NotNull
    public static String getQualifiedNameFromResourceUrl(@NotNull String styleResourceUrl) {
        ResourceUrl url = ResourceUrl.parse((String)styleResourceUrl);
        assert (url != null) : styleResourceUrl;
        return url.namespace != null ? url.namespace + ":" + url.name : url.name;
    }

    @NotNull
    public static String getQualifiedStyleName(@NotNull StyleResourceValue style) {
        String name2 = style.getName();
        return style.isFramework() ? "android:" + name2 : name2;
    }

    @NotNull
    public static String getQualifiedItemAttrName(@NotNull StyleItemResourceValue item) {
        ResourceReference attr = item.getAttr();
        return attr != null ? attr.getRelativeResourceUrl(ResourceNamespace.TODO()).getQualifiedName() : item.getAttrName();
    }

    @Nullable
    public static ConfiguredThemeEditorStyle getThemeEditorStyle(@NotNull Configuration configuration2, @NotNull ResourceReference styleReference) {
        ResourceResolver resolver = configuration2.getResourceResolver();
        StyleResourceValue style = resolver.getStyle(styleReference);
        return style == null ? null : new ConfiguredThemeEditorStyle(configuration2, style);
    }

    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull Module module, @NotNull ResourceReference attr) {
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        assert (facet != null) : String.format("Module %s is not an Android module", module.getName());
        AttributeDefinitions definitions = ModuleResourceManagers.getInstance(facet).getLocalResourceManager().getAttributeDefinitions();
        return definitions.getAttrDefinition(attr);
    }

    @Deprecated
    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull Module module, @Nullable Configuration configuration2, @NotNull String name2) {
        AttributeDefinitions definitions;
        if (name2.startsWith("android:")) {
            IAndroidTarget target2;
            if (configuration2 == null) {
                AndroidFacet facet = AndroidFacet.getInstance((Module)module);
                assert (facet != null);
                target2 = ConfigurationManager.getOrCreateInstance(module).getDefaultTarget();
            } else {
                target2 = configuration2.getRealTarget();
            }
            assert (target2 != null);
            AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target2, AndroidPlatforms.getInstance(module));
            assert (androidTargetData != null);
            definitions = androidTargetData.getAllAttrDefs();
        } else {
            AndroidFacet facet = AndroidFacet.getInstance((Module)module);
            assert (facet != null) : String.format("Module %s is not an Android module", module.getName());
            definitions = ModuleResourceManagers.getInstance(facet).getLocalResourceManager().getAttributeDefinitions();
        }
        return definitions.getAttrDefByName(AttrNameSplitter.findLocalName((String)name2));
    }

    public static int getOriginalApiLevel(@Nullable String name2, @NotNull Project project) {
        if (name2 == null) {
            return -1;
        }
        ApiLookup apiLookup = LintIdeClient.getApiLookup((Project)project);
        if (apiLookup == null) {
            LOG.warn("Could not find Lint client for project " + project.getName());
            return -1;
        }
        ResourceUrl resUrl = ResourceUrl.parse((String)name2);
        if (resUrl == null) {
            if (!name2.startsWith("android:")) {
                return -1;
            }
            return apiLookup.getFieldVersions("android/R$attr", name2.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN)).min();
        }
        if (!resUrl.isFramework()) {
            return -1;
        }
        return apiLookup.getFieldVersions("android/R$" + resUrl.type, RClassNaming.getFieldNameByResourceName((String)resUrl.name)).min();
    }

    @Nullable
    public static String getParentQualifiedName(@NotNull StyleResourceValue style) {
        ResourceReference parent = style.getParentStyle();
        if (parent == null) {
            return null;
        }
        return parent.getRelativeResourceUrl(ResourceNamespace.TODO()).getQualifiedName();
    }

    @NotNull
    public static Collection<StyleItemResourceValue> getThemeAttributes(@NotNull ResourceResolver resolver, @NotNull String themeUrl) {
        StyleResourceValue theme;
        HashMap<String, StyleItemResourceValue> allItems = new HashMap<String, StyleItemResourceValue>();
        String themeName = ResolutionUtils.getQualifiedNameFromResourceUrl(themeUrl);
        while ((theme = resolver.getStyle(AttrNameSplitter.findLocalName((String)themeName), themeName.startsWith("android:"))) != null) {
            Collection themeItems = theme.getDefinedItems();
            for (StyleItemResourceValue item : themeItems) {
                String itemName = ResolutionUtils.getQualifiedItemAttrName(item);
                if (allItems.containsKey(itemName)) continue;
                allItems.put(itemName, item);
            }
            themeName = ResolutionUtils.getParentQualifiedName(theme);
            if (themeName != null) continue;
        }
        return allItems.values();
    }

    @Nullable
    public static ResourceType getAttrType(@NotNull StyleItemResourceValue item, @NotNull Configuration configuration2) {
        ResourceResolver resolver = configuration2.getResourceResolver();
        return ResolutionUtils.getAttrType(item, resolver);
    }

    @Nullable
    public static ResourceType getAttrType(@NotNull StyleItemResourceValue item, @NotNull ResourceResolver resolver) {
        ResourceValue resolvedValue = resolver.resolveResValue((ResourceValue)item);
        return resolvedValue == null ? null : resolvedValue.getResourceType();
    }

    @Slow
    @NotNull
    public static FolderConfiguration getFolderConfiguration(@NotNull AndroidFacet facet, @NotNull ResourceValue resolvedValue, @NotNull FolderConfiguration configuration2) {
        List configurables;
        if (resolvedValue.isFramework()) {
            ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(facet.getModule());
            IAndroidTarget target2 = configurationManager.getDefaultTarget();
            assert (target2 != null);
            ResourceRepository resourceRepository = configurationManager.getResolverCache().getFrameworkResources(configuration2, target2, Collections.emptyList());
            assert (resourceRepository != null);
            configurables = resourceRepository.getResources(ResourceNamespace.ANDROID, resolvedValue.getResourceType(), resolvedValue.getName());
        } else {
            LocalResourceRepository<VirtualFile> localResourceRepository = StudioResourceRepositoryManager.getAppResources(facet);
            configurables = localResourceRepository.getResources(ResourceNamespace.TODO(), resolvedValue.getResourceType(), resolvedValue.getName());
        }
        Configurable configurable = configuration2.findMatchingConfigurable((Collection)configurables);
        assert (configurable != null);
        return configurable.getConfiguration();
    }
}

