/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.debug.utils;

import com.android.tools.idea.execution.common.debug.utils.FacetFinderToken;
import com.android.tools.idea.execution.common.debug.utils.ProcessNameReader;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.CommonTestType;
import com.android.tools.idea.projectsystem.GradleToken;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.SourceProvidersKt;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J \u0010\u0010\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/execution/common/debug/utils/FacetFinderGradleToken;", "Lcom/android/tools/idea/execution/common/debug/utils/FacetFinderToken;", "Lcom/android/tools/idea/projectsystem/gradle/GradleProjectSystem;", "Lcom/android/tools/idea/projectsystem/GradleToken;", "<init>", "()V", "findGlobalProcessDefinition", "Lcom/intellij/openapi/module/Module;", "projectSystem", "project", "Lcom/intellij/openapi/project/Project;", "processName", "", "isDirectlyDeployable", "", "module", "hasTestNature", "intellij.android.projectSystem.gradle"})
public final class FacetFinderGradleToken
implements FacetFinderToken<GradleProjectSystem>,
GradleToken {
    @Override
    @Nullable
    public Module findGlobalProcessDefinition(@NotNull GradleProjectSystem projectSystem, @NotNull Project project, @NotNull String processName) {
        Intrinsics.checkNotNullParameter((Object)projectSystem, (String)"projectSystem");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        for (AndroidFacet facet : ProjectSystemUtil.getAndroidFacets(project)) {
            List<String> globalProcessNames;
            for (NamedIdeaSourceProvider sourceProvider : SourceProvidersKt.getSourceProviders(facet).getCurrentSourceProviders()) {
                for (VirtualFile manifestFile : sourceProvider.getManifestFiles()) {
                    globalProcessNames = ProcessNameReader.INSTANCE.readGlobalProcessNames(project, manifestFile);
                    if (!globalProcessNames.contains(processName)) continue;
                    Module module = facet.getModule();
                    Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
                    return LinkedAndroidModuleGroupUtilsKt.getMainModule(module);
                }
            }
            List list = SourceProvidersKt.getSourceProviders(facet).getCurrentDeviceTestSourceProviders().get(CommonTestType.ANDROID_TEST);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            for (NamedIdeaSourceProvider sourceProvider : list) {
                for (VirtualFile manifestFile : sourceProvider.getManifestFiles()) {
                    globalProcessNames = ProcessNameReader.INSTANCE.readGlobalProcessNames(project, manifestFile);
                    if (!globalProcessNames.contains(processName)) continue;
                    Module module = facet.getModule();
                    Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
                    return LinkedAndroidModuleGroupUtilsKt.getAndroidTestModule(module);
                }
            }
        }
        return null;
    }

    @Override
    public boolean isDirectlyDeployable(@NotNull GradleProjectSystem projectSystem, @NotNull Project project, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)projectSystem, (String)"projectSystem");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return LinkedAndroidModuleGroupUtilsKt.isAndroidTestModule(module) || ProjectSystemUtil.getModuleSystem(module).getType() != AndroidModuleSystem.Type.TYPE_LIBRARY;
    }

    @Override
    public boolean hasTestNature(@NotNull GradleProjectSystem projectSystem, @NotNull Project project, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)projectSystem, (String)"projectSystem");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return LinkedAndroidModuleGroupUtilsKt.isAndroidTestModule(module) || ProjectSystemUtil.getModuleSystem(module).getType() == AndroidModuleSystem.Type.TYPE_TEST;
    }

    @Override
    public boolean isApplicable(@NotNull AndroidProjectSystem projectSystem) {
        return GradleToken.super.isApplicable(projectSystem);
    }
}

