/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.processhandler;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.execution.common.processhandler.AndroidProcessMonitorManager;
import com.android.tools.idea.execution.common.processhandler.AndroidProcessMonitorManagerListener;
import com.android.tools.idea.execution.common.processhandler.TextEmitter;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.OutputStream;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 42\u00020\u0001:\u00014B\u0083\u0001\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012<\b\u0002\u0010\u000e\u001a6\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u000fj\u0002`\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001c\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00032\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0016J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0006H\u0007J\u0010\u0010%\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u0006H\u0007J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0006H\u0007J\u0010\u0010'\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u0006H\u0007J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010$\u001a\u00020\u0006H\u0007J\b\u0010*\u001a\u00020\u0007H\u0015J\b\u0010+\u001a\u00020\u0007H\u0015J\b\u0010,\u001a\u00020\tH\u0017J\n\u0010-\u001a\u0004\u0018\u00010.H\u0017J\b\u0010/\u001a\u00020\u0007H\u0007J\u0010\u00100\u001a\u00020\t2\u0006\u00101\u001a\u000202H\u0003J\b\u00103\u001a\u00020\u0003H\u0016R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessHandler;", "Lcom/intellij/execution/process/ProcessHandler;", "targetApplicationId", "", "finishAndroidProcessCallback", "Lkotlin/Function1;", "Lcom/android/ddmlib/IDevice;", "", "autoTerminate", "", "ansiEscapeDecoder", "Lcom/intellij/execution/process/AnsiEscapeDecoder;", "deploymentApplicationService", "Lcom/android/tools/idea/run/DeploymentApplicationService;", "androidProcessMonitorManagerFactory", "Lkotlin/Function2;", "Lcom/android/tools/idea/execution/common/processhandler/TextEmitter;", "Lkotlin/ParameterName;", "name", "textEmitter", "Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManagerListener;", "listener", "Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManager;", "Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManagerFactory;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;ZLcom/intellij/execution/process/AnsiEscapeDecoder;Lcom/android/tools/idea/run/DeploymentApplicationService;Lkotlin/jvm/functions/Function2;)V", "getTargetApplicationId", "()Ljava/lang/String;", "getAutoTerminate", "()Z", "myMonitorManager", "notifyTextAvailable", "text", "outputType", "Lcom/intellij/openapi/util/Key;", "addTargetDevice", "device", "killClientAndRestartMonitor", "detachDevice", "isAssociated", "getClient", "Lcom/android/ddmlib/Client;", "destroyProcessImpl", "detachProcessImpl", "detachIsDefault", "getProcessInput", "Ljava/io/OutputStream;", "killProcess", "areAnyDevicesAssociated", "executionTarget", "Lcom/android/tools/idea/execution/common/AndroidExecutionTarget;", "toString", "Companion", "intellij.android.execution.common"})
@SourceDebugExtension(value={"SMAP\nAndroidProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidProcessHandler.kt\ncom/android/tools/idea/execution/common/processhandler/AndroidProcessHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1755#2,3:211\n*S KotlinDebug\n*F\n+ 1 AndroidProcessHandler.kt\ncom/android/tools/idea/execution/common/processhandler/AndroidProcessHandler\n*L\n201#1:211,3\n*E\n"})
public final class AndroidProcessHandler
extends ProcessHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @VisibleForTesting
    @NotNull
    private final String targetApplicationId;
    private final boolean autoTerminate;
    @NotNull
    private final AnsiEscapeDecoder ansiEscapeDecoder;
    @NotNull
    private final DeploymentApplicationService deploymentApplicationService;
    @NotNull
    private final AndroidProcessMonitorManager myMonitorManager;
    @NotNull
    private static Logger LOG;

    @JvmOverloads
    public AndroidProcessHandler(@NotNull String targetApplicationId, @NotNull Function1<? super IDevice, Unit> finishAndroidProcessCallback, boolean autoTerminate, @NotNull AnsiEscapeDecoder ansiEscapeDecoder, @NotNull DeploymentApplicationService deploymentApplicationService, @NotNull Function2<? super TextEmitter, ? super AndroidProcessMonitorManagerListener, AndroidProcessMonitorManager> androidProcessMonitorManagerFactory) {
        Intrinsics.checkNotNullParameter((Object)targetApplicationId, (String)"targetApplicationId");
        Intrinsics.checkNotNullParameter(finishAndroidProcessCallback, (String)"finishAndroidProcessCallback");
        Intrinsics.checkNotNullParameter((Object)ansiEscapeDecoder, (String)"ansiEscapeDecoder");
        Intrinsics.checkNotNullParameter((Object)deploymentApplicationService, (String)"deploymentApplicationService");
        Intrinsics.checkNotNullParameter(androidProcessMonitorManagerFactory, (String)"androidProcessMonitorManagerFactory");
        this.targetApplicationId = targetApplicationId;
        this.autoTerminate = autoTerminate;
        this.ansiEscapeDecoder = ansiEscapeDecoder;
        this.deploymentApplicationService = deploymentApplicationService;
        this.myMonitorManager = (AndroidProcessMonitorManager)androidProcessMonitorManagerFactory.invoke((Object)new TextEmitter(this){
            final /* synthetic */ AndroidProcessHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public void emit(String message, Key<?> key) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter(key, (String)"key");
                this.this$0.notifyTextAvailable(message, key);
            }
        }, (Object)new AndroidProcessMonitorManagerListener(this){
            final /* synthetic */ AndroidProcessHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAllTargetProcessesTerminated() {
                if (this.this$0.getAutoTerminate()) {
                    AndroidProcessHandler.access$notifyProcessTerminated(this.this$0, 0);
                }
            }
        });
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                myMonitorManager.start();
            }
        });
    }

    public /* synthetic */ AndroidProcessHandler(String string, Function1 function1, boolean bl, AnsiEscapeDecoder ansiEscapeDecoder, DeploymentApplicationService deploymentApplicationService, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = arg_0 -> AndroidProcessHandler._init_$lambda$0(string, arg_0);
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            ansiEscapeDecoder = new AnsiEscapeDecoder();
        }
        if ((n & 0x10) != 0) {
            deploymentApplicationService = DeploymentApplicationService.Companion.getInstance();
        }
        if ((n & 0x20) != 0) {
            function2 = (arg_0, arg_1) -> AndroidProcessHandler._init_$lambda$1(string, deploymentApplicationService, function1, arg_0, arg_1);
        }
        this(string, (Function1<? super IDevice, Unit>)function1, bl, ansiEscapeDecoder, deploymentApplicationService, (Function2<? super TextEmitter, ? super AndroidProcessMonitorManagerListener, AndroidProcessMonitorManager>)function2);
    }

    @NotNull
    public final String getTargetApplicationId() {
        return this.targetApplicationId;
    }

    public final boolean getAutoTerminate() {
        return this.autoTerminate;
    }

    public void notifyTextAvailable(@NotNull String text2, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        this.ansiEscapeDecoder.escapeText(text2, outputType, (arg_0, arg_1) -> AndroidProcessHandler.notifyTextAvailable$lambda$2(this, arg_0, arg_1));
    }

    @AnyThread
    public final void addTargetDevice(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.myMonitorManager.add(device2);
        LOG.info("Adding device " + device2.getName() + " to monitor for launched app: " + this.targetApplicationId);
    }

    @WorkerThread
    public final boolean killClientAndRestartMonitor(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        return this.myMonitorManager.closeAndReplace(device2) != null;
    }

    @WorkerThread
    public final void detachDevice(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.myMonitorManager.detachDevice(device2);
        if (this.myMonitorManager.isEmpty()) {
            this.detachProcess();
        }
    }

    @AnyThread
    public final boolean isAssociated(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        return this.myMonitorManager.isAssociated(device2);
    }

    @WorkerThread
    @Nullable
    public final Client getClient(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        return this.isAssociated(device2) ? (Client)CollectionsKt.firstOrNull(this.deploymentApplicationService.findClient(device2, this.targetApplicationId)) : null;
    }

    @AnyThread
    protected void destroyProcessImpl() {
        AppExecutorUtil.getAppExecutorService().submit(() -> AndroidProcessHandler.destroyProcessImpl$lambda$3(this));
    }

    @AnyThread
    protected void detachProcessImpl() {
        AppExecutorUtil.getAppExecutorService().submit(() -> AndroidProcessHandler.detachProcessImpl$lambda$4(this));
    }

    @AnyThread
    public boolean detachIsDefault() {
        return false;
    }

    @AnyThread
    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    @AnyThread
    public final void killProcess() {
        this.destroyProcess();
    }

    @AnyThread
    private final boolean areAnyDevicesAssociated(AndroidExecutionTarget executionTarget) {
        boolean bl;
        block3: {
            Collection<IDevice> collection2 = executionTarget.getRunningDevices();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"getRunningDevices(...)");
            Iterable $this$any$iv = collection2;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IDevice it = (IDevice)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!this.isAssociated(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public String toString() {
        return "AndroidProcessHandler[" + this.targetApplicationId + "]";
    }

    @JvmOverloads
    public AndroidProcessHandler(@NotNull String targetApplicationId, @NotNull Function1<? super IDevice, Unit> finishAndroidProcessCallback, boolean autoTerminate, @NotNull AnsiEscapeDecoder ansiEscapeDecoder, @NotNull DeploymentApplicationService deploymentApplicationService) {
        Intrinsics.checkNotNullParameter((Object)targetApplicationId, (String)"targetApplicationId");
        Intrinsics.checkNotNullParameter(finishAndroidProcessCallback, (String)"finishAndroidProcessCallback");
        Intrinsics.checkNotNullParameter((Object)ansiEscapeDecoder, (String)"ansiEscapeDecoder");
        Intrinsics.checkNotNullParameter((Object)deploymentApplicationService, (String)"deploymentApplicationService");
        this(targetApplicationId, finishAndroidProcessCallback, autoTerminate, ansiEscapeDecoder, deploymentApplicationService, null, 32, null);
    }

    @JvmOverloads
    public AndroidProcessHandler(@NotNull String targetApplicationId, @NotNull Function1<? super IDevice, Unit> finishAndroidProcessCallback, boolean autoTerminate, @NotNull AnsiEscapeDecoder ansiEscapeDecoder) {
        Intrinsics.checkNotNullParameter((Object)targetApplicationId, (String)"targetApplicationId");
        Intrinsics.checkNotNullParameter(finishAndroidProcessCallback, (String)"finishAndroidProcessCallback");
        Intrinsics.checkNotNullParameter((Object)ansiEscapeDecoder, (String)"ansiEscapeDecoder");
        this(targetApplicationId, finishAndroidProcessCallback, autoTerminate, ansiEscapeDecoder, null, null, 48, null);
    }

    @JvmOverloads
    public AndroidProcessHandler(@NotNull String targetApplicationId, @NotNull Function1<? super IDevice, Unit> finishAndroidProcessCallback, boolean autoTerminate) {
        Intrinsics.checkNotNullParameter((Object)targetApplicationId, (String)"targetApplicationId");
        Intrinsics.checkNotNullParameter(finishAndroidProcessCallback, (String)"finishAndroidProcessCallback");
        this(targetApplicationId, finishAndroidProcessCallback, autoTerminate, null, null, null, 56, null);
    }

    @JvmOverloads
    public AndroidProcessHandler(@NotNull String targetApplicationId, @NotNull Function1<? super IDevice, Unit> finishAndroidProcessCallback) {
        Intrinsics.checkNotNullParameter((Object)targetApplicationId, (String)"targetApplicationId");
        Intrinsics.checkNotNullParameter(finishAndroidProcessCallback, (String)"finishAndroidProcessCallback");
        this(targetApplicationId, finishAndroidProcessCallback, false, null, null, null, 60, null);
    }

    @JvmOverloads
    public AndroidProcessHandler(@NotNull String targetApplicationId) {
        Intrinsics.checkNotNullParameter((Object)targetApplicationId, (String)"targetApplicationId");
        this(targetApplicationId, null, false, null, null, null, 62, null);
    }

    private static final Unit _init_$lambda$0(String $targetApplicationId, IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        device2.forceStop($targetApplicationId);
        return Unit.INSTANCE;
    }

    private static final AndroidProcessMonitorManager _init_$lambda$1(String $targetApplicationId, DeploymentApplicationService $deploymentApplicationService, Function1 $finishAndroidProcessCallback, TextEmitter textEmitter, AndroidProcessMonitorManagerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)textEmitter, (String)"textEmitter");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return new AndroidProcessMonitorManager($targetApplicationId, $deploymentApplicationService, textEmitter, listener2, $finishAndroidProcessCallback, null, 32, null);
    }

    private static final void notifyTextAvailable$lambda$2(AndroidProcessHandler this$0, String processedText, Key attributes) {
        Intrinsics.checkNotNullParameter((Object)processedText, (String)"processedText");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        super.notifyTextAvailable(processedText, attributes);
    }

    private static final void destroyProcessImpl$lambda$3(AndroidProcessHandler this$0) {
        this$0.myMonitorManager.close();
        this$0.notifyProcessTerminated(0);
        ActivityTracker.getInstance().inc();
    }

    private static final void detachProcessImpl$lambda$4(AndroidProcessHandler this$0) {
        this$0.myMonitorManager.detachAndClose();
        this$0.notifyProcessDetached();
        ActivityTracker.getInstance().inc();
    }

    public static final /* synthetic */ void access$notifyProcessTerminated(AndroidProcessHandler $this, int p0) {
        $this.notifyProcessTerminated(p0);
    }

    static {
        Logger logger = Logger.getInstance(AndroidProcessHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessHandler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.execution.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

