/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.BuildsToPathsMapper;
import com.android.tools.idea.gradle.actions.GoToApkLocationTask;
import com.android.tools.idea.gradle.project.build.invoker.AssembleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvokerKt;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildResult;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.ActionCenter;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoToBundleLocationTask {
    public static final String ANALYZE_URL_PREFIX = "analyze:";
    public static final String LOCATE_URL_PREFIX = "module:";
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myNotificationTitle;
    @NotNull
    private final Collection<Module> myModules;
    @NotNull
    private final List<String> myBuildVariants;

    public GoToBundleLocationTask(@NotNull Project project, @NotNull Collection<Module> modules, @NotNull String notificationTitle) {
        this(project, modules, notificationTitle, Collections.emptyList());
    }

    public GoToBundleLocationTask(@NotNull Project project, @NotNull Collection<Module> modules, @NotNull String notificationTitle, @NotNull List<String> buildVariants) {
        this.myProject = project;
        this.myNotificationTitle = notificationTitle;
        this.myModules = modules;
        this.myBuildVariants = buildVariants;
    }

    public void executeWhenBuildFinished(@NotNull ListenableFuture<AssembleInvocationResult> resultFuture) {
        GradleBuildInvokerKt.whenFinished(resultFuture, MoreExecutors.directExecutor(), result2 -> {
            BuildsToPathsMapper buildsToPathsMapper = BuildsToPathsMapper.getInstance(this.myProject);
            Map<String, File> bundleBuildsToPath = buildsToPathsMapper.getBuildsToPaths((AssembleInvocationResult)result2, this.myBuildVariants, this.myModules, true);
            this.showNotification((GradleBuildResult)result2, bundleBuildsToPath);
            return null;
        });
    }

    private void showNotification(@NotNull GradleBuildResult result2, @NotNull Map<String, File> buildsAndBundlePaths) {
        AndroidNotification notification = AndroidNotification.getInstance((Project)this.myProject);
        if (result2.isBuildSuccessful()) {
            this.notifySuccess(notification, buildsAndBundlePaths);
        } else if (result2.isBuildCancelled()) {
            notification.showBalloon(this.myNotificationTitle, "Build cancelled.", NotificationType.INFORMATION);
        } else {
            String msg = "Errors while building Bundle file. You can find the errors in the 'Build' view.";
            notification.showBalloon(this.myNotificationTitle, msg, NotificationType.ERROR);
        }
    }

    private void notifySuccess(@NotNull AndroidNotification notification, @NotNull Map<String, File> bundleBuildsToPath) {
        boolean isSigned = !this.myBuildVariants.isEmpty();
        StringBuilder builder = new StringBuilder();
        int count = bundleBuildsToPath.size();
        builder.append("App bundle(s) generated successfully for ");
        if (isSigned) {
            String moduleName = ((Module)Iterators.getOnlyElement(this.myModules.iterator())).getName();
            builder.append("module '").append(moduleName).append("' with ").append(count).append(count == 1 ? " build variant" : " build variants");
        } else {
            builder.append(count).append(count == 1 ? " module" : " modules");
        }
        builder.append(":<br/>");
        if (this.isShowFilePathActionSupported()) {
            Iterator<String> iterator2 = bundleBuildsToPath.keySet().iterator();
            while (iterator2.hasNext()) {
                String moduleOrBuildVariant = iterator2.next();
                if (isSigned) {
                    builder.append("Build variant '");
                } else {
                    builder.append("Module '");
                }
                builder.append(moduleOrBuildVariant).append("': ");
                builder.append("<a href=\"").append(LOCATE_URL_PREFIX).append(moduleOrBuildVariant).append("\">locate</a> or ");
                builder.append("<a href=\"").append(ANALYZE_URL_PREFIX).append(moduleOrBuildVariant).append("\">analyze</a> the app bundle.");
                if (!iterator2.hasNext()) continue;
                builder.append("<br/>");
            }
            String text2 = builder.toString();
            notification.showBalloon(this.myNotificationTitle, text2, NotificationType.INFORMATION, (NotificationListener)new OpenFolderNotificationListener(this.myProject, bundleBuildsToPath));
        } else {
            builder.append(bundleBuildsToPath.entrySet().stream().map(entry -> String.format(" - %s: %s", entry.getKey(), ((File)entry.getValue()).getPath())).collect(Collectors.joining("\n")));
            StringBuilder balloonBuilder = new StringBuilder();
            balloonBuilder.append("App bundle(s) generated successfully for ");
            if (isSigned) {
                String moduleName = ((Module)Iterators.getOnlyElement(this.myModules.iterator())).getName();
                balloonBuilder.append("module '").append(moduleName).append("' with ").append(count).append(count == 1 ? " build variant" : " build variants");
            } else {
                balloonBuilder.append(count).append(count == 1 ? " module" : " modules");
            }
            notification.showBalloon(this.myNotificationTitle, balloonBuilder.toString(), NotificationType.INFORMATION, new NotificationHyperlink[]{new OpenEventLogHyperlink()});
            notification.addLogEvent(this.myNotificationTitle, builder.toString(), NotificationType.INFORMATION);
        }
    }

    @VisibleForTesting
    boolean isShowFilePathActionSupported() {
        return RevealFileAction.isSupported();
    }

    private static Logger getLog() {
        return Logger.getInstance(GoToBundleLocationTask.class);
    }

    @VisibleForTesting
    static class OpenFolderNotificationListener
    extends NotificationListener.Adapter {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Map<String, File> myBundlePathsPerModule;
        @NotNull
        private final GoToApkLocationTask.FileOrDirOpener myLocationOpener;

        OpenFolderNotificationListener(@NotNull Project project, @NotNull Map<String, File> myBuildsAndBundlePaths) {
            this(project, myBuildsAndBundlePaths, new GoToApkLocationTask.FileOrDirOpener());
        }

        @VisibleForTesting
        OpenFolderNotificationListener(@NotNull Project project, @NotNull Map<String, File> myBuildsAndBundlePaths, @NotNull GoToApkLocationTask.FileOrDirOpener locationOpener) {
            this.myProject = project;
            this.myBundlePathsPerModule = myBuildsAndBundlePaths;
            this.myLocationOpener = locationOpener;
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            if (this.myProject.isDisposed()) {
                return;
            }
            String description2 = e.getDescription();
            if (description2.startsWith(GoToBundleLocationTask.ANALYZE_URL_PREFIX)) {
                this.openBundleAnalyzer(description2.substring(GoToBundleLocationTask.ANALYZE_URL_PREFIX.length()));
            } else if (description2.startsWith(GoToBundleLocationTask.LOCATE_URL_PREFIX)) {
                File file = this.myBundlePathsPerModule.get(description2.substring(GoToBundleLocationTask.LOCATE_URL_PREFIX.length()));
                this.myLocationOpener.openLocation(file);
            }
        }

        private void openBundleAnalyzer(@NotNull String bundlePath) {
            VirtualFile virtualFile;
            File bundleFile = this.myBundlePathsPerModule.get(bundlePath);
            if (bundleFile == null) {
                GoToBundleLocationTask.getLog().warn(String.format("Error finding bundle file \"%s\"", bundlePath));
                return;
            }
            VirtualFile virtualFile2 = virtualFile = !bundleFile.isFile() ? this.askUserForBundleFile(bundleFile) : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(bundleFile);
            if (virtualFile == null) {
                GoToBundleLocationTask.getLog().warn(String.format("Bundle file not found in virtual file system \"%s\"", bundlePath));
                return;
            }
            OpenFileDescriptor fd = new OpenFileDescriptor(this.myProject, virtualFile);
            List editors = FileEditorManager.getInstance((Project)this.myProject).openEditor(fd, true);
            if (editors.isEmpty()) {
                GoToBundleLocationTask.getLog().warn(String.format("Could not open editor for bundle file \"%s\"", bundlePath));
            }
        }

        @Nullable
        VirtualFile askUserForBundleFile(@NotNull File bundleFile) {
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileDescriptor().withDescription("Select Bundle file to analyze").withFileFilter(file -> "aab".equalsIgnoreCase(file.getExtension()));
            return FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)this.myProject, (VirtualFile)LocalFileSystem.getInstance().findFileByIoFile(bundleFile));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            OpenFolderNotificationListener listener2 = (OpenFolderNotificationListener)((Object)o);
            return Objects.equals(this.myBundlePathsPerModule, listener2.myBundlePathsPerModule);
        }

        public int hashCode() {
            return Objects.hash(this.myBundlePathsPerModule);
        }
    }

    @VisibleForTesting
    static class OpenEventLogHyperlink
    extends NotificationHyperlink {
        OpenEventLogHyperlink() {
            super("open.event.log", "Show app bundle path(s) in the '" + ActionCenter.getToolwindowName() + "' view");
        }

        protected void execute(@NotNull Project project) {
            ToolWindow tw = ActionCenter.getToolWindow((Project)project);
            if (tw != null) {
                tw.activate(null, false);
            }
        }

        public int hashCode() {
            return Objects.hash(this.getUrl(), this.toHtml());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            OpenEventLogHyperlink other = (OpenEventLogHyperlink)((Object)o);
            return this.getUrl().equals(other.getUrl()) && this.toHtml().equals(other.toHtml());
        }
    }
}

