/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.DefaultTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.FileTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.FakeElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelSemanticsDescription;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyUtil {
    public static final Logger LOG = Logger.getInstance(PropertyUtil.class);
    @NonNls
    public static final String FILE_METHOD_NAME = "file";
    @NonNls
    public static final String FILE_CONSTRUCTOR_NAME = "File";
    @NotNull
    public static final PropertyTransform DEFAULT_TRANSFORM = new DefaultTransform();
    @NotNull
    public static final PropertyTransform FILE_TRANSFORM = new FileTransform();

    @NotNull
    public static GradleDslSimpleExpression createOrReplaceBasicExpression(@NotNull GradleDslElement parent, @Nullable GradleDslElement oldElement, @NotNull Object value2, @NotNull GradleNameElement name2, @Nullable ModelPropertyDescription propertyDescription) {
        ModelEffectDescription effect = null;
        if (oldElement instanceof GradleDslLiteral) {
            GradleDslSimpleExpression expression = (GradleDslSimpleExpression)oldElement;
            expression.setValue(value2);
            return expression;
        }
        if (oldElement != null) {
            name2 = oldElement.getNameElement();
            effect = oldElement.getModelEffect();
        } else if (propertyDescription != null) {
            effect = new ModelEffectDescription(propertyDescription, ModelSemanticsDescription.CREATE_WITH_VALUE);
        }
        GradleDslSimpleExpression expression = PropertyUtil.createBasicExpression(parent, value2, name2);
        expression.setModelEffect(effect);
        return expression;
    }

    @NotNull
    public static GradleDslSimpleExpression createBasicExpression(@NotNull GradleDslElement parent, @NotNull Object value2, @NotNull GradleNameElement name2) {
        GradleDslLiteral newElement = new GradleDslLiteral(parent, name2);
        ((GradleDslSimpleExpression)newElement).setValue(value2);
        return newElement;
    }

    public static void replaceElement(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        if (holder instanceof GradlePropertiesDslElement) {
            if (oldElement != null) {
                ((GradlePropertiesDslElement)holder).replaceElement(oldElement, newElement);
            } else {
                ((GradlePropertiesDslElement)holder).setNewElement(newElement);
            }
        } else if (holder instanceof GradleDslMethodCall) {
            if (!(newElement instanceof GradleDslExpression)) {
                LOG.warn((Throwable)new IllegalArgumentException("not an expression (new): " + newElement));
                return;
            }
            GradleDslMethodCall methodCall = (GradleDslMethodCall)holder;
            if (oldElement != null) {
                if (!(oldElement instanceof GradleDslExpression)) {
                    LOG.warn((Throwable)new IllegalArgumentException("not an expression (old): " + oldElement));
                    return;
                }
                methodCall.replaceArgument((GradleDslExpression)oldElement, (GradleDslExpression)newElement);
            } else {
                methodCall.addNewArgument((GradleDslExpression)newElement);
            }
        } else {
            LOG.warn((Throwable)new IllegalStateException("Property holder has unknown type, " + holder));
        }
    }

    public static void removeElement(@NotNull GradleDslElement element) {
        GradleDslElement holder = element.getParent();
        if (holder == null) {
            return;
        }
        if (holder instanceof GradlePropertiesDslElement) {
            ((GradlePropertiesDslElement)holder).removeProperty(element);
        } else if (holder instanceof GradleDslMethodCall) {
            GradleDslMethodCall methodCall = (GradleDslMethodCall)holder;
            if (element == methodCall.getArgumentsElement()) {
                PropertyUtil.removeElement(methodCall);
            }
            methodCall.remove(element);
        } else {
            LOG.warn((Throwable)new IllegalStateException("Property holder has unknown type, " + holder));
        }
    }

    @NotNull
    public static GradlePropertyModelImpl resolveModel(@NotNull GradlePropertyModelImpl model) {
        HashSet<String> seenModels = new HashSet<String>();
        while (model.getValueType() == GradlePropertyModel.ValueType.REFERENCE && !seenModels.contains(model.getFullyQualifiedName())) {
            if (model.getDependencies().isEmpty()) {
                return model;
            }
            seenModels.add(model.getFullyQualifiedName());
            model = model.dependencies().get(0);
        }
        return model;
    }

    @NotNull
    public static GradleDslSimpleExpression resolveElement(@NotNull GradleDslSimpleExpression expression) {
        while (expression instanceof GradleDslLiteral && expression.isReference() && !expression.hasCycle()) {
            GradleReferenceInjection injection = ((GradleDslLiteral)expression).getReferenceInjection();
            if (injection == null) {
                return expression;
            }
            GradleDslSimpleExpression next = injection.getToBeInjectedExpression();
            if (next == null) {
                return expression;
            }
            expression = next;
        }
        return expression;
    }

    @Nullable
    public static GradleDslElement followElement(@NotNull GradleDslElement expression) {
        GradleDslElement element = expression;
        HashSet<GradleDslElement> seen = new HashSet<GradleDslElement>();
        while (element instanceof GradleDslLiteral && ((GradleDslLiteral)element).isReference() && !((GradleDslLiteral)element).hasCycle()) {
            seen.add(element);
            GradleReferenceInjection injection = ((GradleDslLiteral)element).getReferenceInjection();
            if (injection == null) {
                return null;
            }
            GradleDslElement next = injection.getToBeInjected();
            if (next == null || seen.contains(next)) {
                return null;
            }
            element = next;
        }
        return element;
    }

    @Nullable
    public static String getFileValue(@NotNull GradleDslMethodCall methodCall) {
        if (!(methodCall.getMethodName().equals(FILE_METHOD_NAME) && !methodCall.isConstructor() || methodCall.getMethodName().equals(FILE_CONSTRUCTOR_NAME) && methodCall.isConstructor())) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (GradleDslExpression expression : methodCall.getArguments()) {
            String value2;
            if (!(expression instanceof GradleDslSimpleExpression) || (value2 = ((GradleDslSimpleExpression)expression).getValue(String.class)) == null) continue;
            if (builder.length() != 0) {
                builder.append("/");
            }
            builder.append(value2);
        }
        String result2 = builder.toString();
        return result2.isEmpty() ? null : result2;
    }

    public static boolean isNonExpressionPropertiesElement(@Nullable GradleDslElement e) {
        return e instanceof GradlePropertiesDslElement && !(e instanceof GradleDslExpression);
    }

    public static boolean isPropertiesElementOrMap(@Nullable GradleDslElement e) {
        return e instanceof GradlePropertiesDslElement && !(e instanceof GradleDslExpressionList);
    }

    public static boolean isElementModified(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        return PropertyUtil.checkForModifiedValue(oldElement, newElement) || PropertyUtil.checkForModifiedName(oldElement, newElement);
    }

    static boolean isModelElementModified(@NotNull GradleDslElement oldRawElement, @NotNull GradleDslElement newRawElement, @NotNull GradleDslElement oldTransformedElement, @NotNull GradleDslElement newTransformedElement) {
        return PropertyUtil.checkForModifiedValue(oldTransformedElement, newTransformedElement) || PropertyUtil.checkForModifiedName(oldRawElement, newRawElement);
    }

    @Nullable
    public static GradleDslElement findOriginalElement(@NotNull GradleDslElement parent, @NotNull GradleDslElement element) {
        GradleDslElement parentHolder;
        GradleDslElement gradleDslElement = parentHolder = parent instanceof GradleDslMethodCall ? ((GradleDslMethodCall)parent).getArgumentsElement() : parent;
        if (parentHolder instanceof GradlePropertiesDslElement) {
            GradlePropertiesDslElement holder = (GradlePropertiesDslElement)parentHolder;
            if (holder instanceof GradleDslExpressionList || holder instanceof GradleDslElementList) {
                List<GradleDslElement> originalElements = holder.getOriginalElements();
                List<GradleDslElement> elements = holder.getAllPropertyElements();
                int index = elements.indexOf(element);
                return originalElements.contains(element) ? element : (index >= 0 && originalElements.size() > index ? originalElements.get(index) : null);
            }
            return holder.getOriginalElementForNameAndType(element.getName(), element.getElementType());
        }
        return null;
    }

    public static boolean isFakeElementModified(@NotNull FakeElement element) {
        GradleDslElement realExpression = element.getRealExpression();
        GradleDslElement realParent = realExpression.getParent();
        GradleDslElement oldRealExpression = realParent == null ? null : PropertyUtil.findOriginalElement(realParent, realExpression);
        return oldRealExpression == null || PropertyUtil.isElementModified(oldRealExpression, realExpression);
    }

    private static boolean checkForModifiedValue(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        if (!oldElement.getClass().equals(newElement.getClass())) {
            return true;
        }
        if (oldElement instanceof GradleDslSettableExpression) {
            GradleDslSettableExpression oExpression = (GradleDslSettableExpression)oldElement;
            GradleDslSettableExpression nExpression = (GradleDslSettableExpression)newElement;
            String newText = null;
            String oldText = null;
            if (nExpression.getUnsavedValue() != null) {
                newText = nExpression.getUnsavedValue().getText();
            } else if (nExpression.getExpression() != null) {
                newText = nExpression.getExpression().getText();
            }
            if (oExpression.getExpression() != null) {
                oldText = oExpression.getExpression().getText();
            } else if (oExpression.getUnsavedValue() != null) {
                oldText = oExpression.getUnsavedValue().getText();
            }
            return (newText != null || oldText != null) && !Objects.equals(newText, oldText);
        }
        if (oldElement instanceof GradlePropertiesDslElement) {
            GradlePropertiesDslElement oListOrMap = (GradlePropertiesDslElement)oldElement;
            GradlePropertiesDslElement nListOrMap = (GradlePropertiesDslElement)newElement;
            List<GradleDslElement> originalElements = oListOrMap.getOriginalElements();
            List<GradleDslElement> newElements = nListOrMap.getCurrentElements();
            if (originalElements.size() != newElements.size()) {
                return true;
            }
            BiFunction<GradleDslElement, GradleDslElement, Boolean> func = oldElement instanceof GradleDslExpressionList ? PropertyUtil::checkForModifiedValue : PropertyUtil::isElementModified;
            for (int i = 0; i < originalElements.size(); ++i) {
                if (!func.apply(originalElements.get(i), newElements.get(i)).booleanValue()) continue;
                return true;
            }
            return false;
        }
        if (oldElement instanceof GradleDslMethodCall) {
            GradleDslMethodCall oMethodCall = (GradleDslMethodCall)oldElement;
            GradleDslMethodCall nMethodCall = (GradleDslMethodCall)newElement;
            if (!oMethodCall.getMethodName().equals(nMethodCall.getMethodName())) {
                return false;
            }
            return PropertyUtil.checkForModifiedValue(oMethodCall.getArgumentsElement(), nMethodCall.getArgumentsElement());
        }
        PsiElement oldPsi = oldElement.getPsiElement();
        PsiElement newPsi = newElement.getPsiElement();
        return oldPsi == null || newPsi == null || !Objects.equals(oldPsi.getText(), newPsi.getText());
    }

    private static boolean checkForModifiedName(@NotNull GradleDslElement originalElement, @NotNull GradleDslElement newElement) {
        ModelEffectDescription oEffect = originalElement.getModelEffect();
        ModelEffectDescription nEffect = newElement.getModelEffect();
        if (oEffect != null && nEffect != null && Objects.equals(oEffect.property, nEffect.property)) {
            return false;
        }
        GradleNameElement oNameElement = originalElement.getNameElement();
        String oldName = oNameElement.getOriginalName();
        if (oldName == null) {
            return false;
        }
        GradleNameElement nNameElement = newElement.getNameElement();
        String newName = nNameElement.getLocalName();
        if (newName == null) {
            return false;
        }
        return !Objects.equals(GradleNameElement.convertNameToKey(newName), GradleNameElement.convertNameToKey(oldName));
    }
}

