/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.model.CachedValue;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ThreeState;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradleDslSimpleExpression
extends GradleDslElementImpl
implements GradleDslExpression {
    private boolean myIsInterpolated;
    private boolean myIsReference;
    @Nullable
    private PsiElement myUnsavedConfigBlock;
    @Nullable
    protected PsiElement myExpression;
    @Nullable
    protected ThreeState myHasCycle;
    @NotNull
    private final CachedValue<GradleDslSimpleExpression> myResolvedCachedValue;
    @NotNull
    private final CachedValue<GradleDslSimpleExpression> myUnresolvedCachedValue;
    @NotNull
    private final CachedValue<GradleDslSimpleExpression> myRawCachedValue;

    protected GradleDslSimpleExpression(@Nullable GradleDslElement parent, @Nullable PsiElement psiElement, @NotNull GradleNameElement name2, @Nullable PsiElement expression) {
        super(parent, psiElement, name2);
        this.myExpression = expression;
        this.myHasCycle = ThreeState.UNSURE;
        this.resolve();
        this.myResolvedCachedValue = new CachedValue<GradleDslSimpleExpression>(this, GradleDslSimpleExpression::produceValue);
        this.myUnresolvedCachedValue = new CachedValue<GradleDslSimpleExpression>(this, GradleDslSimpleExpression::produceUnresolvedValue);
        this.myRawCachedValue = new CachedValue<GradleDslSimpleExpression>(this, GradleDslSimpleExpression::produceRawValue);
    }

    @Override
    @Nullable
    public PsiElement getExpression() {
        return this.myExpression;
    }

    public void setExpression(@NotNull PsiElement expression) {
        this.myExpression = expression;
    }

    @Nullable
    public final Object getValue() {
        return this.myResolvedCachedValue.getValue();
    }

    @Nullable
    protected abstract Object produceValue();

    @Nullable
    public final Object getUnresolvedValue() {
        return this.myUnresolvedCachedValue.getValue();
    }

    @Nullable
    protected abstract Object produceUnresolvedValue();

    @Nullable
    public <T> T getValue(@NotNull Class<T> clazz2) {
        Object value2 = this.getValue();
        if (value2 != null && clazz2.isAssignableFrom(value2.getClass())) {
            return clazz2.cast(value2);
        }
        return null;
    }

    @Nullable
    public <T> T getUnresolvedValue(@NotNull Class<T> clazz2) {
        Object value2 = this.getUnresolvedValue();
        if (value2 != null && clazz2.isAssignableFrom(value2.getClass())) {
            return clazz2.cast(value2);
        }
        return null;
    }

    public abstract void setValue(@NotNull Object var1);

    @Nullable
    public final Object getRawValue() {
        return this.myRawCachedValue.getValue();
    }

    @Nullable
    protected abstract Object produceRawValue();

    @Override
    @NotNull
    public abstract GradleDslSimpleExpression copy();

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        return this.myDependencies.stream().filter(e -> e.isResolved()).collect(Collectors.toList());
    }

    public boolean isInterpolated() {
        return this.myIsInterpolated;
    }

    public void setInterpolated(boolean isInterpolated) {
        this.myIsInterpolated = isInterpolated;
    }

    public boolean isReference() {
        return this.myIsReference;
    }

    public void setReference(boolean isReference) {
        this.myIsReference = isReference;
    }

    @Nullable
    public String getReferenceText() {
        return null;
    }

    @Override
    protected void reset() {
        this.myRawCachedValue.clear();
        this.myUnresolvedCachedValue.clear();
        this.myResolvedCachedValue.clear();
    }

    @Nullable
    public static GradlePropertiesDslElement dereferencePropertiesElement(@NotNull GradlePropertiesDslElement element, @NotNull String index) {
        GradleDslElement result2 = GradleDslSimpleExpression.dereference(element, index);
        if ((result2 = PropertyUtil.followElement(result2)) instanceof GradlePropertiesDslElement) {
            return (GradlePropertiesDslElement)result2;
        }
        return null;
    }

    protected void valueChanged() {
        this.myHasCycle = ThreeState.UNSURE;
        this.setModified();
    }

    public boolean hasCycle() {
        if (this.myHasCycle != ThreeState.UNSURE) {
            return this.myHasCycle == ThreeState.YES;
        }
        return GradleDslSimpleExpression.hasCycle(this, new HashSet<GradleDslSimpleExpression>(), new HashSet<GradleDslSimpleExpression>());
    }

    private static boolean hasCycle(@NotNull GradleDslSimpleExpression element, @NotNull Set<GradleDslSimpleExpression> seen, @NotNull Set<GradleDslSimpleExpression> cycleFree) {
        if (element.myHasCycle != ThreeState.UNSURE) {
            return element.myHasCycle == ThreeState.YES;
        }
        boolean hasCycle = GradleDslSimpleExpression.checkCycle(element, seen, cycleFree);
        element.myHasCycle = hasCycle ? ThreeState.YES : ThreeState.NO;
        return hasCycle;
    }

    private static boolean checkCycle(@NotNull GradleDslSimpleExpression element, @NotNull Set<GradleDslSimpleExpression> seen, @NotNull Set<GradleDslSimpleExpression> cycleFree) {
        if (cycleFree.contains(element) || element.getExpression() == null) {
            return false;
        }
        if (seen.contains(element)) {
            return true;
        }
        seen.add(element);
        List<GradleReferenceInjection> injections = element.getResolvedVariables();
        for (GradleReferenceInjection injection : injections) {
            boolean hasCycle;
            if (injection.getToBeInjectedExpression() == null || !(hasCycle = GradleDslSimpleExpression.hasCycle(injection.getToBeInjectedExpression(), seen, cycleFree))) continue;
            seen.remove(element);
            return true;
        }
        seen.remove(element);
        cycleFree.add(element);
        return false;
    }

    @Override
    public void resolve() {
        this.setupDependencies(this.myExpression);
    }

    @NotNull
    protected List<GradleReferenceInjection> fetchDependencies(@Nullable PsiElement element) {
        if (element == null) {
            return ImmutableList.of();
        }
        return (List)ApplicationManager.getApplication().runReadAction(() -> this.getDslFile().getParser().getInjections(this, element));
    }

    protected void setupDependencies(@Nullable PsiElement element) {
        this.myDependencies.stream().filter(e -> e.getToBeInjected() != null).forEach(e -> e.getToBeInjected().unregisterDependent((GradleReferenceInjection)e));
        this.myDependencies.stream().filter(e -> e.getToBeInjected() == null).forEach(e -> this.getDslFile().getContext().getDependencyManager().unregisterUnresolvedReference((GradleReferenceInjection)e));
        this.myDependencies.clear();
        this.myDependencies.addAll(this.fetchDependencies(element));
        this.myDependencies.stream().filter(e -> e.getToBeInjected() != null).forEach(e -> e.getToBeInjected().registerDependent((GradleReferenceInjection)e));
        this.myDependencies.stream().filter(e -> e.getToBeInjected() == null).forEach(e -> this.getDslFile().getContext().getDependencyManager().registerUnresolvedReference((GradleReferenceInjection)e));
    }
}

