/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.GradleBlockModelMap;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.SharedParserUtilsKt;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.ElementState;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslAnchor;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslBlockElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ElementSort;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.semantics.MethodSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyType;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertiesElementDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.SemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class GradlePropertiesDslElement
extends GradleDslElementImpl {
    private static final Logger LOG = Logger.getInstance(GradlePropertiesDslElement.class);
    @NotNull
    private static final Predicate<ElementList.ElementItem> VARIABLE_FILTER = e -> e.myElement.getElementType() == PropertyType.VARIABLE;
    @NotNull
    private static final Predicate<ElementList.ElementItem> PROPERTY_FILTER = VARIABLE_FILTER.negate();
    @NotNull
    private static final Predicate<ElementList.ElementItem> ANY_FILTER = Predicates.alwaysTrue();
    @NotNull
    public final ElementList myProperties = new ElementList();

    protected GradlePropertiesDslElement(@Nullable GradleDslElement parent, @Nullable PsiElement psiElement, @NotNull GradleNameElement name2) {
        super(parent, psiElement, name2);
    }

    private void addPropertyInternal(@NotNull GradleDslElement element, @NotNull ElementState state2) {
        if (this instanceof ExtDslElement && state2 == ElementState.TO_BE_ADDED) {
            int index = this.reorderAndMaybeGetNewIndex(element);
            this.myProperties.addElementAtIndex(element, state2, index, false);
        } else {
            this.myProperties.addElement(element, state2, state2 == ElementState.EXISTING);
        }
        if (state2 == ElementState.TO_BE_ADDED) {
            this.updateDependenciesOnAddElement(element);
            element.setModified();
        }
    }

    public void addParsedPropertyAsFirstElement(@NotNull GradleDslElement extElement) {
        this.myProperties.addElementAtIndex(extElement, ElementState.EXISTING, 0, true);
    }

    private void addPropertyInternal(int index, @NotNull GradleDslElement element, @NotNull ElementState state2) {
        this.myProperties.addElementAtIndex(element, state2, index, state2 == ElementState.EXISTING);
        if (state2 == ElementState.TO_BE_ADDED) {
            this.updateDependenciesOnAddElement(element);
            element.setModified();
        }
    }

    public void addAppliedProperty(@NotNull GradleDslElement element) {
        element.addHolder(this);
        this.addPropertyInternal(element, ElementState.APPLIED);
        this.markSubtreeApplied(element, new HashSet<GradleDslElement>());
    }

    private void markSubtreeApplied(@NotNull GradleDslElement element, HashSet<GradleDslElement> seen) {
        seen.add(element);
        if (element instanceof GradlePropertiesDslElement) {
            GradlePropertiesDslElement propertiesDslElement = (GradlePropertiesDslElement)element;
            for (ElementList.ElementItem item : propertiesDslElement.myProperties.myElements) {
                if (seen.contains(item.myElement)) continue;
                item.myElementState = ElementState.APPLIED;
                this.markSubtreeApplied(item.myElement, seen);
            }
        }
    }

    public void addDefaultProperty(@NotNull GradleDslElement element) {
        element.setElementType(PropertyType.REGULAR);
        this.addPropertyInternal(element, ElementState.DEFAULT);
    }

    public void addDefaultPropertyAt(@NotNull GradleDslElement element, int index) {
        element.setElementType(PropertyType.REGULAR);
        this.myProperties.addElementAtIndex(element, ElementState.DEFAULT, index, false);
    }

    private void removePropertyInternal(@NotNull String property2) {
        List<GradleDslElement> elements = this.myProperties.removeAll(e -> e.myElement.getName().equals(property2));
        elements.forEach(e -> {
            e.setModified();
            this.updateDependenciesOnRemoveElement((GradleDslElement)e);
        });
        this.setModified();
    }

    private ElementState removePropertyInternal(@NotNull GradleDslElement element) {
        element.setModified();
        ElementState state2 = this.myProperties.remove(element);
        this.updateDependenciesOnRemoveElement(element);
        return state2;
    }

    private ElementState replacePropertyInternal(@NotNull GradleDslElement element, @NotNull GradleDslElement newElement) {
        element.setModified();
        this.updateDependenciesOnReplaceElement(element, newElement);
        newElement.setModified();
        ElementState oldState = this.myProperties.replaceElement(element, newElement);
        this.reorderAndMaybeGetNewIndex(newElement);
        return oldState;
    }

    private ElementState hidePropertyInternal(@NotNull GradleDslElement element) {
        return this.myProperties.hide(element);
    }

    public void addAppliedModelProperties(@NotNull GradleDslFile file) {
        this.mergePropertiesFrom(file);
    }

    public void mergePropertiesFrom(@NotNull GradlePropertiesDslElement other) {
        Map<String, GradleDslElement> ourProperties = this.getPropertyElements();
        for (Map.Entry<String, GradleDslElement> entry : other.getPropertyElements().entrySet()) {
            GradlePropertiesDslElement createdElement;
            GradleDslElement newProperty = entry.getValue();
            if (newProperty instanceof ApplyDslElement) continue;
            if (ourProperties.containsKey(entry.getKey())) {
                GradleDslElement existingProperty = this.getElementWhere(entry.getKey(), PROPERTY_FILTER);
                if (newProperty instanceof GradleDslBlockElement && existingProperty instanceof GradleDslBlockElement) {
                    ((GradlePropertiesDslElement)existingProperty).mergePropertiesFrom((GradlePropertiesDslElement)newProperty);
                    continue;
                }
            } else if (PropertyUtil.isPropertiesElementOrMap(newProperty) && (createdElement = this.getDslFile().getParser().getPropertiesElement(Arrays.asList(entry.getKey().split("\\.")), this, null)) != null) {
                createdElement.mergePropertiesFrom((GradlePropertiesDslElement)newProperty);
                continue;
            }
            this.addAppliedProperty(entry.getValue());
        }
    }

    public void setParsedElement(@NotNull GradleDslElement element) {
        element.setParent(this);
        this.addPropertyInternal(element, ElementState.EXISTING);
    }

    public void addParsedElement(@NotNull GradleDslElement element) {
        element.setParent(this);
        this.addPropertyInternal(element, ElementState.EXISTING);
    }

    public void augmentParsedElement(@NotNull GradleDslElement element) {
        ModelEffectDescription modelEffect = element.getModelEffect();
        if (modelEffect == null) {
            this.addParsedElement(element);
            return;
        }
        ModelPropertyType type = modelEffect.property.type;
        if (type == ModelPropertyType.MUTABLE_LIST || type == ModelPropertyType.MUTABLE_SET) {
            this.addToParsedExpressionList(modelEffect, element);
            return;
        }
        if (type == ModelPropertyType.MUTABLE_MAP) {
            this.addToParsedExpressionMap(modelEffect, element);
            return;
        }
        this.addParsedElement(element);
    }

    protected void addAsParsedDslExpressionList(@NotNull ModelEffectDescription effect, @NotNull GradleDslSimpleExpression expression) {
        String property2 = effect.property.name;
        PsiElement psiElement = expression.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GradleDslExpressionList literalList = new GradleDslExpressionList((GradleDslElement)this, psiElement, GradleNameElement.create(property2), true);
        literalList.setModelEffect(effect);
        literalList.setElementType(PropertyType.REGULAR);
        if (expression instanceof GradleDslMethodCall) {
            literalList.setPsiElement(((GradleDslMethodCall)expression).getArgumentListPsiElement());
            for (GradleDslElement gradleDslElement : ((GradleDslMethodCall)expression).getArguments()) {
                if (!(gradleDslElement instanceof GradleDslSimpleExpression)) continue;
                literalList.addParsedExpression((GradleDslSimpleExpression)gradleDslElement);
            }
        } else {
            literalList.addParsedExpression(expression);
        }
        this.addPropertyInternal(literalList, ElementState.EXISTING);
    }

    @Nullable
    private static PsiElement mungeElementsForAddToParsedExpressionList(@NotNull GradleDslElement dslElement, @NotNull List<GradleDslElement> newDslElements) {
        PsiElement psiElement = dslElement.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        if (dslElement instanceof GradleDslMethodCall) {
            List<GradleDslExpression> args = ((GradleDslMethodCall)dslElement).getArguments();
            if (!args.isEmpty()) {
                if (args.size() == 1 && args.get(0) instanceof GradleDslExpressionList) {
                    newDslElements.addAll(((GradleDslExpressionList)args.get(0)).getExpressions());
                    PsiElement newElement = args.get(0).getPsiElement();
                    return newElement != null ? newElement : psiElement;
                }
                newDslElements.addAll(args);
                return psiElement;
            }
            return psiElement;
        }
        if (dslElement instanceof GradleDslSimpleExpression) {
            newDslElements.add(dslElement);
            return psiElement;
        }
        if (dslElement instanceof GradleDslExpressionList) {
            newDslElements.addAll(((GradleDslExpressionList)dslElement).getExpressions());
            return psiElement;
        }
        return null;
    }

    public void addToParsedExpressionList(@NotNull String property2, @NotNull GradleDslElement element) {
        ArrayList<GradleDslElement> newElements = new ArrayList<GradleDslElement>();
        PsiElement psiElement = GradlePropertiesDslElement.mungeElementsForAddToParsedExpressionList(element, newElements);
        if (psiElement == null) {
            return;
        }
        GradleDslExpressionList gradleDslExpressionList = this.getPropertyElement(property2, GradleDslExpressionList.class);
        if (gradleDslExpressionList == null) {
            gradleDslExpressionList = new GradleDslExpressionList((GradleDslElement)this, psiElement, GradleNameElement.create(property2), false);
            this.addPropertyInternal(gradleDslExpressionList, ElementState.EXISTING);
        } else {
            gradleDslExpressionList.setPsiElement(psiElement);
        }
        newElements.forEach(gradleDslExpressionList::addParsedElement);
    }

    public void addToParsedExpressionList(@NotNull ModelEffectDescription effect, @NotNull GradleDslElement element) {
        ArrayList<GradleDslElement> newElements = new ArrayList<GradleDslElement>();
        PsiElement psiElement = GradlePropertiesDslElement.mungeElementsForAddToParsedExpressionList(element, newElements);
        if (psiElement == null) {
            return;
        }
        GradleDslExpressionList gradleDslExpressionList = this.getPropertyElement(effect.property, GradleDslExpressionList.class);
        if (gradleDslExpressionList == null) {
            gradleDslExpressionList = new GradleDslExpressionList((GradleDslElement)this, psiElement, GradleNameElement.create(effect.property.name), false);
            ModelEffectDescription createEffect = new ModelEffectDescription(effect.property, ModelSemanticsDescription.CREATE_WITH_VALUE, effect.versionConstraint);
            gradleDslExpressionList.setModelEffect(createEffect);
            gradleDslExpressionList.setElementType(PropertyType.REGULAR);
            this.addPropertyInternal(gradleDslExpressionList, ElementState.EXISTING);
        } else {
            gradleDslExpressionList.setPsiElement(psiElement);
        }
        newElements.forEach(gradleDslExpressionList::addParsedElement);
    }

    public void addToParsedExpressionMap(@NotNull ModelEffectDescription effect, @NotNull GradleDslElement element) {
        if (!((element = PropertyUtil.followElement(element)) instanceof GradleDslExpressionMap)) {
            return;
        }
        GradleDslExpressionMap map2 = this.getPropertyElement(effect.property, GradleDslExpressionMap.class);
        if (map2 == null) {
            map2 = new GradleDslExpressionMap(this, element.getPsiElement(), GradleNameElement.create(effect.property.name), true);
            ModelEffectDescription createEffect = new ModelEffectDescription(effect.property, ModelSemanticsDescription.CREATE_WITH_VALUE, effect.versionConstraint);
            map2.setModelEffect(createEffect);
            map2.setElementType(PropertyType.REGULAR);
            this.addPropertyInternal(map2, ElementState.EXISTING);
        } else {
            map2.setPsiElement(element.getPsiElement());
            SemanticsDescription semantics = ModelSemanticsDescription.CREATE_WITH_VALUE;
            ModelEffectDescription currentEffect = map2.getModelEffect();
            if (currentEffect != null) {
                semantics = currentEffect.semantics;
            }
            ModelEffectDescription newEffect = new ModelEffectDescription(effect.property, semantics, effect.versionConstraint);
            map2.setModelEffect(newEffect);
        }
        GradleDslExpressionMap newElements = (GradleDslExpressionMap)element;
        for (Map.Entry<String, GradleDslElement> entry : newElements.getPropertyElements().entrySet()) {
            map2.setParsedElement(entry.getValue());
        }
    }

    @NotNull
    public Map<String, PropertiesElementDescription<?>> getChildPropertiesElementsDescriptionMap(@NotNull GradleDslNameConverter.Kind kind) {
        return GradleBlockModelMap.getElementMap(this.getClass(), kind);
    }

    @Nullable
    public PropertiesElementDescription getChildPropertiesElementDescription(GradleDslNameConverter converter, String name2) {
        return this.getChildPropertiesElementsDescriptionMap(converter.getKind()).get(name2);
    }

    @NotNull
    public Set<String> getProperties() {
        return this.getPropertyElements().keySet();
    }

    @NotNull
    public Map<String, GradleDslElement> getPropertyElements() {
        return this.getElementsWhere(PROPERTY_FILTER);
    }

    @NotNull
    public <T extends GradleDslElement> List<T> getPropertyElements(@NotNull String name2, @NotNull Class<T> clazz2) {
        return this.myProperties.getElementsWhere(PROPERTY_FILTER).stream().filter(e -> clazz2.isAssignableFrom(e.getClass()) && e.getName().equals(name2)).map(e -> (GradleDslElement)clazz2.cast(e)).collect(Collectors.toList());
    }

    @NotNull
    public List<GradleDslElement> getAllPropertyElements() {
        return this.myProperties.getElementsWhere(PROPERTY_FILTER);
    }

    @NotNull
    public Map<String, GradleDslElement> getVariableElements() {
        return this.getElementsWhere(VARIABLE_FILTER);
    }

    @NotNull
    public Map<String, GradleDslElement> getElements() {
        return this.getElementsWhere(ANY_FILTER);
    }

    @NotNull
    public List<GradleDslElement> getAllElements() {
        return this.myProperties.getElementsWhere(ANY_FILTER);
    }

    @NotNull
    private Map<String, GradleDslElement> getElementsWhere(@NotNull Predicate<ElementList.ElementItem> predicate) {
        LinkedHashMap<String, GradleDslElement> results2 = new LinkedHashMap<String, GradleDslElement>();
        List<GradleDslElement> elements = this.myProperties.getElementsWhere(predicate);
        for (GradleDslElement element : elements) {
            if (element == null) continue;
            results2.put(element.getName(), element);
        }
        return results2;
    }

    private GradleDslElement getElementWhere(@NotNull String name2, @NotNull Predicate<ElementList.ElementItem> predicate) {
        return this.getElementWhere(e -> predicate.test((ElementList.ElementItem)e) && e.myElement.getName().equals(name2));
    }

    private GradleDslElement getElementWhere(@NotNull ModelPropertyDescription property2, @NotNull Predicate<ElementList.ElementItem> predicate) {
        return this.getElementWhere(e -> predicate.test((ElementList.ElementItem)e) && property2.equals(e.myElement.getModelProperty()));
    }

    protected GradleDslElement getElementWhere(@NotNull Predicate<ElementList.ElementItem> predicate) {
        return this.myProperties.getElementWhere(predicate);
    }

    private GradleDslElement getElementBeforeChildWhere(@NotNull String name2, Predicate<ElementList.ElementItem> predicate, @NotNull GradleDslElement element, boolean includeSelf) {
        return this.getElementBeforeChildWhere(e -> predicate.test((ElementList.ElementItem)e) && e.myElement.getName().equals(name2), element, includeSelf);
    }

    protected GradleDslElement getElementBeforeChildWhere(Predicate<ElementList.ElementItem> predicate, @NotNull GradleDslElement element, boolean includeSelf) {
        return this.myProperties.getElementBeforeChildWhere(predicate, element, includeSelf);
    }

    @Nullable
    public GradleDslElement getVariableElement(@NotNull String property2) {
        return this.getElementWhere(property2, VARIABLE_FILTER);
    }

    @Nullable
    public GradleDslElement getPropertyElement(@NotNull String property2) {
        return this.getElementWhere(property2, PROPERTY_FILTER);
    }

    @Nullable
    public GradleDslElement getPropertyElement(@NotNull ModelPropertyDescription property2) {
        return this.getElementWhere(property2, PROPERTY_FILTER);
    }

    @Nullable
    public GradleDslElement getElement(@NotNull String property2) {
        return this.getElementWhere(property2, ANY_FILTER);
    }

    @Nullable
    public GradleDslElement getPropertyElementBefore(@Nullable GradleDslElement element, @NotNull String property2, boolean includeSelf) {
        if (element == null) {
            return this.getElementWhere(property2, PROPERTY_FILTER);
        }
        return this.getElementBeforeChildWhere(property2, PROPERTY_FILTER, element, includeSelf);
    }

    @Nullable
    GradleDslElement getElementBefore(@Nullable GradleDslElement element, @NotNull String property2, boolean includeSelf) {
        if (element == null) {
            return this.getElementWhere(property2, ANY_FILTER);
        }
        return this.getElementBeforeChildWhere(property2, ANY_FILTER, element, includeSelf);
    }

    @Nullable
    public <T extends GradleDslElement> T getPropertyElement(@NotNull String property2, @NotNull Class<T> clazz2) {
        GradleDslElement propertyElement = this.getPropertyElement(property2);
        return (T)(clazz2.isInstance(propertyElement) ? (GradleDslElement)clazz2.cast(propertyElement) : null);
    }

    @Nullable
    public <T extends GradleDslElement> T getPropertyElement(@NotNull ModelPropertyDescription property2, @NotNull Class<T> clazz2) {
        GradleDslElement propertyElement = this.getPropertyElement(property2);
        return (T)(clazz2.isInstance(propertyElement) ? (GradleDslElement)clazz2.cast(propertyElement) : null);
    }

    @Nullable
    public <T extends GradlePropertiesDslElement> T getPropertyElement(@NotNull PropertiesElementDescription<T> description2) {
        assert (description2.name != null);
        return (T)((GradlePropertiesDslElement)this.getPropertyElement(description2.name, description2.clazz));
    }

    @NotNull
    public <T extends GradlePropertiesDslElement> T ensurePropertyElement(@NotNull PropertiesElementDescription<T> description2) {
        return this.ensurePropertyElementAt(description2, null);
    }

    @NotNull
    public <T extends GradlePropertiesDslElement, U> T ensurePropertyElementBefore(@NotNull PropertiesElementDescription<T> description2, Class<U> before) {
        Integer at = null;
        List<GradleDslElement> elements = this.getCurrentElements();
        for (int i = 0; i < elements.size(); ++i) {
            if (!before.isInstance(elements.get(i))) continue;
            at = i;
            break;
        }
        return this.ensurePropertyElementAt(description2, at);
    }

    @NotNull
    public <T extends GradlePropertiesDslElement> T ensureNamedPropertyElement(PropertiesElementDescription<T> description2, GradleNameElement name2) {
        GradlePropertiesDslElement propertyElement = (GradlePropertiesDslElement)this.getPropertyElement(name2.name(), description2.clazz);
        if (propertyElement != null) {
            return (T)propertyElement;
        }
        assert (description2.name == null);
        Object newElement = description2.constructor.construct(this, name2);
        this.setNewElement((GradleDslElement)newElement);
        return newElement;
    }

    @NotNull
    public <T extends GradlePropertiesDslElement> T ensurePropertyElementAt(PropertiesElementDescription<T> description2, Integer at) {
        T propertyElement = this.getPropertyElement(description2);
        if (propertyElement != null) {
            return propertyElement;
        }
        assert (description2.name != null);
        Object newElement = description2.constructor.construct(this, GradleNameElement.create(description2.name));
        if (at != null) {
            this.addNewElementAt(at, (GradleDslElement)newElement);
        } else {
            this.setNewElement((GradleDslElement)newElement);
        }
        return newElement;
    }

    @Nullable
    public <T extends GradleDslElement> T getPropertyElement(@NotNull List<String> properties, @NotNull Class<T> clazz2) {
        GradleDslElement propertyElement = this.myProperties.getElementWhere(e -> properties.contains(e.myElement.getName()));
        return (T)(clazz2.isInstance(propertyElement) ? (GradleDslElement)clazz2.cast(propertyElement) : null);
    }

    @NotNull
    public <T extends GradleDslElement> List<T> getPropertyElements(@NotNull Class<T> clazz2) {
        return this.myProperties.getElementsWhere(PROPERTY_FILTER).stream().filter(e -> clazz2.isAssignableFrom(e.getClass())).map(e -> (GradleDslElement)clazz2.cast(e)).collect(Collectors.toList());
    }

    @NotNull
    public List<GradleDslElement> getPropertyElementsByName(@NotNull String propertyName) {
        return this.myProperties.getElementsWhere(e -> e.myElement.getName().equals(propertyName) && PROPERTY_FILTER.test((ElementList.ElementItem)e));
    }

    @NotNull
    public List<GradleDslElement> getOriginalElements() {
        return this.myProperties.myElements.stream().filter(e -> e.myExistsOnFile).map(e -> e.myElement).collect(Collectors.toList());
    }

    @Nullable
    public GradleDslElement getOriginalElementForNameAndType(@NotNull String name2, @NotNull PropertyType type) {
        return this.myProperties.myElements.stream().filter(e -> e.myElement.getName().equals(name2) && e.myExistsOnFile && e.myElement.getElementType() == type).map(e -> e.myElement).reduce((a, b) -> b).orElse(null);
    }

    @NotNull
    public List<GradleDslElement> getCurrentElements() {
        Predicate<ElementList.ElementItem> currentElementFilter = e -> e.myElementState == ElementState.TO_BE_ADDED || e.myElementState == ElementState.EXISTING || e.myElementState == ElementState.MOVED || e.myElementState == ElementState.DEFAULT && e.myElement instanceof GradlePropertiesDslElement && !((GradlePropertiesDslElement)e.myElement).getCurrentElements().isEmpty();
        return this.myProperties.myElements.stream().filter(currentElementFilter).map(e -> e.myElement).collect(Collectors.toList());
    }

    public void setNewElement(@NotNull GradleDslElement newElement) {
        newElement.setParent(this);
        this.addPropertyInternal(newElement, ElementState.TO_BE_ADDED);
        this.setModified();
    }

    public void addNewElementAt(int index, @NotNull GradleDslElement newElement) {
        newElement.setParent(this);
        this.addPropertyInternal(index, newElement, ElementState.TO_BE_ADDED);
        this.setModified();
    }

    @VisibleForTesting
    public void moveElementTo(int index, @NotNull GradleDslElement newElement) {
        assert (newElement.getParent() == this);
        this.myProperties.moveElementToIndex(newElement, index);
    }

    public void replaceElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        newElement.setParent(this);
        ArrayList<GradlePropertiesDslElement> holders = new ArrayList<GradlePropertiesDslElement>();
        holders.add(this);
        holders.addAll(oldElement.getHolders());
        for (GradlePropertiesDslElement holder : holders) {
            holder.replacePropertyInternal(oldElement, newElement);
        }
    }

    public void substituteElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        assert (newElement.getParent() == this);
        this.myProperties.substituteElement(oldElement, newElement);
    }

    @Override
    public void childPsiUpdated(@NotNull GradleDslElement childElement) {
        assert (childElement.getParent() == this);
        for (ElementList.ElementItem item : this.myProperties.myElements) {
            if (childElement != item.myElement) continue;
            if (childElement.getPsiElement() == null) {
                item.myElementState = ElementState.TO_BE_ADDED;
                item.myExistsOnFile = false;
            } else {
                item.myElementState = ElementState.EXISTING;
                item.myExistsOnFile = true;
            }
            return;
        }
    }

    @Nullable
    public <T> T getLiteral(@NotNull String property2, @NotNull Class<T> clazz2) {
        GradleDslSimpleExpression expression = this.getPropertyElement(property2, GradleDslSimpleExpression.class);
        if (expression == null) {
            return null;
        }
        return expression.getValue(clazz2);
    }

    @NotNull
    public GradleDslLiteral setNewLiteral(@NotNull String property2, @NotNull Object value2) {
        return this.setNewLiteralImpl(property2, value2);
    }

    @NotNull
    private GradleDslLiteral setNewLiteralImpl(@NotNull String property2, @NotNull Object value2) {
        GradleDslLiteral literalElement = this.getPropertyElement(property2, GradleDslLiteral.class);
        if (literalElement == null) {
            literalElement = new GradleDslLiteral(this, GradleNameElement.create(property2));
            this.addPropertyInternal(literalElement, ElementState.TO_BE_ADDED);
        }
        literalElement.setValue(value2);
        return literalElement;
    }

    public void removeProperty(@NotNull String property2) {
        this.removePropertyInternal(property2);
    }

    public void removeProperty(@NotNull GradleDslElement element) {
        this.removePropertyInternal(element);
        for (GradlePropertiesDslElement holder : element.getHolders()) {
            if (this == holder) continue;
            holder.removePropertyInternal(element);
        }
        GradleDslElement parent = element.getParent();
        if (this != parent && parent instanceof GradlePropertiesDslElement) {
            ((GradlePropertiesDslElement)parent).removePropertyInternal(element);
        }
    }

    public void hideProperty(@NotNull GradleDslElement element) {
        this.hidePropertyInternal(element);
        for (GradlePropertiesDslElement holder : element.getHolders()) {
            if (this == holder) continue;
            holder.removePropertyInternal(element);
        }
        GradleDslElement parent = element.getParent();
        if (this != parent && parent instanceof GradlePropertiesDslElement) {
            ((GradlePropertiesDslElement)parent).hidePropertyInternal(element);
        }
    }

    @Override
    @NotNull
    public GradleDslAnchor requestAnchor(@NotNull GradleDslElement element) {
        GradleDslAnchor anchor = new GradleDslAnchor.Start(this);
        for (ElementList.ElementItem item : this.myProperties.myElements) {
            ProjectPropertiesDslElement projectProperties;
            GradleDslElement currentElement;
            if (item.myElement == element) {
                if (item.myElementState == ElementState.EXISTING && SharedParserUtilsKt.findLastPsiElementIn(item.myElement) != null) {
                    return new GradleDslAnchor.After(item.myElement);
                }
                return anchor;
            }
            if (!item.myElementState.isPhysicalInFile() || (currentElement = item.myElement) instanceof ProjectPropertiesDslElement && (projectProperties = (ProjectPropertiesDslElement)currentElement).getAllPropertyElements().stream().allMatch(it -> it.getPsiElement() == null)) continue;
            if (currentElement instanceof ApplyDslElement) {
                anchor = currentElement.requestAnchor(element);
                continue;
            }
            anchor = new GradleDslAnchor.After(currentElement);
        }
        return anchor;
    }

    @Override
    @NotNull
    public Collection<GradleDslElement> getChildren() {
        return this.getAllElements();
    }

    @Override
    @NotNull
    public List<GradleDslElement> getContainedElements(boolean includeProperties) {
        ArrayList<GradleDslElement> result2 = new ArrayList<GradleDslElement>();
        if (includeProperties) {
            result2.addAll(this.getElementsWhere(e -> e.myElementState != ElementState.APPLIED && !e.isDefaultElement()).values());
        } else {
            result2.addAll(this.getVariableElements().values());
        }
        List<GradlePropertiesDslElement> holders = this.getPropertyElements(GradlePropertiesDslElement.class).stream().filter(e -> !(e instanceof GradleDslExpression)).collect(Collectors.toList());
        holders.forEach(e -> result2.addAll(e.getContainedElements(includeProperties)));
        return result2;
    }

    @Override
    public void delete() {
        this.myProperties.forEach(e -> e.myElement.delete());
        super.delete();
    }

    protected void deleteAndRecreate() {
        this.myProperties.removeElements(GradleDslElement::delete);
        if (!this.myProperties.isEmpty()) {
            this.myProperties.forEach(item -> {
                GradleDslElement element;
                GradleDslElement copy = element = item.myElement;
                if (element instanceof GradleDslExpression) {
                    copy = ((GradleDslExpression)element).copy();
                }
                element.getDslFile().getWriter().deleteDslElement(element);
                item.myElement = copy;
            });
            this.getDslFile().getWriter().deleteDslElement(this);
            this.create();
            this.myProperties.forEach(item -> {
                GradleDslElement element = item.myElement;
                element.create();
                item.myElementState = ElementState.EXISTING;
            });
        }
    }

    protected boolean isStructurallyModified() {
        Predicate<ElementList.ElementItem> predicate = e -> e.myElementState.isStructuralChange();
        return this.myProperties.myElements.stream().anyMatch(predicate);
    }

    @Override
    protected void apply() {
        this.getDslFile().getWriter().applyDslPropertiesElement(this);
        this.myProperties.removeElements(GradleDslElement::delete);
        this.maybeCreateNewElementsFromApplied();
        this.myProperties.createElements(e -> e.create() != null);
        this.myProperties.applyElements(e -> {
            if (e.isModified()) {
                e.applyChanges();
            }
        });
        this.myProperties.forEach(item -> {
            if (item.myElementState == ElementState.MOVED) {
                item.myElement.move();
            }
        });
    }

    private void maybeCreateNewElementsFromApplied() {
        ArrayList<GradleDslSimpleExpression> additionalElements = new ArrayList<GradleDslSimpleExpression>();
        for (ElementList.ElementItem elementItem : this.myProperties.myElements) {
            GradleDslElement element = elementItem.myElement;
            if (elementItem.myElementState != ElementState.APPLIED || !element.isModified() || this.isNativeElementForFile(element) || !(element instanceof GradleDslSimpleExpression)) continue;
            GradleDslSimpleExpression expression = (GradleDslSimpleExpression)element;
            additionalElements.add(expression.copy());
            element.resetState();
        }
        for (GradleDslElement gradleDslElement : additionalElements) {
            this.myProperties.addElement(gradleDslElement, ElementState.TO_BE_ADDED, false);
        }
    }

    private boolean isNativeElementForFile(GradleDslElement dslElement) {
        return this.isNativeElementForFile(dslElement, dslElement.getDslFile().getFile());
    }

    private boolean isNativeElementForFile(GradleDslElement dslElement, VirtualFile file) {
        if (dslElement instanceof GradleDslFile) {
            GradleDslFile dslFile = (GradleDslFile)dslElement;
            return dslFile.getFile().equals(file);
        }
        if (this.myParent != null) {
            return this.isNativeElementForFile(dslElement.getParent(), file);
        }
        return false;
    }

    @Override
    protected void reset() {
        this.myProperties.reset();
    }

    protected void clear() {
        this.myProperties.clear();
    }

    public int reorderAndMaybeGetNewIndex(@NotNull GradleDslElement element) {
        int result2 = this.sortElementsAndMaybeGetNewIndex(element);
        element.resolve();
        return result2;
    }

    private int sortElementsAndMaybeGetNewIndex(@NotNull GradleDslElement element) {
        List<GradleDslElement> currentElements = this.myProperties.getElementsWhere(e -> e.myElementState == ElementState.EXISTING || e.myElementState == ElementState.TO_BE_ADDED);
        ArrayList<GradleDslElement> sortedElements = new ArrayList<GradleDslElement>();
        boolean result2 = ElementSort.create(this, element).sort(currentElements, sortedElements);
        int resultIndex = this.myProperties.myElements.size();
        if (!result2) {
            this.notification(NotificationTypeReference.PROPERTY_PLACEMENT);
            return resultIndex;
        }
        int i = 0;
        int j = 0;
        while (i < currentElements.size() && j < sortedElements.size()) {
            if (currentElements.get(i) == sortedElements.get(i)) {
                ++i;
                ++j;
                continue;
            }
            if (sortedElements.get(i) == element && !currentElements.contains(element)) {
                resultIndex = i;
                ++j;
                continue;
            }
            this.moveElementTo(i, (GradleDslElement)sortedElements.get(j));
            ++i;
            ++j;
        }
        return resultIndex;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependencies() {
        return this.getAllElements().stream().map(GradleDslElement::getDependencies).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @VisibleForTesting
    public boolean isApplied(@NotNull GradleDslElement element) {
        for (ElementList.ElementItem item : this.myProperties.myElements) {
            if (item.myElement != element) continue;
            return item.myElementState == ElementState.APPLIED;
        }
        throw new IllegalStateException("Element not found in parent");
    }

    void updateAppliedState(@NotNull GradleDslElement element) {
        for (ElementList.ElementItem item : this.myProperties.myElements) {
            if (item.myElement != element) continue;
            if (item.myElementState == ElementState.APPLIED) {
                item.myElementState = ElementState.TO_BE_ADDED;
            }
            return;
        }
        LOG.warn((Throwable)new IllegalStateException("Element " + element + " not found in parent " + this));
    }

    protected static class ElementList {
        @NotNull
        private final List<ElementItem> myElements = new ArrayList<ElementItem>();

        private void forEach(@NotNull Consumer<ElementItem> func) {
            this.myElements.forEach(func);
        }

        @NotNull
        private List<GradleDslElement> getElementsWhere(@NotNull Predicate<ElementItem> predicate) {
            return this.myElements.stream().filter(e -> e.myElementState.isSemanticallyRelevant()).filter(predicate).map(e -> e.myElement).collect(Collectors.toList());
        }

        @Nullable
        public GradleDslElement getElementWhere(@NotNull Predicate<ElementItem> predicate) {
            ModelEffectDescription effect;
            GradleDslElement last = this.myElements.stream().filter(e -> e.myElementState.isSemanticallyRelevant()).filter(predicate).map(e -> e.myElement).reduce((first, second) -> second).orElse(null);
            if (last != null && (effect = last.getModelEffect()) != null && effect.semantics == MethodSemanticsDescription.RESET) {
                return null;
            }
            return last;
        }

        @Nullable
        public GradleDslElement getElementBeforeChildWhere(@NotNull Predicate<ElementItem> predicate, @NotNull GradleDslElement child, boolean includeSelf) {
            GradleDslElement lastElement = null;
            for (ElementItem i : this.myElements) {
                if (!i.myElementState.isSemanticallyRelevant()) continue;
                if (predicate.test(i) && (includeSelf || child != i.myElement)) {
                    lastElement = i.myElement;
                }
                if (i.myElement != child) continue;
                return lastElement;
            }
            return lastElement;
        }

        public void addElement(@NotNull GradleDslElement newElement, @NotNull ElementState state2, boolean onFile) {
            this.myElements.add(new ElementItem(newElement, state2, onFile));
        }

        private void addElementAtIndex(@NotNull GradleDslElement newElement, @NotNull ElementState state2, int index, boolean onFile) {
            this.myElements.add(this.getRealIndex(index, newElement), new ElementItem(newElement, state2, onFile));
        }

        private void moveElementToIndex(@NotNull GradleDslElement element, int index) {
            ElementItem item = this.myElements.stream().filter(e -> e.myElement == element).findFirst().orElse(null);
            if (item == null) {
                return;
            }
            this.myElements.remove(item);
            ElementList.moveElementTree(item);
            this.myElements.add(this.getRealIndex(index, element), item);
        }

        private int getRealIndex(int index, @NotNull GradleDslElement element) {
            if (index <= 0) {
                return 0;
            }
            for (int i = 0; i < this.myElements.size(); ++i) {
                if (index == 0) {
                    return i;
                }
                ElementItem item = this.myElements.get(i);
                if (!item.myElementState.isPhysicalInFile()) continue;
                --index;
            }
            return this.myElements.size();
        }

        @Nullable
        private ElementState remove(@NotNull GradleDslElement element) {
            ElementItem item = this.myElements.stream().filter(e -> element == e.myElement).findFirst().orElse(null);
            if (item == null) {
                return null;
            }
            ElementState oldState = item.myElementState;
            item.myElementState = ElementState.TO_BE_REMOVED;
            return oldState;
        }

        @Nullable
        private ElementState hide(@NotNull GradleDslElement element) {
            ElementItem item = this.myElements.stream().filter(e -> element == e.myElement).findFirst().orElse(null);
            if (item == null) {
                return null;
            }
            ElementState oldState = item.myElementState;
            item.myElementState = ElementState.HIDDEN;
            return oldState;
        }

        @Nullable
        private ElementState replaceElement(@Nullable GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
            for (int i = 0; i < this.myElements.size(); ++i) {
                ElementItem item = this.myElements.get(i);
                if (oldElement != item.myElement) continue;
                ElementState oldState = item.myElementState;
                item.myElementState = ElementState.TO_BE_REMOVED;
                ElementState newState2 = ElementState.TO_BE_ADDED;
                if (Arrays.asList(ElementState.APPLIED, ElementState.HIDDEN).contains((Object)oldState)) {
                    newState2 = oldState;
                }
                this.myElements.add(i, new ElementItem(newElement, newState2, false));
                return oldState;
            }
            return null;
        }

        @Nullable
        private ElementState substituteElement(@Nullable GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
            for (ElementItem item : this.myElements) {
                if (oldElement != item.myElement) continue;
                item.myElement = newElement;
                if (newElement.getPsiElement() == null) {
                    item.myElementState = ElementState.TO_BE_ADDED;
                    item.myExistsOnFile = false;
                } else {
                    item.myElementState = ElementState.EXISTING;
                    item.myExistsOnFile = true;
                }
                return item.myElementState;
            }
            return null;
        }

        @NotNull
        private @Unmodifiable List<GradleDslElement> removeAll(@NotNull Predicate<ElementItem> filter2) {
            List<ElementItem> toBeRemoved = this.myElements.stream().filter(filter2).collect(Collectors.toList());
            toBeRemoved.forEach((? super T e) -> {
                e.myElementState = ElementState.TO_BE_REMOVED;
            });
            return ContainerUtil.map(toBeRemoved, e -> e.myElement);
        }

        private boolean isEmpty() {
            return this.myElements.isEmpty();
        }

        private void reset() {
            LinkedHashSet<String> seen = new LinkedHashSet<String>();
            Iterator<ElementItem> i = this.myElements.iterator();
            while (i.hasNext()) {
                ElementItem item = i.next();
                item.myElement.resetState();
                if (item.myElementState == ElementState.TO_BE_REMOVED) {
                    item.myElementState = ElementState.EXISTING;
                }
                if (item.myElementState == ElementState.EXISTING) {
                    seen.add(item.myElement.getName());
                }
                if (item.myElementState == ElementState.TO_BE_ADDED) {
                    i.remove();
                }
                if (item.myElementState != ElementState.DEFAULT || !seen.contains(item.myElement.getName())) continue;
                i.remove();
            }
        }

        private void removeElements(@NotNull Consumer<GradleDslElement> removeFunc) {
            Iterator<ElementItem> i = this.myElements.iterator();
            while (i.hasNext()) {
                ElementItem item = i.next();
                if (item.myElementState != ElementState.TO_BE_REMOVED) continue;
                removeFunc.accept(item.myElement);
                i.remove();
            }
        }

        private void createElements(@NotNull Predicate<GradleDslElement> addFunc) {
            Iterator<ElementItem> i = this.myElements.iterator();
            while (i.hasNext()) {
                ElementItem item = i.next();
                if (item.myElementState == ElementState.DEFAULT && !item.isDefaultElement()) {
                    item.myElementState = ElementState.TO_BE_ADDED;
                }
                if (item.myElementState != ElementState.TO_BE_ADDED) continue;
                if (addFunc.test(item.myElement)) {
                    item.myElementState = ElementState.EXISTING;
                    continue;
                }
                i.remove();
            }
        }

        private void applyElements(@NotNull Consumer<GradleDslElement> func) {
            this.myElements.stream().map(e -> e.myElement).forEach(func);
        }

        private void clear() {
            this.myElements.clear();
        }

        private static void moveElementTree(@NotNull ElementItem item) {
            if (item.myElementState != ElementState.TO_BE_ADDED) {
                item.myElementState = ElementState.MOVED;
            }
            item.myElement.setModified();
        }

        public static class ElementItem {
            @NotNull
            private GradleDslElement myElement;
            @NotNull
            private ElementState myElementState;
            private boolean myExistsOnFile;

            private ElementItem(@NotNull GradleDslElement element, @NotNull ElementState state2, boolean existsOnFile) {
                this.myElement = element;
                this.myElementState = state2;
                this.myExistsOnFile = existsOnFile;
            }

            private boolean isDefaultElement() {
                return this.myElementState == ElementState.DEFAULT && this.myElement.isInsignificantIfEmpty() && this.myElement instanceof GradlePropertiesDslElement && ((GradlePropertiesDslElement)this.myElement).getCurrentElements().isEmpty();
            }
        }
    }
}

