/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.plugin;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.model.IdeAndroidProjectType;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.util.BuildFileProcessor;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPluginInfo {
    public static final String APPLICATION_PLUGIN_ID = "com.android.application";
    public static final String DESCRIPTION = "Android Gradle plugin";
    public static final String ARTIFACT_ID = "gradle";
    public static final String API_ARTIFACT_ID = "gradle-api";
    public static final String GROUP_ID = "com.android.tools.build";
    @NotNull
    private final Module myModule;
    @Nullable
    private final AgpVersion myPluginVersion;
    @Nullable
    private final VirtualFile myPluginBuildFile;

    @Slow
    @Nullable
    public static AndroidPluginInfo find(@NotNull Project project) {
        AndroidPluginInfo modelPluginInfo = AndroidPluginInfo.findFromModel(project);
        if (modelPluginInfo != null && modelPluginInfo.getPluginVersion() != null) {
            return modelPluginInfo;
        }
        AndroidPluginInfo buildPluginInfo = AndroidPluginInfo.findInBuildFiles(project, modelPluginInfo == null ? null : modelPluginInfo.getModule());
        return buildPluginInfo == null ? modelPluginInfo : buildPluginInfo;
    }

    @Slow
    @Nullable
    public static AndroidPluginInfo findFromBuildFiles(@NotNull Project project) {
        return AndroidPluginInfo.findInBuildFiles(project, null);
    }

    @Nullable
    public static AndroidPluginInfo findFromModel(@NotNull Project project) {
        return (AndroidPluginInfo)ReadAction.compute(() -> {
            for (AndroidFacet facet : ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID)) {
                AgpVersion agpVersion;
                String agpStringVersion;
                GradleModuleModel gradleModuleModel;
                GradleFacet gradleFacet;
                GradleAndroidModel gradleAndroidModel;
                Module module = facet.getModule();
                if (!LinkedAndroidModuleGroupUtilsKt.isHolderModule(module) || (gradleAndroidModel = GradleAndroidModel.get(facet)) == null || gradleAndroidModel.getAndroidProject().getProjectType() != IdeAndroidProjectType.PROJECT_TYPE_APP || (gradleFacet = GradleFacet.getInstance(module)) == null || (gradleModuleModel = gradleFacet.getGradleModuleModel()) == null || (agpStringVersion = gradleModuleModel.getAgpVersion()) == null || (agpVersion = AgpVersion.tryParse((String)agpStringVersion)) == null) continue;
                return new AndroidPluginInfo(module, agpVersion, null);
            }
            return null;
        });
    }

    @Slow
    @Nullable
    public static VirtualFile findPluginBuildFile(@NotNull Project project) {
        return (VirtualFile)ReadAction.compute(() -> {
            BuildFileSearchResult result2 = AndroidPluginInfo.searchInBuildFiles(project, true);
            return result2.pluginVirtualFile;
        });
    }

    @Slow
    @Nullable
    private static AndroidPluginInfo findInBuildFiles(@NotNull Project project, @Nullable Module appModule) {
        return (AndroidPluginInfo)ReadAction.compute(() -> {
            Module fileAppModule = null;
            BuildFileSearchResult result2 = AndroidPluginInfo.searchInBuildFiles(project, appModule == null);
            if (result2.appVirtualFile != null) {
                fileAppModule = ModuleUtilCore.findModuleForFile((VirtualFile)result2.appVirtualFile, (Project)project);
            }
            if (fileAppModule != null || appModule != null) {
                AgpVersion pluginVersion = StringUtil.isNotEmpty((String)result2.pluginVersion) ? AgpVersion.tryParse((String)result2.pluginVersion) : null;
                return new AndroidPluginInfo(fileAppModule == null ? appModule : fileAppModule, pluginVersion, result2.pluginVirtualFile);
            }
            return null;
        });
    }

    @Slow
    @NotNull
    private static BuildFileSearchResult searchInBuildFiles(@NotNull Project project, boolean searchForAppModule) {
        BuildFileSearchResult result2 = new BuildFileSearchResult();
        boolean[] keepSearchingForAppModule = new boolean[]{searchForAppModule};
        boolean[] keepSearchingForPluginVersion = new boolean[]{true};
        BiConsumer<List, VirtualFile> searchForPluginVersion = (pluginModels, virtualFile) -> {
            for (PluginModel pluginModel : pluginModels) {
                String version2;
                if (!AndroidPluginInfo.isAndroidPluginId(pluginModel.name().forceString()) || !StringUtil.isNotEmpty((String)(version2 = pluginModel.version().toString()))) continue;
                result2.pluginVirtualFile = virtualFile;
                result2.pluginVersion = version2;
                keepSearchingForPluginVersion[0] = false;
                break;
            }
        };
        Processor settingsModelProcessor = settingsModel -> {
            if (keepSearchingForPluginVersion[0]) {
                searchForPluginVersion.accept(settingsModel.pluginManagement().plugins().plugins(), settingsModel.getVirtualFile());
            }
            return keepSearchingForAppModule[0] || keepSearchingForPluginVersion[0];
        };
        Processor buildModelProcessor = buildModel -> {
            List<String> pluginIds;
            if (keepSearchingForAppModule[0] && (pluginIds = PluginModel.extractNames(buildModel.appliedPlugins())).contains(APPLICATION_PLUGIN_ID)) {
                result2.appVirtualFile = buildModel.getVirtualFile();
                keepSearchingForAppModule[0] = false;
            }
            if (keepSearchingForPluginVersion[0]) {
                DependenciesModel dependencies2 = buildModel.buildscript().dependencies();
                for (ArtifactDependencyModel dependency : dependencies2.artifacts("classpath")) {
                    String version2;
                    if (!AndroidPluginInfo.isAndroidPlugin(dependency.name().forceString(), dependency.group().toString()) || !StringUtil.isNotEmpty((String)(version2 = dependency.version().toString()))) continue;
                    result2.pluginVirtualFile = buildModel.getVirtualFile();
                    result2.pluginVersion = version2;
                    keepSearchingForPluginVersion[0] = false;
                    break;
                }
            }
            if (keepSearchingForPluginVersion[0]) {
                searchForPluginVersion.accept(buildModel.plugins(), buildModel.getVirtualFile());
            }
            return keepSearchingForAppModule[0] || keepSearchingForPluginVersion[0];
        };
        BuildFileProcessor.processRecursively(project, (Processor<? super GradleSettingsModel>)settingsModelProcessor, (Processor<? super GradleBuildModel>)buildModelProcessor);
        return result2;
    }

    @VisibleForTesting
    public AndroidPluginInfo(@NotNull Module module, @Nullable AgpVersion pluginVersion, @Nullable VirtualFile pluginBuildFile) {
        this.myModule = module;
        this.myPluginVersion = pluginVersion;
        this.myPluginBuildFile = pluginBuildFile;
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @Nullable
    public AgpVersion getPluginVersion() {
        return this.myPluginVersion;
    }

    @Nullable
    public VirtualFile getPluginBuildFile() {
        return this.myPluginBuildFile;
    }

    public boolean isExperimental() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidPluginInfo that = (AndroidPluginInfo)o;
        return Objects.equals(this.myModule, that.myModule) && Objects.equals(this.myPluginVersion, that.myPluginVersion) && Objects.equals(this.myPluginBuildFile, that.myPluginBuildFile);
    }

    public int hashCode() {
        return Objects.hash(this.myModule, this.myPluginVersion, this.myPluginBuildFile);
    }

    public static boolean isAndroidPlugin(@NotNull String artifactId, @Nullable String groupId) {
        return ARTIFACT_ID.equals(artifactId) && GROUP_ID.equals(groupId);
    }

    public static boolean isAndroidPluginId(@NotNull String pluginId) {
        return pluginId.startsWith("com.android.");
    }

    public static boolean isAndroidPluginOrApi(@NotNull String artifactId, @Nullable String groupId) {
        return AndroidPluginInfo.isAndroidPlugin(artifactId, groupId) || API_ARTIFACT_ID.equals(artifactId) && GROUP_ID.equals(groupId);
    }

    private static class BuildFileSearchResult {
        @Nullable
        VirtualFile appVirtualFile;
        @Nullable
        VirtualFile pluginVirtualFile;
        @Nullable
        String pluginVersion;

        private BuildFileSearchResult() {
        }
    }
}

