/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.android.tools.idea.gradle.project.importing.OpenMigrationToGradleUrlHyperlink;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LegacyAndroidProjects {
    @NonNls
    private static final String SHOW_MIGRATE_TO_GRADLE_POPUP = "show.migrate.to.gradle.popup";
    @NotNull
    private final Project myProject;

    LegacyAndroidProjects(@NotNull Project project) {
        this.myProject = project;
    }

    @Nullable
    private static String getPackageNameInLegacyIdeaAndroidModule(@NotNull AndroidFacet facet) {
        Manifest manifest = Manifest.getMainManifest(facet);
        return manifest != null ? (String)manifest.getPackage().getValue() : null;
    }

    void showMigrateToGradleWarning() {
        this.trackProject();
        if (!this.shouldShowMigrateToGradleNotification()) {
            return;
        }
        String errMsg = "This project does not use the Gradle build system. We recommend that you migrate to using the Gradle build system.";
        NotificationHyperlink doNotShowAgainHyperlink = new NotificationHyperlink("do.not.show", "Don't show this message again."){

            protected void execute(@NotNull Project project) {
                PropertiesComponent.getInstance((Project)LegacyAndroidProjects.this.myProject).setValue(LegacyAndroidProjects.SHOW_MIGRATE_TO_GRADLE_POPUP, "false");
            }
        };
        AndroidNotification notification = AndroidNotification.getInstance((Project)this.myProject);
        notification.showBalloon("Migrate Project to Gradle?", errMsg, NotificationType.WARNING, new NotificationHyperlink[]{new OpenMigrationToGradleUrlHyperlink().setCloseOnClick(true), doNotShowAgainHyperlink});
    }

    void trackProject() {
        if (!AnalyticsSettings.getOptedIn()) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            String packageName = null;
            for (AndroidFacet facet : ProjectSystemUtil.getAndroidFacets(this.myProject)) {
                if (facet != null && !AndroidModel.isRequired(facet)) {
                    String modulePackageName;
                    if (((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject()) {
                        packageName = LegacyAndroidProjects.getPackageNameInLegacyIdeaAndroidModule(facet);
                        if (packageName != null) {
                            break;
                        }
                    } else if (packageName == null && (modulePackageName = LegacyAndroidProjects.getPackageNameInLegacyIdeaAndroidModule(facet)) != null) {
                        packageName = modulePackageName;
                    }
                }
                if (packageName == null) continue;
                AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
                event.setCategory(AndroidStudioEvent.EventCategory.GRADLE).setKind(AndroidStudioEvent.EventKind.LEGACY_IDEA_ANDROID_PROJECT);
                UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(event, this.myProject));
            }
        });
    }

    private boolean shouldShowMigrateToGradleNotification() {
        return PropertiesComponent.getInstance((Project)this.myProject).getBoolean(SHOW_MIGRATE_TO_GRADLE_POPUP, true);
    }
}

