/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleBridgeImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.idea.core.script.KotlinScriptEntitySource;

public class SupportedModuleChecker {
    @NotNull
    public static SupportedModuleChecker getInstance() {
        return (SupportedModuleChecker)ApplicationManager.getApplication().getService(SupportedModuleChecker.class);
    }

    public void checkForSupportedModules(@NotNull Project project) {
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (modules.length == 0 || !(ProjectSystemUtil.getProjectSystem(project) instanceof GradleProjectSystem)) {
            return;
        }
        ArrayList<Module> unsupportedModules = new ArrayList<Module>();
        boolean androidGradleSeen = false;
        for (Module module : modules) {
            ModuleType moduleType;
            if (this.isKotlinScriptModule(module) || !((moduleType = ModuleType.get((Module)module)) instanceof JavaModuleType)) continue;
            String externalSystemId = ExternalSystemModulePropertyManager.getInstance((Module)module).getExternalSystemId();
            if (!GradleProjectSystemUtil.GRADLE_SYSTEM_ID.getId().equals(externalSystemId)) {
                unsupportedModules.add(module);
                continue;
            }
            androidGradleSeen = true;
        }
        if (!androidGradleSeen || unsupportedModules.isEmpty()) {
            return;
        }
        this.displayUnsupportedModulesNotification(project, unsupportedModules);
    }

    private boolean isKotlinScriptModule(@NotNull Module module) {
        ModuleBridgeImpl moduleBridge = (ModuleBridgeImpl)module;
        ModuleEntity resolved = (ModuleEntity)moduleBridge.getEntityStorage().getCurrent().resolve((SymbolicEntityId)moduleBridge.getModuleEntityId());
        if (resolved == null) {
            return false;
        }
        return resolved.getEntitySource() instanceof KotlinScriptEntitySource;
    }

    private void displayUnsupportedModulesNotification(Project project, List<Module> unsupportedModules) {
        String moduleNames = StringUtil.join(unsupportedModules, Module::getName, (String)", ");
        String notificationTitle = AndroidBundle.message("project.sync.unsupported.modules.detected.title", new Object[0]);
        String notificationMessage = AndroidBundle.message("project.sync.unsupported.modules.detected.message", moduleNames);
        String notificationButton = AndroidBundle.message("project.sync.unsupported.modules.detected.button", new Object[0]);
        ModulePointerManager modulePointerManager = ModulePointerManager.getInstance((Project)project);
        List<ModulePointer> unsupportedModulePointers = unsupportedModules.stream().map(arg_0 -> ((ModulePointerManager)modulePointerManager).create(arg_0)).toList();
        UnsupportedModulesQuickFix unsupportedModulesQuickFix = new UnsupportedModulesQuickFix(notificationButton, unsupportedModulePointers);
        AndroidNotification.getInstance((Project)project).showBalloon(notificationTitle, notificationMessage, NotificationType.ERROR, new NotificationHyperlink[]{unsupportedModulesQuickFix});
    }

    @VisibleForTesting
    static class UnsupportedModulesQuickFix
    extends NotificationHyperlink {
        private final List<ModulePointer> unsupportedModules;

        @VisibleForTesting
        public Stream<Module> getUnsupportedModules() {
            return this.unsupportedModules.stream().map(ModulePointer::getModule).filter(Objects::nonNull);
        }

        protected UnsupportedModulesQuickFix(String text2, List<ModulePointer> unsupportedModules) {
            super("unsupported.modules.quick.fix", text2);
            this.unsupportedModules = unsupportedModules;
        }

        public boolean executeIfClicked(@NotNull Project project, @NotNull HyperlinkEvent event) {
            this.execute(project);
            return false;
        }

        protected void execute(@NotNull Project project) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                ModifiableModuleModel modifiableModule = moduleManager.getModifiableModel();
                this.getUnsupportedModules().forEach(arg_0 -> ((ModifiableModuleModel)modifiableModule).disposeModule(arg_0));
                modifiableModule.commit();
            });
            ProjectSystemService.getInstance(project).getProjectSystem().getSyncManager().requestSyncProject(new ProjectSystemSyncManager.SyncReason(GradleSyncStats.Trigger.TRIGGER_QF_REMOVE_UNSUPPORTED_MODULES));
        }
    }
}

