/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output;

import com.android.tools.idea.gradle.project.sync.idea.issues.ErrorMessageAwareBuildIssue;
import com.android.utils.FileUtils;
import com.google.wireless.android.sdk.stats.BuildErrorMessage;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.BuildIssueEvent;
import com.intellij.build.events.FileMessageEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.issue.BuildIssue;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\"\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"toBuildErrorMessage", "Lcom/google/wireless/android/sdk/stats/BuildErrorMessage;", "buildEvent", "Lcom/intellij/build/events/BuildEvent;", "toolNameToEnumMap", "", "", "Lcom/google/wireless/android/sdk/stats/BuildErrorMessage$ErrorType;", "findErrorTypeByGroup", "messageGroup", "getFileType", "Lcom/google/wireless/android/sdk/stats/BuildErrorMessage$FileType;", "file", "Ljava/io/File;", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nBuildOutputErrorsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildOutputErrorsListener.kt\ncom/android/tools/idea/gradle/project/build/output/BuildOutputErrorsListenerKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,118:1\n487#2,7:119\n*S KotlinDebug\n*F\n+ 1 BuildOutputErrorsListener.kt\ncom/android/tools/idea/gradle/project/build/output/BuildOutputErrorsListenerKt\n*L\n104#1:119,7\n*E\n"})
public final class BuildOutputErrorsListenerKt {
    @NotNull
    private static final Map<String, BuildErrorMessage.ErrorType> toolNameToEnumMap;

    @Nullable
    public static final BuildErrorMessage toBuildErrorMessage(@NotNull BuildEvent buildEvent) {
        Intrinsics.checkNotNullParameter((Object)buildEvent, (String)"buildEvent");
        if (!(buildEvent instanceof MessageEvent) || ((MessageEvent)buildEvent).getKind() != MessageEvent.Kind.ERROR) {
            return null;
        }
        if (buildEvent instanceof BuildIssueEvent) {
            BuildIssue buildIssue2 = ((BuildIssueEvent)buildEvent).getIssue();
            Intrinsics.checkNotNullExpressionValue((Object)buildIssue2, (String)"getIssue(...)");
            BuildIssue issue2 = buildIssue2;
            if (issue2 instanceof ErrorMessageAwareBuildIssue) {
                return ((ErrorMessageAwareBuildIssue)issue2).getBuildErrorMessage();
            }
        }
        BuildErrorMessage.Builder builder = BuildErrorMessage.newBuilder();
        String string = ((MessageEvent)buildEvent).getGroup();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroup(...)");
        BuildErrorMessage.ErrorType errorType = BuildOutputErrorsListenerKt.findErrorTypeByGroup(string);
        if (errorType != null) {
            BuildErrorMessage.ErrorType it = errorType;
            boolean bl = false;
            builder.setErrorShownType(it);
        }
        if (buildEvent instanceof FileMessageEvent) {
            builder.setFileLocationIncluded(true);
            File file = ((FileMessageEvent)buildEvent).getFilePosition().getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            builder.setFileIncludedType(BuildOutputErrorsListenerKt.getFileType(file));
            if (((FileMessageEvent)buildEvent).getFilePosition().getStartLine() >= 0) {
                builder.setLineLocationIncluded(true);
            }
        }
        return builder.build();
    }

    private static final BuildErrorMessage.ErrorType findErrorTypeByGroup(String messageGroup) {
        Map<String, BuildErrorMessage.ErrorType> $this$filterKeys$iv = toolNameToEnumMap;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, BuildErrorMessage.ErrorType> result$iv = new LinkedHashMap<String, BuildErrorMessage.ErrorType>();
        for (Map.Entry<String, BuildErrorMessage.ErrorType> entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = entry$iv.getKey();
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)messageGroup, (String)it, (boolean)false, (int)2, null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return (BuildErrorMessage.ErrorType)CollectionsKt.firstOrNull((Iterable)((Map)result$iv).values());
    }

    private static final BuildErrorMessage.FileType getFileType(File file) {
        block3: {
            block2: {
                String filePath = file.isAbsolute() ? file.getAbsolutePath() : file.getPath();
                Intrinsics.checkNotNull((Object)filePath);
                CharSequence charSequence = filePath;
                char c = File.separatorChar;
                String[] stringArray = new String[]{"build", "generated"};
                String string = FileUtils.join((String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
                String string2 = string;
                if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)(c + string2 + File.separatorChar), (boolean)false, (int)2, null)) break block2;
                CharSequence charSequence2 = filePath;
                c = File.separatorChar;
                stringArray = new String[]{"build", "intermediates"};
                String string3 = FileUtils.join((String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"join(...)");
                string2 = string3;
                if (!StringsKt.contains$default((CharSequence)charSequence2, (CharSequence)(c + string2 + File.separatorChar), (boolean)false, (int)2, null)) break block3;
            }
            return BuildErrorMessage.FileType.BUILD_GENERATED_FILE;
        }
        return BuildErrorMessage.FileType.PROJECT_FILE;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Compiler", (Object)BuildErrorMessage.ErrorType.JAVA_COMPILER), TuplesKt.to((Object)"Kotlin Compiler", (Object)BuildErrorMessage.ErrorType.KOTLIN_COMPILER), TuplesKt.to((Object)"Clang Compiler", (Object)BuildErrorMessage.ErrorType.CLANG), TuplesKt.to((Object)"CMake", (Object)BuildErrorMessage.ErrorType.CMAKE), TuplesKt.to((Object)"Data Binding compiler", (Object)BuildErrorMessage.ErrorType.DATA_BINDING), TuplesKt.to((Object)"Xml parsing", (Object)BuildErrorMessage.ErrorType.XML_PARSER), TuplesKt.to((Object)"AAPT", (Object)BuildErrorMessage.ErrorType.AAPT), TuplesKt.to((Object)"D8", (Object)BuildErrorMessage.ErrorType.D8), TuplesKt.to((Object)"R8", (Object)BuildErrorMessage.ErrorType.R8), TuplesKt.to((Object)"Resource and asset merger", (Object)BuildErrorMessage.ErrorType.RESOURCE_AND_ASSET_MERGER), TuplesKt.to((Object)"Android Gradle Plugin", (Object)BuildErrorMessage.ErrorType.GENERAL_ANDROID_GRADLE_PLUGIN)};
        toolNameToEnumMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

