/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output;

import com.android.tools.idea.gradle.project.build.output.BuildOutputParserUtils;
import com.android.tools.idea.gradle.project.build.output.DescribedOpenGradleJdkSettingsQuickfix;
import com.android.tools.idea.gradle.project.build.quickFixes.OpenBuildJdkInfoLinkQuickFix;
import com.android.tools.idea.gradle.project.build.quickFixes.PickLanguageLevelInPSDQuickFix;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.quickFixes.SetJavaLanguageLevelAllQuickFix;
import com.android.tools.idea.gradle.project.sync.quickFixes.SetJavaToolchainQuickFix;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.google.wireless.android.sdk.stats.BuildErrorMessage;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.lang.JavaVersion;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00100\u000fH\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/JavaLanguageLevelDeprecationOutputParser;", "Lcom/intellij/build/output/BuildOutputParser;", "<init>", "()V", "obsoletePattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "notSupportedPattern", "parse", "", "line", "", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "parseLines", "Lcom/android/tools/idea/gradle/project/build/output/JavaLanguageLevelDeprecationOutputParser$ParsingResult;", "firstLine", "Companion", "ParsingResult", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nJavaLanguageLevelDeprecationOutputParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaLanguageLevelDeprecationOutputParser.kt\ncom/android/tools/idea/gradle/project/build/output/JavaLanguageLevelDeprecationOutputParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,244:1\n1#2:245\n*E\n"})
public final class JavaLanguageLevelDeprecationOutputParser
implements BuildOutputParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Pattern obsoletePattern = Pattern.compile("warning: \\[options] (source|target) value (\\S+) is obsolete and will be removed in a future release");
    private final Pattern notSupportedPattern = Pattern.compile("error: (Source|Target) option (\\S+) is no longer supported\\. Use (\\S+) or later\\.");
    private static final Pattern notSupportedMessagePattern = Pattern.compile("(Source|Target) option (\\S+) is no longer supported\\. Use (\\S+) or later\\.");
    private static final Pattern javaVersionRemovedPattern = Pattern.compile("Java compiler version (\\d+) has removed support for compiling with source/target version (\\d+)\\.?");

    public boolean parse(@NotNull String line, @NotNull BuildOutputInstantReader reader2, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        ParsingResult parsingResult = this.parseLines(line, reader2);
        if (parsingResult == null) {
            return false;
        }
        ParsingResult parseResult = parsingResult;
        BuildIssue issue2 = Companion.composeBuildIssue(parseResult.getTitle(), parseResult.getTitle(), parseResult.getModulePath(), parseResult.getSuggestedToolchainVersion(), parseResult.getSuggestedLanguageLevel());
        messageConsumer.accept((BuildEvent)new BuildIssueEventImpl(reader2.getParentEventId(), issue2, parseResult.getKind()));
        return true;
    }

    @VisibleForTesting
    @Nullable
    public final ParsingResult parseLines(@NotNull String firstLine, @NotNull BuildOutputInstantReader reader2) {
        String string;
        JavaVersion minimumVersionSecondLine;
        JavaVersion minimumVersionFirstLine;
        Object currentVersionSecondLineText;
        Object currentVersionFirstLineText;
        MessageEvent.Kind matchedKind;
        block21: {
            Pair<String, String> pair;
            block18: {
                block19: {
                    String secondLine;
                    block20: {
                        Pair<String, String> secondResult;
                        Pair<String, String> pair2;
                        Pair<String, String> firstResult;
                        block17: {
                            Pair<String, String> pair3;
                            block14: {
                                block15: {
                                    block16: {
                                        Intrinsics.checkNotNullParameter((Object)firstLine, (String)"firstLine");
                                        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
                                        matchedKind = null;
                                        currentVersionFirstLineText = null;
                                        currentVersionSecondLineText = null;
                                        minimumVersionFirstLine = null;
                                        minimumVersionSecondLine = null;
                                        Pair<String, String> pair4 = JavaLanguageLevelDeprecationOutputParser.parseLines$tryParseWarningLine(this, firstLine);
                                        if (pair4 == null) break block14;
                                        firstResult = pair4;
                                        boolean bl = false;
                                        matchedKind = MessageEvent.Kind.WARNING;
                                        currentVersionFirstLineText = firstResult.getFirst();
                                        String string2 = reader2.readLine();
                                        if (string2 == null) break block15;
                                        secondLine = string2;
                                        boolean bl2 = false;
                                        pair3 = JavaLanguageLevelDeprecationOutputParser.parseLines$tryParseWarningLine(this, secondLine);
                                        if (pair3 == null) break block16;
                                        secondResult = pair2 = pair3;
                                        boolean bl3 = false;
                                        currentVersionSecondLineText = secondResult.getFirst();
                                        pair3 = pair2;
                                        if (pair3 != null) break block17;
                                    }
                                    reader2.pushBack();
                                    pair3 = Unit.INSTANCE;
                                    break block17;
                                }
                                pair3 = null;
                                break block17;
                            }
                            pair3 = null;
                        }
                        Pair<String, String> pair5 = JavaLanguageLevelDeprecationOutputParser.parseLines$tryParseErrorLine(this, firstLine);
                        if (pair5 == null) break block18;
                        firstResult = pair5;
                        boolean bl = false;
                        matchedKind = MessageEvent.Kind.ERROR;
                        currentVersionFirstLineText = firstResult.getFirst();
                        minimumVersionFirstLine = JavaVersion.tryParse((String)((String)firstResult.getSecond()));
                        String string3 = reader2.readLine();
                        if (string3 == null) break block19;
                        secondLine = string3;
                        boolean bl4 = false;
                        pair = JavaLanguageLevelDeprecationOutputParser.parseLines$tryParseWarningLine(this, secondLine);
                        if (pair == null) break block20;
                        secondResult = pair2 = pair;
                        boolean bl5 = false;
                        currentVersionSecondLineText = secondResult.getFirst();
                        pair = pair2;
                        if (pair != null) break block21;
                    }
                    Pair<String, String> pair6 = JavaLanguageLevelDeprecationOutputParser.parseLines$tryParseErrorLine(this, secondLine);
                    if (pair6 != null) {
                        Pair<String, String> pair7;
                        Pair<String, String> secondResult = pair7 = pair6;
                        boolean bl = false;
                        currentVersionSecondLineText = secondResult.getFirst();
                        minimumVersionSecondLine = JavaVersion.tryParse((String)((String)secondResult.getSecond()));
                        pair = pair7;
                    } else {
                        reader2.pushBack();
                        pair = Unit.INSTANCE;
                    }
                    break block21;
                }
                pair = null;
                break block21;
            }
            pair = null;
        }
        MessageEvent.Kind kind = matchedKind;
        if (kind == null) {
            return null;
        }
        MessageEvent.Kind kind2 = kind;
        String string4 = reader2.readLine();
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)"warning: [options] To suppress warnings about obsolete options, use -Xlint:-options.")) {
                reader2.pushBack();
            }
        }
        Integer suggestedToolchainVersion = Companion.suggestedToolchainVersionFromCurrent(JavaVersion.tryParse((String)((String)currentVersionFirstLineText)));
        LanguageLevel suggestedLanguageLevel = currentVersionSecondLineText != null ? Companion.suggestedLanguageLevelFromCurrentAndMinimum(JavaVersion.tryParse((String)((String)currentVersionSecondLineText)), minimumVersionSecondLine) : Companion.suggestedLanguageLevelFromCurrentAndMinimum(JavaVersion.tryParse((String)((String)currentVersionFirstLineText)), minimumVersionFirstLine);
        Object object = reader2.getParentEventId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getParentEventId(...)");
        String string5 = BuildOutputParserUtils.INSTANCE.extractTaskNameFromId(object);
        if (string5 == null) {
            return null;
        }
        String taskName = string5;
        String string6 = GradleProjectSystemUtil.getParentModulePath(taskName);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getParentModulePath(...)");
        String modulePath = string6;
        switch (WhenMappings.$EnumSwitchMapping$0[kind2.ordinal()]) {
            case 1: {
                string = "Java compiler has removed support for compiling with source/target compatibility version " + currentVersionFirstLineText + ".";
                break;
            }
            case 2: {
                string = "Java compiler has deprecated support for compiling with source/target compatibility version " + currentVersionFirstLineText + ".";
                break;
            }
            default: {
                return null;
            }
        }
        String title2 = string;
        return new ParsingResult(kind2, title2, suggestedToolchainVersion, suggestedLanguageLevel, modulePath);
    }

    private static final Pair<String, String> parseLines$tryParseErrorLine(JavaLanguageLevelDeprecationOutputParser this$0, String line) {
        Pair pair;
        Matcher matcher;
        Matcher matcher2;
        Matcher it = matcher2 = this$0.notSupportedPattern.matcher(line);
        boolean bl = false;
        Matcher matcher3 = matcher = it.matches() ? matcher2 : null;
        if (matcher != null) {
            it = matcher;
            boolean bl2 = false;
            pair = new Pair((Object)it.group(2), (Object)it.group(3));
        } else {
            pair = null;
        }
        return pair;
    }

    private static final Pair<String, String> parseLines$tryParseWarningLine(JavaLanguageLevelDeprecationOutputParser this$0, String line) {
        Pair pair;
        Matcher matcher;
        Matcher matcher2;
        Matcher it = matcher2 = this$0.obsoletePattern.matcher(line);
        boolean bl = false;
        Matcher matcher3 = matcher = it.matches() ? matcher2 : null;
        if (matcher != null) {
            it = matcher;
            boolean bl2 = false;
            pair = new Pair((Object)it.group(2), null);
        } else {
            pair = null;
        }
        return pair;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u0019\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u0018J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u001dR\u0019\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/JavaLanguageLevelDeprecationOutputParser$Companion;", "", "<init>", "()V", "notSupportedMessagePattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getNotSupportedMessagePattern", "()Ljava/util/regex/Pattern;", "javaVersionRemovedPattern", "getJavaVersionRemovedPattern", "composeBuildIssue", "Lcom/intellij/build/issue/BuildIssue;", "title", "", "message", "modulePath", "suggestedToolchainVersion", "", "suggestedLanguageLevel", "Lcom/intellij/pom/java/LanguageLevel;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Lcom/intellij/pom/java/LanguageLevel;)Lcom/intellij/build/issue/BuildIssue;", "suggestedLanguageLevelForCompiler", "compilerVersion", "Lcom/intellij/util/lang/JavaVersion;", "suggestedLanguageLevelFromCurrentAndMinimum", "currentVersion", "minimumVersion", "suggestedToolchainVersionFromCurrent", "(Lcom/intellij/util/lang/JavaVersion;)Ljava/lang/Integer;", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public final Pattern getNotSupportedMessagePattern() {
            return notSupportedMessagePattern;
        }

        public final Pattern getJavaVersionRemovedPattern() {
            return javaVersionRemovedPattern;
        }

        @NotNull
        public final BuildIssue composeBuildIssue(@NotNull String title2, @NotNull String message, @NotNull String modulePath, @Nullable Integer suggestedToolchainVersion, @NotNull LanguageLevel suggestedLanguageLevel) {
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
            Intrinsics.checkNotNullParameter((Object)suggestedLanguageLevel, (String)"suggestedLanguageLevel");
            BuildIssueComposer issueComposer = new BuildIssueComposer(message, title2);
            issueComposer.startNewParagraph();
            if (suggestedToolchainVersion != null) {
                issueComposer.addQuickFix(new SetJavaToolchainQuickFix(suggestedToolchainVersion, CollectionsKt.listOf((Object)modulePath)));
            }
            issueComposer.addQuickFix(new SetJavaLanguageLevelAllQuickFix(suggestedLanguageLevel, true));
            issueComposer.addQuickFix(new PickLanguageLevelInPSDQuickFix());
            issueComposer.addQuickFix(new DescribedOpenGradleJdkSettingsQuickfix());
            issueComposer.addQuickFix(new OpenBuildJdkInfoLinkQuickFix());
            BuildErrorMessage buildErrorMessage = BuildErrorMessage.newBuilder().setErrorShownType(BuildErrorMessage.ErrorType.JAVA_NOT_SUPPORTED_LANGUAGE_LEVEL).build();
            Intrinsics.checkNotNullExpressionValue((Object)buildErrorMessage, (String)"build(...)");
            return issueComposer.composeErrorMessageAwareBuildIssue(buildErrorMessage);
        }

        @NotNull
        public final LanguageLevel suggestedLanguageLevelForCompiler(@NotNull JavaVersion compilerVersion) {
            Intrinsics.checkNotNullParameter((Object)compilerVersion, (String)"compilerVersion");
            return compilerVersion.isAtLeast(21) ? LanguageLevel.JDK_11 : (compilerVersion.isAtLeast(17) ? LanguageLevel.JDK_1_8 : LanguageLevel.JDK_1_8);
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final LanguageLevel suggestedLanguageLevelFromCurrentAndMinimum(@Nullable JavaVersion currentVersion, @Nullable JavaVersion minimumVersion) {
            LanguageLevel languageLevel;
            LanguageLevel minimumLevel = LanguageLevel.parse((String)String.valueOf(minimumVersion));
            if (minimumLevel != null) {
                JavaVersion javaVersion = minimumVersion;
                Intrinsics.checkNotNull((Object)javaVersion);
                if (javaVersion.isAtLeast(8)) {
                    languageLevel = minimumLevel;
                    return languageLevel;
                }
            }
            if (currentVersion == null) {
                languageLevel = LanguageLevel.JDK_1_8;
                return languageLevel;
            }
            if (currentVersion.isAtLeast(8)) {
                languageLevel = LanguageLevel.JDK_11;
                return languageLevel;
            }
            languageLevel = LanguageLevel.JDK_1_8;
            return languageLevel;
        }

        @Nullable
        public final Integer suggestedToolchainVersionFromCurrent(@Nullable JavaVersion currentVersion) {
            return currentVersion == null ? null : (currentVersion.feature == 6 ? Integer.valueOf(8) : (currentVersion.feature == 7 ? Integer.valueOf(11) : (currentVersion.feature == 8 ? Integer.valueOf(17) : null)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003JB\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/JavaLanguageLevelDeprecationOutputParser$ParsingResult;", "", "kind", "Lcom/intellij/build/events/MessageEvent$Kind;", "title", "", "suggestedToolchainVersion", "", "suggestedLanguageLevel", "Lcom/intellij/pom/java/LanguageLevel;", "modulePath", "<init>", "(Lcom/intellij/build/events/MessageEvent$Kind;Ljava/lang/String;Ljava/lang/Integer;Lcom/intellij/pom/java/LanguageLevel;Ljava/lang/String;)V", "getKind", "()Lcom/intellij/build/events/MessageEvent$Kind;", "getTitle", "()Ljava/lang/String;", "getSuggestedToolchainVersion", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getSuggestedLanguageLevel", "()Lcom/intellij/pom/java/LanguageLevel;", "getModulePath", "component1", "component2", "component3", "component4", "component5", "copy", "(Lcom/intellij/build/events/MessageEvent$Kind;Ljava/lang/String;Ljava/lang/Integer;Lcom/intellij/pom/java/LanguageLevel;Ljava/lang/String;)Lcom/android/tools/idea/gradle/project/build/output/JavaLanguageLevelDeprecationOutputParser$ParsingResult;", "equals", "", "other", "hashCode", "toString", "intellij.android.projectSystem.gradle"})
    public static final class ParsingResult {
        @NotNull
        private final MessageEvent.Kind kind;
        @NotNull
        private final String title;
        @Nullable
        private final Integer suggestedToolchainVersion;
        @NotNull
        private final LanguageLevel suggestedLanguageLevel;
        @NotNull
        private final String modulePath;

        public ParsingResult(@NotNull MessageEvent.Kind kind, @NotNull String title2, @Nullable Integer suggestedToolchainVersion, @NotNull LanguageLevel suggestedLanguageLevel, @NotNull String modulePath) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            Intrinsics.checkNotNullParameter((Object)suggestedLanguageLevel, (String)"suggestedLanguageLevel");
            Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
            this.kind = kind;
            this.title = title2;
            this.suggestedToolchainVersion = suggestedToolchainVersion;
            this.suggestedLanguageLevel = suggestedLanguageLevel;
            this.modulePath = modulePath;
        }

        @NotNull
        public final MessageEvent.Kind getKind() {
            return this.kind;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @Nullable
        public final Integer getSuggestedToolchainVersion() {
            return this.suggestedToolchainVersion;
        }

        @NotNull
        public final LanguageLevel getSuggestedLanguageLevel() {
            return this.suggestedLanguageLevel;
        }

        @NotNull
        public final String getModulePath() {
            return this.modulePath;
        }

        @NotNull
        public final MessageEvent.Kind component1() {
            return this.kind;
        }

        @NotNull
        public final String component2() {
            return this.title;
        }

        @Nullable
        public final Integer component3() {
            return this.suggestedToolchainVersion;
        }

        @NotNull
        public final LanguageLevel component4() {
            return this.suggestedLanguageLevel;
        }

        @NotNull
        public final String component5() {
            return this.modulePath;
        }

        @NotNull
        public final ParsingResult copy(@NotNull MessageEvent.Kind kind, @NotNull String title2, @Nullable Integer suggestedToolchainVersion, @NotNull LanguageLevel suggestedLanguageLevel, @NotNull String modulePath) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            Intrinsics.checkNotNullParameter((Object)suggestedLanguageLevel, (String)"suggestedLanguageLevel");
            Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
            return new ParsingResult(kind, title2, suggestedToolchainVersion, suggestedLanguageLevel, modulePath);
        }

        public static /* synthetic */ ParsingResult copy$default(ParsingResult parsingResult, MessageEvent.Kind kind, String string, Integer n, LanguageLevel languageLevel, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                kind = parsingResult.kind;
            }
            if ((n2 & 2) != 0) {
                string = parsingResult.title;
            }
            if ((n2 & 4) != 0) {
                n = parsingResult.suggestedToolchainVersion;
            }
            if ((n2 & 8) != 0) {
                languageLevel = parsingResult.suggestedLanguageLevel;
            }
            if ((n2 & 0x10) != 0) {
                string2 = parsingResult.modulePath;
            }
            return parsingResult.copy(kind, string, n, languageLevel, string2);
        }

        @NotNull
        public String toString() {
            return "ParsingResult(kind=" + this.kind + ", title=" + this.title + ", suggestedToolchainVersion=" + this.suggestedToolchainVersion + ", suggestedLanguageLevel=" + this.suggestedLanguageLevel + ", modulePath=" + this.modulePath + ")";
        }

        public int hashCode() {
            int result2 = this.kind.hashCode();
            result2 = result2 * 31 + this.title.hashCode();
            result2 = result2 * 31 + (this.suggestedToolchainVersion == null ? 0 : ((Object)this.suggestedToolchainVersion).hashCode());
            result2 = result2 * 31 + this.suggestedLanguageLevel.hashCode();
            result2 = result2 * 31 + this.modulePath.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsingResult)) {
                return false;
            }
            ParsingResult parsingResult = (ParsingResult)other;
            if (this.kind != parsingResult.kind) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.title, (Object)parsingResult.title)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.suggestedToolchainVersion, (Object)parsingResult.suggestedToolchainVersion)) {
                return false;
            }
            if (this.suggestedLanguageLevel != parsingResult.suggestedLanguageLevel) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.modulePath, (Object)parsingResult.modulePath);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageEvent.Kind.values().length];
            try {
                nArray[MessageEvent.Kind.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageEvent.Kind.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

