/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.facet.gradle;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetType;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleFacet
extends Facet<GradleFacetConfiguration> {
    public static final String ANDROID_GRADLE_FACET_ID = "android-gradle";
    public static final String ANDROID_GRADLE_FACET_NAME = "Android-Gradle";
    @NotNull
    private static final FacetTypeId<GradleFacet> TYPE_ID = new FacetTypeId("android-gradle");
    @Nullable
    private GradleModuleModel myGradleModuleModel;

    public static boolean isAppliedTo(@NotNull Module module) {
        return GradleFacet.getInstance(module) != null;
    }

    @Nullable
    public static GradleFacet getInstance(@NotNull Module module) {
        if (module.isDisposed()) {
            Logger.getInstance(GradleFacet.class).warn("Android-Gradle facet is requested on a disposed module " + module);
            return null;
        }
        Module holderModule = LinkedAndroidModuleGroupUtilsKt.getHolderModule(module);
        if (holderModule.isDisposed()) {
            Logger.getInstance(GradleFacet.class).warn("Android-Gradle facet is requested on " + module + " but holder module is disposed " + holderModule);
            return null;
        }
        return (GradleFacet)FacetManager.getInstance((Module)holderModule).getFacetByType(GradleFacet.getFacetTypeId());
    }

    public GradleFacet(@NotNull Module module, @NotNull String name2, @NotNull GradleFacetConfiguration configuration2) {
        super((FacetType)GradleFacet.getFacetType(), module, name2, (FacetConfiguration)configuration2, null);
    }

    @NotNull
    public static GradleFacetType getFacetType() {
        FacetType facetType = FacetTypeRegistry.getInstance().findFacetType(GradleFacet.getFacetId());
        assert (facetType instanceof GradleFacetType);
        return (GradleFacetType)facetType;
    }

    @NotNull
    public static FacetTypeId<GradleFacet> getFacetTypeId() {
        return TYPE_ID;
    }

    @NotNull
    public static String getFacetId() {
        return ANDROID_GRADLE_FACET_ID;
    }

    @NotNull
    public static String getFacetName() {
        return ANDROID_GRADLE_FACET_NAME;
    }

    @Nullable
    public GradleModuleModel getGradleModuleModel() {
        return this.myGradleModuleModel;
    }

    public void setGradleModuleModel(@NotNull GradleModuleModel gradleModuleModel) {
        this.myGradleModuleModel = gradleModuleModel;
        ((GradleFacetConfiguration)this.getConfiguration()).LAST_KNOWN_AGP_VERSION = this.myGradleModuleModel.getAgpVersion();
    }
}

