/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.gradle.project.Info;
import com.android.tools.idea.gradle.project.SyncDueMessage;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.importing.OpenMigrationToGradleUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.GradleProjectModels;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.idea.GradleSyncExecutor;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0017J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0017\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/gradle/project/sync/GradleSyncInvokerImpl;", "Lcom/android/tools/idea/gradle/project/sync/GradleSyncInvoker;", "<init>", "()V", "requestProjectSync", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lcom/android/tools/idea/gradle/project/sync/GradleSyncInvoker$Request;", "listener", "Lcom/android/tools/idea/gradle/project/sync/GradleSyncListener;", "fetchAndMergeNativeVariants", "requestedAbis", "", "", "fetchGradleModels", "Lcom/android/tools/idea/gradle/project/sync/GradleProjectModels;", "Companion", "intellij.android.projectSystem.gradle"})
public final class GradleSyncInvokerImpl
implements GradleSyncInvoker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    public void requestProjectSync(@NotNull Project project, @NotNull GradleSyncInvoker.Request request, @Nullable GradleSyncListener listener2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!TrustedProjects.isTrusted((Project)project)) {
            LOG.info("Skip " + project.getName() + " import, because project is not trusted", new Throwable());
            GradleSyncListener gradleSyncListener = listener2;
            if (gradleSyncListener != null) {
                gradleSyncListener.syncSkipped(project);
            }
            return;
        }
        SyncDueMessage.INSTANCE.dismissNotificationIfPresent(project);
        if (GradleSyncState.Companion.getInstance(project).isSyncInProgress()) {
            GradleSyncListener gradleSyncListener = listener2;
            if (gradleSyncListener != null) {
                gradleSyncListener.syncSkipped(project);
            }
            return;
        }
        if (GradleBuildInvoker.Companion.getInstance(project).getInternalIsBuildRunning()) {
            GradleSyncListener gradleSyncListener = listener2;
            if (gradleSyncListener != null) {
                gradleSyncListener.syncSkipped(project);
            }
            return;
        }
        Runnable syncTask = () -> GradleSyncInvokerImpl.requestProjectSync$lambda$0(project, listener2, request);
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            application.invokeAndWait(syncTask);
        } else {
            ApplicationManager.getApplication().invokeLater(syncTask);
        }
    }

    @Override
    @WorkerThread
    public void fetchAndMergeNativeVariants(@NotNull Project project, @NotNull Set<String> requestedAbis) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(requestedAbis, (String)"requestedAbis");
        new GradleSyncExecutor(project).fetchAndMergeNativeVariants(requestedAbis);
    }

    @Override
    @WorkerThread
    @NotNull
    public GradleProjectModels fetchGradleModels(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradleProjectModels gradleProjectModels = new GradleSyncExecutor(project).fetchGradleModels();
        Intrinsics.checkNotNullExpressionValue((Object)gradleProjectModels, (String)"fetchGradleModels(...)");
        return gradleProjectModels;
    }

    private static final void requestProjectSync$lambda$0(Project $project, GradleSyncListener $listener, GradleSyncInvoker.Request $request) {
        ExternalSystemUtil.ensureToolWindowContentInitialized((Project)$project, (ProjectSystemId)GradleProjectSystemUtil.GRADLE_SYSTEM_ID);
        if (GradleSyncInvokerImpl.Companion.prepareProject($project, $listener)) {
            GradleSyncInvokerImpl.Companion.sync($project, $request, $listener);
        }
    }

    static {
        Logger logger = Logger.getInstance(GradleSyncInvoker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/gradle/project/sync/GradleSyncInvokerImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "prepareProject", "", "project", "Lcom/intellij/openapi/project/Project;", "listener", "Lcom/android/tools/idea/gradle/project/sync/GradleSyncListener;", "sync", "", "request", "Lcom/android/tools/idea/gradle/project/sync/GradleSyncInvoker$Request;", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean prepareProject(Project project, GradleSyncListener listener2) {
            if (Info.getInstance(project).isBuildWithGradle()) {
                FileDocumentManager.getInstance().saveAllDocuments();
                return true;
            }
            AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> Companion.prepareProject$lambda$0(project, listener2));
            return false;
        }

        @UiThread
        private final void sync(Project project, GradleSyncInvoker.Request request, GradleSyncListener listener2) {
            UIUtil.invokeAndWaitIfNeeded(() -> Companion.sync$lambda$1(project));
            new GradleSyncExecutor(project).sync(request, listener2);
        }

        private static final void prepareProject$lambda$0(Project $project, GradleSyncListener $listener) {
            block0: {
                String string = "The project '%s' is not a Gradle-based project";
                Object[] objectArray = new Object[]{$project.getName()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                String msg = string2;
                LOG.error(msg);
                NotificationHyperlink[] notificationHyperlinkArray = new NotificationHyperlink[]{new OpenMigrationToGradleUrlHyperlink()};
                AndroidNotification.getInstance((Project)$project).showBalloon("Project Sync", msg, NotificationType.ERROR, notificationHyperlinkArray);
                GradleSyncListener gradleSyncListener = $listener;
                if (gradleSyncListener == null) break block0;
                gradleSyncListener.syncFailed($project, msg);
            }
        }

        private static final void sync$lambda$1(Project $project) {
            GradleSyncMessages.getInstance($project).removeAllMessages();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

