/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.GradleDistributionInstallIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.errors.UnsupportedGradleVersionIssueChecker;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.issues.SyncFailureUsageReporter;
import com.android.tools.idea.gradle.project.sync.quickFixes.OpenStudioProxySettingsQuickFix;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleWrapperSettingsOpenQuickFix;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016JD\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00140\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/GradleDistributionInstallIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "<init>", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "intellij.android.projectSystem.gradle"})
public final class GradleDistributionInstallIssueChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        String string = issueData.getError().getMessage();
        if (string == null) {
            return null;
        }
        String message = string;
        if (!StringsKt.startsWith$default((String)message, (String)GradleDistributionInstallIssueCheckerKt.COULD_NOT_INSTALL_GRADLE_DISTRIBUTION_PREFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        SyncFailureUsageReporter.Companion.getInstance().collectFailure(issueData.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.GRADLE_DISTRIBUTION_INSTALL_ERROR);
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(message, null, 2, null);
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        if (!Intrinsics.areEqual((Object)issueData.getError(), (Object)rootCause)) {
            buildIssueComposer.addDescriptionOnNewLine("Reason: " + rootCause);
            buildIssueComposer.startNewParagraph();
            if (rootCause instanceof UnknownHostException || rootCause instanceof ConnectException) {
                buildIssueComposer.addQuickFix("Please ensure ", "gradle distribution url", " is correct.", (BuildIssueQuickFix)new GradleWrapperSettingsOpenQuickFix(issueData.getProjectPath(), "distributionUrl"));
                buildIssueComposer.addQuickFix("If you are behind an HTTP proxy, please ", "configure the proxy settings", ".", new OpenStudioProxySettingsQuickFix());
            }
            if (rootCause instanceof RuntimeException) {
                String string2 = ((RuntimeException)rootCause).getMessage();
                boolean bl = string2 != null ? StringsKt.startsWith$default((String)string2, (String)"Could not create parent directory for lock file", (boolean)false, (int)2, null) : false;
                if (bl) {
                    buildIssueComposer.addDescriptionOnNewLine("Please ensure Android Studio can write to the specified Gradle wrapper distribution directory.\nYou can also change Gradle home directory in Gradle Settings.");
                    buildIssueComposer.startNewParagraph();
                    buildIssueComposer.addQuickFix("Open Gradle Settings", new UnsupportedGradleVersionIssueChecker.OpenGradleSettingsQuickFix());
                    buildIssueComposer.addQuickFix("Open Gradle wrapper settings", (BuildIssueQuickFix)new GradleWrapperSettingsOpenQuickFix(issueData.getProjectPath(), null));
                }
            }
        }
        return buildIssueComposer.composeBuildIssue();
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return StringsKt.startsWith$default((String)failureCause, (String)GradleDistributionInstallIssueCheckerKt.COULD_NOT_INSTALL_GRADLE_DISTRIBUTION_PREFIX, (boolean)false, (int)2, null);
    }
}

