/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.sync.errors.MissingNdkIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallNdkHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.processor.FixNdkVersionProcessor;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016JD\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00140\u0013H\u0016J&\u0010\u0015\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/MissingNdkIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "<init>", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "appendQuickFix", "quickFixes", "", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "quickFix", "errorMessage", "matchesNdkNotConfigured", "matchesKnownLocatorIssue", "matchesTriedInstall", "FixNdkVersionQuickFix", "InstallNdkQuickFix", "intellij.android.projectSystem.gradle"})
public final class MissingNdkIssueChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        String gradleVersion2;
        BuildEnvironment buildEnvironment;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        String string = this.errorMessage(issueData);
        if (string == null) {
            return null;
        }
        String message = string;
        Revision preferredVersion = MissingNdkIssueCheckerKt.tryExtractPreferredNdkDownloadVersion(message);
        List quickFixes = new ArrayList();
        Ref.ObjectRef description2 = new Ref.ObjectRef();
        description2.element = message + "\n";
        IdeSdks ideSdks = IdeSdks.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)ideSdks, (String)"getInstance(...)");
        IdeSdks ideSdks2 = ideSdks;
        String localRevision = null;
        if (preferredVersion != null) {
            LocalPackage localPackage = ideSdks2.getSpecificLocalPackage("ndk;" + preferredVersion);
            localRevision = localPackage != null && (localPackage = localPackage.getVersion()) != null ? localPackage.toString() : null;
        } else if (this.matchesNdkNotConfigured(message) || this.matchesKnownLocatorIssue(message) || this.matchesTriedInstall(message)) {
            Revision revision;
            LocalPackage localPackage;
            LocalPackage localPackage2 = ideSdks2.getHighestLocalNdkPackage(false);
            if (localPackage2 == null) {
                localPackage2 = ideSdks2.getHighestLocalNdkPackage(true);
            }
            localRevision = (localPackage = localPackage2) != null && (revision = localPackage.getVersion()) != null ? revision.toString() : null;
        } else {
            return null;
        }
        String string2 = (buildEnvironment = issueData.getBuildEnvironment()) != null && (buildEnvironment = buildEnvironment.getGradle()) != null ? buildEnvironment.getGradleVersion() : (gradleVersion2 = null);
        if (gradleVersion2 != null && GradleVersion.version((String)gradleVersion2).getBaseVersion().compareTo(GradleVersion.version((String)"6.2")) <= 0) {
            return null;
        }
        if (localRevision != null) {
            description2.element = description2.element + this.appendQuickFix(quickFixes, new FixNdkVersionQuickFix(localRevision), "Update NDK version to " + localRevision + " and sync project");
        } else {
            Revision revision = preferredVersion;
            description2.element = description2.element + this.appendQuickFix(quickFixes, new InstallNdkQuickFix(revision != null ? revision.toString() : null), (String)(preferredVersion != null ? "Install NDK '" + preferredVersion + "' and sync project" : "Install latest NDK and sync project"));
        }
        return new BuildIssue((Ref.ObjectRef<String>)description2, quickFixes){
            private final String title;
            private final String description;
            private final List<BuildIssueQuickFix> quickFixes;
            {
                this.title = "NDK not configured.";
                this.description = (String)$description.element;
                this.quickFixes = $quickFixes;
            }

            public String getTitle() {
                return this.title;
            }

            public String getDescription() {
                return this.description;
            }

            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            public Navigatable getNavigatable(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return null;
            }
        };
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return MissingNdkIssueCheckerKt.tryExtractPreferredNdkDownloadVersion(failureCause) != null || this.matchesNdkNotConfigured(failureCause) || this.matchesKnownLocatorIssue(failureCause) || this.matchesTriedInstall(failureCause);
    }

    private final String appendQuickFix(List<BuildIssueQuickFix> quickFixes, BuildIssueQuickFix quickFix, String message) {
        ((Collection)quickFixes).add(quickFix);
        return "\n<a href=\"" + quickFix.getId() + "\">" + message + "</a>";
    }

    private final String errorMessage(GradleIssueData issueData) {
        Pair pair = GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError());
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"getRootCauseAndLocation(...)");
        Pair rootCauseAndLocation = pair;
        Throwable throwable = (Throwable)rootCauseAndLocation.first;
        if (throwable == null) {
            return null;
        }
        Throwable rootCause = throwable;
        return rootCause.getMessage();
    }

    private final boolean matchesNdkNotConfigured(String errorMessage) {
        return StringsKt.startsWith$default((String)errorMessage, (String)"NDK not configured.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)errorMessage, (String)"NDK location not found.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)errorMessage, (String)"Requested NDK version", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)errorMessage, (String)"No version of NDK matched the requested version", (boolean)false, (int)2, null);
    }

    private final boolean matchesKnownLocatorIssue(String errorMessage) {
        return StringsKt.startsWith$default((String)errorMessage, (String)"Specified android.ndkVersion", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"does not have enough precision", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)errorMessage, (String)"Location specified by ndk.dir", (boolean)false, (int)2, null);
    }

    private final boolean matchesTriedInstall(String errorMessage) {
        return (StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"Failed to install the following Android SDK packages as some licences have not been accepted.", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"Failed to install the following SDK components:", (boolean)false, (int)2, null)) && StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"NDK", (boolean)false, (int)2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/MissingNdkIssueChecker$FixNdkVersionQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "version", "", "<init>", "(Ljava/lang/String;)V", "getVersion", "()Ljava/lang/String;", "id", "getId", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.projectSystem.gradle"})
    @SourceDebugExtension(value={"SMAP\nMissingNdkIssueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingNdkIssueChecker.kt\ncom/android/tools/idea/gradle/project/sync/errors/MissingNdkIssueChecker$FixNdkVersionQuickFix\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n11476#2,9:208\n13402#2:217\n13403#2:219\n11485#2:220\n1#3:218\n*S KotlinDebug\n*F\n+ 1 MissingNdkIssueChecker.kt\ncom/android/tools/idea/gradle/project/sync/errors/MissingNdkIssueChecker$FixNdkVersionQuickFix\n*L\n154#1:208,9\n154#1:217\n154#1:219\n154#1:220\n154#1:218\n*E\n"})
    public static final class FixNdkVersionQuickFix
    implements BuildIssueQuickFix {
        @NotNull
        private final String version;
        @NotNull
        private final String id;

        public FixNdkVersionQuickFix(@NotNull String version2) {
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            this.version = version2;
            this.id = "fix.ndk.version.quickfix";
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            CompletableFuture future2 = new CompletableFuture();
            ApplicationManager.getApplication().invokeLater(() -> FixNdkVersionQuickFix.runQuickFix$lambda$1(project, this, future2));
            return future2;
        }

        /*
         * WARNING - void declaration
         */
        private static final void runQuickFix$lambda$1(Project $project, FixNdkVersionQuickFix this$0, CompletableFuture $future) {
            try {
                void $this$mapNotNullTo$iv$iv;
                LocalProperties localProperties = new LocalProperties(Projects.getBaseDirPath((Project)$project));
                localProperties.setAndroidNdkPath((File)null);
                localProperties.save();
                Module[] $this$mapNotNull$iv = ModuleManager.Companion.getInstance($project).getModules();
                boolean $i$f$mapNotNull = false;
                Module[] moduleArray = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile it$iv$iv;
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl = false;
                    void it = element$iv$iv;
                    boolean bl2 = false;
                    if (GradleProjectSystemUtil.getGradleBuildFile((Module)it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List buildFiles = (List)destination$iv$iv;
                FixNdkVersionProcessor processor = new FixNdkVersionProcessor($project, buildFiles, this$0.version);
                processor.run();
                $future.complete(null);
            }
            catch (Exception e) {
                $future.completeExceptionally(e);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/MissingNdkIssueChecker$InstallNdkQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "preferredVersion", "", "<init>", "(Ljava/lang/String;)V", "id", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.projectSystem.gradle"})
    @SourceDebugExtension(value={"SMAP\nMissingNdkIssueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingNdkIssueChecker.kt\ncom/android/tools/idea/gradle/project/sync/errors/MissingNdkIssueChecker$InstallNdkQuickFix\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n11476#2,9:208\n13402#2:217\n13403#2:219\n11485#2:220\n1#3:218\n*S KotlinDebug\n*F\n+ 1 MissingNdkIssueChecker.kt\ncom/android/tools/idea/gradle/project/sync/errors/MissingNdkIssueChecker$InstallNdkQuickFix\n*L\n179#1:208,9\n179#1:217\n179#1:219\n179#1:220\n179#1:218\n*E\n"})
    public static final class InstallNdkQuickFix
    implements BuildIssueQuickFix {
        @Nullable
        private final String preferredVersion;

        public InstallNdkQuickFix(@Nullable String preferredVersion) {
            this.preferredVersion = preferredVersion;
        }

        @NotNull
        public String getId() {
            return "install.ndk.quickfix";
        }

        @NotNull
        public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            CompletableFuture future2 = new CompletableFuture();
            ApplicationManager.getApplication().invokeLater(() -> InstallNdkQuickFix.runQuickFix$lambda$1(project, this, future2));
            return future2;
        }

        /*
         * WARNING - void declaration
         */
        private static final void runQuickFix$lambda$1(Project $project, InstallNdkQuickFix this$0, CompletableFuture $future) {
            try {
                void $this$mapNotNullTo$iv$iv;
                Module[] $this$mapNotNull$iv = ModuleManager.Companion.getInstance($project).getModules();
                boolean $i$f$mapNotNull = false;
                Module[] moduleArray = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile it$iv$iv;
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl = false;
                    void it = element$iv$iv;
                    boolean bl2 = false;
                    if (GradleProjectSystemUtil.getGradleBuildFile((Module)it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List buildFiles = (List)destination$iv$iv;
                new InstallNdkHyperlink(this$0.preferredVersion, buildFiles).execute($project);
                $future.complete(null);
            }
            catch (Exception e) {
                $future.completeExceptionally(e);
            }
        }
    }
}

