/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.repository.api.ProgressIndicator;
import com.android.tools.idea.gradle.project.sync.SdkSync;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0017\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u001a:\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u001c\u0010\u0014\u001a\u0004\u0018\u00010\n*\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0002\u001a\b\u0010\u0015\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0007H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "syncAndroidSdks", "", "Lcom/android/tools/idea/gradle/project/sync/SdkSync;", "projectPath", "", "Lorg/jetbrains/annotations/SystemDependent;", "computeSdkReloadingAsNeeded", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lcom/android/tools/idea/sdk/AndroidSdks;", "project", "Lcom/intellij/openapi/project/Project;", "moduleDisplayName", "compileTarget", "bootClasspath", "", "ideSdks", "Lcom/android/tools/idea/sdk/IdeSdks;", "findMatchingSdkForAddon", "logAndroidSdkHomeNotFound", "logSdkFound", "sdk", "moduleName", "intellij.android.projectSystem.gradle"})
@JvmName(name="SdkSyncUtil")
@SourceDebugExtension(value={"SMAP\nSdkSyncUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkSyncUtil.kt\ncom/android/tools/idea/gradle/project/sync/idea/SdkSyncUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,171:1\n1557#2:172\n1628#2,3:173\n295#2,2:176\n295#2:178\n296#2:181\n1863#2,2:182\n12567#3,2:179\n*S KotlinDebug\n*F\n+ 1 SdkSyncUtil.kt\ncom/android/tools/idea/gradle/project/sync/idea/SdkSyncUtil\n*L\n137#1:172\n137#1:173,3\n139#1:176,2\n146#1:178\n146#1:181\n163#1:182,2\n147#1:179,2\n*E\n"})
public final class SdkSyncUtil {
    @NotNull
    private static final Logger LOG;

    public static final void syncAndroidSdks(@NotNull SdkSync $this$syncAndroidSdks, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)$this$syncAndroidSdks, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        File projectDir = new File(projectPath);
        if (!projectDir.isDirectory()) {
            throw new IllegalStateException("The project directory does not exist!");
        }
        LocalProperties localProperties = new LocalProperties(projectDir);
        SdkSync.syncIdeAndProjectAndroidSdks$default($this$syncAndroidSdks, localProperties, null, 2, null);
    }

    @Nullable
    public static final Sdk computeSdkReloadingAsNeeded(@NotNull AndroidSdks $this$computeSdkReloadingAsNeeded, @NotNull Project project, @NotNull String moduleDisplayName, @NotNull String compileTarget, @NotNull Collection<String> bootClasspath, @NotNull IdeSdks ideSdks) {
        Intrinsics.checkNotNullParameter((Object)$this$computeSdkReloadingAsNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleDisplayName, (String)"moduleDisplayName");
        Intrinsics.checkNotNullParameter((Object)compileTarget, (String)"compileTarget");
        Intrinsics.checkNotNullParameter(bootClasspath, (String)"bootClasspath");
        Intrinsics.checkNotNullParameter((Object)ideSdks, (String)"ideSdks");
        Sdk sdk = $this$computeSdkReloadingAsNeeded.findSuitableAndroidSdk(compileTarget);
        if (sdk != null) {
            VirtualFile[] virtualFileArray = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
            if (((Object[])virtualFileArray).length == 0) {
                Sdk sdkToRemove = sdk;
                ActionsKt.invokeAndWaitIfNeeded$default(null, () -> SdkSyncUtil.computeSdkReloadingAsNeeded$lambda$1(sdkToRemove), (int)1, null);
                sdk = null;
            }
        }
        if (sdk != null) {
            SdkSyncUtil.logSdkFound(sdk, moduleDisplayName);
            return sdk;
        }
        StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(SdkSync.class);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> SdkSyncUtil.computeSdkReloadingAsNeeded$lambda$2($this$computeSdkReloadingAsNeeded, progress2), "Reloading SDKs", false, project);
        File androidSdkHomePath = ideSdks.getAndroidSdkPath();
        if (androidSdkHomePath == null) {
            SdkSyncUtil.logAndroidSdkHomeNotFound();
            return null;
        }
        Ref.ObjectRef newSdk = new Ref.ObjectRef();
        ActionsKt.invokeAndWaitIfNeeded$default(null, () -> SdkSyncUtil.computeSdkReloadingAsNeeded$lambda$4(newSdk, $this$computeSdkReloadingAsNeeded, androidSdkHomePath, compileTarget), (int)1, null);
        if (newSdk.element != null) {
            Object object = newSdk.element;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.projectRoots.Sdk");
            SdkSyncUtil.logSdkFound((Sdk)object, moduleDisplayName);
            Object object2 = newSdk.element;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.openapi.projectRoots.Sdk");
            return (Sdk)object2;
        }
        return SdkSyncUtil.findMatchingSdkForAddon($this$computeSdkReloadingAsNeeded, bootClasspath);
    }

    /*
     * WARNING - void declaration
     */
    private static final Sdk findMatchingSdkForAddon(AndroidSdks $this$findMatchingSdkForAddon, Collection<String> bootClasspath) {
        Object v5;
        File androidJarPath;
        block11: {
            Object v0;
            block9: {
                void $this$firstOrNull$iv;
                Iterator $this$mapTo$iv$iv;
                if (bootClasspath.size() <= 1) {
                    return null;
                }
                Iterable $this$map$iv = bootClasspath;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void path;
                    Object item$iv$iv = iterator2.next();
                    String string = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(new File((String)path));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    File file = (File)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)file.getName(), (Object)"android.jar")) continue;
                    v0 = element$iv;
                    break block9;
                }
                v0 = null;
            }
            File file = v0;
            if (file == null) {
                AndroidSdks $this$findMatchingSdkForAddon_u24lambda_u247 = $this$findMatchingSdkForAddon;
                boolean bl = false;
                LOG.warn("Unable to find android.jar in bootclasspath. Bootclasspath: " + CollectionsKt.joinToString$default((Iterable)bootClasspath, null, null, null, (int)0, null, null, (int)63, null) + ".");
                return null;
            }
            androidJarPath = file;
            List list = $this$findMatchingSdkForAddon.getAllAndroidSdks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllAndroidSdks(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block10: {
                    Sdk sdk = (Sdk)element$iv;
                    boolean bl2 = false;
                    VirtualFile[] virtualFileArray = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
                    Object[] $this$any$iv = virtualFileArray;
                    boolean $i$f$any = false;
                    for (Object element$iv2 : $this$any$iv) {
                        VirtualFile sdkFile = (VirtualFile)element$iv2;
                        boolean bl3 = false;
                        if (!FileUtil.filesEqual((File)VfsUtilCore.virtualToIoFile((VirtualFile)sdkFile), (File)androidJarPath)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
                if (!bl) continue;
                v5 = element$iv;
                break block11;
            }
            v5 = null;
        }
        Object var3_25 = v5;
        Sdk it = var3_25;
        boolean bl = false;
        if (it == null) {
            Object object;
            if ($this$findMatchingSdkForAddon.getAllAndroidSdks().isEmpty()) {
                object = "No available Android SDKs.";
            } else {
                List list = $this$findMatchingSdkForAddon.getAllAndroidSdks();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllAndroidSdks(...)");
                object = "Available Android SDKs: " + CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, SdkSyncUtil::findMatchingSdkForAddon$lambda$11$lambda$10, (int)31, null) + ".";
            }
            String availableSdks = object;
            LOG.warn("Unable to find Android SDK that contains " + androidJarPath + ". " + availableSdks);
        }
        return var3_25;
    }

    private static final void logAndroidSdkHomeNotFound() {
        LOG.warn("Path to Android SDK not set");
        List<Sdk> list = IdeSdks.getInstance().getEligibleAndroidSdks();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getEligibleAndroidSdks(...)");
        List<Sdk> sdks = list;
        LOG.warn("# of eligible SDKs: " + sdks.size());
        Iterable $this$forEach$iv = sdks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Sdk sdk = (Sdk)element$iv;
            boolean bl = false;
            LOG.info("sdk: " + sdk);
        }
    }

    private static final void logSdkFound(Sdk sdk, String moduleName) {
        String string = sdk.getHomePath();
        if (string == null) {
            string = "<path not set>";
        }
        String sdkPath = string;
        LOG.debug("Set Android SDK '" + sdk.getName() + "' (" + sdkPath + ") to module " + moduleName);
    }

    private static final Unit computeSdkReloadingAsNeeded$lambda$1$lambda$0(Sdk $sdkToRemove) {
        ProjectJdkTable.getInstance().removeJdk($sdkToRemove);
        return Unit.INSTANCE;
    }

    private static final Unit computeSdkReloadingAsNeeded$lambda$1(Sdk $sdkToRemove) {
        ActionsKt.runWriteAction(() -> SdkSyncUtil.computeSdkReloadingAsNeeded$lambda$1$lambda$0($sdkToRemove));
        return Unit.INSTANCE;
    }

    private static final void computeSdkReloadingAsNeeded$lambda$2(AndroidSdks $this_computeSdkReloadingAsNeeded, StudioLoggerProgressIndicator $progress) {
        $this_computeSdkReloadingAsNeeded.tryToChooseSdkHandler().getRepoManager((ProgressIndicator)$progress).reloadLocalIfNeeded((ProgressIndicator)$progress);
    }

    private static final Sdk computeSdkReloadingAsNeeded$lambda$4$lambda$3(AndroidSdks $this_computeSdkReloadingAsNeeded, File $androidSdkHomePath, String $compileTarget) {
        return $this_computeSdkReloadingAsNeeded.tryToCreate($androidSdkHomePath, $compileTarget);
    }

    private static final Unit computeSdkReloadingAsNeeded$lambda$4(Ref.ObjectRef $newSdk, AndroidSdks $this_computeSdkReloadingAsNeeded, File $androidSdkHomePath, String $compileTarget) {
        $newSdk.element = ActionsKt.runWriteAction(() -> SdkSyncUtil.computeSdkReloadingAsNeeded$lambda$4$lambda$3($this_computeSdkReloadingAsNeeded, $androidSdkHomePath, $compileTarget));
        return Unit.INSTANCE;
    }

    private static final CharSequence findMatchingSdkForAddon$lambda$11$lambda$10(Sdk sdk) {
        String string = sdk.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    static {
        Logger logger = Logger.getInstance(SdkSync.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

