/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.model.IdeSyncIssue;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.hyperlink.SuppressUnsupportedSdkVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SimpleDeduplicatingSyncIssueReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueNotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014JF\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00102\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u0014H\u0014J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0007J \u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0002J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/CompileSdkVersionTooHighReporter;", "Lcom/android/tools/idea/gradle/project/sync/issues/SimpleDeduplicatingSyncIssueReporter;", "<init>", "()V", "getSupportedIssueType", "", "getDeduplicationKey", "", "issue", "Lcom/android/tools/idea/gradle/model/IdeSyncIssue;", "getCustomLinks", "", "Lcom/android/tools/idea/gradle/project/sync/issues/SyncIssueNotificationHyperlink;", "project", "Lcom/intellij/openapi/project/Project;", "syncIssues", "", "affectedModules", "Lcom/intellij/openapi/module/Module;", "buildFileMap", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "createQuickFixes", "suppressSdkQuickFix", "Lcom/android/tools/idea/gradle/project/sync/hyperlink/SuppressUnsupportedSdkVersionHyperlink;", "tryExtractPropertyFromSyncMessage", "", "Companion", "intellij.android.projectSystem.gradle"})
public final class CompileSdkVersionTooHighReporter
extends SimpleDeduplicatingSyncIssueReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex PATTERN = new Regex("android.suppressUnsupportedCompileSdk=(\\S+)");

    @Override
    protected int getSupportedIssueType() {
        return 47;
    }

    @Override
    @NotNull
    protected Object getDeduplicationKey(@NotNull IdeSyncIssue issue2) {
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        return this.getSupportedIssueType();
    }

    @Override
    @NotNull
    protected List<SyncIssueNotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(syncIssues, (String)"syncIssues");
        Intrinsics.checkNotNullParameter(affectedModules, (String)"affectedModules");
        Intrinsics.checkNotNullParameter(buildFileMap, (String)"buildFileMap");
        if (syncIssues.isEmpty() || affectedModules.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return this.createQuickFixes(project, syncIssues);
    }

    @VisibleForTesting
    @NotNull
    public final List<SyncIssueNotificationHyperlink> createQuickFixes(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(syncIssues, (String)"syncIssues");
        return CollectionsKt.listOfNotNull((Object)this.suppressSdkQuickFix(project, syncIssues));
    }

    private final SuppressUnsupportedSdkVersionHyperlink suppressSdkQuickFix(Project project, List<IdeSyncIssue> syncIssues) {
        AndroidPluginInfo pluginInfo = AndroidPluginInfo.find(project);
        if (pluginInfo != null) {
            SuppressUnsupportedSdkVersionHyperlink suppressUnsupportedSdkVersionHyperlink;
            AgpVersion agpVersion = pluginInfo.getPluginVersion();
            if (agpVersion != null && agpVersion.isAtLeast(8, 2, 0, "alpha", 7, false)) {
                String string = syncIssues.get(0).getData();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    suppressUnsupportedSdkVersionHyperlink = new SuppressUnsupportedSdkVersionHyperlink(it);
                } else {
                    suppressUnsupportedSdkVersionHyperlink = null;
                }
            } else {
                String string = this.tryExtractPropertyFromSyncMessage(syncIssues);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    suppressUnsupportedSdkVersionHyperlink = new SuppressUnsupportedSdkVersionHyperlink(it);
                } else {
                    suppressUnsupportedSdkVersionHyperlink = null;
                }
            }
            return suppressUnsupportedSdkVersionHyperlink;
        }
        return null;
    }

    private final String tryExtractPropertyFromSyncMessage(List<IdeSyncIssue> syncIssues) {
        MatchResult matchResult;
        String message = syncIssues.get(0).getMessage();
        MatchResult matchResult2 = matchResult = Regex.find$default((Regex)PATTERN, (CharSequence)message, (int)0, (int)2, null);
        return matchResult2 != null ? matchResult2.getValue() : null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/CompileSdkVersionTooHighReporter$Companion;", "", "<init>", "()V", "PATTERN", "Lkotlin/text/Regex;", "getPATTERN", "()Lkotlin/text/Regex;", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getPATTERN() {
            return PATTERN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

