/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.tools.idea.gradle.model.IdeSyncIssue;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileSyncMessageHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueNotificationHyperlink;
import com.android.tools.idea.project.hyperlink.SyncMessageFragment;
import com.android.tools.idea.project.hyperlink.SyncMessageHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.project.messages.SyncMessageWithContext;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.PositionInFile;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class SimpleDeduplicatingSyncIssueReporter
extends BaseSyncIssuesReporter {
    @TestOnly
    @NotNull
    public final List<SyncMessageWithContext> report(@NotNull IdeSyncIssue syncIssue, @NotNull Module module, @Nullable VirtualFile buildFile) {
        return this.reportAll((List<IdeSyncIssue>)ImmutableList.of((Object)syncIssue), (Map<IdeSyncIssue, Module>)ImmutableMap.of((Object)syncIssue, (Object)module), (Map<Module, VirtualFile>)(buildFile == null ? ImmutableMap.of() : ImmutableMap.of((Object)module, (Object)buildFile)));
    }

    @Override
    @NotNull
    public final List<SyncMessageWithContext> reportAll(@NotNull List<IdeSyncIssue> syncIssues, @NotNull Map<IdeSyncIssue, Module> moduleMap, @NotNull Map<Module, VirtualFile> buildFileMap) {
        ArrayList<SyncMessageWithContext> result2 = new ArrayList<SyncMessageWithContext>();
        LinkedHashMap<Object, List> groupedIssues = new LinkedHashMap<Object, List>();
        for (IdeSyncIssue issue2 : syncIssues) {
            groupedIssues.computeIfAbsent(this.getDeduplicationKey(issue2), config -> new ArrayList()).add(issue2);
        }
        for (List entry : groupedIssues.values()) {
            IdeSyncIssue issue3;
            Module module;
            if (entry.isEmpty() || (module = moduleMap.get(issue3 = (IdeSyncIssue)entry.get(0))) == null) continue;
            if (!this.shouldReport(module.getProject())) {
                return new ArrayList<SyncMessageWithContext>();
            }
            List<Module> affectedModules = entry.stream().map(moduleMap::get).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(Module::getName)).collect(Collectors.toList());
            SyncMessage syncMessage = this.createSyncMessage(module.getProject(), entry, affectedModules, buildFileMap, this.getMessageType(entry));
            result2.add(new SyncMessageWithContext(syncMessage, affectedModules));
        }
        return result2;
    }

    protected MessageType getMessageType(List<IdeSyncIssue> syncIssues) {
        boolean isError = syncIssues.stream().anyMatch(i -> i.getSeverity() == 2);
        return isError ? MessageType.WARNING : MessageType.INFO;
    }

    protected boolean shouldReport(@NotNull Project project) {
        return true;
    }

    private SyncMessage createSyncMessage(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, MessageType type) {
        assert (!syncIssues.isEmpty());
        SyncMessage syncMessage = this.setupSyncMessage(project, syncIssues, affectedModules, buildFileMap, type);
        List<SyncIssueNotificationHyperlink> customLinks = this.getCustomLinks(project, syncIssues, affectedModules, buildFileMap);
        syncMessage.add(customLinks);
        if (this.shouldIncludeModuleLinks() && !affectedModules.isEmpty()) {
            final StringBuilder builder = new StringBuilder();
            final List links = affectedModules.stream().map(m -> this.doCreateModuleLink(project, (Module)m, syncIssues, (VirtualFile)buildFileMap.get(m))).collect(Collectors.toList());
            builder.append("Affected Modules: ");
            List linkHtmls = links.stream().map(SyncMessageHyperlink::toHtml).collect(Collectors.toList());
            builder.append(String.join((CharSequence)", ", linkHtmls));
            syncMessage.add(new SyncMessageFragment(){

                @Override
                public void executeHandler(@NotNull Project project, @NotNull HyperlinkEvent event) {
                    for (SyncMessageHyperlink link2 : links) {
                        if (!link2.getUrls().contains(event.getDescription())) continue;
                        link2.executeHandler(project, event);
                    }
                }

                @Override
                @NotNull
                public Collection<String> getUrls() {
                    return ContainerUtil.flatMap((Iterable)links, it -> new ArrayList<String>(it.getUrls()));
                }

                @Override
                @NotNull
                public String toHtml() {
                    return builder.toString();
                }

                @Override
                @NotNull
                public List<AndroidStudioEvent.GradleSyncQuickFix> getQuickFixIds() {
                    return links.stream().flatMap(it -> it.getQuickFixIds().stream()).collect(Collectors.toList());
                }
            });
        }
        return syncMessage;
    }

    @NotNull
    private SyncMessageHyperlink doCreateModuleLink(@NotNull Project project, @NotNull Module module, @NotNull List<IdeSyncIssue> syncIssues, @Nullable VirtualFile buildFile) {
        if (buildFile == null) {
            final String text2 = ProjectSystemUtil.getModuleSystem(module).getDisplayNameForModule();
            return new SyncMessageHyperlink("url." + module.getName(), text2){

                @Override
                @NotNull
                public List<AndroidStudioEvent.GradleSyncQuickFix> getQuickFixIds() {
                    return Collections.emptyList();
                }

                @Override
                protected void execute(@NotNull Project project) {
                }

                @Override
                @NotNull
                public String toHtml() {
                    return text2;
                }
            };
        }
        return this.createModuleLink(project, module, syncIssues, buildFile);
    }

    @NotNull
    public OpenFileSyncMessageHyperlink createModuleLink(@NotNull Project project, @NotNull Module module, @NotNull List<IdeSyncIssue> syncIssues, @NotNull VirtualFile buildFile) {
        @NotNull String displayName = ProjectSystemUtil.getModuleSystem(module).getDisplayNameForModule();
        return new OpenFileSyncMessageHyperlink(buildFile.getPath(), displayName, -1, -1);
    }

    @NotNull
    protected Object getDeduplicationKey(@NotNull IdeSyncIssue issue2) {
        return issue2.getData() == null ? issue2 : issue2.getData();
    }

    protected boolean shouldIncludeModuleLinks() {
        return true;
    }

    @NotNull
    protected List<SyncIssueNotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        return ImmutableList.of();
    }

    @NotNull
    protected SyncMessage setupSyncMessage(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull MessageType type) {
        VirtualFile file;
        assert (!syncIssues.isEmpty());
        PositionInFile position = null;
        if (affectedModules.size() == 1 && (file = buildFileMap.get(affectedModules.get(0))) != null) {
            position = new PositionInFile(file);
        }
        return position != null ? new SyncMessage(project, "Gradle Sync Issues", type, position, syncIssues.get(0).getMessage()) : new SyncMessage("Gradle Sync Issues", type, syncIssues.get(0).getMessage());
    }

    public static int getLineNumberForElement(@NotNull Project project, @Nullable PsiElement element) {
        return (Integer)ApplicationManager.getApplication().runReadAction(() -> {
            Document document;
            if (element != null && (document = PsiDocumentManager.getInstance((Project)project).getDocument(element.getContainingFile())) != null) {
                return document.getLineNumber(element.getTextOffset());
            }
            return -1;
        });
    }
}

