/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues.processor;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.project.sync.issues.processor.GradlePluginInfo;
import com.android.tools.idea.gradle.project.sync.issues.processor.UpdateGradlePluginProcessorKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0014J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/processor/UpdateGradlePluginProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "pluginToVersionMap", "", "Lcom/android/tools/idea/gradle/project/sync/issues/processor/GradlePluginInfo;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "performRefactoring", "", "([Lcom/intellij/usageView/UsageInfo;)V", "getCommandName", "getUsages", "", "projectBuildModel", "Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;", "gradleBuildModel", "Lcom/android/tools/idea/gradle/dsl/api/GradleBuildModel;", "GradlePluginUsageInfo", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nUpdateGradlePluginProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateGradlePluginProcessor.kt\ncom/android/tools/idea/gradle/project/sync/issues/processor/UpdateGradlePluginProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1368#2:115\n1454#2,5:116\n774#2:136\n865#2,2:137\n1863#2,2:139\n1557#2:141\n1628#2,3:142\n1863#2,2:145\n1368#2:147\n1454#2,5:148\n1611#2,9:153\n1863#2:162\n1864#2:164\n1620#2:165\n37#3:121\n36#3,3:122\n4135#4,11:125\n1#5:163\n*S KotlinDebug\n*F\n+ 1 UpdateGradlePluginProcessor.kt\ncom/android/tools/idea/gradle/project/sync/issues/processor/UpdateGradlePluginProcessor\n*L\n45#1:115\n45#1:116,5\n51#1:136\n51#1:137,2\n55#1:139,2\n59#1:141\n59#1:142,3\n59#1:145,2\n67#1:147\n67#1:148,5\n73#1:153,9\n73#1:162\n73#1:164\n73#1:165\n47#1:121\n47#1:122,3\n51#1:125,11\n73#1:163\n*E\n"})
public final class UpdateGradlePluginProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<GradlePluginInfo, String> pluginToVersionMap;

    public UpdateGradlePluginProcessor(@NotNull Project project, @NotNull Map<GradlePluginInfo, String> pluginToVersionMap) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(pluginToVersionMap, (String)"pluginToVersionMap");
        super(project);
        this.project = project;
        this.pluginToVersionMap = pluginToVersionMap;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return new UsageViewDescriptor(){

            public PsiElement[] getElements() {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return "Update Plugin Versions";
            }

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "Plugin versions to update (" + usagesCount + " usage" + (usagesCount == 1 ? "" : "s") + " in " + filesCount + " file" + (filesCount == 1 ? "" : "s") + ")";
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected UsageInfo[] findUsages() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = UpdateGradlePluginProcessorKt.getIncludedBuilds(this.project);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ProjectBuildModel it = (ProjectBuildModel)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getUsages(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new UsageInfo[0]);
    }

    /*
     * WARNING - void declaration
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        void $this$mapTo$iv$iv;
        GradlePluginUsageInfo it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        UsageInfo[] $this$filterIsInstance$iv = usages;
        boolean $i$f$filterIsInstance = false;
        UsageInfo[] usageInfoArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GradlePluginUsageInfo)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            it = (GradlePluginUsageInfo)((Object)element$iv$iv);
            boolean bl = false;
            PsiElement element = it.getElement();
            if (!(element != null && element.isValid())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List gradlePluginUsages = (List)destination$iv$iv;
        Iterable $this$forEach$iv = gradlePluginUsages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradlePluginUsageInfo it2 = (GradlePluginUsageInfo)((Object)element$iv);
            boolean bl = false;
            it2.getDependencyModel().enableSetThrough();
            it2.getDependencyModel().version().getResultModel().setValue(it2.getNewVersion());
        }
        Iterable $this$map$iv = gradlePluginUsages;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (GradlePluginUsageInfo)((Object)item$iv$iv);
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getProjectBuildModel());
        }
        $this$forEach$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProjectBuildModel it3 = (ProjectBuildModel)element$iv;
            boolean bl = false;
            it3.applyChanges();
        }
    }

    @NotNull
    protected String getCommandName() {
        return "Update Plugin Versions";
    }

    /*
     * WARNING - void declaration
     */
    private final List<UsageInfo> getUsages(ProjectBuildModel projectBuildModel) {
        void $this$flatMapTo$iv$iv;
        List<GradleBuildModel> list = projectBuildModel.getAllIncludedBuildModels();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllIncludedBuildModels(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            GradleBuildModel it = (GradleBuildModel)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Iterable list$iv$iv = this.getUsages(projectBuildModel, it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<UsageInfo> getUsages(ProjectBuildModel projectBuildModel, GradleBuildModel gradleBuildModel) {
        void $this$mapNotNullTo$iv$iv;
        List<ArtifactDependencyModel> list = gradleBuildModel.buildscript().dependencies().artifacts();
        Intrinsics.checkNotNullExpressionValue(list, (String)"artifacts(...)");
        List<ArtifactDependencyModel> artifactDependencies = list;
        Iterable $this$mapNotNull$iv = artifactDependencies;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            GradlePluginUsageInfo gradlePluginUsageInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ArtifactDependencyModel it = (ArtifactDependencyModel)element$iv$iv;
            boolean bl2 = false;
            if (this.pluginToVersionMap.get(new GradlePluginInfo(it.name().toString(), it.group().toString())) == null) {
                gradlePluginUsageInfo = null;
            } else if (it.getPsiElement() == null) {
                gradlePluginUsageInfo = null;
            } else {
                PsiElement psiElement;
                String newVersion;
                Intrinsics.checkNotNull((Object)it);
                gradlePluginUsageInfo = new GradlePluginUsageInfo(projectBuildModel, it, newVersion, psiElement);
            }
            if (gradlePluginUsageInfo == null) continue;
            GradlePluginUsageInfo it$iv$iv = gradlePluginUsageInfo;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/processor/UpdateGradlePluginProcessor$GradlePluginUsageInfo;", "Lcom/intellij/usageView/UsageInfo;", "projectBuildModel", "Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;", "dependencyModel", "Lcom/android/tools/idea/gradle/dsl/api/dependencies/ArtifactDependencyModel;", "newVersion", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;Lcom/android/tools/idea/gradle/dsl/api/dependencies/ArtifactDependencyModel;Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "getProjectBuildModel", "()Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;", "getDependencyModel", "()Lcom/android/tools/idea/gradle/dsl/api/dependencies/ArtifactDependencyModel;", "getNewVersion", "()Ljava/lang/String;", "intellij.android.projectSystem.gradle"})
    private static final class GradlePluginUsageInfo
    extends UsageInfo {
        @NotNull
        private final ProjectBuildModel projectBuildModel;
        @NotNull
        private final ArtifactDependencyModel dependencyModel;
        @NotNull
        private final String newVersion;

        public GradlePluginUsageInfo(@NotNull ProjectBuildModel projectBuildModel, @NotNull ArtifactDependencyModel dependencyModel, @NotNull String newVersion, @NotNull PsiElement psiElement) {
            Intrinsics.checkNotNullParameter((Object)projectBuildModel, (String)"projectBuildModel");
            Intrinsics.checkNotNullParameter((Object)dependencyModel, (String)"dependencyModel");
            Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            super(psiElement);
            this.projectBuildModel = projectBuildModel;
            this.dependencyModel = dependencyModel;
            this.newVersion = newVersion;
        }

        @NotNull
        public final ProjectBuildModel getProjectBuildModel() {
            return this.projectBuildModel;
        }

        @NotNull
        public final ArtifactDependencyModel getDependencyModel() {
            return this.dependencyModel;
        }

        @NotNull
        public final String getNewVersion() {
            return this.newVersion;
        }
    }
}

