/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.tools.adtui.HtmlLabel;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeComponentNecessity;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeComponentRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessorKt;
import com.android.tools.idea.gradle.project.upgrade.GradlePluginUpgrade;
import com.android.tools.idea.gradle.project.upgrade.Java8DefaultRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.R8FullModeDefaultRefactoringProcessor;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class AgpUpgradeRefactoringProcessorDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JEditorPane myEditorPane;
    private JPanel myJava8SettingsPanel;
    private JPanel myR8FullModeSettingsPanel;
    private ComboBox<Java8DefaultRefactoringProcessor.NoLanguageLevelAction> myNoLanguageLevelActionComboBox;
    private ComboBox<R8FullModeDefaultRefactoringProcessor.NoPropertyPresentAction> myNoPropertyPresentActionComboBox;
    @NotNull
    private AgpUpgradeRefactoringProcessor myProcessor;
    @NotNull
    private Java8DefaultRefactoringProcessor myJava8Processor;
    @NotNull
    private R8FullModeDefaultRefactoringProcessor myR8FullModeProcessor;

    AgpUpgradeRefactoringProcessorDialog(@NotNull AgpUpgradeRefactoringProcessor processor, boolean hasChangedBuildFiles) {
        this(processor, (Java8DefaultRefactoringProcessor)processor.getComponentRefactoringProcessors().stream().filter(x -> x instanceof Java8DefaultRefactoringProcessor).findFirst().get(), (R8FullModeDefaultRefactoringProcessor)processor.getComponentRefactoringProcessors().stream().filter(x -> x instanceof R8FullModeDefaultRefactoringProcessor).findFirst().get(), hasChangedBuildFiles);
    }

    AgpUpgradeRefactoringProcessorDialog(@NotNull AgpUpgradeRefactoringProcessor processor, @NotNull Java8DefaultRefactoringProcessor java8Processor, @NotNull R8FullModeDefaultRefactoringProcessor r8FullModeProcessor, boolean hasChangedBuildFiles) {
        this(processor, java8Processor, r8FullModeProcessor, hasChangedBuildFiles, false, false);
    }

    AgpUpgradeRefactoringProcessorDialog(@NotNull AgpUpgradeRefactoringProcessor processor, @NotNull Java8DefaultRefactoringProcessor java8Processor, @NotNull R8FullModeDefaultRefactoringProcessor r8FullModeProcessor, boolean hasChangedBuildFiles, boolean preserveComponentProcessorConfigurations) {
        this(processor, java8Processor, r8FullModeProcessor, hasChangedBuildFiles, preserveComponentProcessorConfigurations, false);
    }

    @VisibleForTesting
    AgpUpgradeRefactoringProcessorDialog(@NotNull AgpUpgradeRefactoringProcessor processor, @NotNull Java8DefaultRefactoringProcessor java8Processor, @NotNull R8FullModeDefaultRefactoringProcessor r8FullModeProcessor, boolean hasChangedBuildFiles, boolean preserveComponentProcessorConfigurations, boolean processorAlreadyConfiguredForJava8Dialog) {
        super(processor.getProject());
        JBLabel label2;
        R8FullModeDefaultRefactoringProcessor.NoPropertyPresentAction initialNoPropertyPresentAction;
        Java8DefaultRefactoringProcessor.NoLanguageLevelAction initialNoLanguageLevelAction;
        this.setupUI();
        this.myProcessor = processor;
        this.myJava8Processor = java8Processor;
        this.myR8FullModeProcessor = r8FullModeProcessor;
        this.setTitle("Android Gradle Plugin Upgrade Assistant");
        this.init();
        HtmlLabel.setUpAsHtmlLabel((JEditorPane)this.myEditorPane);
        this.myEditorPane.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                BrowserUtil.browse((URL)e.getURL());
            }
        });
        if (preserveComponentProcessorConfigurations) {
            initialNoLanguageLevelAction = this.myJava8Processor.getNoLanguageLevelAction();
            initialNoPropertyPresentAction = this.myR8FullModeProcessor.getNoPropertyPresentAction();
        } else {
            initialNoLanguageLevelAction = Java8DefaultRefactoringProcessor.NoLanguageLevelAction.ACCEPT_NEW_DEFAULT;
            initialNoPropertyPresentAction = R8FullModeDefaultRefactoringProcessor.NoPropertyPresentAction.ACCEPT_NEW_DEFAULT;
            Iterator<AgpUpgradeComponentRefactoringProcessor> iterator2 = this.myProcessor.getComponentRefactoringProcessors().iterator();
            while (iterator2.hasNext()) {
                Object p;
                AgpUpgradeComponentNecessity necessity = ((AgpUpgradeComponentRefactoringProcessor)((Object)(p = iterator2.next()))).necessity();
                ((AgpUpgradeComponentRefactoringProcessor)((Object)p)).setEnabled(necessity == AgpUpgradeComponentNecessity.MANDATORY_CODEPENDENT || necessity == AgpUpgradeComponentNecessity.MANDATORY_INDEPENDENT);
            }
        }
        if (!processorAlreadyConfiguredForJava8Dialog) {
            AbstractAction backAction2 = new AbstractAction(UIUtil.replaceMnemonicAmpersand((String)"&Back")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean hasChangesInBuildFiles = !GradlePluginUpgrade.isCleanEnoughProject(AgpUpgradeRefactoringProcessorDialog.this.myProcessor.getProject());
                    boolean runProcessor = (Boolean)ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.nonModal(), () -> {
                        AgpUpgradeRefactoringProcessorDialog dialog2 = new AgpUpgradeRefactoringProcessorDialog(AgpUpgradeRefactoringProcessorDialog.this.myProcessor, AgpUpgradeRefactoringProcessorDialog.this.myJava8Processor, AgpUpgradeRefactoringProcessorDialog.this.myR8FullModeProcessor, hasChangesInBuildFiles, true, true);
                        return dialog2.showAndGet();
                    });
                    if (runProcessor) {
                        DumbService.getInstance((Project)AgpUpgradeRefactoringProcessorDialog.this.myProcessor.getProject()).smartInvokeLater(() -> AgpUpgradeRefactoringProcessorDialog.this.myProcessor.run());
                    } else {
                        AgpUpgradeRefactoringProcessorKt.notifyCancelledUpgrade(AgpUpgradeRefactoringProcessorDialog.this.myProcessor.getProject(), AgpUpgradeRefactoringProcessorDialog.this.myProcessor.getCurrent());
                    }
                }
            };
            this.myProcessor.setBackFromPreviewAction(backAction2);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p><b>Incompatibility between Android Studio and Android Gradle plugin</b></p>");
        sb.append("<p>This project is using Android Gradle plugin version ").append(this.myProcessor.getCurrent()).append(", which is incompatible with this version of Android Studio.  To continue importing this project (").append(this.myProcessor.getProject().getName()).append(") Android Studio will upgrade ").append("the project's build files to use version ").append(this.myProcessor.getNew()).append(" of Android Gradle ").append("plugin (see the <a href='https://developer.android.com/studio/").append(this.myProcessor.getNew().isPreview() ? "preview/features" : "releases/gradle-plugin").append("'>release notes</a><icon src='AllIcons.Ide.External_link_arrow'> for more information).</p>");
        sb.append("<br/><p>The following commands will be executed to upgrade your project");
        if (this.myProcessor.getAgpVersionRefactoringProcessor().isEnabled()) {
            sb.append(" from Android Gradle Plugin version ").append(this.myProcessor.getCurrent()).append(" to version ").append(this.myProcessor.getNew());
        }
        sb.append(":</p>");
        sb.append("<br/><ul>");
        for (AgpUpgradeComponentRefactoringProcessor p : this.myProcessor.getComponentRefactoringProcessorsWithAgpVersionProcessorLast()) {
            if (!p.isEnabled() || p.isAlwaysNoOpForProject()) continue;
            sb.append("<li>").append(p.getCommandName()).append(".");
            String url = p.getReadMoreUrl();
            if (url != null) {
                sb.append(" <a href='").append(url).append("'>Read more</a>.");
            }
            sb.append("</li>");
        }
        sb.append("</ul>");
        if (hasChangedBuildFiles) {
            sb.append("<br/><p><b>Warning</b>: there are uncommitted changes in project build files.  Before upgrading, you should commit or revert changes to the build files so that changes from the upgrade process can be handled separately.</p>");
        }
        this.myEditorPane.setText(sb.toString());
        if (this.myJava8Processor.isEnabled() && !this.myJava8Processor.isAlwaysNoOpForProject()) {
            label2 = new JBLabel("Action on no explicit Java language level: ");
            this.myJava8SettingsPanel.add((Component)label2);
            this.myNoLanguageLevelActionComboBox = new ComboBox((Object[])new Java8DefaultRefactoringProcessor.NoLanguageLevelAction[]{Java8DefaultRefactoringProcessor.NoLanguageLevelAction.ACCEPT_NEW_DEFAULT, Java8DefaultRefactoringProcessor.NoLanguageLevelAction.INSERT_OLD_DEFAULT});
            this.myNoLanguageLevelActionComboBox.setSelectedItem((Object)initialNoLanguageLevelAction);
            this.myJava8SettingsPanel.add((Component)this.myNoLanguageLevelActionComboBox);
            this.myJava8SettingsPanel.setVisible(true);
        } else {
            this.myJava8SettingsPanel.setVisible(false);
        }
        if (this.myR8FullModeProcessor.isEnabled() && !this.myR8FullModeProcessor.isAlwaysNoOpForProject()) {
            label2 = new JBLabel("Action on no android.enableR8.fullMode property: ");
            this.myR8FullModeSettingsPanel.add((Component)label2);
            this.myNoPropertyPresentActionComboBox = new ComboBox((Object[])new R8FullModeDefaultRefactoringProcessor.NoPropertyPresentAction[]{R8FullModeDefaultRefactoringProcessor.NoPropertyPresentAction.ACCEPT_NEW_DEFAULT, R8FullModeDefaultRefactoringProcessor.NoPropertyPresentAction.INSERT_OLD_DEFAULT});
            this.myNoPropertyPresentActionComboBox.setSelectedItem((Object)initialNoPropertyPresentAction);
            this.myR8FullModeSettingsPanel.add((Component)this.myNoPropertyPresentActionComboBox);
            this.myR8FullModeSettingsPanel.setVisible(true);
        } else {
            this.myR8FullModeSettingsPanel.setVisible(false);
        }
        this.myPanel.setPreferredSize((Dimension)new JBDimension(500, -1));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected Action[] createActions() {
        PreviewRefactoringAction previewAction = new PreviewRefactoringAction();
        return (Action[])ArrayUtil.mergeArrays((Object[])super.createActions(), (Object[])new Action[]{previewAction});
    }

    public void doCancelAction() {
        if (this.myProcessor.getUsageView() != null) {
            this.myProcessor.getUsageView().close();
        }
        super.doCancelAction();
    }

    protected void doOKAction() {
        this.myProcessor.setPreviewUsages(false);
        if (this.myProcessor.getUsageView() != null) {
            this.myProcessor.getUsageView().close();
        }
        this.doOKActionWithPreviewState();
    }

    private void doOKActionWithPreviewState() {
        Enum action2;
        if (this.myNoLanguageLevelActionComboBox != null && (action2 = (Java8DefaultRefactoringProcessor.NoLanguageLevelAction)((Object)this.myNoLanguageLevelActionComboBox.getSelectedItem())) != null) {
            this.myJava8Processor.setNoLanguageLevelAction((Java8DefaultRefactoringProcessor.NoLanguageLevelAction)action2);
        }
        if (this.myNoPropertyPresentActionComboBox != null && (action2 = (R8FullModeDefaultRefactoringProcessor.NoPropertyPresentAction)((Object)this.myNoPropertyPresentActionComboBox.getSelectedItem())) != null) {
            this.myR8FullModeProcessor.setNoPropertyPresentAction((R8FullModeDefaultRefactoringProcessor.NoPropertyPresentAction)action2);
        }
        super.doOKAction();
    }

    @NotNull
    protected Action getOKAction() {
        Action okAction = super.getOKAction();
        okAction.putValue("Name", "Upgrade");
        return okAction;
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.myEditorPane = new JEditorPane();
        this.myPanel.add((Component)this.myEditorPane, new GridConstraints(0, 0, 1, 1, 0, 3, 4, 4, null, new Dimension(150, 50), null, 0, false));
        this.myJava8SettingsPanel = new JPanel();
        this.myJava8SettingsPanel.setLayout(new FlowLayout(1, 5, 5));
        this.myPanel.add((Component)this.myJava8SettingsPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myR8FullModeSettingsPanel = new JPanel();
        this.myR8FullModeSettingsPanel.setLayout(new FlowLayout(1, 5, 5));
        this.myPanel.add((Component)this.myR8FullModeSettingsPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
    }

    private class PreviewRefactoringAction
    extends DialogWrapper.DialogWrapperAction {
        protected PreviewRefactoringAction() {
            super((DialogWrapper)AgpUpgradeRefactoringProcessorDialog.this, "Show Usages");
        }

        protected void doAction(ActionEvent e) {
            AgpUpgradeRefactoringProcessorDialog.this.myProcessor.setPreviewUsages(true);
            AgpUpgradeRefactoringProcessorDialog.this.doOKActionWithPreviewState();
        }
    }
}

