/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.refactoring;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPath;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPathKt;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleRenameModuleHandler
implements RenameHandler,
TitledHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Module module = GradleRenameModuleHandler.getGradleModule(dataContext);
        return module != null && GradleRenameModuleHandler.getModuleRootDir(module) != null;
    }

    @Nullable
    private static VirtualFile getModuleRootDir(@NotNull Module module) {
        File moduleRootDir = AndroidRootUtil.findModuleRootFolderPath(module);
        if (moduleRootDir == null) {
            return null;
        }
        return VfsUtil.findFileByIoFile((File)moduleRootDir, (boolean)true);
    }

    @UiThread
    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file, @NotNull DataContext dataContext) {
    }

    @UiThread
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @NotNull DataContext dataContext) {
        Module module = GradleRenameModuleHandler.getGradleModule(dataContext);
        assert (module != null);
        String currentName = ModuleGrouper.instanceFor((Project)project).getShortenedName(module);
        if (LinkedAndroidModuleGroupUtilsKt.isHolderModule(module)) {
            Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.module.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)currentName, (InputValidator)new MyInputValidator(module));
        } else {
            Messages.showErrorDialog((Project)project, (String)"Cannot rename an Android Gradle sourceSet", (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
        }
    }

    @Nullable
    private static Module getGradleModule(@NotNull DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return module;
        }
        return null;
    }

    @NotNull
    public String getActionTitle() {
        return RefactoringBundle.message((String)"rename.module.title");
    }

    private static void requestSync(@NotNull Project project) {
        ProjectSystemService.getInstance(project).getProjectSystem().getSyncManager().requestSyncProject(new ProjectSystemSyncManager.SyncReason(GradleSyncStats.Trigger.TRIGGER_REFACTOR_MODULE_RENAMED));
    }

    private static String getNewPath(@NotNull String oldPath, @NotNull String newName) {
        Object newPath;
        List segments = Splitter.on((String)":").splitToList((CharSequence)oldPath);
        ArrayList modifiableSegments = Lists.newArrayList((Iterable)segments);
        int segmentCount = modifiableSegments.size();
        if (segmentCount == 0) {
            newPath = ":" + newName.trim();
        } else {
            modifiableSegments.set(segmentCount - 1, newName);
            newPath = Joiner.on((String)":").join((Iterable)modifiableSegments);
        }
        return newPath;
    }

    private static void reset(@NotNull List<GradleBuildModel> buildModels) {
        for (GradleBuildModel buildModel : buildModels) {
            buildModel.resetState();
        }
    }

    private static class MyInputValidator
    implements InputValidator {
        @NotNull
        private final Module myModule;

        private MyInputValidator(@NotNull Module module) {
            this.myModule = module;
        }

        public boolean checkInput(@Nullable String inputString) {
            String currentName = ModuleGrouper.instanceFor((Project)this.myModule.getProject()).getShortenedName(this.myModule);
            return inputString != null && !inputString.isEmpty() && !inputString.equals(currentName) && !inputString.contains(":") && !inputString.contains(".");
        }

        public boolean canClose(@NotNull String inputString) {
            final Project project = this.myModule.getProject();
            ProjectBuildModel projectModel = ProjectBuildModel.get(project);
            GradleSettingsModel settingsModel = projectModel.getProjectSettingsModel();
            if (settingsModel == null) {
                Messages.showErrorDialog((Project)project, (String)"Gradle settings file not found", (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                return true;
            }
            VirtualFile moduleRoot = GradleRenameModuleHandler.getModuleRootDir(this.myModule);
            assert (moduleRoot != null);
            GradleProjectPath gradleProjectPath = GradleProjectPathKt.getGradleProjectPath(this.myModule);
            if (gradleProjectPath != null && gradleProjectPath.getPath().equals(":")) {
                Messages.showErrorDialog((Project)project, (String)"Can't rename root module", (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                return true;
            }
            if (gradleProjectPath == null) {
                return true;
            }
            String oldModuleGradlePath = gradleProjectPath.getPath();
            ArrayList<GradleBuildModel> modifiedBuildModels = new ArrayList<GradleBuildModel>();
            for (Module module : Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).filter(LinkedAndroidModuleGroupUtilsKt::isHolderModule).toList()) {
                GradleBuildModel buildModel = projectModel.getModuleBuildModel(module);
                if (buildModel == null) continue;
                DependenciesModel dependenciesModel = buildModel.dependencies();
                for (ModuleDependencyModel dependency : dependenciesModel.modules()) {
                    ResolvedPropertyModel path = dependency.path();
                    if (!oldModuleGradlePath.equals(path.forceString())) continue;
                    path.setValue(GradleRenameModuleHandler.getNewPath(oldModuleGradlePath, inputString));
                }
                List<GradlePropertyModel> dynamicFeatures = buildModel.android().dynamicFeatures().toList();
                if (dynamicFeatures != null) {
                    for (GradlePropertyModel feature : dynamicFeatures) {
                        if (!oldModuleGradlePath.equals(feature.forceString())) continue;
                        feature.setValue(GradleRenameModuleHandler.getNewPath(oldModuleGradlePath, inputString));
                    }
                }
                if (!buildModel.isModified()) continue;
                modifiedBuildModels.add(buildModel);
            }
            String currentName = ModuleGrouper.instanceFor((Project)project).getShortenedName(this.myModule);
            String msg = IdeBundle.message((String)"command.renaming.module", (Object[])new Object[]{currentName});
            WriteCommandAction.Builder actionBuilder = WriteCommandAction.writeCommandAction((Project)project).withName(msg).withGlobalUndo();
            ThrowableComputable action2 = () -> {
                if (!settingsModel.modulePaths().contains(oldModuleGradlePath)) {
                    String settingsFileName = settingsModel.getVirtualFile().getName();
                    Messages.showErrorDialog((Project)project, (String)("Can't find module '" + currentName + "' in " + settingsFileName), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                    GradleRenameModuleHandler.reset(modifiedBuildModels);
                    return true;
                }
                ModifiableModuleModel modifiableModel = ModuleManager.getInstance((Project)project).getModifiableModel();
                String newName = inputString;
                if (ModuleGrouperKt.isQualifiedModuleNamesEnabled((Project)project)) {
                    ArrayList<String> groupPath = new ArrayList<String>(ModuleGrouper.instanceFor((Project)project).getGroupPath(this.myModule));
                    groupPath.add(inputString);
                    newName = StringUtil.join(groupPath, (String)".");
                }
                try {
                    modifiableModel.renameModule(this.myModule, newName);
                }
                catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"error.module.already.exists", (Object[])new Object[]{inputString}), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0])));
                    GradleRenameModuleHandler.reset(modifiedBuildModels);
                    return false;
                }
                settingsModel.replaceModulePath(oldModuleGradlePath, GradleRenameModuleHandler.getNewPath(oldModuleGradlePath, inputString));
                for (GradleBuildModel buildModel : modifiedBuildModels) {
                    buildModel.applyChanges();
                }
                settingsModel.applyChanges();
                try {
                    moduleRoot.rename((Object)this, inputString);
                }
                catch (IOException e) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)("Rename folder failed: " + e.getMessage()), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0])));
                    GradleRenameModuleHandler.reset(modifiedBuildModels);
                    return false;
                }
                modifiableModel.commit();
                UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

                    public void undo() throws UnexpectedUndoException {
                        GradleRenameModuleHandler.requestSync(project);
                    }

                    public void redo() throws UnexpectedUndoException {
                        GradleRenameModuleHandler.requestSync(project);
                    }
                });
                return true;
            };
            try {
                if (((Boolean)actionBuilder.compute(action2)).booleanValue()) {
                    GradleRenameModuleHandler.requestSync(project);
                    return true;
                }
                return false;
            }
            catch (Throwable c) {
                return false;
            }
        }
    }
}

