/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.repositories;

import com.android.ide.common.gradle.Component;
import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.gradle.Module;
import com.android.ide.common.gradle.RichVersion;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.GoogleMavenRepositoryV2;
import com.android.ide.common.repository.GoogleMavenRepositoryV2Host;
import com.android.ide.common.repository.IdeNetworkCacheUtils;
import com.android.ide.common.repository.MavenRepositories;
import com.android.ide.common.repository.NetworkCache;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.io.CancellableFileIo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.repositories.IdeGoogleMavenRepository;
import com.android.tools.idea.gradle.repositories.OfflineIdeGoogleMavenRepository;
import com.android.tools.idea.gradle.util.GradleLocalCache;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.ui.GuiTestingService;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.LintClient;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.serviceContainer.NonInjectable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 42\u00020\u0001:\u00014B3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\t\b\u0010\u00a2\u0006\u0004\b\n\u0010\fJ\b\u0010\u0013\u001a\u00020\u0003H\u0002J\b\u0010\u0014\u001a\u00020\u0006H\u0002J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tJ(\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u0006\u0010\u0019\u001a\u00020\tJ8\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!J8\u0010\"\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!J$\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u001cJ \u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020(2\u0006\u0010 \u001a\u00020!J$\u0010+\u001a\u0004\u0018\u00010\u00162\u0006\u0010,\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100J$\u00101\u001a\u0004\u0018\u00010\u000f2\u0006\u0010,\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100J\u0018\u00102\u001a\u0002032\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/tools/idea/gradle/repositories/RepositoryUrlManager;", "", "googleMavenRepository", "Lcom/android/ide/common/repository/GoogleMavenRepository;", "cachedGoogleMavenRepository", "googleMavenRepositoryV2", "Lcom/android/ide/common/repository/GoogleMavenRepositoryV2;", "cachedGoogleMavenRepositoryV2", "useEmbeddedStudioRepo", "", "<init>", "(Lcom/android/ide/common/repository/GoogleMavenRepository;Lcom/android/ide/common/repository/GoogleMavenRepository;Lcom/android/ide/common/repository/GoogleMavenRepositoryV2;Lcom/android/ide/common/repository/GoogleMavenRepositoryV2;Z)V", "()V", "pendingNetworkRequests", "", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "useGMavenV2", "bestGoogleMavenRepository", "bestGoogleMavenRepositoryV2", "getArtifactComponent", "Lcom/android/ide/common/gradle/Component;", "artifactId", "Lcom/android/ide/common/repository/GoogleMavenArtifactId;", "preview", "filter", "Ljava/util/function/Predicate;", "Lcom/android/ide/common/gradle/Version;", "getLibraryRevision", "groupId", "includePreviews", "fileSystem", "Ljava/nio/file/FileSystem;", "findVersion", "findCompileDependencies", "", "Lcom/android/ide/common/gradle/Dependency;", "version", "getArchiveForComponent", "Ljava/io/File;", "component", "sdkLocation", "resolveDependency", "dependency", "project", "Lcom/intellij/openapi/project/Project;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "resolveDependencyRichVersion", "refreshCacheInBackground", "", "Companion", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nRepositoryUrlManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoryUrlManager.kt\ncom/android/tools/idea/gradle/repositories/RepositoryUrlManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,346:1\n25#2:347\n774#3:348\n865#3,2:349\n*S KotlinDebug\n*F\n+ 1 RepositoryUrlManager.kt\ncom/android/tools/idea/gradle/repositories/RepositoryUrlManager\n*L\n69#1:347\n157#1:348\n157#1:349,2\n*E\n"})
public final class RepositoryUrlManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GoogleMavenRepository googleMavenRepository;
    @NotNull
    private final GoogleMavenRepository cachedGoogleMavenRepository;
    @NotNull
    private final GoogleMavenRepositoryV2 googleMavenRepositoryV2;
    @NotNull
    private final GoogleMavenRepositoryV2 cachedGoogleMavenRepositoryV2;
    private final boolean useEmbeddedStudioRepo;
    @NotNull
    private final Set<String> pendingNetworkRequests;
    @NotNull
    private final Logger logger;
    private final boolean useGMavenV2;

    @NonInjectable
    @VisibleForTesting
    public RepositoryUrlManager(@NotNull GoogleMavenRepository googleMavenRepository, @NotNull GoogleMavenRepository cachedGoogleMavenRepository, @NotNull GoogleMavenRepositoryV2 googleMavenRepositoryV2, @NotNull GoogleMavenRepositoryV2 cachedGoogleMavenRepositoryV2, boolean useEmbeddedStudioRepo) {
        Intrinsics.checkNotNullParameter((Object)googleMavenRepository, (String)"googleMavenRepository");
        Intrinsics.checkNotNullParameter((Object)cachedGoogleMavenRepository, (String)"cachedGoogleMavenRepository");
        Intrinsics.checkNotNullParameter((Object)googleMavenRepositoryV2, (String)"googleMavenRepositoryV2");
        Intrinsics.checkNotNullParameter((Object)cachedGoogleMavenRepositoryV2, (String)"cachedGoogleMavenRepositoryV2");
        this.googleMavenRepository = googleMavenRepository;
        this.cachedGoogleMavenRepository = cachedGoogleMavenRepository;
        this.googleMavenRepositoryV2 = googleMavenRepositoryV2;
        this.cachedGoogleMavenRepositoryV2 = cachedGoogleMavenRepositoryV2;
        this.useEmbeddedStudioRepo = useEmbeddedStudioRepo;
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.pendingNetworkRequests = keySetView;
        RepositoryUrlManager $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(RepositoryUrlManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        Object t = StudioFlags.ENABLE_GMAVEN_REPOSITORY_V2.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        this.useGMavenV2 = (Boolean)t;
    }

    public /* synthetic */ RepositoryUrlManager(GoogleMavenRepository googleMavenRepository, GoogleMavenRepository googleMavenRepository2, GoogleMavenRepositoryV2 googleMavenRepositoryV2, GoogleMavenRepositoryV2 googleMavenRepositoryV22, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this(googleMavenRepository, googleMavenRepository2, googleMavenRepositoryV2, googleMavenRepositoryV22, bl);
    }

    private final GoogleMavenRepository bestGoogleMavenRepository() {
        return ApplicationManager.getApplication().isDispatchThread() ? this.cachedGoogleMavenRepository : this.googleMavenRepository;
    }

    private final GoogleMavenRepositoryV2 bestGoogleMavenRepositoryV2() {
        return ApplicationManager.getApplication().isDispatchThread() ? this.cachedGoogleMavenRepositoryV2 : this.googleMavenRepositoryV2;
    }

    public RepositoryUrlManager() {
        this(IdeGoogleMavenRepository.INSTANCE, OfflineIdeGoogleMavenRepository.INSTANCE, GoogleMavenRepositoryV2.Companion.create(new GoogleMavenRepositoryV2Host(){
            private final Path cacheDir = ApplicationManager.getApplication().isUnitTestMode() || GuiTestingService.getInstance().isGuiTestingMode() ? null : Paths.get(PathManager.getSystemPath(), new String[0]).normalize().resolve("maven.google");

            public Path getCacheDir() {
                return this.cacheDir;
            }

            public NetworkCache.ReadUrlDataResult readUrlData(String url, int timeout, long lastModified) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                return IdeNetworkCacheUtils.Companion.readHttpUrlData$default(IdeNetworkCacheUtils.Companion, url, timeout, lastModified, null, 8, null);
            }

            public void error(Throwable throwable, String message) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                Logger.getInstance(RepositoryUrlManager.class).warn(message, throwable);
            }

            public InputStream readDefaultData(String relative) {
                return super.readDefaultData(relative);
            }

            public int getCacheExpiryHours() {
                return super.getCacheExpiryHours();
            }

            public int getNetworkTimeoutMs() {
                return super.getNetworkTimeoutMs();
            }

            public boolean getUseNetwork() {
                return super.getUseNetwork();
            }
        }), GoogleMavenRepositoryV2.Companion.create(new GoogleMavenRepositoryV2Host(){
            private final Path cacheDir = ApplicationManager.getApplication().isUnitTestMode() || GuiTestingService.getInstance().isGuiTestingMode() ? null : Paths.get(PathManager.getSystemPath(), new String[0]).normalize().resolve("maven.google");

            public Path getCacheDir() {
                return this.cacheDir;
            }

            public NetworkCache.ReadUrlDataResult readUrlData(String url, int timeout, long lastModified) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                throw new UnsupportedOperationException("Should not be called as it is supposed to be an offline repository");
            }

            public void error(Throwable throwable, String message) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                Logger.getInstance(RepositoryUrlManager.class).warn(message, throwable);
            }

            public InputStream readDefaultData(String relative) {
                return super.readDefaultData(relative);
            }

            public int getCacheExpiryHours() {
                return super.getCacheExpiryHours();
            }

            public int getNetworkTimeoutMs() {
                return super.getNetworkTimeoutMs();
            }

            public boolean getUseNetwork() {
                return super.getUseNetwork();
            }
        }), false);
    }

    @Nullable
    public final Component getArtifactComponent(@NotNull GoogleMavenArtifactId artifactId, boolean preview) {
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        return this.getArtifactComponent(artifactId, null, preview);
    }

    @Nullable
    public final Component getArtifactComponent(@NotNull GoogleMavenArtifactId artifactId, @Nullable Predicate<Version> filter2, boolean preview) {
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        String string = artifactId.getMavenGroupId();
        String string2 = artifactId.getMavenArtifactId();
        FileSystem fileSystem = FileSystems.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getDefault(...)");
        String string3 = this.getLibraryRevision(string, string2, filter2, preview, fileSystem);
        if (string3 == null) {
            return null;
        }
        String revision = string3;
        return artifactId.getComponent(revision);
    }

    @Nullable
    public final String getLibraryRevision(@NotNull String groupId, @NotNull String artifactId, @Nullable Predicate<Version> filter2, boolean includePreviews, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Version version2 = this.findVersion(groupId, artifactId, filter2, includePreviews, fileSystem);
        return version2 != null ? version2.toString() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Version findVersion(@NotNull String groupId, @NotNull String artifactId, @Nullable Predicate<Version> filter2, boolean includePreviews, @NotNull FileSystem fileSystem) {
        Version version2;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Version version3 = version2 = this.useGMavenV2 ? this.bestGoogleMavenRepositoryV2().findVersion(groupId, artifactId, filter2, includePreviews) : this.bestGoogleMavenRepository().findVersion(groupId, artifactId, filter2, includePreviews);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.refreshCacheInBackground(groupId, artifactId);
        }
        if (version2 != null) {
            this.logger.debug("Found dependency " + groupId + ":" + artifactId + ":" + version2 + " in GMaven");
            return version2;
        }
        if (this.useEmbeddedStudioRepo) {
            Version embeddedVersion;
            Component component;
            block6: {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                List<File> list = GradleProjectSystemUtil.findAndroidStudioLocalMavenRepoPaths();
                Intrinsics.checkNotNullExpressionValue(list, (String)"findAndroidStudioLocalMavenRepoPaths(...)");
                Iterable iterable = list;
                boolean $i$f$filter = false;
                Component component2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    File it = (File)element$iv$iv;
                    boolean bl = false;
                    File file = it;
                    boolean bl2 = file != null ? file.isDirectory() : false;
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (File it : (Iterable)((List)destination$iv$iv)) {
                    boolean bl = false;
                    Path repoPath = fileSystem.getPath(it.getPath(), new String[0]);
                    this.logger.debug("Checking " + repoPath + " for " + groupId + ":" + artifactId + "...");
                    component2 = MavenRepositories.getHighestInstalledVersion((String)groupId, (String)artifactId, (Path)repoPath, filter2, (boolean)includePreviews);
                    if (component2 == null) continue;
                    component = component2;
                    break block6;
                }
                component = null;
            }
            Component component3 = component;
            Version version4 = embeddedVersion = component3 != null ? component3.getVersion() : null;
            if (embeddedVersion != null) {
                this.logger.debug("Found dependency " + groupId + ":" + artifactId + ":" + embeddedVersion + " in embedded repo");
                return embeddedVersion;
            }
        }
        return null;
    }

    @NotNull
    public final List<Dependency> findCompileDependencies(@NotNull String groupId, @NotNull String artifactId, @NotNull Version version2) {
        List result2;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        List list = result2 = this.useGMavenV2 ? this.bestGoogleMavenRepositoryV2().findCompileDependencies(groupId, artifactId, version2) : this.bestGoogleMavenRepository().findCompileDependencies(groupId, artifactId, version2);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.refreshCacheInBackground(groupId, artifactId);
        }
        return result2;
    }

    @Nullable
    public final File getArchiveForComponent(@NotNull Component component, @NotNull File sdkLocation, @NotNull FileSystem fileSystem) {
        Path artifactDirectory;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)sdkLocation, (String)"sdkLocation");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        String group2 = component.getGroup();
        String name2 = component.getName();
        Path sdkPath = fileSystem.getPath(sdkLocation.getPath(), new String[0]);
        SdkMavenRepository sdkMavenRepository = SdkMavenRepository.find((Path)sdkPath, (String)group2, (String)name2);
        if (sdkMavenRepository == null) {
            return null;
        }
        SdkMavenRepository repository2 = sdkMavenRepository;
        Path path = repository2.getRepositoryLocation(sdkPath, true);
        if (path == null) {
            return null;
        }
        Path repositoryLocation = path;
        Path path2 = artifactDirectory = MavenRepositories.getArtifactDirectory((Path)repositoryLocation, (Component)component);
        Intrinsics.checkNotNull((Object)path2);
        if (!CancellableFileIo.isDirectory((Path)path2, (LinkOption[])new LinkOption[0])) {
            return null;
        }
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)"jar", (Object)"aar").iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
        UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
        while (unmodifiableIterator2.hasNext()) {
            String artifactType = (String)unmodifiableIterator2.next();
            Path archive = artifactDirectory.resolve(name2 + "-" + component.getVersion() + "." + artifactType);
            if (!CancellableFileIo.isRegularFile((Path)archive, (LinkOption[])new LinkOption[0])) continue;
            return archive.toFile();
        }
        return null;
    }

    @Nullable
    public final Component resolveDependency(@NotNull Dependency dependency, @Nullable Project project, @Nullable AndroidSdkHandler sdkHandler) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        AndroidSdkHandler androidSdkHandler = sdkHandler;
        if (androidSdkHandler == null) {
            AndroidSdkHandler androidSdkHandler2 = AndroidSdks.getInstance().tryToChooseSdkHandler();
            androidSdkHandler = androidSdkHandler2;
            Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler2, (String)"tryToChooseSdkHandler(...)");
        }
        String string = this.resolveDependencyRichVersion(dependency, project, androidSdkHandler);
        if (string == null) {
            return null;
        }
        String version2 = string;
        String string2 = dependency.getGroup();
        if (string2 == null) {
            return null;
        }
        return new Component(string2, dependency.getName(), Version.Companion.parse(version2));
    }

    @Nullable
    public final String resolveDependencyRichVersion(@NotNull Dependency dependency, @Nullable Project project, @Nullable AndroidSdkHandler sdkHandler) {
        String remoteRepoVersion;
        Version versionFound;
        Version previewVersion;
        Version stableVersion;
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        AndroidSdkHandler androidSdkHandler = sdkHandler;
        if (androidSdkHandler == null) {
            AndroidSdkHandler androidSdkHandler2 = AndroidSdks.getInstance().tryToChooseSdkHandler();
            androidSdkHandler = androidSdkHandler2;
            Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler2, (String)"tryToChooseSdkHandler(...)");
        }
        AndroidSdkHandler sdkHandler2 = androidSdkHandler;
        Version version2 = dependency.getExplicitSingletonVersion();
        if (version2 != null) {
            Version it = version2;
            boolean bl = false;
            this.logger.debug("Returned " + dependency + " directly because it's a singleton");
            return it.toString();
        }
        Predicate<Version> filter2 = arg_0 -> RepositoryUrlManager.resolveDependencyRichVersion$lambda$3(dependency, arg_0);
        Module module = dependency.getModule();
        if (module == null) {
            RepositoryUrlManager $this$resolveDependencyRichVersion_u24lambda_u244 = this;
            boolean bl = false;
            $this$resolveDependencyRichVersion_u24lambda_u244.logger.debug("Couldn't resolve " + dependency + " since it doesn't correspond to a Module");
            return null;
        }
        Module module2 = module;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.refreshCacheInBackground(module2.getGroup(), module2.getName());
        }
        Version version3 = stableVersion = this.useGMavenV2 ? this.bestGoogleMavenRepositoryV2().findVersion(module2.getGroup(), module2.getName(), filter2, false) : this.bestGoogleMavenRepository().findVersion(module2.getGroup(), module2.getName(), filter2, false);
        if (stableVersion != null) {
            this.logger.debug("Resolved dependency stable " + module2.getGroup() + ":" + module2.getName() + ":" + stableVersion + " in GMaven");
            return stableVersion.toString();
        }
        Version version4 = previewVersion = this.useGMavenV2 ? this.bestGoogleMavenRepositoryV2().findVersion(module2.getGroup(), module2.getName(), filter2, true) : this.bestGoogleMavenRepository().findVersion(module2.getGroup(), module2.getName(), filter2, true);
        if (previewVersion != null) {
            this.logger.debug("Resolved dependency preview " + module2.getGroup() + ":" + module2.getName() + ":" + previewVersion + " in GMaven");
            return previewVersion.toString();
        }
        Path sdkLocation = sdkHandler2.getLocation();
        if (sdkLocation != null) {
            String string = module2.getGroup();
            String string2 = module2.getName();
            Object object = sdkHandler2.getLocation();
            if (object == null || (object = object.getFileSystem()) == null) {
                object = FileSystems.getDefault();
            }
            Object object2 = object;
            Intrinsics.checkNotNull((Object)object2);
            String libraryCoordinate = this.getLibraryRevision(string, string2, filter2, false, (FileSystem)object2);
            if (libraryCoordinate != null) {
                this.logger.debug("Resolved stable " + module2.getGroup() + ":" + module2.getName() + ":" + libraryCoordinate + " from library (see above)");
                return libraryCoordinate;
            }
            String string3 = module2.getGroup();
            String string4 = module2.getName();
            Object object3 = sdkHandler2.getLocation();
            if (object3 == null || (object3 = object3.getFileSystem()) == null) {
                object3 = FileSystems.getDefault();
            }
            object2 = object3;
            Intrinsics.checkNotNull((Object)object2);
            libraryCoordinate = this.getLibraryRevision(string3, string4, filter2, true, (FileSystem)object2);
            if (libraryCoordinate != null) {
                this.logger.debug("Resolved preview " + module2.getGroup() + ":" + module2.getName() + ":" + libraryCoordinate + " from library (see above)");
                return libraryCoordinate;
            }
        }
        if ((versionFound = GradleLocalCache.getInstance().findLatestArtifactVersion(dependency, project)) != null) {
            this.logger.debug("Resolved " + module2.getGroup() + ":" + module2.getName() + ":" + versionFound + " from Gradle cache");
            return versionFound.toString();
        }
        if (project == null) {
            RepositoryUrlManager $this$resolveDependencyRichVersion_u24lambda_u245 = this;
            boolean bl = false;
            $this$resolveDependencyRichVersion_u24lambda_u245.logger.debug("Couldn't resolve " + dependency + " because project is null");
            return null;
        }
        LintClient client = (LintClient)LintIdeSupport.createClient$default((LintIdeSupport)LintIdeSupport.Companion.get(), (Project)project, null, (int)2, null);
        boolean allowPreview = dependency.getExplicitlyIncludesPreview();
        Version version5 = GradleDetector.Companion.getLatestVersionFromRemoteRepo(client, dependency, filter2, allowPreview);
        String string = remoteRepoVersion = version5 != null ? version5.toString() : null;
        if (remoteRepoVersion != null) {
            this.logger.debug("Resolved " + module2.getGroup() + ":" + module2.getName() + ":" + remoteRepoVersion + " from remote Maven");
            return remoteRepoVersion;
        }
        this.logger.debug("Couldn't resolve " + dependency);
        return null;
    }

    private final void refreshCacheInBackground(String groupId, String artifactId) {
        String searchKey = groupId + ":" + artifactId;
        if (this.pendingNetworkRequests.add(searchKey)) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> RepositoryUrlManager.refreshCacheInBackground$lambda$8(this, groupId, artifactId, searchKey));
        }
    }

    private static final boolean resolveDependencyRichVersion$lambda$3(Dependency $dependency, Version version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        RichVersion richVersion = $dependency.getVersion();
        return richVersion != null ? richVersion.contains(version2) : true;
    }

    private static final boolean refreshCacheInBackground$lambda$8$lambda$6(Version it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean refreshCacheInBackground$lambda$8$lambda$7(Version it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void refreshCacheInBackground$lambda$8(RepositoryUrlManager this$0, String $groupId, String $artifactId, String $searchKey) {
        try {
            Version version2 = this$0.useGMavenV2 ? this$0.googleMavenRepositoryV2.findVersion($groupId, $artifactId, RepositoryUrlManager::refreshCacheInBackground$lambda$8$lambda$6, true) : this$0.googleMavenRepository.findVersion($groupId, $artifactId, RepositoryUrlManager::refreshCacheInBackground$lambda$8$lambda$7, true);
        }
        finally {
            this$0.pendingNetworkRequests.remove($searchKey);
        }
    }

    @JvmStatic
    @NotNull
    public static final RepositoryUrlManager get() {
        return Companion.get();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/gradle/repositories/RepositoryUrlManager$Companion;", "", "<init>", "()V", "get", "Lcom/android/tools/idea/gradle/repositories/RepositoryUrlManager;", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RepositoryUrlManager get() {
            Object object = ApplicationManager.getApplication().getService(RepositoryUrlManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (RepositoryUrlManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

