/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.repositories.search;

import com.android.ide.common.gradle.Version;
import com.android.tools.idea.gradle.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.repositories.search.GroupArtifactQuery;
import com.android.tools.idea.gradle.repositories.search.LocalMavenRepositoryKt;
import com.android.tools.idea.gradle.repositories.search.ModuleQuery;
import com.android.tools.idea.gradle.repositories.search.SearchQuery;
import com.android.tools.idea.gradle.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.repositories.search.SearchResult;
import com.google.wireless.android.sdk.stats.PSDEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Url;
import java.io.File;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/gradle/repositories/search/LocalMavenRepository;", "Lcom/android/tools/idea/gradle/repositories/search/ArtifactRepository;", "rootLocation", "Ljava/io/File;", "name", "", "<init>", "(Ljava/io/File;Ljava/lang/String;)V", "getRootLocation", "()Ljava/io/File;", "getName", "()Ljava/lang/String;", "rootLocationPath", "Ljava/nio/file/Path;", "isRemote", "", "()Z", "doSearch", "Lcom/android/tools/idea/gradle/repositories/search/SearchResult;", "request", "Lcom/android/tools/idea/gradle/repositories/search/SearchRequest;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "intellij.android.projectSystem.gradle.repositorySearch"})
public final class LocalMavenRepository
extends ArtifactRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File rootLocation;
    @NotNull
    private final String name;
    @NotNull
    private final Path rootLocationPath;
    private final boolean isRemote;

    public LocalMavenRepository(@NotNull File rootLocation, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)rootLocation, (String)"rootLocation");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(PSDEvent.PSDRepositoryUsage.PSDRepository.PROJECT_STRUCTURE_DIALOG_REPOSITORY_LOCAL);
        this.rootLocation = rootLocation;
        this.name = name2;
        Path path = this.rootLocation.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        this.rootLocationPath = path;
    }

    @NotNull
    public final File getRootLocation() {
        return this.rootLocation;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isRemote() {
        return this.isRemote;
    }

    @Override
    @NotNull
    protected SearchResult doSearch(@NotNull SearchRequest request) {
        Function2 function2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        List foundArtifacts = new ArrayList();
        SearchQuery query = request.getQuery();
        if (query instanceof ModuleQuery) {
            Function1 modulePredicate = LocalMavenRepositoryKt.access$toWildcardMatchingPredicate(((ModuleQuery)query).getModule());
            function2 = (arg_0, arg_1) -> LocalMavenRepository.doSearch$lambda$0(modulePredicate, arg_0, arg_1);
        } else if (query instanceof GroupArtifactQuery) {
            String string;
            String groupIdPredicate;
            String string2 = ((GroupArtifactQuery)query).getGroupId();
            if (string2 == null || (string2 = LocalMavenRepositoryKt.access$toWildcardMatchingPredicate(string2)) == null) {
                string2 = groupIdPredicate = LocalMavenRepository::doSearch$lambda$1;
            }
            if ((string = ((GroupArtifactQuery)query).getArtifactName()) == null || (string = LocalMavenRepositoryKt.access$toWildcardMatchingPredicate(string)) == null) {
                string = LocalMavenRepository::doSearch$lambda$2;
            }
            String artifactNamePredicate = string;
            function2 = (arg_0, arg_1) -> LocalMavenRepository.doSearch$lambda$3((Function1)groupIdPredicate, (Function1)artifactNamePredicate, arg_0, arg_1);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Function2 artifactPredicate = function2;
        try {
            Files.walkFileTree(this.rootLocationPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this, (Function2<? super String, ? super String, Boolean>)artifactPredicate, (List<FoundArtifact>)foundArtifacts){
                final /* synthetic */ LocalMavenRepository this$0;
                final /* synthetic */ Function2<String, String, Boolean> $artifactPredicate;
                final /* synthetic */ List<FoundArtifact> $foundArtifacts;
                {
                    this.this$0 = $receiver;
                    this.$artifactPredicate = $artifactPredicate;
                    this.$foundArtifacts = $foundArtifacts;
                }

                /*
                 * Unable to fully structure code
                 */
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    block6: {
                        block8: {
                            block7: {
                                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                                v0 = dir.toFile();
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toFile(...)");
                                visitedDirFile = v0;
                                repositoryRelativeDirectory = FilesKt.relativeTo((File)visitedDirFile, (File)this.this$0.getRootLocation());
                                if (repositoryRelativeDirectory.getParentFile() == null) {
                                    return FileVisitResult.CONTINUE;
                                }
                                v1 = repositoryRelativeDirectory.getParentFile().getPath();
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getPath(...)");
                                groupIdProbe = StringsKt.replace$default((String)v1, (char)File.separatorChar, (char)'.', (boolean)false, (int)4, null);
                                artifactNameProbe = visitedDirFile.getName();
                                Intrinsics.checkNotNull((Object)artifactNameProbe);
                                if (!((Boolean)this.$artifactPredicate.invoke((Object)groupIdProbe, (Object)artifactNameProbe)).booleanValue()) break block6;
                                var8_7 = visitedDirFile.listFiles();
                                if (var8_7 == null) break block7;
                                var9_8 = var8_7;
                                $i$f$mapNotNull = false;
                                var11_10 = $this$mapNotNull$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$mapNotNullTo = false;
                                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                $i$f$forEach = false;
                                var17_16 = ((void)$this$forEach$iv$iv$iv).length;
                                for (var16_15 = 0; var16_15 < var17_16; ++var16_15) {
                                    element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[var16_15];
                                    $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
                                    it = element$iv$iv;
                                    $i$a$-mapNotNull-LocalMavenRepository$doSearch$1$preVisitDirectory$versions$1 = false;
                                    versionProbe = it.getName();
                                    expectedPomFileName = artifactNameProbe + "-" + versionProbe + ".pom";
                                    if (!it.isDirectory()) ** GOTO lbl-1000
                                    Intrinsics.checkNotNull((Object)it);
                                    if (FilesKt.resolve((File)it, (String)expectedPomFileName).isFile()) {
                                        Intrinsics.checkNotNull((Object)versionProbe);
                                        v2 = Version.Companion.parse(versionProbe);
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v2 = null;
                                    }
                                    if (v2 == null) continue;
                                    it$iv$iv = v2;
                                    $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
                                    destination$iv$iv.add(it$iv$iv);
                                }
                                v3 = (List)destination$iv$iv;
                                break block8;
                            }
                            v3 = v4 = null;
                        }
                        if (v3 == null) {
                            v4 = CollectionsKt.emptyList();
                        }
                        if (((Collection)(versions = v4)).isEmpty() == false) {
                            this.$foundArtifacts.add(new FoundArtifact(this.this$0.getName(), groupIdProbe, artifactNameProbe, versions));
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Throwable e) {
            String msg = "Failed to search local repository " + this.rootLocationPath;
            Logger.getInstance(LocalMavenRepository.class).warn(msg, e);
        }
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                FoundArtifact it = (FoundArtifact)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getGroupId());
                it = (FoundArtifact)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getGroupId())));
            }
        };
        return new SearchResult(CollectionsKt.sortedWith((Iterable)foundArtifacts, (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    FoundArtifact it = (FoundArtifact)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (FoundArtifact)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
                return n;
            }
        }));
    }

    @NotNull
    public final File component1() {
        return this.rootLocation;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final LocalMavenRepository copy(@NotNull File rootLocation, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)rootLocation, (String)"rootLocation");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return new LocalMavenRepository(rootLocation, name2);
    }

    public static /* synthetic */ LocalMavenRepository copy$default(LocalMavenRepository localMavenRepository, File file, String string, int n, Object object) {
        if ((n & 1) != 0) {
            file = localMavenRepository.rootLocation;
        }
        if ((n & 2) != 0) {
            string = localMavenRepository.name;
        }
        return localMavenRepository.copy(file, string);
    }

    @NotNull
    public String toString() {
        return "LocalMavenRepository(rootLocation=" + this.rootLocation + ", name=" + this.name + ")";
    }

    public int hashCode() {
        int result2 = this.rootLocation.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LocalMavenRepository)) {
            return false;
        }
        LocalMavenRepository localMavenRepository = (LocalMavenRepository)other;
        if (!Intrinsics.areEqual((Object)this.rootLocation, (Object)localMavenRepository.rootLocation)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)localMavenRepository.name);
    }

    private static final boolean doSearch$lambda$0(Function1 $modulePredicate, String group2, String artifactName) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        return (Boolean)$modulePredicate.invoke((Object)(group2 + ":" + artifactName));
    }

    private static final boolean doSearch$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean doSearch$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean doSearch$lambda$3(Function1 $groupIdPredicate, Function1 $artifactNamePredicate, String group2, String artifactName) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        return (Boolean)$groupIdPredicate.invoke((Object)group2) != false && (Boolean)$artifactNamePredicate.invoke((Object)artifactName) != false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/gradle/repositories/search/LocalMavenRepository$Companion;", "", "<init>", "()V", "maybeCreateLocalMavenRepository", "Lcom/android/tools/idea/gradle/repositories/search/LocalMavenRepository;", "mavenRepositoryUrl", "", "mavenRepositoryName", "intellij.android.projectSystem.gradle.repositorySearch"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LocalMavenRepository maybeCreateLocalMavenRepository(@NotNull String mavenRepositoryUrl, @NotNull String mavenRepositoryName) {
            Intrinsics.checkNotNullParameter((Object)mavenRepositoryUrl, (String)"mavenRepositoryUrl");
            Intrinsics.checkNotNullParameter((Object)mavenRepositoryName, (String)"mavenRepositoryName");
            Url url = LocalMavenRepositoryKt.access$parseToLocalFile(mavenRepositoryUrl, false);
            if (url == null && (url = LocalMavenRepositoryKt.access$parseToLocalFile(mavenRepositoryUrl, true)) == null) {
                return null;
            }
            Url parsedRepositoryUrl = url;
            String string = parsedRepositoryUrl.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String repositoryPath = string;
            File repositoryRootFile = new File(repositoryPath);
            if (repositoryRootFile.isAbsolute()) {
                return new LocalMavenRepository(repositoryRootFile, mavenRepositoryName);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

