/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.repositories.search;

import com.android.ide.common.gradle.Version;
import com.android.tools.idea.gradle.repositories.search.ArbitraryModulesSearchByModuleQuery;
import com.android.tools.idea.gradle.repositories.search.ArbitraryModulesSearchQuery;
import com.android.tools.idea.gradle.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.repositories.search.GroupArtifactQuery;
import com.android.tools.idea.gradle.repositories.search.ModuleQuery;
import com.android.tools.idea.gradle.repositories.search.SearchQuery;
import com.android.tools.idea.gradle.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.repositories.search.SearchResult;
import com.android.tools.idea.gradle.repositories.search.SingleModuleSearchQuery;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.PSDEvent;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.io.HttpRequests;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/gradle/repositories/search/MavenCentralRepository;", "Lcom/android/tools/idea/gradle/repositories/search/ArtifactRepository;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "isRemote", "", "()Z", "doSearch", "Lcom/android/tools/idea/gradle/repositories/search/SearchResult;", "request", "Lcom/android/tools/idea/gradle/repositories/search/SearchRequest;", "parseArbitraryModulesResponse", "response", "Ljava/io/Reader;", "createArbitraryModulesRequestUrl", "parseSingleModuleResponse", "query", "Lcom/android/tools/idea/gradle/repositories/search/SingleModuleSearchQuery;", "createSingleModuleRequestUrl", "intellij.android.projectSystem.gradle.repositorySearch"})
@SourceDebugExtension(value={"SMAP\nMavenCentralRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenCentralRepository.kt\ncom/android/tools/idea/gradle/repositories/search/MavenCentralRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,183:1\n1611#2,9:184\n1863#2:193\n1864#2:196\n1620#2:197\n1485#2:198\n1510#2,3:199\n1513#2,3:209\n1368#2:215\n1454#2,5:216\n1557#2:222\n1628#2,3:223\n1#3:194\n1#3:195\n381#4,7:202\n126#5:212\n153#5,2:213\n155#5:221\n*S KotlinDebug\n*F\n+ 1 MavenCentralRepository.kt\ncom/android/tools/idea/gradle/repositories/search/MavenCentralRepository\n*L\n115#1:184,9\n115#1:193\n115#1:196\n115#1:197\n124#1:198\n124#1:199,3\n124#1:209,3\n126#1:215\n126#1:216,5\n169#1:222\n169#1:223,3\n115#1:195\n124#1:202,7\n125#1:212\n125#1:213,2\n125#1:221\n*E\n"})
public final class MavenCentralRepository
extends ArtifactRepository {
    @NotNull
    public static final MavenCentralRepository INSTANCE = new MavenCentralRepository();
    @NotNull
    private static final String name = "Maven Central";
    private static final boolean isRemote = true;

    private MavenCentralRepository() {
        super(PSDEvent.PSDRepositoryUsage.PSDRepository.PROJECT_STRUCTURE_DIALOG_REPOSITORY_MAVEN_CENTRAL);
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    public boolean isRemote() {
        return isRemote;
    }

    @Override
    @NotNull
    protected SearchResult doSearch(@NotNull SearchRequest request) {
        SearchResult searchResult;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        SearchQuery query = request.getQuery();
        if (query instanceof ArbitraryModulesSearchByModuleQuery || query instanceof ArbitraryModulesSearchQuery) {
            Object object = HttpRequests.request((String)this.createArbitraryModulesRequestUrl(request)).accept("application/xml").connect(MavenCentralRepository::doSearch$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connect(...)");
            searchResult = (SearchResult)object;
        } else if (query instanceof SingleModuleSearchQuery) {
            Object object = HttpRequests.request((String)this.createSingleModuleRequestUrl((SingleModuleSearchQuery)query)).accept("application/xml").connect(arg_0 -> MavenCentralRepository.doSearch$lambda$1(query, request, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connect(...)");
            searchResult = (SearchResult)object;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return searchResult;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final SearchResult parseArbitraryModulesResponse(@NotNull Reader response2) {
        List list;
        List list2;
        Element element;
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Element element2 = JDOMUtil.load((Reader)response2);
        if (element2 != null && (element = element2.getChild("result")) != null && (list2 = element.getChildren("doc")) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            CharSequence charSequence;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = list2;
            boolean $i$f$mapNotNull22 = false;
            void var8_8 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator<Object> iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FoundArtifact it$iv$iv;
                Version version2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Element docElement = (Element)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)docElement);
                String group2 = MavenCentralRepository.parseArbitraryModulesResponse$findStringAttribute(docElement, "g");
                String artifact = MavenCentralRepository.parseArbitraryModulesResponse$findStringAttribute(docElement, "a");
                if (MavenCentralRepository.parseArbitraryModulesResponse$findStringAttribute(docElement, "v") != null) {
                    String it;
                    boolean bl3 = false;
                    version2 = Version.Companion.parse(it);
                } else {
                    version2 = null;
                }
                Version version3 = version2;
                charSequence = group2;
                if ((charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)artifact) == null || StringsKt.isBlank((CharSequence)charSequence) || version3 == null ? null : new FoundArtifact(INSTANCE.getName(), group2, artifact, version3)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $i$f$mapNotNull22 = (List)destination$iv$iv;
            boolean $i$f$groupBy22 = false;
            destination$iv$iv = $this$groupBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                FoundArtifact it = (FoundArtifact)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = it.getGroupId() + ":" + it.getName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map $i$f$groupBy22 = destination$iv$iv2;
            boolean $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
                Collection collection2 = destination$iv$iv3;
                boolean bl = false;
                List allVersions = (List)entry.getValue();
                Iterable $i$f$getOrPut = allVersions;
                String string = null;
                String string2 = null;
                Set set2 = null;
                FoundArtifact foundArtifact = (FoundArtifact)CollectionsKt.first((List)allVersions);
                boolean $i$f$flatMap = false;
                charSequence = $this$flatMap$iv;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    FoundArtifact it = (FoundArtifact)element$iv$iv;
                    boolean bl6 = false;
                    Iterable list$iv$iv = it.getUnsortedVersions();
                    CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
                }
                List list3 = (List)destination$iv$iv4;
                collection2.add(FoundArtifact.copy$default(foundArtifact, set2, string2, string, CollectionsKt.toSet((Iterable)list3), 7, null));
            }
            list = (List)destination$iv$iv3;
        } else {
            list = CollectionsKt.emptyList();
        }
        List result2 = list;
        return new SearchResult(result2);
    }

    @VisibleForTesting
    @NotNull
    public final String createArbitraryModulesRequestUrl(@NotNull SearchRequest request) {
        String string;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        StringBuilder $this$createArbitraryModulesRequestUrl_u24lambda_u2413 = stringBuilder = new StringBuilder();
        boolean bl = false;
        SearchQuery searchQuery = request.getQuery();
        if (searchQuery instanceof GroupArtifactQuery) {
            String string2;
            String string3;
            String string4;
            Object[] objectArray;
            int n;
            String string5;
            Object object;
            Object[] objectArray2;
            Object[] objectArray3 = ((GroupArtifactQuery)request.getQuery()).getGroupId();
            if (objectArray3 != null) {
                Object[] it = objectArray2 = objectArray3;
                boolean bl2 = false;
                object = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? objectArray2 : null;
            } else {
                object = null;
            }
            Object[] queryGroupId = object;
            String string6 = ((GroupArtifactQuery)request.getQuery()).getArtifactName();
            if (string6 != null) {
                String string7;
                String it = string7 = string6;
                boolean bl3 = false;
                string5 = !StringsKt.isBlank((CharSequence)it) ? string7 : null;
            } else {
                string5 = null;
            }
            String queryArtifactId = string5;
            Object[] objectArray4 = objectArray2 = new String[2];
            int n2 = 0;
            if (queryGroupId != null) {
                Object[] it = queryGroupId;
                n = n2;
                objectArray = objectArray4;
                boolean bl4 = false;
                string4 = "g:" + MavenCentralRepository.createArbitraryModulesRequestUrl$lambda$13$escapeQueryExpression((String)it);
                objectArray4 = objectArray;
                n2 = n;
                string3 = string4;
            } else {
                string3 = null;
            }
            objectArray4[n2] = string3;
            Object[] objectArray5 = objectArray2;
            int n3 = 1;
            String string8 = queryArtifactId;
            if (string8 != null) {
                String it = string8;
                n = n3;
                objectArray = objectArray5;
                boolean bl5 = false;
                string4 = "a:" + MavenCentralRepository.createArbitraryModulesRequestUrl$lambda$13$escapeQueryExpression(it);
                objectArray5 = objectArray;
                n3 = n;
                string2 = string4;
            } else {
                string2 = null;
            }
            objectArray5[n3] = string2;
            String string9 = URLEncoder.encode(CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray2), (CharSequence)" AND ", null, null, (int)0, null, null, (int)62, null), Charsets.UTF_8);
            string = string9;
            Intrinsics.checkNotNull((Object)string9);
        } else if (searchQuery instanceof ModuleQuery) {
            String it = ((ModuleQuery)request.getQuery()).getModule();
            boolean bl6 = false;
            String string10 = URLEncoder.encode("id:" + MavenCentralRepository.createArbitraryModulesRequestUrl$lambda$13$escapeQueryExpression(it), Charsets.UTF_8);
            string = string10;
            Intrinsics.checkNotNull((Object)string10);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String query = string;
        $this$createArbitraryModulesRequestUrl_u24lambda_u2413.append("https://search.maven.org/solrsearch/select?");
        $this$createArbitraryModulesRequestUrl_u24lambda_u2413.append("rows=" + request.getRowCount() + "&");
        $this$createArbitraryModulesRequestUrl_u24lambda_u2413.append("start=" + request.getStart() + "&");
        $this$createArbitraryModulesRequestUrl_u24lambda_u2413.append("wt=xml&");
        $this$createArbitraryModulesRequestUrl_u24lambda_u2413.append("q=" + query + "&");
        $this$createArbitraryModulesRequestUrl_u24lambda_u2413.append("core=gav");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final SearchResult parseSingleModuleResponse(@NotNull Reader response2, @NotNull SingleModuleSearchQuery query) {
        SearchResult searchResult;
        FoundArtifact result2;
        FoundArtifact foundArtifact;
        List list;
        Element element;
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Element element2 = JDOMUtil.load((Reader)response2);
        if (element2 == null) {
            return new SearchResult(CollectionsKt.emptyList());
        }
        Element root = element2;
        if (!Intrinsics.areEqual((Object)query.getGroupId(), (Object)root.getChild("groupId").getTextTrim())) {
            return new SearchResult(CollectionsKt.emptyList());
        }
        if (!Intrinsics.areEqual((Object)query.getArtifactName(), (Object)root.getChild("artifactId").getTextTrim())) {
            return new SearchResult(CollectionsKt.emptyList());
        }
        Element element3 = root.getChild("versioning");
        if (element3 != null && (element = element3.getChild("versions")) != null && (list = element.getChildren("version")) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list;
            boolean $i$f$map = false;
            void var11_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Element element4 = (Element)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                String string = it.getTextTrim();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextTrim(...)");
                collection2.add(Version.Companion.parse(string));
            }
            List it = (List)destination$iv$iv;
            boolean bl = false;
            foundArtifact = new FoundArtifact(INSTANCE.getName(), query.getGroupId(), query.getArtifactName(), it);
        } else {
            foundArtifact = null;
        }
        FoundArtifact foundArtifact2 = result2 = foundArtifact;
        if (foundArtifact2 != null) {
            FoundArtifact it = foundArtifact2;
            boolean bl = false;
            searchResult = new SearchResult(CollectionsKt.listOf(result2));
        } else {
            searchResult = new SearchResult(CollectionsKt.emptyList());
        }
        return searchResult;
    }

    @VisibleForTesting
    @NotNull
    public final String createSingleModuleRequestUrl(@NotNull SingleModuleSearchQuery query) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        StringBuilder $this$createSingleModuleRequestUrl_u24lambda_u2417 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createSingleModuleRequestUrl_u24lambda_u2417.append("https://repo.maven.apache.org/maven2/");
        $this$createSingleModuleRequestUrl_u24lambda_u2417.append(StringsKt.replace$default((String)query.getGroupId(), (char)'.', (char)'/', (boolean)false, (int)4, null));
        $this$createSingleModuleRequestUrl_u24lambda_u2417.append("/");
        $this$createSingleModuleRequestUrl_u24lambda_u2417.append(query.getArtifactName());
        $this$createSingleModuleRequestUrl_u24lambda_u2417.append("/maven-metadata.xml");
        return stringBuilder.toString();
    }

    private static final SearchResult doSearch$lambda$0(HttpRequests.Request it) {
        SearchResult searchResult;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            BufferedReader bufferedReader = it.getReader();
            Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"getReader(...)");
            searchResult = INSTANCE.parseArbitraryModulesResponse(bufferedReader);
        }
        catch (JDOMException e) {
            throw new IOException("Failed to parse request: " + it, e);
        }
        return searchResult;
    }

    private static final SearchResult doSearch$lambda$1(SearchQuery $query, SearchRequest $request, HttpRequests.Request it) {
        SearchResult searchResult;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            BufferedReader bufferedReader = it.getReader();
            Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"getReader(...)");
            searchResult = INSTANCE.parseSingleModuleResponse(bufferedReader, (SingleModuleSearchQuery)$query);
        }
        catch (HttpRequests.HttpStatusException e) {
            ArbitraryModulesSearchQuery fallbackQuery = new ArbitraryModulesSearchQuery(((SingleModuleSearchQuery)$query).getGroupId(), ((SingleModuleSearchQuery)$query).getArtifactName());
            SearchRequest fallbackRequest = new SearchRequest(fallbackQuery, $request.getRowCount(), $request.getStart());
            searchResult = INSTANCE.doSearch(fallbackRequest);
        }
        catch (JDOMException e) {
            throw new IOException("Failed to parse request: " + it, e);
        }
        return searchResult;
    }

    private static final String parseArbitraryModulesResponse$findStringAttribute(Element $this$parseArbitraryModulesResponse_u24findStringAttribute, String name2) {
        Object v1;
        block1: {
            List list = $this$parseArbitraryModulesResponse_u24findStringAttribute.getChildren("str");
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                Element it = (Element)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getAttributeValue("name"), (Object)name2)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        Element element = v1;
        return element != null ? element.getTextTrim() : null;
    }

    private static final String createArbitraryModulesRequestUrl$lambda$13$escapeQueryExpression(String $this$createArbitraryModulesRequestUrl_u24lambda_u2413_u24escapeQueryExpression) {
        return $this$createArbitraryModulesRequestUrl_u24lambda_u2413_u24escapeQueryExpression;
    }
}

