/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.sdk;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class GradleAndroidSdkEventListener
implements IdeSdks.AndroidSdkEventListener {
    private static final Logger LOG = Logger.getInstance(GradleAndroidSdkEventListener.class);

    @Override
    public void afterSdkPathChange(@NotNull File sdkPath, @NotNull Project project) {
        LocalProperties localProperties;
        if (!(ProjectSystemUtil.getProjectSystem(project) instanceof GradleProjectSystem)) {
            return;
        }
        try {
            localProperties = new LocalProperties(Projects.getBaseDirPath((Project)project));
        }
        catch (IOException e) {
            GradleAndroidSdkEventListener.logAndShowErrorWhenUpdatingLocalProperties(project, e, "read", sdkPath);
            return;
        }
        if (!FileUtil.filesEqual((File)sdkPath, (File)localProperties.getAndroidSdkPath())) {
            try {
                localProperties.setAndroidSdkPath(sdkPath);
                localProperties.save();
            }
            catch (IOException e) {
                GradleAndroidSdkEventListener.logAndShowErrorWhenUpdatingLocalProperties(project, e, "update", sdkPath);
                return;
            }
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ProjectSystemService.getInstance(project).getProjectSystem().getSyncManager().requestSyncProject(new ProjectSystemSyncManager.SyncReason(GradleSyncStats.Trigger.TRIGGER_SDK_PATH_CHANGED));
        }
    }

    private static void logAndShowErrorWhenUpdatingLocalProperties(@NotNull Project project, @NotNull Exception error, @NotNull String action2, @NotNull File sdkHomePath) {
        LOG.info((Throwable)error);
        String msg = String.format("Unable to %1$s local.properties file in project '%2$s'.\n\nCause: %3$s\n\nPlease manually update the file's '%4$s' property value to \n'%5$s'\nand sync the project with Gradle files.", action2, project.getName(), GradleAndroidSdkEventListener.getMessage(error), "sdk.dir", sdkHomePath.getPath());
        Messages.showErrorDialog((Project)project, (String)msg, (String)"Project SDK Update");
    }

    @NotNull
    private static String getMessage(@NotNull Exception e) {
        String cause = e.getMessage();
        return Strings.isNullOrEmpty((String)cause) ? "[Unknown]" : cause;
    }
}

