/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.project;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.dependencies.details.JarDependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.dependencies.details.ModuleDependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.dependencies.details.MultipleLibraryDependenciesDetails;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.AbstractDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.GoToModuleAction;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.ModuleDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.graph.DependenciesTreeRootNode;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.graph.DependenciesTreeStructure;
import com.android.tools.idea.gradle.structure.configurables.issues.DependencyViewIssuesRenderer;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesViewer;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.AbstractDependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseCollapseAllAction;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseExpandAllAction;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.NodeHyperlinkSupport;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsDeclaredDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsModuleDependency;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DependencyGraphPanel
extends AbstractDependenciesPanel {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final Tree myTree;
    @NotNull
    private final StructureTreeModel<DependenciesTreeStructure> myStructureTreeModel;
    @NotNull
    private final NodeHyperlinkSupport<ModuleDependencyNode> myHyperlinkSupport;
    @NotNull
    private final SelectionChangeEventDispatcher<List<AbstractDependencyNode<?, ? extends PsBaseDependency>>> myEventDispatcher = new SelectionChangeEventDispatcher();
    private final MergingUpdateQueue myUpdateIssuesQueue = new MergingUpdateQueue("myUpdateIssuesQueue", 300, true, (JComponent)this, (Disposable)this);
    private boolean myIgnoreTreeSelectionEvents;

    DependencyGraphPanel(@NotNull PsModule fakeModule, @NotNull PsContext context) {
        super("All Dependencies", context, null);
        this.myContext = context;
        this.myUpdateIssuesQueue.setRestartTimerOnAdd(true);
        this.initializeDependencyDetails();
        this.setIssuesViewer(new IssuesViewer(this.myContext, new DependencyViewIssuesRenderer(this.myContext)));
        DependenciesTreeStructure treeStructure = new DependenciesTreeStructure(this.createRootNode());
        this.myStructureTreeModel = new StructureTreeModel((AbstractTreeStructure)treeStructure, (Disposable)this);
        this.myTree = new Tree((TreeModel)new AsyncTreeModel(this.myStructureTreeModel, (Disposable)this)){
            {
                this.setRowHeight(JBUI.scale((int)24));
            }

            protected void processMouseEvent(MouseEvent e) {
                ModuleDependencyNode node;
                int id2 = e.getID();
                if (id2 == 501 && (node = DependencyGraphPanel.this.myHyperlinkSupport.getIfHyperlink(e)) != null) {
                    PsModuleDependency moduleDependency = (PsModuleDependency)node.getFirstModel();
                    String name2 = moduleDependency.getName();
                    DependencyGraphPanel.this.myContext.setSelectedModule(name2, DependencyGraphPanel.this);
                    return;
                }
                super.processMouseEvent(e);
            }
        };
        JScrollPane scrollPane2 = UiUtil.setUp((JTree)this.myTree, "dependenciesTree");
        this.getContentsPanel().add((Component)this.createActionsPanel(), "North");
        this.getContentsPanel().add((Component)scrollPane2, "Center");
        TreeSelectionListener treeSelectionListener = e -> {
            if (!this.myIgnoreTreeSelectionEvents) {
                PsBaseDependency selected;
                List<AbstractDependencyNode<?, PsBaseDependency>> selection2 = this.getSelection();
                PsBaseDependency psBaseDependency = selected = !selection2.isEmpty() ? (PsBaseDependency)selection2.get(0).getFirstModel() : null;
                if (selected == null) {
                    this.notifySelectionChanged(Collections.emptyList());
                } else {
                    this.notifySelectionChanged(selection2);
                }
                this.updateDetails(selected);
                this.updateIssues(selection2);
            }
            this.myIgnoreTreeSelectionEvents = false;
        };
        this.myTree.addTreeSelectionListener(treeSelectionListener);
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                DependencyGraphPanel.this.popupInvoked(x, y);
            }
        });
        this.doEnsureSelection();
        this.myHyperlinkSupport = new NodeHyperlinkSupport<ModuleDependencyNode>(this.myTree, ModuleDependencyNode.class, this.myContext, true);
        PsModule.DependenciesChangeListener dependenciesChangeListener = event -> {
            this.myStructureTreeModel.getInvoker().invoke(() -> ((DependenciesTreeStructure)this.myStructureTreeModel.getTreeStructure()).reset());
            this.myStructureTreeModel.invalidateAsync().thenRun(() -> {
                if (event instanceof PsModule.DependencyAddedEvent) {
                    PsDeclaredDependency dependency = (PsDeclaredDependency)((PsModule.DependencyAddedEvent)event).getDependency().getValue();
                    this.myStructureTreeModel.getInvoker().compute(() -> ((DependenciesTreeStructure)this.myStructureTreeModel.getTreeStructure()).findDeclaredDependencyNode(dependency)).onSuccess(nodeOptional -> nodeOptional.ifPresent(node -> this.myStructureTreeModel.select(node, (JTree)this.myTree, path -> {})));
                }
            });
        };
        this.myContext.getProject().forEachModule(module -> module.add(dependenciesChangeListener, this));
    }

    @NotNull
    private DependenciesTreeRootNode createRootNode() {
        return new DependenciesTreeRootNode(this.myContext.getProject(), this.myContext.getUiSettings());
    }

    @NotNull
    private List<AbstractDependencyNode<?, ? extends PsBaseDependency>> getSelection() {
        ArrayList selection2 = new ArrayList();
        List matchingSelection = TreeUtil.collectSelectedObjectsOfType((JTree)this.myTree, AbstractDependencyNode.class);
        for (AbstractDependencyNode node : matchingSelection) {
            selection2.add(node);
        }
        return selection2;
    }

    private void updateIssues(final @NotNull List<AbstractDependencyNode<?, ? extends PsBaseDependency>> selection2) {
        this.myUpdateIssuesQueue.queue(new Update(this){

            public void run() {
                HashSet issues2 = Sets.newHashSet();
                for (AbstractDependencyNode node : selection2) {
                    for (PsBaseDependency dependency : node.getModels()) {
                        issues2.addAll(DependencyGraphPanel.this.myContext.getAnalyzerDaemon().getIssues().findIssues(dependency.getPath(), null));
                    }
                }
                DependencyGraphPanel.this.displayIssues(issues2, null);
            }
        });
    }

    private void notifySelectionChanged(@NotNull List<AbstractDependencyNode<?, ? extends PsBaseDependency>> selected) {
        this.myEventDispatcher.selectionChanged(selected);
    }

    private void popupInvoked(int x, int y) {
        ModuleDependencyNode node = this.myHyperlinkSupport.getNodeForLocation(x, y);
        if (node != null) {
            PsModuleDependency moduleDependency = (PsModuleDependency)node.getFirstModel();
            String name2 = moduleDependency.getName();
            DefaultActionGroup group2 = new DefaultActionGroup();
            group2.add((AnAction)new GoToModuleAction(name2, this.getContext(), (JComponent)this.myTree));
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("DependencyGraphPanel", (ActionGroup)group2);
            popupMenu.getComponent().show((Component)this.myTree, x, y);
        }
    }

    private void initializeDependencyDetails() {
        this.addDetails(new MultipleLibraryDependenciesDetails());
        this.addDetails(new JarDependencyDetails(this.getContext(), false));
        this.addDetails(new ModuleDependencyDetails(this.getContext(), false));
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    void add(@NotNull SelectionChangeListener<List<AbstractDependencyNode<?, ? extends PsBaseDependency>>> listener2) {
        this.myEventDispatcher.addListener(listener2, this);
    }

    @Override
    @NotNull
    protected List<AnAction> getExtraToolbarActions(@NotNull JComponent focusComponent) {
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
        actions2.add((AnAction)new AbstractBaseExpandAllAction(this.myTree, AllIcons.Actions.Expandall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                DependencyGraphPanel.this.myTree.requestFocusInWindow();
                TreeUtil.expandAll((JTree)DependencyGraphPanel.this.myTree);
                DependencyGraphPanel.this.doEnsureSelection();
            }
        });
        actions2.add((AnAction)new AbstractBaseCollapseAllAction(this.myTree, AllIcons.Actions.Collapseall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                DependencyGraphPanel.this.myTree.clearSelection();
                DependencyGraphPanel.this.notifySelectionChanged(Collections.emptyList());
                DependencyGraphPanel.this.myTree.requestFocusInWindow();
                TreeUtil.collapseAll((JTree)DependencyGraphPanel.this.myTree, (int)-1);
                DependencyGraphPanel.this.doEnsureSelection();
            }
        });
        return actions2;
    }

    private void doEnsureSelection() {
        TreeUtil.ensureSelection((JTree)this.myTree);
    }

    public void dispose() {
        Disposer.dispose(this.myHyperlinkSupport);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        return ActionCallback.DONE;
    }

    @Override
    @NotNull
    protected String getPlaceName() {
        return "dependencies.graph.project";
    }
}

